/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfConstNumber
extends CfInstruction {
    private final long value;
    private final ValueType type;

    public CfConstNumber(long value, ValueType type) {
        this.value = value;
        this.type = type;
    }

    public ValueType getType() {
        return this.type;
    }

    public long getRawValue() {
        return this.value;
    }

    public int getIntValue() {
        assert (this.type == ValueType.INT);
        return (int)this.value;
    }

    public long getLongValue() {
        assert (this.type == ValueType.LONG);
        return this.value;
    }

    public float getFloatValue() {
        assert (this.type == ValueType.FLOAT);
        return Float.intBitsToFloat((int)this.value);
    }

    public double getDoubleValue() {
        assert (this.type == ValueType.DOUBLE);
        return Double.longBitsToDouble(this.value);
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        switch (this.type) {
            case INT: {
                int value = this.getIntValue();
                if (-1 <= value && value <= 5) {
                    visitor.visitInsn(3 + value);
                    break;
                }
                if (-128 <= value && value <= 127) {
                    visitor.visitIntInsn(16, value);
                    break;
                }
                if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
                    visitor.visitIntInsn(17, value);
                    break;
                }
                visitor.visitLdcInsn(value);
                break;
            }
            case LONG: {
                long value = this.getLongValue();
                if (value == 0L || value == 1L) {
                    visitor.visitInsn(9 + (int)value);
                    break;
                }
                visitor.visitLdcInsn(value);
                break;
            }
            case FLOAT: {
                float value = this.getFloatValue();
                if (value == 0.0f || value == 1.0f || value == 2.0f) {
                    visitor.visitInsn(11 + (int)value);
                    if (!CfConstNumber.isNegativeZeroFloat(value)) break;
                    visitor.visitInsn(118);
                    break;
                }
                visitor.visitLdcInsn(Float.valueOf(value));
                break;
            }
            case DOUBLE: {
                double value = this.getDoubleValue();
                if (value == 0.0 || value == 1.0) {
                    visitor.visitInsn(14 + (int)value);
                    if (!CfConstNumber.isNegativeZeroDouble(value)) break;
                    visitor.visitInsn(119);
                    break;
                }
                visitor.visitLdcInsn(value);
                break;
            }
            default: {
                throw new Unreachable("Non supported type in cf backend: " + (Object)((Object)this.type));
            }
        }
    }

    private static boolean isNegativeZeroDouble(double value) {
        return Double.doubleToLongBits(value) == Double.doubleToLongBits(-0.0);
    }

    private static boolean isNegativeZeroFloat(float value) {
        return Float.floatToIntBits(value) == Float.floatToIntBits(-0.0f);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        builder.addConst(this.type.toPrimitiveTypeLattice(), state.push((ValueType)this.type).register, this.value);
    }
}

