/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ArrayTypeLatticeElement
extends ReferenceTypeLatticeElement {
    public ArrayTypeLatticeElement(DexType type, boolean isNullable) {
        super(type, isNullable);
        assert (type.isArrayType());
    }

    public DexType getArrayType() {
        return this.type;
    }

    public int getNesting() {
        return this.type.getNumberOfLeadingSquareBrackets();
    }

    public DexType getArrayElementType(DexItemFactory factory) {
        return this.type.toArrayElementType(factory);
    }

    public DexType getArrayBaseType(DexItemFactory factory) {
        return this.type.toBaseType(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceTypeLatticeElement getOrCreateDualLattice() {
        if (this.dual != null) {
            return this.dual;
        }
        ArrayTypeLatticeElement arrayTypeLatticeElement = this;
        synchronized (arrayTypeLatticeElement) {
            if (this.dual == null) {
                ArrayTypeLatticeElement dual = new ArrayTypeLatticeElement(this.type, !this.isNullable());
                ArrayTypeLatticeElement.linkDualLattice(this, dual);
            }
        }
        return this.dual;
    }

    @Override
    public TypeLatticeElement asNullable() {
        return this.isNullable() ? this : this.getOrCreateDualLattice();
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return !this.isNullable() ? this : this.getOrCreateDualLattice();
    }

    @Override
    public boolean isBasedOnMissingClass(AppInfo appInfo) {
        return this.getArrayBaseType(appInfo.dexItemFactory).isMissingOrHasMissingSuperType(appInfo);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return this;
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return ArrayTypeLatticeElement.fromDexType(this.getArrayElementType(appInfo.dexItemFactory), true, appInfo);
    }

    @Override
    public int hashCode() {
        return (this.isNullable() ? 1 : -1) * this.type.hashCode();
    }
}

