/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;

public class InliningConstraints {
    private Enqueuer.AppInfoWithLiveness appInfo;
    private GraphLense graphLense;

    public InliningConstraints(Enqueuer.AppInfoWithLiveness appInfo) {
        this(appInfo, GraphLense.getIdentityLense());
    }

    public InliningConstraints(Enqueuer.AppInfoWithLiveness appInfo, GraphLense graphLense) {
        assert (graphLense.isContextFreeForMethods());
        this.appInfo = appInfo;
        this.graphLense = graphLense;
    }

    public Inliner.ConstraintWithTarget forAlwaysMaterializingUser() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArgument() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArrayGet() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArrayLength() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArrayPut() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forBinop() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forCheckCast(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forConstClass(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forConstInstruction() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDebugLocalRead() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDebugLocalsChange() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDebugPosition() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDup() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDup2() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forInstanceGet(DexField field, DexType invocationContext) {
        DexField lookup = this.graphLense.lookupField(field);
        return this.forFieldInstruction(lookup, this.appInfo.lookupInstanceTarget(lookup.clazz, lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forInstanceOf(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forInstancePut(DexField field, DexType invocationContext) {
        DexField lookup = this.graphLense.lookupField(field);
        return this.forFieldInstruction(lookup, this.appInfo.lookupInstanceTarget(lookup.clazz, lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forInvoke(DexMethod method, Invoke.Type type, DexType invocationContext) {
        switch (type) {
            case DIRECT: {
                return this.forInvokeDirect(method, invocationContext);
            }
            case INTERFACE: {
                return this.forInvokeInterface(method, invocationContext);
            }
            case STATIC: {
                return this.forInvokeStatic(method, invocationContext);
            }
            case SUPER: {
                return this.forInvokeSuper(method, invocationContext);
            }
            case VIRTUAL: {
                return this.forInvokeVirtual(method, invocationContext);
            }
            case CUSTOM: {
                return this.forInvokeCustom();
            }
            case POLYMORPHIC: {
                return this.forInvokePolymorphic(method, invocationContext);
            }
        }
        throw new Unreachable("Unexpected type: " + (Object)((Object)type));
    }

    public Inliner.ConstraintWithTarget forInvokeCustom() {
        return Inliner.ConstraintWithTarget.NEVER;
    }

    public Inliner.ConstraintWithTarget forInvokeDirect(DexMethod method, DexType invocationContext) {
        DexMethod lookup = this.graphLense.lookupMethod(method);
        return this.forSingleTargetInvoke(lookup, this.appInfo.lookupDirectTarget(lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forInvokeInterface(DexMethod method, DexType invocationContext) {
        DexMethod lookup = this.graphLense.lookupMethod(method);
        return this.forVirtualInvoke(lookup, this.appInfo.lookupInterfaceTargets(lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forInvokeMultiNewArray(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forInvokeNewArray(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forInvokePolymorphic(DexMethod method, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.NEVER;
    }

    public Inliner.ConstraintWithTarget forInvokeStatic(DexMethod method, DexType invocationContext) {
        DexMethod lookup = this.graphLense.lookupMethod(method);
        return this.forSingleTargetInvoke(lookup, this.appInfo.lookupStaticTarget(lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forInvokeSuper(DexMethod method, DexType invocationContext) {
        return new Inliner.ConstraintWithTarget(Inliner.Constraint.SAMECLASS, invocationContext);
    }

    public Inliner.ConstraintWithTarget forInvokeVirtual(DexMethod method, DexType invocationContext) {
        DexMethod lookup = this.graphLense.lookupMethod(method);
        return this.forVirtualInvoke(lookup, this.appInfo.lookupVirtualTargets(lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forJumpInstruction() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forLoad() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forMonitor() {
        return Inliner.ConstraintWithTarget.NEVER;
    }

    public Inliner.ConstraintWithTarget forMove() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forMoveException() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forNewArrayEmpty(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forNewArrayFilledData() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forNewInstance(DexType type, DexType invocationContext) {
        return Inliner.ConstraintWithTarget.classIsVisible(invocationContext, type, this.appInfo);
    }

    public Inliner.ConstraintWithTarget forNonNull() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forPop() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forReturn() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forStaticGet(DexField field, DexType invocationContext) {
        DexField lookup = this.graphLense.lookupField(field);
        return this.forFieldInstruction(lookup, this.appInfo.lookupStaticTarget(lookup.clazz, lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forStaticPut(DexField field, DexType invocationContext) {
        DexField lookup = this.graphLense.lookupField(field);
        return this.forFieldInstruction(lookup, this.appInfo.lookupStaticTarget(lookup.clazz, lookup), invocationContext);
    }

    public Inliner.ConstraintWithTarget forStore() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forSwap() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forThrow() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forUnop() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    private Inliner.ConstraintWithTarget forFieldInstruction(DexField field, DexEncodedField target, DexType invocationContext) {
        DexType fieldHolder = this.graphLense.lookupType(field.clazz);
        DexClass fieldClass = this.appInfo.definitionFor(fieldHolder);
        if (target != null && fieldClass != null) {
            Inliner.ConstraintWithTarget fieldConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, fieldHolder, target.accessFlags, this.appInfo);
            Inliner.ConstraintWithTarget classConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, fieldHolder, fieldClass.accessFlags, this.appInfo);
            return Inliner.ConstraintWithTarget.meet(fieldConstraintWithTarget, classConstraintWithTarget, this.appInfo);
        }
        return Inliner.ConstraintWithTarget.NEVER;
    }

    private Inliner.ConstraintWithTarget forSingleTargetInvoke(DexMethod method, DexEncodedMethod target, DexType invocationContext) {
        DexType methodHolder;
        DexClass methodClass;
        if (method.holder.isArrayType()) {
            return Inliner.ConstraintWithTarget.ALWAYS;
        }
        if (target != null && (methodClass = this.appInfo.definitionFor(methodHolder = this.graphLense.lookupType(target.method.holder))) != null) {
            Inliner.ConstraintWithTarget methodConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, methodHolder, target.accessFlags, this.appInfo);
            Inliner.ConstraintWithTarget classConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, methodHolder, methodClass.accessFlags, this.appInfo);
            return Inliner.ConstraintWithTarget.meet(methodConstraintWithTarget, classConstraintWithTarget, this.appInfo);
        }
        return Inliner.ConstraintWithTarget.NEVER;
    }

    private Inliner.ConstraintWithTarget forVirtualInvoke(DexMethod method, Collection<DexEncodedMethod> targets, DexType invocationContext) {
        Inliner.ConstraintWithTarget classConstraintWithTarget;
        if (method.holder.isArrayType()) {
            return Inliner.ConstraintWithTarget.ALWAYS;
        }
        if (targets == null) {
            return Inliner.ConstraintWithTarget.NEVER;
        }
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        DexEncodedMethod resolutionTarget = resolutionResult.asResultOfResolve();
        if (resolutionTarget == null) {
            return Inliner.ConstraintWithTarget.NEVER;
        }
        DexType methodHolder = this.graphLense.lookupType(resolutionTarget.method.holder);
        DexClass methodClass = this.appInfo.definitionFor(methodHolder);
        assert (methodClass != null);
        Inliner.ConstraintWithTarget methodConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, methodHolder, resolutionTarget.accessFlags, this.appInfo);
        Inliner.ConstraintWithTarget result = Inliner.ConstraintWithTarget.meet(methodConstraintWithTarget, classConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, methodHolder, methodClass.accessFlags, this.appInfo), this.appInfo);
        if (result == Inliner.ConstraintWithTarget.NEVER) {
            return result;
        }
        for (DexEncodedMethod target : targets) {
            methodHolder = this.graphLense.lookupType(target.method.holder);
            assert (this.appInfo.definitionFor(methodHolder) != null);
            methodConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(invocationContext, methodHolder, target.accessFlags, this.appInfo);
            if ((result = Inliner.ConstraintWithTarget.meet(result, methodConstraintWithTarget, this.appInfo)) != Inliner.ConstraintWithTarget.NEVER) continue;
            return result;
        }
        return result;
    }
}

