/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class MainDexClasses {
    private final Set<DexType> rootSet;
    private final Set<DexType> dependencies;
    private final Set<DexType> classes;

    private MainDexClasses(Set<DexType> rootSet, Set<DexType> dependencies) {
        assert (Sets.intersection(rootSet, dependencies).isEmpty());
        this.rootSet = Collections.unmodifiableSet(rootSet);
        this.dependencies = Collections.unmodifiableSet(dependencies);
        this.classes = Sets.union(rootSet, dependencies);
    }

    public Set<DexType> getRoots() {
        return this.rootSet;
    }

    public Set<DexType> getDependencies() {
        return this.dependencies;
    }

    public Set<DexType> getClasses() {
        return this.classes;
    }

    public static Builder builder(AppInfo appInfo) {
        return new Builder(appInfo);
    }

    public static class Builder {
        public final AppInfo appInfo;
        public final Set<DexType> roots = Sets.newIdentityHashSet();
        public final Set<DexType> dependencies = Sets.newIdentityHashSet();

        private Builder(AppInfo appInfo) {
            this.appInfo = appInfo;
        }

        public Builder addRoots(Collection<DexType> rootSet) {
            assert (rootSet.stream().allMatch(this::isProgramClass));
            this.roots.addAll(rootSet);
            return this;
        }

        public Builder addDependency(DexType type) {
            assert (this.isProgramClass(type));
            this.dependencies.add(type);
            return this;
        }

        public boolean contains(DexType type) {
            return this.roots.contains(type) || this.dependencies.contains(type);
        }

        public MainDexClasses build() {
            return new MainDexClasses(this.roots, this.dependencies);
        }

        private boolean isProgramClass(DexType dexType) {
            DexClass clazz = this.appInfo.definitionFor(dexType);
            return clazz != null && clazz.isProgramClass();
        }
    }
}

