/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Stream;

public class DependencyData {
    private String mMainFile;
    private List<String> mSecondaryFiles = Lists.newArrayList();
    private List<String> mOutputFiles = Lists.newArrayList();
    List<String> mSecondaryOutputFiles = Lists.newArrayList();

    DependencyData() {
    }

    public String getMainFile() {
        return this.mMainFile;
    }

    void setMainFile(String path) {
        this.mMainFile = path;
    }

    public List<String> getSecondaryFiles() {
        return this.mSecondaryFiles;
    }

    void addSecondaryFile(String path) {
        this.mSecondaryFiles.add(path);
    }

    public List<String> getOutputFiles() {
        return this.mOutputFiles;
    }

    void addOutputFile(String path) {
        this.mOutputFiles.add(path);
    }

    public void addSecondaryOutputFile(String path) {
        this.mSecondaryOutputFiles.add(path);
    }

    public List<String> getSecondaryOutputFiles() {
        return this.mSecondaryOutputFiles;
    }

    public static DependencyData parseDependencyFile(File dependencyFile) throws IOException {
        if (!dependencyFile.isFile()) {
            return null;
        }
        try (Stream<String> lines = Files.lines(dependencyFile.toPath(), Charsets.UTF_8);){
            DependencyData dependencyData = DependencyData.processDependencyData(lines::iterator);
            return dependencyData;
        }
    }

    static DependencyData processDependencyData(Iterable<String> content) {
        DependencyData data = new DependencyData();
        ParseMode parseMode = ParseMode.OUTPUT;
        for (String line : content) {
            if ((line = line.trim()).startsWith(":")) {
                parseMode = ParseMode.MAIN;
                line = line.substring(1).trim();
            }
            ParseMode nextMode = parseMode;
            if (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1).trim();
            }
            if (line.endsWith(":")) {
                nextMode = parseMode == ParseMode.SECONDARY ? ParseMode.DONE : ParseMode.MAIN;
                line = line.substring(0, line.length() - 1).trim();
            }
            if (nextMode == ParseMode.DONE) break;
            if (!line.isEmpty()) {
                switch (parseMode) {
                    case OUTPUT: {
                        data.addOutputFile(line);
                        break;
                    }
                    case MAIN: {
                        data.setMainFile(line);
                        nextMode = ParseMode.SECONDARY;
                        break;
                    }
                    case SECONDARY: {
                        data.addSecondaryFile(line);
                    }
                }
            }
            parseMode = nextMode;
        }
        if (data.getMainFile() == null) {
            return null;
        }
        return data;
    }

    public String toString() {
        return "DependencyData{mMainFile='" + this.mMainFile + '\'' + ", mSecondaryFiles=" + this.mSecondaryFiles + ", mOutputFiles=" + this.mOutputFiles + '}';
    }

    private static enum ParseMode {
        OUTPUT,
        MAIN,
        SECONDARY,
        DONE;

    }
}

