/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfIfCmp
extends CfInstruction {
    private final If.Type kind;
    private final ValueType type;
    private final CfLabel target;

    public CfIfCmp(If.Type kind, ValueType type, CfLabel target) {
        this.kind = kind;
        this.type = type;
        this.target = target;
    }

    public If.Type getKind() {
        return this.kind;
    }

    public ValueType getType() {
        return this.type;
    }

    @Override
    public CfLabel getTarget() {
        return this.target;
    }

    public int getOpcode() {
        switch (this.kind) {
            case EQ: {
                return this.type.isObject() ? 165 : 159;
            }
            case GE: {
                return 162;
            }
            case GT: {
                return 163;
            }
            case LE: {
                return 164;
            }
            case LT: {
                return 161;
            }
            case NE: {
                return this.type.isObject() ? 166 : 160;
            }
        }
        throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitJumpInsn(this.getOpcode(), this.target.getLabel());
    }

    @Override
    public boolean isConditionalJump() {
        return true;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int right = state.pop().register;
        int left = state.pop().register;
        int trueTargetOffset = code.getLabelOffset(this.target);
        int falseTargetOffset = code.getCurrentInstructionIndex() + 1;
        builder.addIf(this.kind, this.type, left, right, trueTargetOffset, falseTargetOffset);
    }
}

