/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.position;

import com.android.tools.r8.Keep;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.position.Position;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Keep
public class MethodPosition
implements Position {
    private DexMethod method;

    public MethodPosition(DexMethod method) {
        this.method = method;
    }

    public String getName() {
        return this.method.name.toString();
    }

    public String getHolder() {
        return this.method.holder.toDescriptorString();
    }

    public String getReturnType() {
        return this.method.proto.returnType.toDescriptorString();
    }

    public List<String> getParameterTypes() {
        return Arrays.stream(this.method.proto.parameters.values).map(DexType::toDescriptorString).collect(Collectors.toList());
    }

    public String toString() {
        return this.method.toSourceString();
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MethodPosition) {
            return this.method.equals(((MethodPosition)o).method);
        }
        return false;
    }
}

