/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.PrintSeeds;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrintUses {
    private static final String USAGE = "Arguments: <rt.jar> <r8.jar> <sample.jar>\n\nPrintUses prints the classes, interfaces, methods and fields used by <sample.jar>,\nrestricted to classes and interfaces in <r8.jar> that are not in <sample.jar>.\n<rt.jar> and <r8.jar> should point to libraries used by <sample.jar>.\n\nThe output is in the same format as what is printed when specifying -printseeds in\na ProGuard configuration file. See also the " + PrintSeeds.class.getSimpleName() + " program in R8.";
    private final Set<String> descriptors;
    private final PrintStream out;
    private Set<DexType> types = Sets.newIdentityHashSet();
    private Map<DexType, Set<DexMethod>> methods = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexField>> fields = Maps.newIdentityHashMap();
    private final DexApplication application;
    private final AppInfoWithSubtyping appInfo;
    private int errors;

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println(USAGE.replace("\n", System.lineSeparator()));
            return;
        }
        AndroidApp.Builder builder = AndroidApp.builder();
        Path rtJar = Paths.get(args[0], new String[0]);
        builder.addLibraryFile(rtJar);
        Path r8Jar = Paths.get(args[1], new String[0]);
        builder.addLibraryFile(r8Jar);
        Path sampleJar = Paths.get(args[2], new String[0]);
        builder.addProgramFile(sampleJar);
        HashSet<String> descriptors = new HashSet<String>(PrintUses.getDescriptors(r8Jar));
        descriptors.removeAll(PrintUses.getDescriptors(sampleJar));
        PrintUses printUses = new PrintUses(descriptors, builder.build(), System.out);
        printUses.analyze();
        printUses.print();
        if (printUses.errors > 0) {
            System.err.println(printUses.errors + " errors");
            System.exit(1);
        }
    }

    private static Set<String> getDescriptors(Path path) throws IOException {
        return new ArchiveClassFileProvider(path).getClassDescriptors();
    }

    private PrintUses(Set<String> descriptors, AndroidApp inputApp, PrintStream out) throws Exception {
        this.descriptors = descriptors;
        this.out = out;
        InternalOptions options = new InternalOptions();
        this.application = new ApplicationReader(inputApp, options, new Timing("PrintUses")).read().toDirect();
        this.appInfo = new AppInfoWithSubtyping(this.application);
    }

    private void analyze() {
        UseCollector useCollector = new UseCollector(this.appInfo.dexItemFactory);
        for (DexProgramClass dexProgramClass : this.application.classes()) {
            useCollector.registerSuperType(dexProgramClass, dexProgramClass.superType);
            for (DexType implementsType : dexProgramClass.interfaces.values) {
                useCollector.registerSuperType(dexProgramClass, implementsType);
            }
            dexProgramClass.forEachMethod(x$0 -> useCollector.registerMethod(x$0));
            dexProgramClass.forEachField(x$0 -> useCollector.registerField(x$0));
        }
    }

    private void print() {
        ArrayList<DexType> types = new ArrayList<DexType>(this.types);
        types.sort(Comparator.comparing(DexType::toSourceString));
        for (DexType type : types) {
            String typeName = type.toSourceString();
            DexClass dexClass = this.application.definitionFor(type);
            if (dexClass == null) {
                this.error("Could not find definition for type " + type.toSourceString());
                continue;
            }
            this.out.println(typeName);
            ArrayList methods = new ArrayList(this.methods.get(type));
            ArrayList<String> methodDefinitions = new ArrayList<String>(methods.size());
            for (DexMethod method : methods) {
                DexEncodedMethod encodedMethod = dexClass.lookupMethod(method);
                if (encodedMethod == null) {
                    this.error("Could not find definition for method " + method.toSourceString());
                    continue;
                }
                methodDefinitions.add(PrintUses.getMethodSourceString(encodedMethod));
            }
            methodDefinitions.sort(Comparator.naturalOrder());
            for (String encodedMethod : methodDefinitions) {
                this.out.println(typeName + ": " + encodedMethod);
            }
            ArrayList<DexField> fields = new ArrayList<DexField>((Collection)this.fields.get(type));
            fields.sort(Comparator.comparing(DexField::toSourceString));
            for (DexField field : fields) {
                this.out.println(typeName + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
            }
        }
    }

    private void error(String message) {
        this.out.println("# Error: " + message);
        ++this.errors;
    }

    private static String getMethodSourceString(DexEncodedMethod encodedMethod) {
        DexMethod method = encodedMethod.method;
        StringBuilder builder = new StringBuilder();
        if (encodedMethod.accessFlags.isConstructor()) {
            if (encodedMethod.accessFlags.isStatic()) {
                builder.append("<clinit>");
            } else {
                String holderName = method.holder.toSourceString();
                String constructorName = holderName.substring(holderName.lastIndexOf(46) + 1);
                builder.append(constructorName);
            }
        } else {
            builder.append(method.proto.returnType.toSourceString()).append(" ").append(method.name.toSourceString());
        }
        builder.append("(");
        for (int i = 0; i < method.getArity(); ++i) {
            if (i != 0) {
                builder.append(",");
            }
            builder.append(method.proto.parameters.values[i].toSourceString());
        }
        builder.append(")");
        return builder.toString();
    }

    class UseCollector
    extends UseRegistry {
        UseCollector(DexItemFactory factory) {
            super(factory);
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            DexEncodedMethod target = PrintUses.this.appInfo.lookupVirtualTarget(method.holder, method);
            if (target != null && target.method != method) {
                this.addType(method.holder);
                this.addMethod(target.method);
            } else {
                this.addMethod(method);
            }
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.addMethod(method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            DexEncodedMethod target = PrintUses.this.appInfo.lookupStaticTarget(method);
            if (target != null && target.method != method) {
                this.addType(method.holder);
                this.addMethod(target.method);
            } else {
                this.addMethod(method);
            }
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvokeVirtual(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            this.addMethod(method);
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            this.addField(field);
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            this.addField(field);
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            this.addType(type);
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            this.addField(field);
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            this.addField(field);
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            this.addType(type);
            return false;
        }

        private void addType(DexType type) {
            if (this.isTargetType(type) && PrintUses.this.types.add(type)) {
                PrintUses.this.methods.put(type, Sets.newIdentityHashSet());
                PrintUses.this.fields.put(type, Sets.newIdentityHashSet());
            }
        }

        private boolean isTargetType(DexType type) {
            return PrintUses.this.descriptors.contains(type.toDescriptorString());
        }

        private void addField(DexField field) {
            this.addType(field.type);
            this.addType(field.clazz);
            Set typeFields = (Set)PrintUses.this.fields.get(field.clazz);
            if (typeFields != null) {
                typeFields.add(field);
            }
        }

        private void addMethod(DexMethod method) {
            this.addType(method.holder);
            for (DexType parameterType : method.proto.parameters.values) {
                this.addType(parameterType);
            }
            this.addType(method.proto.returnType);
            Set typeMethods = (Set)PrintUses.this.methods.get(method.holder);
            if (typeMethods != null) {
                typeMethods.add(method);
            }
        }

        private void registerField(DexEncodedField field) {
            this.registerTypeReference(field.field.type);
        }

        private void registerMethod(DexEncodedMethod method) {
            DexEncodedMethod superTarget = PrintUses.this.appInfo.lookupSuperTarget(method.method, method.method.holder);
            if (superTarget != null) {
                this.registerInvokeSuper(superTarget.method);
            }
            for (DexType type : method.method.proto.parameters.values) {
                this.registerTypeReference(type);
            }
            this.registerTypeReference(method.method.proto.returnType);
            method.registerCodeReferences(this);
        }

        private void registerSuperType(DexProgramClass clazz, DexType superType) {
            this.registerTypeReference(superType);
            clazz.forEachMethod(method -> {
                AppInfo.ResolutionResult resolutionResult = PrintUses.this.appInfo.resolveMethod(superType, method.method);
                for (DexEncodedMethod dexEncodedMethod : resolutionResult.asListOfTargets()) {
                    this.addMethod(dexEncodedMethod.method);
                }
            });
        }
    }
}

