/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import java.util.Collections;
import java.util.List;

public abstract class FieldInstruction
extends Instruction {
    private MemberType type;
    private final DexField field;

    protected FieldInstruction(DexField field, Value dest, Value value) {
        this(field, dest, Collections.singletonList(value));
    }

    protected FieldInstruction(DexField field, Value dest, List<Value> inValues) {
        super(dest, inValues);
        assert (field != null);
        this.field = field;
        this.type = MemberType.fromDexType(field.type);
    }

    public MemberType getType() {
        return this.type;
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public boolean isFieldInstruction() {
        return true;
    }

    @Override
    public FieldInstruction asFieldInstruction() {
        return this;
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }
}

