/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ByteBufferProvider;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.utils.EncodedValueUtils;
import com.android.tools.r8.utils.LebUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class DexOutputBuffer {
    private static final int DEFAULT_BUFFER_SIZE = 262144;
    private final ByteBufferProvider byteBufferProvider;
    private ByteBuffer byteBuffer;

    @VisibleForTesting
    DexOutputBuffer() {
        this(new ByteBufferProvider(){});
    }

    public DexOutputBuffer(ByteBufferProvider byteBufferProvider) {
        this.byteBufferProvider = byteBufferProvider;
        this.byteBuffer = this.allocateByteBuffer(262144);
    }

    private void ensureSpaceFor(int bytes) {
        if (this.byteBuffer.remaining() < bytes) {
            int newSize = this.byteBuffer.capacity() + Math.max(this.byteBuffer.capacity(), bytes * 2);
            ByteBuffer newBuffer = this.allocateByteBuffer(newSize);
            System.arraycopy(this.byteBuffer.array(), 0, newBuffer.array(), 0, this.byteBuffer.position());
            newBuffer.position(this.byteBuffer.position());
            this.freeByteBuffer(this.byteBuffer);
            this.byteBuffer = newBuffer;
        }
    }

    private ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer buffer = this.byteBufferProvider.acquireByteBuffer(size);
        if (!buffer.hasArray()) {
            throw new CompilationError("Provided byte-buffer is required to have an array backing, but does not.");
        }
        if (buffer.capacity() < size) {
            throw new CompilationError("Insufficient capacity of provided byte-buffer. Requested capacity " + size + ", actual capacity: " + buffer.capacity());
        }
        if (buffer.position() != 0) {
            throw new CompilationError("Provided byte-buffer is required to start at position zero, but starts at " + buffer.position() + ".");
        }
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    private void freeByteBuffer(ByteBuffer buffer) {
        assert (buffer != null);
        this.byteBufferProvider.releaseByteBuffer(buffer);
    }

    public void putUleb128(int value) {
        LebUtils.putUleb128(this, value);
    }

    public void putSleb128(int value) {
        LebUtils.putSleb128(this, value);
    }

    public int putSignedEncodedValue(long value, int expectedSize) {
        return EncodedValueUtils.putSigned(this, value, expectedSize);
    }

    public int putUnsignedEncodedValue(long value, int expectedSize) {
        return EncodedValueUtils.putUnsigned(this, value, expectedSize);
    }

    public void putInstructions(Instruction[] insns, ObjectToOffsetMapping mapping) {
        int size = 0;
        for (Instruction insn : insns) {
            size += insn.getSize();
        }
        this.ensureSpaceFor(size * 2);
        assert (this.byteBuffer.position() % 2 == 0);
        ShortBuffer shortBuffer = this.byteBuffer.asShortBuffer();
        for (int i = 0; i < insns.length; ++i) {
            insns[i].write(shortBuffer, mapping);
        }
        this.byteBuffer.position(this.byteBuffer.position() + shortBuffer.position() * 2);
    }

    public void putByte(byte aByte) {
        this.ensureSpaceFor(1);
        this.byteBuffer.put(aByte);
    }

    public void putBytes(byte[] bytes) {
        this.ensureSpaceFor(bytes.length);
        this.byteBuffer.put(bytes);
    }

    public void putShort(short aShort) {
        this.ensureSpaceFor(2);
        this.byteBuffer.putShort(aShort);
    }

    public void putInt(int anInteger) {
        this.ensureSpaceFor(4);
        this.byteBuffer.putInt(anInteger);
    }

    public int align(int bytes) {
        assert (bytes > 0);
        int mask = bytes - 1;
        int newPosition = this.byteBuffer.position() + mask & ~mask;
        this.ensureSpaceFor(newPosition - this.position());
        this.byteBuffer.position(newPosition);
        return newPosition;
    }

    public int position() {
        return this.byteBuffer.position();
    }

    public void forward(int bytes) {
        this.ensureSpaceFor(bytes);
        this.byteBuffer.position(this.byteBuffer.position() + bytes);
    }

    public void rewind(int bytes) {
        this.forward(-bytes);
    }

    public void moveTo(int position) {
        this.ensureSpaceFor(position - this.byteBuffer.position());
        this.byteBuffer.position(position);
    }

    public boolean isAligned(int bytes) {
        return this.position() % bytes == 0;
    }

    public byte[] asArray() {
        return this.byteBuffer.array();
    }

    public ByteBuffer stealByteBuffer() {
        ByteBuffer buffer = this.byteBuffer;
        this.byteBuffer = null;
        return buffer;
    }
}

