/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.regalloc.LiveIntervals;

class SpillMove {
    final TypeLatticeElement type;
    LiveIntervals from;
    final LiveIntervals to;

    public SpillMove(TypeLatticeElement type, LiveIntervals to, LiveIntervals from) {
        this.type = type;
        this.to = to;
        this.from = from;
        assert (to.getRegister() != Integer.MIN_VALUE);
        assert (from.getRegister() != Integer.MIN_VALUE);
    }

    public int hashCode() {
        return this.type.hashCode() + 3 * this.from.getRegister() + 5 * this.to.getRegister();
    }

    public void updateMaxNonSpilled() {
        int maxTo;
        int maxFrom = this.from.getMaxNonSpilledRegister();
        if (maxFrom > (maxTo = this.to.getMaxNonSpilledRegister())) {
            this.to.setMaxNonSpilledRegister(maxFrom);
        } else {
            this.from.setMaxNonSpilledRegister(maxTo);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SpillMove)) {
            return false;
        }
        SpillMove o = (SpillMove)other;
        return this.type == o.type && this.from.getRegister() == o.from.getRegister() && this.to.getRegister() == o.to.getRegister() && this.from.getSplitParent() == o.from.getSplitParent() && this.to.getSplitParent() == o.to.getSplitParent();
    }

    public String toString() {
        return this.to.getRegister() + " <- " + this.from.getRegister() + " (" + this.type + ")";
    }
}

