/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.base.MoreObjects;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.ClassMergingRule;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.ProguardAccessFlags;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassSpecification;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepPackageNamesRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberRuleReturnValue;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardPathList;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWhyAreYouKeepingRule;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.IdentifierUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LongInterval;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ProguardConfigurationParser {
    private final ProguardConfiguration.Builder configurationBuilder;
    private final DexItemFactory dexItemFactory;
    private final Reporter reporter;
    private final boolean allowTestOptions;
    private static final List<String> IGNORED_SINGLE_ARG_OPTIONS = ImmutableList.of("protomapping", "target");
    private static final List<String> IGNORED_OPTIONAL_SINGLE_ARG_OPTIONS = ImmutableList.of("runtype", "laststageoutput");
    private static final List<String> IGNORED_FLAG_OPTIONS = ImmutableList.of("forceprocessing", "dontusemixedcaseclassnames", "dontpreverify", "experimentalshrinkunusedprotofields", "filterlibraryjarswithorginalprogramjars", "dontskipnonpubliclibraryclasses", "dontskipnonpubliclibraryclassmembers", "invokebasemethod", "mergeinterfacesaggressively", "android", "shrinkunusedprotofields", "allowruntypeandignoreoptimizationpasses", new String[0]);
    private static final List<String> IGNORED_CLASS_DESCRIPTOR_OPTIONS = ImmutableList.of("isclassnamestring", "whyarenotsimple");
    private static final List<String> WARNED_SINGLE_ARG_OPTIONS = ImmutableList.of("outjars");
    private static final List<String> WARNED_FLAG_OPTIONS = ImmutableList.of("addconfigurationdebugging");
    private static final List<String> WARNED_CLASS_DESCRIPTOR_OPTIONS = ImmutableList.of("assumenoexternalsideeffects", "assumenoescapingparameters", "assumenoexternalreturnvalues");
    private static final List<String> UNSUPPORTED_FLAG_OPTIONS = ImmutableList.of("skipnonpubliclibraryclasses");

    public ProguardConfigurationParser(DexItemFactory dexItemFactory, Reporter reporter) {
        this(dexItemFactory, reporter, false);
    }

    public ProguardConfigurationParser(DexItemFactory dexItemFactory, Reporter reporter, boolean allowTestOptions) {
        this.dexItemFactory = dexItemFactory;
        this.configurationBuilder = ProguardConfiguration.builder(dexItemFactory, reporter);
        this.reporter = reporter;
        this.allowTestOptions = allowTestOptions;
    }

    public ProguardConfiguration.Builder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    private void validate() {
        if (this.configurationBuilder.isKeepParameterNames() && this.configurationBuilder.isObfuscating()) {
            throw this.reporter.fatalError(new StringDiagnostic("-keepparameternames is not supported", this.configurationBuilder.getKeepParameterNamesOptionOrigin(), this.configurationBuilder.getKeepParameterNamesOptionPosition()));
        }
        if (this.configurationBuilder.isOverloadAggressively() && this.configurationBuilder.isUseUniqueClassMemberNames()) {
            this.reporter.warning(new StringDiagnostic("The -overloadaggressively flag has no effect if -useuniqueclassmembernames is also specified."));
        }
    }

    public ProguardConfiguration getConfig() {
        this.validate();
        return this.configurationBuilder.build();
    }

    public ProguardConfiguration getConfigRawForTesting() {
        this.validate();
        return this.configurationBuilder.buildRaw();
    }

    public void parse(Path path) {
        this.parse(ImmutableList.of(new ProguardConfigurationSourceFile(path)));
    }

    public void parse(ProguardConfigurationSource source) {
        this.parse(ImmutableList.of(source));
    }

    public void parse(List<ProguardConfigurationSource> sources) {
        for (ProguardConfigurationSource source : sources) {
            try {
                new ProguardConfigurationSourceParser(source).parse();
            }
            catch (IOException e) {
                this.reporter.error(new StringDiagnostic("Failed to read file: " + e.getMessage(), source.getOrigin()));
            }
            catch (ProguardRuleParserException e) {
                this.reporter.error(e, MoreObjects.firstNonNull(e.getCause(), e));
            }
        }
        this.reporter.failIfPendingErrors();
    }

    private String getTextSourceSnippet(String source, TextPosition start, TextPosition end) {
        long length = end.getOffset() - start.getOffset();
        if (start.getOffset() < 0L || end.getOffset() < 0L || start.getOffset() >= (long)source.length() || end.getOffset() > (long)source.length() || length <= 0L) {
            return null;
        }
        return source.substring((int)start.getOffset(), (int)end.getOffset());
    }

    static class IdentifierPatternWithWildcards {
        final String pattern;
        final List<ProguardWildcard> wildcards;

        IdentifierPatternWithWildcards(String pattern, List<ProguardWildcard> wildcards) {
            this.pattern = pattern;
            this.wildcards = wildcards;
        }

        static IdentifierPatternWithWildcards withoutWildcards(String pattern) {
            return new IdentifierPatternWithWildcards(pattern, ImmutableList.of());
        }

        boolean isMatchAllNames() {
            return this.pattern.equals("*");
        }

        boolean hasUnusualCharacters() {
            if (this.pattern.contains("<") || this.pattern.contains(">")) {
                int angleStartCount = 0;
                int angleEndCount = 0;
                for (int i = 0; i < this.pattern.length(); ++i) {
                    char c = this.pattern.charAt(i);
                    if (c == '<') {
                        ++angleStartCount;
                    }
                    if (c != '>') continue;
                    ++angleEndCount;
                }
                return angleStartCount != angleEndCount || angleStartCount != this.wildcards.size();
            }
            return false;
        }
    }

    private class ProguardConfigurationSourceParser {
        private final String name;
        private final String contents;
        private int position = 0;
        private int positionAfterInclude = 0;
        private int line = 1;
        private int lineStartPosition = 0;
        private Path baseDirectory;
        private final Origin origin;
        private final Predicate<Integer> CLASS_NAME_PREDICATE = codePoint -> IdentifierUtils.isDexIdentifierPart(codePoint) || codePoint == 46 || codePoint == 42 || codePoint == 63 || codePoint == 37 || codePoint == 91 || codePoint == 93;

        ProguardConfigurationSourceParser(ProguardConfigurationSource source) throws IOException {
            this.contents = source.get();
            this.baseDirectory = source.getBaseDirectory();
            this.name = source.getName();
            this.origin = source.getOrigin();
        }

        public void parse() throws ProguardRuleParserException {
            do {
                this.skipWhitespace();
            } while (this.parseOption());
            ProguardConfigurationParser.this.configurationBuilder.addParsedConfiguration(this.contents.substring(this.positionAfterInclude, this.contents.length()));
        }

        private boolean parseOption() throws ProguardRuleParserException {
            if (this.eof()) {
                return false;
            }
            if (this.acceptArobaseInclude()) {
                return true;
            }
            TextPosition optionStart = this.getPosition();
            this.expectChar('-');
            if (!(this.parseIgnoredOption() || this.parseIgnoredOptionAndWarn(optionStart) || this.parseUnsupportedOptionAndErr(optionStart))) {
                if (this.acceptString("renamesourcefileattribute")) {
                    this.skipWhitespace();
                    if (this.isOptionalArgumentGiven()) {
                        ProguardConfigurationParser.this.configurationBuilder.setRenameSourceFileAttribute(this.acceptQuotedOrUnquotedString());
                    } else {
                        ProguardConfigurationParser.this.configurationBuilder.setRenameSourceFileAttribute("");
                    }
                } else if (this.acceptString("keepattributes")) {
                    this.parseKeepAttributes();
                } else if (this.acceptString("keeppackagenames")) {
                    ProguardKeepPackageNamesRule rule = this.parseKeepPackageNamesRule();
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("keepparameternames")) {
                    ProguardConfigurationParser.this.configurationBuilder.setKeepParameterNames(true, this.origin, this.getPosition(optionStart));
                } else if (this.acceptString("checkdiscard")) {
                    ProguardCheckDiscardRule rule = this.parseCheckDiscardRule(optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("keepdirectories")) {
                    ProguardConfigurationParser.this.configurationBuilder.enableKeepDirectories();
                    this.parsePathFilter(ProguardConfigurationParser.this.configurationBuilder::addKeepDirectories);
                } else if (this.acceptString("keep")) {
                    ProguardKeepRule rule = this.parseKeepRule(optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("whyareyoukeeping")) {
                    ProguardWhyAreYouKeepingRule rule = this.parseWhyAreYouKeepingRule(optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("dontoptimize")) {
                    ProguardConfigurationParser.this.configurationBuilder.disableOptimization();
                } else if (this.acceptString("optimizationpasses")) {
                    this.skipWhitespace();
                    Integer expectedOptimizationPasses = this.acceptInteger();
                    if (expectedOptimizationPasses == null) {
                        throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Missing n of \"-optimizationpasses n\"", this.origin, this.getPosition(optionStart)));
                    }
                    this.warnIgnoringOptions("optimizationpasses", optionStart);
                } else if (this.acceptString("dontobfuscate")) {
                    ProguardConfigurationParser.this.configurationBuilder.disableObfuscation();
                } else if (this.acceptString("dontshrink")) {
                    ProguardConfigurationParser.this.configurationBuilder.disableShrinking();
                } else if (this.acceptString("printusage")) {
                    ProguardConfigurationParser.this.configurationBuilder.setPrintUsage(true);
                    this.skipWhitespace();
                    if (this.isOptionalArgumentGiven()) {
                        ProguardConfigurationParser.this.configurationBuilder.setPrintUsageFile(this.parseFileName(false));
                    }
                } else if (this.acceptString("verbose")) {
                    ProguardConfigurationParser.this.configurationBuilder.setVerbose(true);
                } else if (this.acceptString("ignorewarnings")) {
                    ProguardConfigurationParser.this.configurationBuilder.setIgnoreWarnings(true);
                } else if (this.acceptString("dontwarn")) {
                    this.parseClassFilter(ProguardConfigurationParser.this.configurationBuilder::addDontWarnPattern);
                } else if (this.acceptString("dontnote")) {
                    this.parseClassFilter(ProguardConfigurationParser.this.configurationBuilder::addDontNotePattern);
                } else if (this.acceptString("repackageclasses")) {
                    if (ProguardConfigurationParser.this.configurationBuilder.getPackageObfuscationMode() == InternalOptions.PackageObfuscationMode.FLATTEN) {
                        this.warnOverridingOptions("repackageclasses", "flattenpackagehierarchy", optionStart);
                    }
                    this.skipWhitespace();
                    char quote = this.acceptQuoteIfPresent();
                    if (this.isQuote(quote)) {
                        ProguardConfigurationParser.this.configurationBuilder.setPackagePrefix(this.parsePackageNameOrEmptyString());
                        this.expectClosingQuote(quote);
                    } else {
                        ProguardConfigurationParser.this.configurationBuilder.setPackagePrefix("");
                    }
                } else if (this.acceptString("flattenpackagehierarchy")) {
                    if (ProguardConfigurationParser.this.configurationBuilder.getPackageObfuscationMode() == InternalOptions.PackageObfuscationMode.REPACKAGE) {
                        this.warnOverridingOptions("repackageclasses", "flattenpackagehierarchy", optionStart);
                        this.skipWhitespace();
                        if (this.isOptionalArgumentGiven()) {
                            this.skipSingleArgument();
                        }
                    } else {
                        this.skipWhitespace();
                        char quote = this.acceptQuoteIfPresent();
                        if (this.isQuote(quote)) {
                            ProguardConfigurationParser.this.configurationBuilder.setFlattenPackagePrefix(this.parsePackageNameOrEmptyString());
                            this.expectClosingQuote(quote);
                        } else {
                            ProguardConfigurationParser.this.configurationBuilder.setFlattenPackagePrefix("");
                        }
                    }
                } else if (this.acceptString("overloadaggressively")) {
                    ProguardConfigurationParser.this.configurationBuilder.setOverloadAggressively(true);
                } else if (this.acceptString("allowaccessmodification")) {
                    ProguardConfigurationParser.this.configurationBuilder.setAllowAccessModification(true);
                } else if (this.acceptString("printconfiguration")) {
                    ProguardConfigurationParser.this.configurationBuilder.setPrintConfiguration(true);
                    this.skipWhitespace();
                    if (this.isOptionalArgumentGiven()) {
                        ProguardConfigurationParser.this.configurationBuilder.setPrintConfigurationFile(this.parseFileName(false));
                    }
                } else if (this.acceptString("printmapping")) {
                    ProguardConfigurationParser.this.configurationBuilder.setPrintMapping(true);
                    this.skipWhitespace();
                    if (this.isOptionalArgumentGiven()) {
                        ProguardConfigurationParser.this.configurationBuilder.setPrintMappingFile(this.parseFileName(false));
                    }
                } else if (this.acceptString("applymapping")) {
                    ProguardConfigurationParser.this.configurationBuilder.setApplyMappingFile(this.parseFileName(false));
                } else if (this.acceptString("assumenosideeffects")) {
                    ProguardAssumeNoSideEffectRule rule = this.parseAssumeNoSideEffectsRule(optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("assumevalues")) {
                    ProguardAssumeValuesRule rule = this.parseAssumeValuesRule(optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("include")) {
                    ProguardConfigurationParser.this.configurationBuilder.addParsedConfiguration(this.contents.substring(this.positionAfterInclude, this.position - ("include".length() + 1)));
                    this.skipWhitespace();
                    this.parseInclude();
                    this.positionAfterInclude = this.position;
                } else if (this.acceptString("basedirectory")) {
                    this.skipWhitespace();
                    this.baseDirectory = this.parseFileName(false);
                } else if (this.acceptString("injars")) {
                    ProguardConfigurationParser.this.configurationBuilder.addInjars(this.parseClassPath());
                } else if (this.acceptString("libraryjars")) {
                    ProguardConfigurationParser.this.configurationBuilder.addLibraryJars(this.parseClassPath());
                } else if (this.acceptString("printseeds")) {
                    ProguardConfigurationParser.this.configurationBuilder.setPrintSeeds(true);
                    this.skipWhitespace();
                    if (this.isOptionalArgumentGiven()) {
                        ProguardConfigurationParser.this.configurationBuilder.setSeedFile(this.parseFileName(false));
                    }
                } else if (this.acceptString("obfuscationdictionary")) {
                    ProguardConfigurationParser.this.configurationBuilder.setObfuscationDictionary(this.parseFileName(false));
                } else if (this.acceptString("classobfuscationdictionary")) {
                    ProguardConfigurationParser.this.configurationBuilder.setClassObfuscationDictionary(this.parseFileName(false));
                } else if (this.acceptString("packageobfuscationdictionary")) {
                    ProguardConfigurationParser.this.configurationBuilder.setPackageObfuscationDictionary(this.parseFileName(false));
                } else if (this.acceptString("alwaysinline")) {
                    InlineRule rule = this.parseInlineRule(InlineRule.Type.ALWAYS, optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (ProguardConfigurationParser.this.allowTestOptions && this.acceptString("forceinline")) {
                    InlineRule rule = this.parseInlineRule(InlineRule.Type.FORCE, optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                    ProguardCheckDiscardRule ruled = rule.asProguardCheckDiscardRule();
                    ProguardConfigurationParser.this.configurationBuilder.addRule(ruled);
                } else if (ProguardConfigurationParser.this.allowTestOptions && this.acceptString("neverinline")) {
                    InlineRule rule = this.parseInlineRule(InlineRule.Type.NEVER, optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (ProguardConfigurationParser.this.allowTestOptions && this.acceptString("neverclassinline")) {
                    ClassInlineRule rule = this.parseClassInlineRule(ClassInlineRule.Type.NEVER, optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (ProguardConfigurationParser.this.allowTestOptions && this.acceptString("nevermerge")) {
                    ClassMergingRule rule = this.parseClassMergingRule(ClassMergingRule.Type.NEVER, optionStart);
                    ProguardConfigurationParser.this.configurationBuilder.addRule(rule);
                } else if (this.acceptString("useuniqueclassmembernames")) {
                    ProguardConfigurationParser.this.configurationBuilder.setUseUniqueClassMemberNames(true);
                } else if (this.acceptString("adaptclassstrings")) {
                    this.parseClassFilter(ProguardConfigurationParser.this.configurationBuilder::addAdaptClassStringsPattern);
                } else if (this.acceptString("adaptresourcefilenames")) {
                    ProguardConfigurationParser.this.configurationBuilder.enableAdaptResourceFilenames();
                    this.parsePathFilter(ProguardConfigurationParser.this.configurationBuilder::addAdaptResourceFilenames);
                } else if (this.acceptString("adaptresourcefilecontents")) {
                    ProguardConfigurationParser.this.configurationBuilder.enableAdaptResourceFileContents();
                    this.parsePathFilter(ProguardConfigurationParser.this.configurationBuilder::addAdaptResourceFileContents);
                } else if (this.acceptString("identifiernamestring")) {
                    ProguardConfigurationParser.this.configurationBuilder.addRule(this.parseIdentifierNameStringRule(optionStart));
                } else if (this.acceptString("if")) {
                    ProguardConfigurationParser.this.configurationBuilder.addRule(this.parseIfRule(optionStart));
                } else {
                    String unknownOption = this.acceptString();
                    String devMessage = "";
                    if (Version.isDev() && unknownOption != null && (unknownOption.equals("forceinline") || unknownOption.equals("neverinline"))) {
                        devMessage = ", this option needs to be turned on explicitly if used for tests.";
                    }
                    ProguardConfigurationParser.this.reporter.error(new StringDiagnostic("Unknown option \"-" + unknownOption + "\"" + devMessage, this.origin, this.getPosition(optionStart)));
                }
            }
            return true;
        }

        private boolean parseUnsupportedOptionAndErr(TextPosition optionStart) {
            String option = Iterables.find(UNSUPPORTED_FLAG_OPTIONS, this::skipFlag, null);
            if (option != null) {
                ProguardConfigurationParser.this.reporter.error(new StringDiagnostic("Unsupported option: -" + option, this.origin, this.getPosition(optionStart)));
                return true;
            }
            return false;
        }

        private boolean parseIgnoredOptionAndWarn(TextPosition optionStart) {
            String option = Iterables.find(WARNED_CLASS_DESCRIPTOR_OPTIONS, this::skipOptionWithClassSpec, null);
            if (option == null && (option = (String)Iterables.find(WARNED_FLAG_OPTIONS, this::skipFlag, null)) == null && (option = (String)Iterables.find(WARNED_SINGLE_ARG_OPTIONS, this::skipOptionWithSingleArg, null)) == null) {
                return false;
            }
            this.warnIgnoringOptions(option, optionStart);
            return true;
        }

        private boolean parseIgnoredOption() {
            return Iterables.any(IGNORED_SINGLE_ARG_OPTIONS, this::skipOptionWithSingleArg) || Iterables.any(IGNORED_OPTIONAL_SINGLE_ARG_OPTIONS, this::skipOptionWithOptionalSingleArg) || Iterables.any(IGNORED_FLAG_OPTIONS, this::skipFlag) || Iterables.any(IGNORED_CLASS_DESCRIPTOR_OPTIONS, this::skipOptionWithClassSpec) || this.parseOptimizationOption();
        }

        private void parseInclude() throws ProguardRuleParserException {
            TextPosition start = this.getPosition();
            Path included = this.parseFileName(false);
            try {
                new ProguardConfigurationSourceParser(new ProguardConfigurationSourceFile(included)).parse();
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                throw this.parseError("Included file '" + included.toString() + "' not found", start, e);
            }
            catch (IOException e) {
                throw this.parseError("Failed to read included file '" + included.toString() + "'", start, e);
            }
        }

        private boolean acceptArobaseInclude() throws ProguardRuleParserException {
            if (this.remainingChars() < 2) {
                return false;
            }
            if (!this.acceptChar('@')) {
                return false;
            }
            this.parseInclude();
            return true;
        }

        private void parseKeepAttributes() throws ProguardRuleParserException {
            List<String> attributesPatterns = this.acceptPatternList();
            if (attributesPatterns.isEmpty()) {
                throw this.parseError("Expected attribute pattern list");
            }
            ProguardConfigurationParser.this.configurationBuilder.addKeepAttributePatterns(attributesPatterns);
        }

        private boolean skipFlag(String name) {
            return this.acceptString(name);
        }

        private boolean skipOptionWithSingleArg(String name) {
            if (this.acceptString(name)) {
                this.skipSingleArgument();
                return true;
            }
            return false;
        }

        private boolean skipOptionWithOptionalSingleArg(String name) {
            if (this.acceptString(name)) {
                this.skipWhitespace();
                if (this.isOptionalArgumentGiven()) {
                    this.skipSingleArgument();
                }
                return true;
            }
            return false;
        }

        private boolean skipOptionWithClassSpec(String name) {
            if (this.acceptString(name)) {
                try {
                    ProguardKeepRule.Builder keepRuleBuilder = ProguardKeepRule.builder();
                    this.parseClassSpec(keepRuleBuilder, true);
                    return true;
                }
                catch (ProguardRuleParserException e) {
                    throw ProguardConfigurationParser.this.reporter.fatalError(e, MoreObjects.firstNonNull(e.getCause(), e));
                }
            }
            return false;
        }

        private boolean parseOptimizationOption() {
            if (!this.acceptString("optimizations")) {
                return false;
            }
            do {
                this.skipWhitespace();
                this.skipOptimizationName();
                this.skipWhitespace();
            } while (this.acceptChar(','));
            return true;
        }

        private void skipOptimizationName() {
            if (this.acceptChar('!')) {
                this.skipWhitespace();
            }
            this.acceptString((Integer next) -> Character.isAlphabetic(next) || next == 47 || next == 42);
        }

        private void skipSingleArgument() {
            this.skipWhitespace();
            while (!this.eof() && !Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
        }

        private ProguardKeepRule parseKeepRule(Position start) throws ProguardRuleParserException {
            ProguardKeepRule.Builder keepRuleBuilder = (ProguardKeepRule.Builder)((ProguardKeepRule.Builder)ProguardKeepRule.builder().setOrigin(this.origin)).setStart(start);
            this.parseRuleTypeAndModifiers(keepRuleBuilder);
            this.parseClassSpec(keepRuleBuilder, false);
            if (keepRuleBuilder.getMemberRules().isEmpty()) {
                ProguardMemberRule.Builder defaultRuleBuilder = ProguardMemberRule.builder();
                defaultRuleBuilder.setName(IdentifierPatternWithWildcards.withoutWildcards("<init>"));
                defaultRuleBuilder.setRuleType(ProguardMemberType.INIT);
                defaultRuleBuilder.setArguments(Collections.emptyList());
                keepRuleBuilder.getMemberRules().add(defaultRuleBuilder.build());
            }
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private ProguardWhyAreYouKeepingRule parseWhyAreYouKeepingRule(Position start) throws ProguardRuleParserException {
            ProguardWhyAreYouKeepingRule.Builder keepRuleBuilder = (ProguardWhyAreYouKeepingRule.Builder)((ProguardWhyAreYouKeepingRule.Builder)ProguardWhyAreYouKeepingRule.builder().setOrigin(this.origin)).setStart(start);
            this.parseClassSpec(keepRuleBuilder, false);
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private ProguardKeepPackageNamesRule parseKeepPackageNamesRule() throws ProguardRuleParserException {
            ProguardKeepPackageNamesRule.Builder keepRuleBuilder = ProguardKeepPackageNamesRule.builder();
            keepRuleBuilder.setClassNames(this.parseClassNames());
            return keepRuleBuilder.build();
        }

        private ProguardCheckDiscardRule parseCheckDiscardRule(Position start) throws ProguardRuleParserException {
            ProguardCheckDiscardRule.Builder keepRuleBuilder = (ProguardCheckDiscardRule.Builder)((ProguardCheckDiscardRule.Builder)ProguardCheckDiscardRule.builder().setOrigin(this.origin)).setStart(start);
            this.parseClassSpec(keepRuleBuilder, false);
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private ClassInlineRule parseClassInlineRule(ClassInlineRule.Type type, Position start) throws ProguardRuleParserException {
            ClassInlineRule.Builder keepRuleBuilder = ((ClassInlineRule.Builder)((ClassInlineRule.Builder)ClassInlineRule.builder().setOrigin(this.origin)).setStart(start)).setType(type);
            this.parseClassSpec(keepRuleBuilder, false);
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private ClassMergingRule parseClassMergingRule(ClassMergingRule.Type type, Position start) throws ProguardRuleParserException {
            ClassMergingRule.Builder keepRuleBuilder = ((ClassMergingRule.Builder)((ClassMergingRule.Builder)ClassMergingRule.builder().setOrigin(this.origin)).setStart(start)).setType(type);
            this.parseClassSpec(keepRuleBuilder, false);
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private InlineRule parseInlineRule(InlineRule.Type type, Position start) throws ProguardRuleParserException {
            InlineRule.Builder keepRuleBuilder = ((InlineRule.Builder)((InlineRule.Builder)InlineRule.builder().setOrigin(this.origin)).setStart(start)).setType(type);
            this.parseClassSpec(keepRuleBuilder, false);
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private ProguardIdentifierNameStringRule parseIdentifierNameStringRule(Position start) throws ProguardRuleParserException {
            ProguardIdentifierNameStringRule.Builder keepRuleBuilder = (ProguardIdentifierNameStringRule.Builder)((ProguardIdentifierNameStringRule.Builder)ProguardIdentifierNameStringRule.builder().setOrigin(this.origin)).setStart(start);
            this.parseClassSpec(keepRuleBuilder, false);
            TextPosition end = this.getPosition();
            keepRuleBuilder.setSource(this.getSourceSnippet(this.contents, start, end));
            keepRuleBuilder.setEnd(end);
            return keepRuleBuilder.build();
        }

        private ProguardIfRule parseIfRule(TextPosition optionStart) throws ProguardRuleParserException {
            ProguardIfRule.Builder ifRuleBuilder = (ProguardIfRule.Builder)((ProguardIfRule.Builder)ProguardIfRule.builder().setOrigin(this.origin)).setStart(optionStart);
            this.parseClassSpec(ifRuleBuilder, false);
            this.skipWhitespace();
            TextPosition keepStart = this.getPosition();
            if (this.acceptString("-keep")) {
                ProguardKeepRule subsequentRule = this.parseKeepRule(keepStart);
                ifRuleBuilder.setSubsequentRule(subsequentRule);
                ProguardIfRule ifRule = ifRuleBuilder.build();
                this.verifyAndLinkBackReferences(ifRule.getWildcards());
                return ifRule;
            }
            throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Expecting '-keep' option after '-if' option.", this.origin, this.getPosition(optionStart)));
        }

        void verifyAndLinkBackReferences(Iterable<ProguardWildcard> wildcards) {
            ArrayList<ProguardWildcard.Pattern> patterns = new ArrayList<ProguardWildcard.Pattern>();
            boolean backReferenceStarted = false;
            for (ProguardWildcard wildcard : wildcards) {
                if (wildcard.isBackReference()) {
                    backReferenceStarted = true;
                    ProguardWildcard.BackReference backReference = wildcard.asBackReference();
                    if (patterns.size() < backReference.referenceIndex) {
                        throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Wildcard <" + backReference.referenceIndex + "> is invalid (only seen " + patterns.size() + " at this point).", this.origin, this.getPosition()));
                    }
                    backReference.setReference((ProguardWildcard.Pattern)patterns.get(backReference.referenceIndex - 1));
                    continue;
                }
                assert (wildcard.isPattern());
                if (backReferenceStarted) continue;
                patterns.add(wildcard.asPattern());
            }
        }

        private <C extends ProguardClassSpecification, B extends ProguardClassSpecification.Builder<C, B>> void parseClassSpec(ProguardClassSpecification.Builder<C, B> builder, boolean allowValueSpecification) throws ProguardRuleParserException {
            this.parseClassFlagsAndAnnotations(builder);
            this.parseClassType(builder);
            builder.setClassNames(this.parseClassNames());
            this.parseInheritance(builder);
            this.parseMemberRules(builder, allowValueSpecification);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseRuleTypeAndModifiers(ProguardKeepRule.Builder builder) {
            block5: {
                block7: {
                    block8: {
                        block6: {
                            if (!this.acceptString("names")) break block6;
                            builder.setType(ProguardKeepRuleType.KEEP);
                            builder.getModifiersBuilder().setAllowsShrinking(true);
                            break block5;
                        }
                        if (!this.acceptString("class")) break block7;
                        if (!this.acceptString("members")) break block8;
                        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
                        break block5;
                    }
                    if (this.acceptString("eswithmembers")) {
                        builder.setType(ProguardKeepRuleType.KEEP_CLASSES_WITH_MEMBERS);
                        break block5;
                    } else if (this.acceptString("membernames")) {
                        builder.setType(ProguardKeepRuleType.KEEP_CLASS_MEMBERS);
                        builder.getModifiersBuilder().setAllowsShrinking(true);
                        break block5;
                    } else {
                        if (!this.acceptString("eswithmembernames")) {
                            this.unacceptString("-keepclass");
                            TextPosition start = this.getPosition();
                            this.acceptString("-");
                            String unknownOption = this.acceptString();
                            throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Unknown option \"-" + unknownOption + "\"", this.origin, start));
                        }
                        builder.setType(ProguardKeepRuleType.KEEP_CLASSES_WITH_MEMBERS);
                        builder.getModifiersBuilder().setAllowsShrinking(true);
                    }
                    break block5;
                }
                builder.setType(ProguardKeepRuleType.KEEP);
            }
            this.parseRuleModifiers(builder);
        }

        private void parseRuleModifiers(ProguardKeepRule.Builder builder) {
            this.skipWhitespace();
            while (this.acceptChar(',')) {
                this.skipWhitespace();
                if (this.acceptString("allow")) {
                    if (this.acceptString("shrinking")) {
                        builder.getModifiersBuilder().setAllowsShrinking(true);
                    } else if (this.acceptString("optimization")) {
                        builder.getModifiersBuilder().setAllowsOptimization(true);
                    } else if (this.acceptString("obfuscation")) {
                        builder.getModifiersBuilder().setAllowsObfuscation(true);
                    }
                } else if (this.acceptString("includedescriptorclasses")) {
                    builder.getModifiersBuilder().setIncludeDescriptorClasses(true);
                }
                this.skipWhitespace();
            }
        }

        private ProguardTypeMatcher parseAnnotation() throws ProguardRuleParserException {
            this.skipWhitespace();
            int startPosition = this.position;
            if (this.acceptChar('@')) {
                IdentifierPatternWithWildcards identifierPatternWithWildcards = this.parseClassName();
                String className = identifierPatternWithWildcards.pattern;
                if (className.equals("interface")) {
                    this.position = startPosition;
                    return null;
                }
                return ProguardTypeMatcher.create(identifierPatternWithWildcards, ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory);
            }
            return null;
        }

        private boolean parseNegation() {
            this.skipWhitespace();
            return this.acceptChar('!');
        }

        private void parseClassFlagsAndAnnotations(ProguardClassSpecification.Builder builder) throws ProguardRuleParserException {
            int start;
            while (true) {
                this.skipWhitespace();
                ProguardTypeMatcher annotation = this.parseAnnotation();
                if (annotation != null) {
                    assert (builder.getClassAnnotation() == null);
                    builder.setClassAnnotation(annotation);
                    continue;
                }
                start = this.position;
                ProguardAccessFlags flags = this.parseNegation() ? builder.getNegatedClassAccessFlags() : builder.getClassAccessFlags();
                this.skipWhitespace();
                if (this.acceptString("public")) {
                    flags.setPublic();
                    continue;
                }
                if (this.acceptString("final")) {
                    flags.setFinal();
                    continue;
                }
                if (!this.acceptString("abstract")) break;
                flags.setAbstract();
            }
            this.position = start;
        }

        private StringDiagnostic parseClassTypeUnexpected(Origin origin, TextPosition start) {
            return new StringDiagnostic("Expected [!]interface|@interface|class|enum", origin, this.getPosition(start));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseClassType(ProguardClassSpecification.Builder builder) throws ProguardRuleParserException {
            this.skipWhitespace();
            TextPosition start = this.getPosition();
            if (this.acceptChar('!')) {
                builder.setClassTypeNegated(true);
            }
            if (this.acceptChar('@')) {
                this.skipWhitespace();
                if (!this.acceptString("interface")) throw ProguardConfigurationParser.this.reporter.fatalError(this.parseClassTypeUnexpected(this.origin, start));
                builder.setClassType(ProguardClassType.ANNOTATION_INTERFACE);
                return;
            } else if (this.acceptString("interface")) {
                builder.setClassType(ProguardClassType.INTERFACE);
                return;
            } else if (this.acceptString("class")) {
                builder.setClassType(ProguardClassType.CLASS);
                return;
            } else {
                if (!this.acceptString("enum")) throw ProguardConfigurationParser.this.reporter.fatalError(this.parseClassTypeUnexpected(this.origin, start));
                builder.setClassType(ProguardClassType.ENUM);
            }
        }

        private void parseInheritance(ProguardClassSpecification.Builder classSpecificationBuilder) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptString("implements")) {
                classSpecificationBuilder.setInheritanceIsExtends(false);
            } else if (this.acceptString("extends")) {
                classSpecificationBuilder.setInheritanceIsExtends(true);
            } else {
                return;
            }
            classSpecificationBuilder.setInheritanceAnnotation(this.parseAnnotation());
            classSpecificationBuilder.setInheritanceClassName(ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory));
        }

        private <C extends ProguardClassSpecification, B extends ProguardClassSpecification.Builder<C, B>> void parseMemberRules(ProguardClassSpecification.Builder<C, B> classSpecificationBuilder, boolean allowValueSpecification) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (!this.eof() && this.acceptChar('{')) {
                ProguardMemberRule rule;
                while ((rule = this.parseMemberRule(allowValueSpecification)) != null) {
                    classSpecificationBuilder.getMemberRules().add(rule);
                }
                this.skipWhitespace();
                this.expectChar('}');
            }
        }

        private ProguardMemberRule parseMemberRule(boolean allowValueSpecification) throws ProguardRuleParserException {
            ProguardMemberRule.Builder ruleBuilder = ProguardMemberRule.builder();
            this.skipWhitespace();
            ruleBuilder.setAnnotation(this.parseAnnotation());
            this.parseMemberAccessFlags(ruleBuilder);
            this.parseMemberPattern(ruleBuilder, allowValueSpecification);
            return ruleBuilder.isValid() ? ruleBuilder.build() : null;
        }

        private void parseMemberAccessFlags(ProguardMemberRule.Builder ruleBuilder) {
            boolean found = true;
            while (found && !this.eof()) {
                found = false;
                ProguardAccessFlags flags = this.parseNegation() ? ruleBuilder.getNegatedAccessFlags() : ruleBuilder.getAccessFlags();
                this.skipWhitespace();
                switch (this.peekChar()) {
                    case 'a': {
                        found = this.acceptString("abstract");
                        if (!found) break;
                        flags.setAbstract();
                        break;
                    }
                    case 'f': {
                        found = this.acceptString("final");
                        if (!found) break;
                        flags.setFinal();
                        break;
                    }
                    case 'n': {
                        found = this.acceptString("native");
                        if (!found) break;
                        flags.setNative();
                        break;
                    }
                    case 'p': {
                        found = this.acceptString("public");
                        if (found) {
                            flags.setPublic();
                            break;
                        }
                        found = this.acceptString("private");
                        if (found) {
                            flags.setPrivate();
                            break;
                        }
                        found = this.acceptString("protected");
                        if (!found) break;
                        flags.setProtected();
                        break;
                    }
                    case 's': {
                        found = this.acceptString("synchronized");
                        if (found) {
                            flags.setSynchronized();
                            break;
                        }
                        found = this.acceptString("static");
                        if (found) {
                            flags.setStatic();
                            break;
                        }
                        found = this.acceptString("strictfp");
                        if (!found) break;
                        flags.setStrict();
                        break;
                    }
                    case 't': {
                        found = this.acceptString("transient");
                        if (!found) break;
                        flags.setTransient();
                        break;
                    }
                    case 'v': {
                        found = this.acceptString("volatile");
                        if (!found) break;
                        flags.setVolatile();
                        break;
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseMemberPattern(ProguardMemberRule.Builder ruleBuilder, boolean allowValueSpecification) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptString("<methods>")) {
                ruleBuilder.setRuleType(ProguardMemberType.ALL_METHODS);
            } else if (this.acceptString("<fields>")) {
                ruleBuilder.setRuleType(ProguardMemberType.ALL_FIELDS);
            } else if (this.acceptString("<init>")) {
                ruleBuilder.setRuleType(ProguardMemberType.INIT);
                ruleBuilder.setName(IdentifierPatternWithWildcards.withoutWildcards("<init>"));
                ruleBuilder.setArguments(this.parseArgumentList());
            } else {
                TextPosition firstStart = this.getPosition();
                IdentifierPatternWithWildcards first = this.acceptIdentifierWithBackreference(IdentifierType.ANY);
                if (first != null) {
                    this.skipWhitespace();
                    if (first.pattern.equals("*") && this.hasNextChar(';')) {
                        ruleBuilder.setRuleType(ProguardMemberType.ALL);
                    } else if (this.hasNextChar('(')) {
                        ruleBuilder.setRuleType(ProguardMemberType.CONSTRUCTOR);
                        ruleBuilder.setName(first);
                        ruleBuilder.setArguments(this.parseArgumentList());
                    } else {
                        TextPosition secondStart = this.getPosition();
                        IdentifierPatternWithWildcards second = this.acceptIdentifierWithBackreference(IdentifierType.ANY);
                        if (second == null) throw this.parseError("Expected field or method name");
                        this.skipWhitespace();
                        if (this.hasNextChar('(')) {
                            ruleBuilder.setRuleType(ProguardMemberType.METHOD);
                            ruleBuilder.setName(second);
                            ruleBuilder.setTypeMatcher(ProguardTypeMatcher.create(first, ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
                            ruleBuilder.setArguments(this.parseArgumentList());
                        } else {
                            if (first.hasUnusualCharacters()) {
                                this.warnUnusualCharacters("type", first.pattern, "field", firstStart);
                            }
                            if (second.hasUnusualCharacters()) {
                                this.warnUnusualCharacters("field name", second.pattern, "field", secondStart);
                            }
                            ruleBuilder.setRuleType(ProguardMemberType.FIELD);
                            ruleBuilder.setName(second);
                            ruleBuilder.setTypeMatcher(ProguardTypeMatcher.create(first, ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
                        }
                        this.skipWhitespace();
                        if (this.acceptString("return")) {
                            this.skipWhitespace();
                            if (this.acceptString("true")) {
                                ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(true));
                            } else if (this.acceptString("false")) {
                                ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(false));
                            } else if (this.acceptString("null")) {
                                ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue());
                            } else {
                                TextPosition fieldOrValueStart = this.getPosition();
                                String qualifiedFieldNameOrInteger = this.acceptFieldNameOrIntegerForReturn();
                                if (qualifiedFieldNameOrInteger != null) {
                                    if (this.isInteger(qualifiedFieldNameOrInteger)) {
                                        Integer min;
                                        Integer max = min = Integer.valueOf(Integer.parseInt(qualifiedFieldNameOrInteger));
                                        this.skipWhitespace();
                                        if (this.acceptString("..")) {
                                            this.skipWhitespace();
                                            max = this.acceptInteger();
                                            if (max == null) {
                                                throw this.parseError("Expected integer value");
                                            }
                                        }
                                        if (!allowValueSpecification) {
                                            throw this.parseError("Unexpected value specification", fieldOrValueStart);
                                        }
                                        ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(new LongInterval(min, max)));
                                    } else {
                                        if (!(ruleBuilder.getTypeMatcher() instanceof ProguardTypeMatcher.MatchSpecificType)) throw this.parseError("Expected specific type", fieldOrValueStart);
                                        int lastDotIndex = qualifiedFieldNameOrInteger.lastIndexOf(".");
                                        DexType fieldType = ((ProguardTypeMatcher.MatchSpecificType)ruleBuilder.getTypeMatcher()).type;
                                        DexType fieldClass = ProguardConfigurationParser.this.dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(qualifiedFieldNameOrInteger.substring(0, lastDotIndex)));
                                        DexString fieldName = ProguardConfigurationParser.this.dexItemFactory.createString(qualifiedFieldNameOrInteger.substring(lastDotIndex + 1));
                                        DexField field = ProguardConfigurationParser.this.dexItemFactory.createField(fieldClass, fieldType, fieldName);
                                        ruleBuilder.setReturnValue(new ProguardMemberRuleReturnValue(field));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!ruleBuilder.isValid()) return;
            this.skipWhitespace();
            this.expectChar(';');
        }

        private List<ProguardTypeMatcher> parseArgumentList() throws ProguardRuleParserException {
            ArrayList<ProguardTypeMatcher> arguments = new ArrayList<ProguardTypeMatcher>();
            this.skipWhitespace();
            this.expectChar('(');
            this.skipWhitespace();
            if (this.acceptChar(')')) {
                return arguments;
            }
            if (this.acceptString("...")) {
                arguments.add(ProguardTypeMatcher.create(IdentifierPatternWithWildcards.withoutWildcards("..."), ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
            } else {
                IdentifierPatternWithWildcards identifierPatternWithWildcards = this.parseClassName();
                while (identifierPatternWithWildcards != null) {
                    arguments.add(ProguardTypeMatcher.create(identifierPatternWithWildcards, ProguardTypeMatcher.ClassOrType.TYPE, ProguardConfigurationParser.this.dexItemFactory));
                    this.skipWhitespace();
                    identifierPatternWithWildcards = this.acceptChar(',') ? this.parseClassName() : null;
                }
            }
            this.skipWhitespace();
            this.expectChar(')');
            return arguments;
        }

        private String replaceSystemPropertyReferences(String fileName) throws ProguardRuleParserException {
            StringBuilder result = new StringBuilder();
            int copied = 0;
            int start = -1;
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.charAt(i) == '<') {
                    if (copied < i) {
                        result.append(fileName.substring(copied, i));
                        copied = i;
                    }
                    start = i;
                    continue;
                }
                if (fileName.charAt(i) != '>' || start == -1 || start >= i) continue;
                String systemProperty = fileName.substring(start + 1, i);
                String v = null;
                if (systemProperty.length() > 0) {
                    v = System.getProperty(systemProperty);
                }
                if (v == null) {
                    throw this.parseError("Value of system property '" + systemProperty + "' not found");
                }
                result.append(v);
                start = -1;
                copied = i + 1;
            }
            if (copied == 0) {
                return fileName;
            }
            result.append(fileName.substring(copied, fileName.length()));
            return result.toString();
        }

        private Path parseFileName(boolean stopAfterPathSeparator) throws ProguardRuleParserException {
            TextPosition start = this.getPosition();
            this.skipWhitespace();
            if (this.baseDirectory == null) {
                throw this.parseError("Options with file names are not supported", start);
            }
            char quote = this.acceptQuoteIfPresent();
            boolean quoted = this.isQuote(quote);
            String fileName = this.acceptString((Integer character) -> !(quoted && character == quote || !quoted && character == File.pathSeparatorChar && stopAfterPathSeparator || !quoted && Character.isWhitespace(character) || !quoted && character == 40));
            if (fileName == null) {
                throw this.parseError("File name expected", start);
            }
            if (quoted) {
                if (this.eof()) {
                    throw this.parseError("No closing " + quote + " quote", start);
                }
                this.acceptChar(quote);
            }
            fileName = this.replaceSystemPropertyReferences(fileName);
            return this.baseDirectory.resolve(fileName);
        }

        private List<FilteredClassPath> parseClassPath() throws ProguardRuleParserException {
            ArrayList<FilteredClassPath> classPath = new ArrayList<FilteredClassPath>();
            this.skipWhitespace();
            Path file = this.parseFileName(true);
            ImmutableList<String> filters = this.parseClassPathFilters();
            classPath.add(new FilteredClassPath(file, filters));
            while (this.acceptChar(File.pathSeparatorChar)) {
                file = this.parseFileName(true);
                filters = this.parseClassPathFilters();
                classPath.add(new FilteredClassPath(file, filters));
            }
            return classPath;
        }

        private ImmutableList<String> parseClassPathFilters() throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.acceptChar('(')) {
                ImmutableList.Builder filters = new ImmutableList.Builder();
                filters.add(this.parseFileFilter());
                this.skipWhitespace();
                while (this.acceptChar(',')) {
                    filters.add(this.parseFileFilter());
                    this.skipWhitespace();
                }
                if (this.peekChar() == ';') {
                    throw this.parseError("Only class file filters are supported in classpath");
                }
                this.expectChar(')');
                return filters.build();
            }
            return ImmutableList.of();
        }

        private String parseFileFilter() throws ProguardRuleParserException {
            TextPosition start = this.getPosition();
            this.skipWhitespace();
            String fileFilter = this.acceptString((Integer character) -> character != 44 && character != 59 && character != 41 && !Character.isWhitespace(character));
            if (fileFilter == null) {
                throw this.parseError("file filter expected", start);
            }
            return fileFilter;
        }

        private ProguardAssumeNoSideEffectRule parseAssumeNoSideEffectsRule(Position start) throws ProguardRuleParserException {
            ProguardAssumeNoSideEffectRule.Builder builder = (ProguardAssumeNoSideEffectRule.Builder)((ProguardAssumeNoSideEffectRule.Builder)ProguardAssumeNoSideEffectRule.builder().setOrigin(this.origin)).setStart(start);
            this.parseClassSpec(builder, true);
            TextPosition end = this.getPosition();
            builder.setSource(this.getSourceSnippet(this.contents, start, end));
            builder.setEnd(end);
            return builder.build();
        }

        private ProguardAssumeValuesRule parseAssumeValuesRule(Position start) throws ProguardRuleParserException {
            ProguardAssumeValuesRule.Builder builder = (ProguardAssumeValuesRule.Builder)((ProguardAssumeValuesRule.Builder)ProguardAssumeValuesRule.builder().setOrigin(this.origin)).setStart(start);
            this.parseClassSpec(builder, true);
            TextPosition end = this.getPosition();
            builder.setSource(this.getSourceSnippet(this.contents, start, end));
            builder.setEnd(end);
            return builder.build();
        }

        private void skipWhitespace() {
            while (!this.eof() && Character.isWhitespace(this.contents.charAt(this.position))) {
                if (this.peekChar() == '\n') {
                    ++this.line;
                    this.lineStartPosition = this.position + 1;
                }
                ++this.position;
            }
            this.skipComment();
        }

        private void skipComment() {
            if (this.eof()) {
                return;
            }
            if (this.peekChar() == '#') {
                while (!this.eof() && this.peekChar() != '\n') {
                    ++this.position;
                }
                this.skipWhitespace();
            }
        }

        private boolean isInteger(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private boolean eof() {
            return this.position == this.contents.length();
        }

        private boolean eof(int position) {
            return position == this.contents.length();
        }

        private boolean hasNextChar(char c) {
            if (this.eof()) {
                return false;
            }
            return this.peekChar() == c;
        }

        private boolean hasNextChar(Predicate<Character> predicate) {
            if (this.eof()) {
                return false;
            }
            return predicate.test(Character.valueOf(this.peekChar()));
        }

        private boolean isOptionalArgumentGiven() {
            return !this.eof() && !this.hasNextChar('-');
        }

        private boolean acceptChar(char c) {
            if (this.hasNextChar(c)) {
                ++this.position;
                return true;
            }
            return false;
        }

        private char acceptQuoteIfPresent() {
            boolean NO_QUOTE = false;
            return this.hasNextChar(this::isQuote) ? this.readChar() : (char)'\u0000';
        }

        private void expectClosingQuote(char quote) throws ProguardRuleParserException {
            assert (this.isQuote(quote));
            if (!this.hasNextChar(quote)) {
                throw this.parseError("Missing closing quote");
            }
            this.acceptChar(quote);
        }

        private boolean isQuote(char c) {
            return c == '\'' || c == '\"';
        }

        private char peekChar() {
            return this.contents.charAt(this.position);
        }

        private char peekCharAt(int position) {
            assert (!this.eof(position));
            return this.contents.charAt(position);
        }

        private char readChar() {
            return this.contents.charAt(this.position++);
        }

        private int remainingChars() {
            return this.contents.length() - this.position;
        }

        private void expectChar(char c) throws ProguardRuleParserException {
            if (!this.acceptChar(c)) {
                throw this.parseError("Expected char '" + c + "'");
            }
        }

        private boolean acceptString(String expected) {
            if (this.remainingChars() < expected.length()) {
                return false;
            }
            for (int i = 0; i < expected.length(); ++i) {
                if (expected.charAt(i) == this.contents.charAt(this.position + i)) continue;
                return false;
            }
            this.position += expected.length();
            return true;
        }

        private String acceptString() {
            return this.acceptString((Integer c) -> !Character.isWhitespace(c));
        }

        private String acceptQuotedOrUnquotedString() throws ProguardRuleParserException {
            char quote = this.acceptQuoteIfPresent();
            String result = this.acceptString((Integer c) -> !Character.isWhitespace(c) && c != quote);
            if (this.isQuote(quote)) {
                this.expectClosingQuote(quote);
            }
            return result == null ? "" : result;
        }

        private Integer acceptInteger() {
            String s = this.acceptString(Character::isDigit);
            if (s == null) {
                return null;
            }
            return Integer.parseInt(s);
        }

        private String acceptClassName() {
            return this.acceptString(this.CLASS_NAME_PREDICATE);
        }

        private IdentifierPatternWithWildcards acceptIdentifierWithBackreference(IdentifierType kind) {
            ImmutableList.Builder wildcardsCollector = ImmutableList.builder();
            StringBuilder currentAsterisks = null;
            int asteriskCount = 0;
            StringBuilder currentBackreference = null;
            this.skipWhitespace();
            int start = this.position;
            int end = this.position;
            while (!this.eof(end)) {
                int current = this.contents.codePointAt(end);
                assert (currentAsterisks == null || currentBackreference == null);
                if (currentBackreference != null) {
                    if (current == 62) {
                        try {
                            int backreference = Integer.parseUnsignedInt(currentBackreference.toString());
                            if (backreference <= 0) {
                                throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Wildcard <" + backreference + "> is invalid.", this.origin, this.getPosition()));
                            }
                            wildcardsCollector.add(new ProguardWildcard.BackReference(backreference));
                            currentBackreference = null;
                            end += Character.charCount(current);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Wildcard <" + currentBackreference.toString() + "> is invalid.", this.origin, this.getPosition()));
                        }
                    }
                    if (48 <= current && current <= 57 || current == 45 && currentBackreference.length() == 0) {
                        currentBackreference.append((char)current);
                        end += Character.charCount(current);
                        continue;
                    }
                    if (kind == IdentifierType.CLASS_NAME) {
                        throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Use of generics not allowed for java type.", this.origin, this.getPosition()));
                    }
                    currentBackreference = null;
                } else if (currentAsterisks != null) {
                    if (current == 42) {
                        if (asteriskCount >= 3) {
                            wildcardsCollector.add(new ProguardWildcard.Pattern(currentAsterisks.toString()));
                            currentAsterisks = new StringBuilder();
                            asteriskCount = 0;
                        }
                        currentAsterisks.append((char)current);
                        ++asteriskCount;
                        end += Character.charCount(current);
                        continue;
                    }
                    wildcardsCollector.add(new ProguardWildcard.Pattern(currentAsterisks.toString()));
                    currentAsterisks = null;
                    asteriskCount = 0;
                }
                assert (currentAsterisks == null && currentBackreference == null);
                if (current == 42) {
                    if (kind == IdentifierType.CLASS_NAME) {
                        currentAsterisks = new StringBuilder();
                        currentAsterisks.append((char)current);
                        asteriskCount = 1;
                    } else {
                        wildcardsCollector.add(new ProguardWildcard.Pattern(String.valueOf((char)current)));
                    }
                    end += Character.charCount(current);
                    continue;
                }
                if (current == 63 || current == 37) {
                    wildcardsCollector.add(new ProguardWildcard.Pattern(String.valueOf((char)current)));
                    end += Character.charCount(current);
                    continue;
                }
                if (this.CLASS_NAME_PREDICATE.test(current) || current == 62) {
                    end += Character.charCount(current);
                    continue;
                }
                if (current != 60) break;
                currentBackreference = new StringBuilder();
                end += Character.charCount(current);
            }
            if (currentAsterisks != null) {
                wildcardsCollector.add(new ProguardWildcard.Pattern(currentAsterisks.toString()));
            }
            if (kind == IdentifierType.CLASS_NAME && currentBackreference != null) {
                throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Missing closing angular bracket", this.origin, this.getPosition()));
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return new IdentifierPatternWithWildcards(this.contents.substring(start, end), (List<ProguardWildcard>)((Object)wildcardsCollector.build()));
        }

        private String acceptFieldNameOrIntegerForReturn() {
            int end;
            int current;
            this.skipWhitespace();
            int start = this.position;
            for (end = this.position; !this.eof(end) && ((current = this.contents.codePointAt(end)) != 46 || this.eof(end + 1) || this.peekCharAt(end + 1) != '.') && (start == end && IdentifierUtils.isDexIdentifierStart(current) || start < end && (IdentifierUtils.isDexIdentifierPart(current) || current == 46)); end += Character.charCount(current)) {
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return this.contents.substring(start, end);
        }

        private List<String> acceptPatternList() throws ProguardRuleParserException {
            ArrayList<String> patterns = new ArrayList<String>();
            this.skipWhitespace();
            String pattern = this.acceptPattern();
            while (pattern != null) {
                patterns.add(pattern);
                this.skipWhitespace();
                TextPosition start = this.getPosition();
                if (this.acceptChar(',')) {
                    this.skipWhitespace();
                    pattern = this.acceptPattern();
                    if (pattern != null) continue;
                    throw this.parseError("Expected list element", start);
                }
                pattern = null;
            }
            return patterns;
        }

        private String acceptPattern() {
            return this.acceptString((Integer codePoint) -> IdentifierUtils.isDexIdentifierPart(codePoint) || codePoint == 33 || codePoint == 42);
        }

        private String acceptString(Predicate<Integer> codepointAcceptor) {
            int current;
            int start = this.position;
            int end = this.position;
            while (!this.eof(end) && codepointAcceptor.test(current = this.contents.codePointAt(end))) {
                end += Character.charCount(current);
            }
            if (start == end) {
                return null;
            }
            this.position = end;
            return this.contents.substring(start, end);
        }

        private void unacceptString(String expected) {
            assert (this.position >= expected.length());
            this.position -= expected.length();
            for (int i = 0; i < expected.length(); ++i) {
                assert (expected.charAt(i) == this.contents.charAt(this.position + i));
            }
        }

        private void parseClassFilter(Consumer<ProguardClassNameList> consumer) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.isOptionalArgumentGiven()) {
                consumer.accept(this.parseClassNames());
            } else {
                consumer.accept(ProguardClassNameList.singletonList(ProguardTypeMatcher.defaultAllMatcher()));
            }
        }

        private ProguardClassNameList parseClassNames() throws ProguardRuleParserException {
            ProguardClassNameList.Builder builder = ProguardClassNameList.builder();
            this.skipWhitespace();
            boolean negated = this.acceptChar('!');
            builder.addClassName(negated, ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory));
            this.skipWhitespace();
            while (this.acceptChar(',')) {
                negated = this.acceptChar('!');
                builder.addClassName(negated, ProguardTypeMatcher.create(this.parseClassName(), ProguardTypeMatcher.ClassOrType.CLASS, ProguardConfigurationParser.this.dexItemFactory));
                this.skipWhitespace();
            }
            return builder.build();
        }

        private String parsePackageNameOrEmptyString() {
            String name = this.acceptClassName();
            return name == null ? "" : name;
        }

        private IdentifierPatternWithWildcards parseClassName() throws ProguardRuleParserException {
            IdentifierPatternWithWildcards name = this.acceptIdentifierWithBackreference(IdentifierType.CLASS_NAME);
            if (name == null) {
                throw this.parseError("Class name expected");
            }
            return name;
        }

        private boolean pathFilterMatcher(Integer character) {
            return character != 44 && !Character.isWhitespace(character);
        }

        private void parsePathFilter(Consumer<ProguardPathList> consumer) throws ProguardRuleParserException {
            this.skipWhitespace();
            if (this.isOptionalArgumentGiven()) {
                consumer.accept(this.parsePathFilter());
            } else {
                consumer.accept(ProguardPathList.emptyList());
            }
        }

        private ProguardPathList parsePathFilter() throws ProguardRuleParserException {
            ProguardPathList.Builder builder = ProguardPathList.builder();
            this.skipWhitespace();
            boolean negated = this.acceptChar('!');
            this.skipWhitespace();
            String fileFilter = this.acceptString(this::pathFilterMatcher);
            if (fileFilter == null) {
                throw this.parseError("Path filter expected");
            }
            builder.addFileName(negated, fileFilter);
            this.skipWhitespace();
            while (this.acceptChar(',')) {
                this.skipWhitespace();
                negated = this.acceptChar('!');
                this.skipWhitespace();
                fileFilter = this.acceptString(this::pathFilterMatcher);
                if (fileFilter == null) {
                    throw this.parseError("Path filter expected");
                }
                builder.addFileName(negated, fileFilter);
                this.skipWhitespace();
            }
            return builder.build();
        }

        private String snippetForPosition() {
            String[] lines = this.contents.split("\n", -1);
            int remaining = this.position;
            for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
                String line = lines[lineNumber];
                if (remaining <= line.length() || lineNumber == lines.length - 1) {
                    String arrow = CharBuffer.allocate(remaining).toString().replace('\u0000', ' ') + '^';
                    return this.name + ":" + (lineNumber + 1) + ":" + (remaining + 1) + "\n" + line + '\n' + arrow;
                }
                remaining -= line.length() + 1;
            }
            return this.name;
        }

        private String snippetForPosition(TextPosition start) {
            String[] lines = this.contents.split("\n", -1);
            String line = lines[start.getLine() - 1];
            String arrow = CharBuffer.allocate(start.getColumn() - 1).toString().replace('\u0000', ' ') + '^';
            return this.name + ":" + (start.getLine() + 1) + ":" + start.getColumn() + "\n" + line + '\n' + arrow;
        }

        private ProguardRuleParserException parseError(String message) {
            return new ProguardRuleParserException(message, this.snippetForPosition(), this.origin, this.getPosition());
        }

        private ProguardRuleParserException parseError(String message, Throwable cause) {
            return new ProguardRuleParserException(message, this.snippetForPosition(), this.origin, this.getPosition(), cause);
        }

        private ProguardRuleParserException parseError(String message, TextPosition start, Throwable cause) {
            return new ProguardRuleParserException(message, this.snippetForPosition(start), this.origin, this.getPosition(start), cause);
        }

        private ProguardRuleParserException parseError(String message, TextPosition start) {
            return new ProguardRuleParserException(message, this.snippetForPosition(start), this.origin, this.getPosition(start));
        }

        private void warnIgnoringOptions(String optionName, TextPosition start) {
            ProguardConfigurationParser.this.reporter.warning(new StringDiagnostic("Ignoring option: -" + optionName, this.origin, this.getPosition(start)));
        }

        private void warnOverridingOptions(String optionName, String victim, TextPosition start) {
            ProguardConfigurationParser.this.reporter.warning(new StringDiagnostic("Option -" + optionName + " overrides -" + victim, this.origin, this.getPosition(start)));
        }

        private void warnUnusualCharacters(String kind, String pattern, String ruleType, TextPosition start) {
            ProguardConfigurationParser.this.reporter.warning(new StringDiagnostic("The " + kind + " \"" + pattern + "\" is used in a " + ruleType + " rule. The characters in this " + kind + " are legal for the JVM, but unlikely to originate from a source language. Maybe this is not the rule you are looking for.", this.origin, this.getPosition(start)));
        }

        private void failPartiallyImplementedOption(String optionName, TextPosition start) {
            throw ProguardConfigurationParser.this.reporter.fatalError(new StringDiagnostic("Option " + optionName + " currently not supported", this.origin, this.getPosition(start)));
        }

        private Position getPosition(TextPosition start) {
            if (start.getOffset() == (long)this.position) {
                return start;
            }
            return new TextRange(start, this.getPosition());
        }

        private TextPosition getPosition() {
            return new TextPosition(this.position, this.line, this.getColumn());
        }

        private int getColumn() {
            return this.position - this.lineStartPosition + 1;
        }

        private String getSourceSnippet(String source, Position start, Position end) {
            return start instanceof TextPosition && end instanceof TextPosition ? ProguardConfigurationParser.this.getTextSourceSnippet(source, (TextPosition)start, (TextPosition)end) : null;
        }
    }

    private static enum IdentifierType {
        CLASS_NAME,
        ANY;

    }
}

