/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.AssemblyWriter;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexByteCodeWriter;
import com.android.tools.r8.graph.SmaliWriter;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class Disassemble {
    public static void main(String[] args) throws IOException, ExecutionException, CompilationFailedException {
        DisassembleCommand.Builder builder = DisassembleCommand.parse(args);
        DisassembleCommand command = (DisassembleCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println("Usage: disasm [options] <input-files>\n where <input-files> are dex files\n and options are:\n  --all                   # Include all information in disassembly.\n  --smali                 # Disassemble using smali syntax.\n  --ir                    # Print IR before and after optimization.\n  --pg-map <file>         # Proguard map <file> for mapping names.\n  --output                # Specify a file or directory to write to.\n  --version               # Print the version of r8.\n  --help                  # Print this message.");
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("Disassemble (R8) 1.4.23");
            return;
        }
        Disassemble.disassemble(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassemble(DisassembleCommand command) throws IOException, ExecutionException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        Timing timing = new Timing("disassemble");
        try {
            DexByteCodeWriter writer;
            DexApplication application = new ApplicationReader(app, options, timing).read(command.proguardMap, executor);
            DexByteCodeWriter dexByteCodeWriter = writer = command.useSmali() ? new SmaliWriter(application, options) : new AssemblyWriter(application, options, command.allInfo, command.useIr());
            if (command.getOutputPath() != null) {
                writer.write(command.getOutputPath());
            } else {
                writer.write(System.out);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    public static class DisassembleCommand
    extends BaseCommand {
        private final Path outputPath;
        private final StringResource proguardMap;
        static final String USAGE_MESSAGE = "Usage: disasm [options] <input-files>\n where <input-files> are dex files\n and options are:\n  --all                   # Include all information in disassembly.\n  --smali                 # Disassemble using smali syntax.\n  --ir                    # Print IR before and after optimization.\n  --pg-map <file>         # Proguard map <file> for mapping names.\n  --output                # Specify a file or directory to write to.\n  --version               # Print the version of r8.\n  --help                  # Print this message.";
        private final boolean allInfo;
        private final boolean useSmali;
        private final boolean useIr;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) {
            Builder builder = DisassembleCommand.builder();
            DisassembleCommand.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--all")) {
                    builder.setAllInfo(true);
                    continue;
                }
                if (arg.equals("--smali")) {
                    builder.setUseSmali(true);
                    continue;
                }
                if (arg.equals("--ir")) {
                    builder.setUseIr(true);
                    continue;
                }
                if (arg.equals("--pg-map")) {
                    builder.setProguardMapFile(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--output")) {
                    String outputPath = args[++i];
                    builder.setOutputPath(Paths.get(outputPath, new String[0]));
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private DisassembleCommand(AndroidApp inputApp, Path outputPath, StringResource proguardMap, boolean allInfo, boolean useSmali, boolean useIr) {
            super(inputApp);
            this.outputPath = outputPath;
            this.proguardMap = proguardMap;
            this.allInfo = allInfo;
            this.useSmali = useSmali;
            this.useIr = useIr;
        }

        private DisassembleCommand(boolean printHelp, boolean printVersion) {
            super(printHelp, printVersion);
            this.outputPath = null;
            this.proguardMap = null;
            this.allInfo = false;
            this.useSmali = false;
            this.useIr = false;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public boolean useSmali() {
            return this.useSmali;
        }

        public boolean useIr() {
            return this.useIr;
        }

        @Override
        InternalOptions getInternalOptions() {
            InternalOptions internal = new InternalOptions();
            internal.useSmaliSyntax = this.useSmali;
            internal.enableCfFrontend = true;
            return internal;
        }

        public static class Builder
        extends BaseCommand.Builder<DisassembleCommand, Builder> {
            private Path outputPath = null;
            private Path proguardMapFile = null;
            private boolean useSmali = false;
            private boolean allInfo = false;
            private boolean useIr;

            @Override
            Builder self() {
                return this;
            }

            public Builder setProguardMapFile(Path path) {
                this.proguardMapFile = path;
                return this;
            }

            public Path getOutputPath() {
                return this.outputPath;
            }

            public Builder setOutputPath(Path outputPath) {
                this.outputPath = outputPath;
                return this;
            }

            public Builder setAllInfo(boolean allInfo) {
                this.allInfo = allInfo;
                return this;
            }

            public Builder setUseSmali(boolean useSmali) {
                this.useSmali = useSmali;
                return this;
            }

            public Builder setUseIr(boolean useIr) {
                this.useIr = useIr;
                return this;
            }

            @Override
            protected DisassembleCommand makeCommand() {
                if (this.isPrintHelp() || this.isPrintVersion()) {
                    return new DisassembleCommand(this.isPrintHelp(), this.isPrintVersion());
                }
                return new DisassembleCommand(this.getAppBuilder().build(), this.getOutputPath(), this.proguardMapFile == null ? null : StringResource.fromFile(this.proguardMapFile), this.allInfo, this.useSmali, this.useIr);
            }
        }
    }
}

