/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.RelativeFile;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.StoredEntryType;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;

public final class RelativeFiles {
    private RelativeFiles() {
    }

    public static ImmutableSet<RelativeFile> fromDirectory(File directory) {
        return RelativeFiles.fromDirectory(directory, directory);
    }

    public static ImmutableSet<RelativeFile> fromDirectory(File directory, Predicate<RelativeFile> filter) {
        return ImmutableSet.copyOf((Collection)Sets.filter(RelativeFiles.fromDirectory(directory, directory), filter::test));
    }

    private static ImmutableSet<RelativeFile> fromDirectory(File base, File directory) {
        File[] directoryFiles;
        Preconditions.checkArgument((boolean)base.isDirectory(), (Object)"!base.isDirectory()");
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        HashSet files = Sets.newHashSet();
        for (File file : directoryFiles = (File[])Verify.verifyNotNull((Object)directory.listFiles(), (String)"directory.listFiles() == null", (Object[])new Object[0])) {
            if (file.isDirectory()) {
                files.addAll(RelativeFiles.fromDirectory(base, file));
                continue;
            }
            files.add(new RelativeFile(base, file));
        }
        return ImmutableSet.copyOf((Collection)files);
    }

    public static Predicate<RelativeFile> fromPathPredicate(Predicate<String> predicate) {
        return rf -> predicate.test(rf.getRelativePath());
    }

    public static ImmutableSet<RelativeFile> fromZip(File zip2) throws IOException {
        Preconditions.checkArgument((boolean)zip2.isFile(), (String)"!zip.isFile(): %s", (Object)zip2);
        HashSet files = Sets.newHashSet();
        try (ZFile zipReader = ZFile.openReadOnly((File)zip2);){
            for (StoredEntry entry : zipReader.entries()) {
                if (entry.getType() != StoredEntryType.FILE) continue;
                files.add(new RelativeFile(zip2, entry.getCentralDirectoryHeader().getName()));
            }
        }
        return ImmutableSet.copyOf((Collection)files);
    }
}

