/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ChromeTracingProfileConverter;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.ProcessProfileWriterFactory;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public final class ProcessProfileWriter
implements ProfileRecordWriter {
    private boolean finished = false;
    private final GradleBuildMemorySample mStartMemoryStats;
    private final NameAnonymizer mNameAnonymizer;
    private final GradleBuildProfile.Builder mBuild;
    private final List<AndroidStudioEvent.Builder> otherEvents = Collections.synchronizedList(new ArrayList());
    private final LoadingCache<String, Project> mProjects;
    private final boolean mEnableChromeTracingOutput;
    private final AtomicLong lastRecordId = new AtomicLong(1L);
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> spans;
    private final List<Supplier<String>> applicationIdSuppliers = Collections.synchronizedList(new ArrayList());

    @Override
    public long allocateRecordId() {
        return this.lastRecordId.incrementAndGet();
    }

    public static ProcessProfileWriter get() {
        return ProcessProfileWriterFactory.getFactory().get();
    }

    ProcessProfileWriter(boolean enableChromeTracingOutput) {
        this.mEnableChromeTracingOutput = enableChromeTracingOutput;
        this.mNameAnonymizer = new NameAnonymizer();
        this.mBuild = GradleBuildProfile.newBuilder();
        this.mStartMemoryStats = this.createAndRecordMemorySample();
        this.mProjects = CacheBuilder.newBuilder().build((CacheLoader)new ProjectCacheLoader(this.mNameAnonymizer));
        this.spans = new ConcurrentLinkedQueue();
    }

    @Override
    public void writeRecord(String project, String variant, GradleBuildProfileSpan.Builder executionRecord) {
        executionRecord.setProject(this.mNameAnonymizer.anonymizeProjectPath(project));
        executionRecord.setVariant(this.mNameAnonymizer.anonymizeVariant(project, variant));
        this.spans.add(executionRecord.build());
    }

    public void recordEvent(AndroidStudioEvent.Builder event) {
        Preconditions.checkArgument((boolean)event.hasProductDetails(), (Object)"Product details not set.");
        this.otherEvents.add(event);
    }

    synchronized void finishAndWrite(Path outputFile) {
        this.finish();
        try {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(outputFile, StandardOpenOption.CREATE_NEW));){
                this.mBuild.build().writeTo((OutputStream)outputStream);
            }
            if (this.mEnableChromeTracingOutput) {
                ChromeTracingProfileConverter.toJson(outputFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    synchronized void finish() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Already finished");
        this.finished = true;
        this.mBuild.addAllSpan(this.spans);
        GradleBuildMemorySample memoryStats = this.createAndRecordMemorySample();
        this.mBuild.setBuildTime(memoryStats.getTimestamp() - this.mStartMemoryStats.getTimestamp());
        this.mBuild.setGcCount(memoryStats.getGcCount() - this.mStartMemoryStats.getGcCount());
        this.mBuild.setGcTime(memoryStats.getGcTimeMs() - this.mStartMemoryStats.getGcTimeMs());
        for (Project project : this.mProjects.asMap().values()) {
            for (GradleBuildVariant.Builder variant : project.variants.values()) {
                project.properties.addVariant(variant);
            }
            if (project.properties == null) continue;
            this.mBuild.addProject(project.properties);
        }
        this.mBuild.addAllRawProjectId(this.getApplicationIds());
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_PROFILE).setGradleBuildProfile(this.mBuild.build()).setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setJvmDetails(CommonMetricsData.getJvmDetails()));
        for (AndroidStudioEvent.Builder otherEvent : this.otherEvents) {
            UsageTracker.log((AndroidStudioEvent.Builder)otherEvent);
        }
    }

    private synchronized List<String> getApplicationIds() {
        HashSet<String> applicationIds = new HashSet<String>(this.applicationIdSuppliers.size());
        for (Supplier<String> applicationIdSupplier : this.applicationIdSuppliers) {
            applicationIds.add(applicationIdSupplier.get());
        }
        return (List)applicationIds.stream().sorted().collect(ImmutableList.toImmutableList());
    }

    public static GradleBuildProfile.Builder getGlobalProperties() {
        return ProcessProfileWriter.get().getProperties();
    }

    GradleBuildProfile.Builder getProperties() {
        return this.mBuild;
    }

    public static GradleBuildProject.Builder getProject(String projectPath) {
        return ((Project)ProcessProfileWriter.get().mProjects.getUnchecked((Object)projectPath)).properties;
    }

    public static GradleBuildVariant.Builder getOrCreateVariant(String projectPath, String variantName) {
        return ProcessProfileWriter.get().addVariant(projectPath, variantName);
    }

    private GradleBuildVariant.Builder addVariant(String projectPath, String variantName) {
        Project project = (Project)this.mProjects.getUnchecked((Object)projectPath);
        GradleBuildVariant.Builder properties = project.variants.get(variantName);
        if (properties == null) {
            properties = GradleBuildVariant.newBuilder();
            properties.setId(this.mNameAnonymizer.anonymizeVariant(projectPath, variantName));
            project.variants.put(variantName, properties);
        }
        return properties;
    }

    private GradleBuildMemorySample createAndRecordMemorySample() {
        GradleBuildMemorySample stats = GradleBuildMemorySample.newBuilder().setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setTimestamp(System.currentTimeMillis()).build();
        if (stats != null) {
            this.mBuild.addMemorySample(stats);
        }
        return stats;
    }

    public static void recordMemorySample() {
        ProcessProfileWriter.get().createAndRecordMemorySample();
    }

    public void recordApplicationId(Supplier<String> applicationId) {
        this.applicationIdSuppliers.add(applicationId);
    }

    private static class Project {
        final Map<String, GradleBuildVariant.Builder> variants = Maps.newConcurrentMap();
        final GradleBuildProject.Builder properties = GradleBuildProject.newBuilder();

        Project(long id) {
            this.properties.setId(id);
        }
    }

    private static class ProjectCacheLoader
    extends CacheLoader<String, Project> {
        private final NameAnonymizer mNameAnonymizer;

        ProjectCacheLoader(NameAnonymizer nameAnonymizer) {
            this.mNameAnonymizer = nameAnonymizer;
        }

        public Project load(String name) throws Exception {
            return new Project(this.mNameAnonymizer.anonymizeProjectPath(name));
        }
    }
}

