/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.origin.Origin;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class AppInfoWithSubtyping
extends AppInfo {
    private final Set<DexType> missingClasses = Sets.newIdentityHashSet();
    private final Map<DexType, ImmutableSet<DexType>> subtypeMap = new IdentityHashMap<DexType, ImmutableSet<DexType>>();

    public AppInfoWithSubtyping(DexApplication application) {
        super(application);
        this.populateSubtypeMap(application.asDirect(), application.dexItemFactory);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous) {
        super(previous);
        this.missingClasses.addAll(previous.missingClasses);
        this.subtypeMap.putAll(previous.subtypeMap);
        assert (this.app instanceof DirectMappedDexApplication);
    }

    protected AppInfoWithSubtyping(DirectMappedDexApplication application, GraphLense lense) {
        super(application, lense);
        this.populateSubtypeMap(application, this.dexItemFactory);
    }

    private DirectMappedDexApplication getDirectApplication() {
        return (DirectMappedDexApplication)this.app;
    }

    public Iterable<DexLibraryClass> libraryClasses() {
        return this.getDirectApplication().libraryClasses();
    }

    public Set<DexType> getMissingClasses() {
        return Collections.unmodifiableSet(this.missingClasses);
    }

    public Set<DexType> subtypes(DexType type) {
        assert (type.isClassType());
        ImmutableSet<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    private void populateSuperType(Map<DexType, Set<DexType>> map2, DexType superType, DexClass baseClass, Function<DexType, DexClass> definitions) {
        Set set;
        if (superType != null && (set = map2.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            this.populateAllSuperTypes(map2, superType, baseClass, definitions);
        }
    }

    private void populateAllSuperTypes(Map<DexType, Set<DexType>> map2, DexType holder, DexClass baseClass, Function<DexType, DexClass> definitions) {
        DexClass holderClass = definitions.apply(holder);
        if (holderClass != null) {
            this.populateSuperType(map2, holderClass.superType, baseClass, definitions);
            if (holderClass.superType != null) {
                holderClass.superType.addDirectSubtype(holder);
            } else assert (this.dexItemFactory.objectType == holder);
            for (DexType inter : holderClass.interfaces.values) {
                this.populateSuperType(map2, inter, baseClass, definitions);
                inter.addInterfaceSubtype(holder);
            }
            if (holderClass.isInterface()) {
                holder.tagAsInteface();
            }
        } else {
            if (!baseClass.isLibraryClass()) {
                this.missingClasses.add(holder);
            }
            if (holder != this.dexItemFactory.objectType) {
                this.dexItemFactory.objectType.addDirectSubtype(holder);
            }
        }
    }

    private void populateSubtypeMap(DirectMappedDexApplication app, DexItemFactory dexItemFactory) {
        dexItemFactory.clearSubtypeInformation();
        dexItemFactory.objectType.tagAsSubtypeRoot();
        IdentityHashMap<DexType, Set<DexType>> map2 = new IdentityHashMap<DexType, Set<DexType>>();
        for (DexClass dexClass : Iterables.concat(app.classes(), app.libraryClasses())) {
            this.populateAllSuperTypes(map2, dexClass.type, dexClass, app::definitionFor);
        }
        for (Map.Entry entry : map2.entrySet()) {
            this.subtypeMap.put((DexType)entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        assert (DexType.validateLevelsAreCorrect(app::definitionFor, dexItemFactory));
    }

    public Set<DexEncodedMethod> lookupVirtualTargets(DexMethod method) {
        if (method.holder.isArrayType()) {
            assert (method.name == this.dexItemFactory.cloneMethodName);
            return null;
        }
        DexClass root = this.definitionFor(method.holder);
        if (root == null) {
            return null;
        }
        AppInfo.ResolutionResult topTargets = this.resolveMethodOnClass(method.holder, method);
        if (topTargets.asResultOfResolve() == null) {
            return null;
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        topTargets.forEachTarget(result::add);
        for (DexType type : this.subtypes(method.holder)) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult methods = this.resolveMethodOnClass(type, method);
            methods.forEachTarget(target -> {
                if (target.isVirtualMethod()) {
                    result.add((DexEncodedMethod)target);
                }
            });
        }
        return result;
    }

    @Override
    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexType invocationContext) {
        if (!invocationContext.isSubtypeOf(method.holder, this)) {
            DexClass contextClass = this.definitionFor(invocationContext);
            throw new CompilationError("Illegal invoke-super to " + method.toSourceString() + " from class " + invocationContext, contextClass != null ? contextClass.getOrigin() : Origin.unknown());
        }
        return super.lookupSuperTarget(method, invocationContext);
    }

    protected boolean hasAnyInstantiatedLambdas(DexType type) {
        return true;
    }

    public Set<DexEncodedMethod> lookupInterfaceTargets(DexMethod method) {
        DexEncodedMethod singleTarget;
        AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
        if (topTarget.asResultOfResolve() == null) {
            return null;
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        if (topTarget.hasSingleTarget() && (singleTarget = topTarget.asSingleTarget()).getCode() != null && this.hasAnyInstantiatedLambdas(singleTarget.method.holder)) {
            result.add(singleTarget);
        }
        Set<DexType> set = this.subtypes(method.holder);
        for (DexType type : set) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult targetMethods = this.resolveMethodOnClass(type, method);
            targetMethods.forEachTarget(result::add);
        }
        return result;
    }

    public Set<DexEncodedMethod> lookupLambdaImplementedMethods(DexCallSite callSite) {
        List<DexType> callSiteInterfaces = LambdaDescriptor.getInterfaces(callSite, this);
        if (callSiteInterfaces == null || callSiteInterfaces.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>(callSiteInterfaces);
        Set<DexType> visited = Sets.newIdentityHashSet();
        while (!worklist.isEmpty()) {
            DexType iface = (DexType)worklist.removeFirst();
            if (iface.isUnknown() || !visited.add(iface)) continue;
            assert (iface.isInterface());
            DexClass clazz = this.definitionFor(iface);
            if (clazz == null) continue;
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                if (method.method.name != callSite.methodName || !method.accessFlags.isAbstract()) continue;
                result.add(method);
            }
            Collections.addAll(worklist, clazz.interfaces.values);
        }
        return result;
    }

    public boolean isStringConcat(DexMethodHandle bootstrapMethod) {
        return bootstrapMethod.type.isInvokeStatic() && (bootstrapMethod.asMethod() == this.dexItemFactory.stringConcatWithConstantsMethod || bootstrapMethod.asMethod() == this.dexItemFactory.stringConcatMethod);
    }

    @Override
    public void registerNewType(DexType newType, DexType superType) {
        superType.addDirectSubtype(newType);
    }

    @Override
    public boolean hasSubtyping() {
        return true;
    }

    @Override
    public AppInfoWithSubtyping withSubtyping() {
        return this;
    }
}

