/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.IROrdering;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.ThrowingBiConsumer;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CallGraph
extends CallSiteInformation {
    private final Map<DexEncodedMethod, Node> nodes = new LinkedHashMap<DexEncodedMethod, Node>();
    private final IROrdering shuffle;
    private final Set<DexMethod> singleCallSite = Sets.newIdentityHashSet();
    private final Set<DexMethod> doubleCallSite = Sets.newIdentityHashSet();

    private CallGraph(InternalOptions options) {
        this.shuffle = options.testing.irOrdering;
    }

    public static CallGraph build(DexApplication application, AppView<Enqueuer.AppInfoWithLiveness> appView, InternalOptions options, Timing timing) {
        CallGraph graph = new CallGraph(options);
        DexClass[] classes = application.classes().toArray(new DexClass[application.classes().size()]);
        Arrays.sort(classes, (a, b) -> a.type.slowCompareTo(b.type));
        for (DexClass clazz : classes) {
            for (DexEncodedMethod method : clazz.allMethodsSorted()) {
                Node node = graph.ensureMethodNode(method);
                InvokeExtractor extractor = new InvokeExtractor(appView, node, graph);
                method.registerCodeReferences(extractor);
            }
        }
        assert (CallGraph.allMethodsExists(application, graph));
        timing.begin("Cycle elimination");
        CycleEliminator cycleEliminator = new CycleEliminator(graph.nodes.values(), options);
        cycleEliminator.breakCycles();
        timing.end();
        assert (cycleEliminator.breakCycles() == 0);
        graph.fillCallSiteSets(appView.appInfo());
        return graph;
    }

    @Override
    public boolean hasSingleCallSite(DexMethod method) {
        return this.singleCallSite.contains(method);
    }

    @Override
    public boolean hasDoubleCallSite(DexMethod method) {
        return this.doubleCallSite.contains(method);
    }

    private void fillCallSiteSets(Enqueuer.AppInfoWithLiveness appInfo) {
        assert (this.singleCallSite.isEmpty());
        for (Node value : this.nodes.values()) {
            if (appInfo.isPinned(value.method.method)) continue;
            if (value.invokeCount == 1) {
                this.singleCallSite.add(value.method.method);
                continue;
            }
            if (value.invokeCount != 2) continue;
            this.doubleCallSite.add(value.method.method);
        }
    }

    private static boolean allMethodsExists(DexApplication application, CallGraph graph) {
        for (DexProgramClass clazz : application.classes()) {
            clazz.forEachMethod(method -> {
                assert (graph.nodes.get(method) != null);
            });
        }
        return true;
    }

    private Collection<DexEncodedMethod> extractLeaves() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        List<Node> leaves = this.nodes.values().stream().filter(Node::isLeaf).collect(Collectors.toList());
        leaves.forEach(leaf -> {
            ((Node)leaf).callers.forEach(caller -> ((Node)caller).callees.remove(leaf));
            this.nodes.remove(leaf.method);
        });
        Set methods = leaves.stream().map(x -> x.method).collect(Collectors.toCollection(LinkedHashSet::new));
        return this.shuffle.order(methods);
    }

    private synchronized Node ensureMethodNode(DexEncodedMethod method) {
        return this.nodes.computeIfAbsent(method, k -> new Node(method));
    }

    private synchronized void addCall(Node caller, Node callee) {
        assert (caller != null);
        assert (callee != null);
        if (caller != callee) {
            caller.addCallee(callee);
        } else {
            caller.isSelfRecursive = true;
        }
        callee.invokeCount++;
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    public <E extends Exception> void forEachMethod(ThrowingBiConsumer<DexEncodedMethod, Predicate<DexEncodedMethod>, E> consumer, Action waveDone, ExecutorService executorService) throws ExecutionException {
        while (!this.isEmpty()) {
            Collection<DexEncodedMethod> methods = this.extractLeaves();
            assert (methods.size() > 0);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (DexEncodedMethod method : methods) {
                futures.add(executorService.submit(() -> {
                    consumer.accept(method, methods::contains);
                    return null;
                }));
            }
            ThreadUtils.awaitFutures(futures);
            waveDone.execute();
        }
    }

    public void dump() {
        this.nodes.forEach((m, n) -> System.out.println(n + "\n"));
    }

    private static class InvokeExtractor
    extends UseRegistry {
        private final Enqueuer.AppInfoWithLiveness appInfo;
        private final GraphLense graphLense;
        private final Node caller;
        private final CallGraph graph;

        InvokeExtractor(AppView<Enqueuer.AppInfoWithLiveness> appView, Node caller, CallGraph graph) {
            super(appView.dexItemFactory());
            this.appInfo = appView.appInfo();
            this.graphLense = appView.graphLense();
            this.caller = caller;
            this.graph = graph;
        }

        private void addClassInitializerTarget(DexClass clazz) {
            assert (clazz != null);
            if (clazz.hasClassInitializer() && !clazz.isLibraryClass()) {
                DexEncodedMethod possibleTarget = clazz.getClassInitializer();
                this.addTarget(possibleTarget);
            }
        }

        private void addClassInitializerTarget(DexType type) {
            DexClass clazz = this.appInfo.definitionFor(type.toBaseType(this.appInfo.dexItemFactory));
            if (clazz != null) {
                this.addClassInitializerTarget(clazz);
            }
        }

        private void addTarget(DexEncodedMethod target) {
            Node callee = this.graph.ensureMethodNode(target);
            this.graph.addCall(this.caller, callee);
        }

        private void addPossibleTarget(DexEncodedMethod possibleTarget) {
            DexClass possibleTargetClass = this.appInfo.definitionFor(possibleTarget.method.getHolder());
            if (possibleTargetClass != null && !possibleTargetClass.isLibraryClass()) {
                this.addTarget(possibleTarget);
            }
        }

        private void addPossibleTargets(DexEncodedMethod definition, Set<DexEncodedMethod> possibleTargets) {
            for (DexEncodedMethod possibleTarget : possibleTargets) {
                if (possibleTarget == definition) continue;
                this.addPossibleTarget(possibleTarget);
            }
        }

        private void processInvoke(Invoke.Type type, DexMethod method) {
            DexEncodedMethod source = this.caller.method;
            GraphLense.GraphLenseLookupResult result = this.graphLense.lookupMethod(method, source.method, type);
            method = result.getMethod();
            type = result.getType();
            DexEncodedMethod definition = this.appInfo.lookup(type, method, source.method.holder);
            if (definition != null) {
                assert (!source.accessFlags.isBridge() || definition != this.caller.method);
                DexClass definitionHolder = this.appInfo.definitionFor(definition.method.getHolder());
                assert (definitionHolder != null);
                if (!definitionHolder.isLibraryClass()) {
                    this.addClassInitializerTarget(definitionHolder);
                    this.addTarget(definition);
                    if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                        Set<DexEncodedMethod> possibleTargets = definitionHolder.isInterface() ? this.appInfo.lookupInterfaceTargets(definition.method) : this.appInfo.lookupVirtualTargets(definition.method);
                        this.addPossibleTargets(definition, possibleTargets);
                    }
                }
            }
        }

        private void processFieldAccess(DexField field) {
            this.addClassInitializerTarget(field.getHolder());
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            this.processInvoke(Invoke.Type.VIRTUAL, method);
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.processInvoke(Invoke.Type.DIRECT, method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            this.processInvoke(Invoke.Type.STATIC, method);
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            this.processInvoke(Invoke.Type.INTERFACE, method);
            return false;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            this.processInvoke(Invoke.Type.SUPER, method);
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            this.addClassInitializerTarget(type);
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            this.processFieldAccess(field);
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }
    }

    public static class CycleEliminator {
        public static final String CYCLIC_FORCE_INLINING_MESSAGE = "Unable to satisfy force inlining constraints due to cyclic force inlining";
        private final Collection<Node> nodes;
        private final InternalOptions options;
        private Deque<Node> stack = new ArrayDeque<Node>();
        private Set<Node> stackSet = Sets.newIdentityHashSet();
        private Set<Node> marked = Sets.newIdentityHashSet();
        private int numberOfCycles = 0;

        public CycleEliminator(Collection<Node> nodes, InternalOptions options) {
            this.options = options;
            this.nodes = options.testing.nondeterministicCycleElimination ? this.reorderNodes(new ArrayList<Node>(nodes)) : nodes;
        }

        public int breakCycles() {
            for (Node node : this.nodes) {
                this.traverse(node);
            }
            int result = this.numberOfCycles;
            this.reset();
            return result;
        }

        private void reset() {
            assert (this.stack.isEmpty());
            assert (this.stackSet.isEmpty());
            this.marked.clear();
            this.numberOfCycles = 0;
        }

        private void traverse(Node node) {
            if (this.marked.contains(node)) {
                return;
            }
            this.push(node);
            Node[] callees = node.callees.toArray(new Node[node.callees.size()]);
            Arrays.sort(callees, (a, b) -> a.method.method.slowCompareTo(b.method.method));
            if (this.options.testing.nondeterministicCycleElimination) {
                this.reorderNodes(Arrays.asList(callees));
            }
            for (Node callee : callees) {
                if (this.stackSet.contains(callee)) {
                    ++this.numberOfCycles;
                    if (CycleEliminator.edgeRemovalIsSafe(node, callee)) {
                        callee.callers.remove(node);
                        node.callees.remove(callee);
                        continue;
                    }
                    LinkedList<Node> cycle = this.extractCycle(callee);
                    CallEdge edge = this.findCallEdgeForRemoval(cycle);
                    if (edge != null) {
                        assert (CycleEliminator.edgeRemovalIsSafe(edge.caller, edge.callee));
                        edge.caller.callees.remove(edge.callee);
                        edge.callee.callers.remove(edge.caller);
                    }
                    this.recoverStack(cycle);
                    continue;
                }
                this.traverse(callee);
            }
            this.pop(node);
            this.marked.add(node);
        }

        private void push(Node node) {
            this.stack.push(node);
            boolean changed = this.stackSet.add(node);
            assert (changed);
        }

        private void pop(Node node) {
            Node popped = this.stack.pop();
            assert (popped == node);
            boolean changed = this.stackSet.remove(node);
            assert (changed);
        }

        private LinkedList<Node> extractCycle(Node entry) {
            LinkedList<Node> cycle = new LinkedList<Node>();
            do {
                assert (!this.stack.isEmpty());
                cycle.add(this.stack.pop());
            } while (cycle.getLast() != entry);
            return cycle;
        }

        private CallEdge findCallEdgeForRemoval(LinkedList<Node> extractedCycle) {
            Node callee = extractedCycle.getLast();
            for (Node caller : extractedCycle) {
                if (!caller.callees.contains(callee)) {
                    assert (!callee.callers.contains(caller));
                    return null;
                }
                if (CycleEliminator.edgeRemovalIsSafe(caller, callee)) {
                    return new CallEdge(caller, callee);
                }
                callee = caller;
            }
            throw new CompilationError(CYCLIC_FORCE_INLINING_MESSAGE);
        }

        private static boolean edgeRemovalIsSafe(Node caller, Node callee) {
            return !callee.method.getOptimizationInfo().forceInline();
        }

        private void recoverStack(LinkedList<Node> extractedCycle) {
            Iterator<Node> descendingIt = extractedCycle.descendingIterator();
            while (descendingIt.hasNext()) {
                this.stack.push(descendingIt.next());
            }
        }

        private Collection<Node> reorderNodes(List<Node> nodes) {
            assert (this.options.testing.nondeterministicCycleElimination);
            Collections.shuffle(nodes);
            return nodes;
        }

        private static class CallEdge {
            private final Node caller;
            private final Node callee;

            public CallEdge(Node caller, Node callee) {
                this.caller = caller;
                this.callee = callee;
            }
        }
    }

    public static class Node {
        public final DexEncodedMethod method;
        private int invokeCount = 0;
        private boolean isSelfRecursive = false;
        private final Set<Node> callees = new LinkedHashSet<Node>();
        private final Set<Node> callers = new LinkedHashSet<Node>();

        public Node(DexEncodedMethod method) {
            this.method = method;
        }

        public boolean isBridge() {
            return this.method.accessFlags.isBridge();
        }

        public void addCallee(Node method) {
            this.callees.add(method);
            method.callers.add(this);
        }

        public boolean hasCallee(Node method) {
            return this.callees.contains(method);
        }

        boolean isSelfRecursive() {
            return this.isSelfRecursive;
        }

        public boolean isLeaf() {
            return this.callees.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodNode for: ");
            builder.append(this.method.toSourceString());
            builder.append(" (");
            builder.append(this.callees.size());
            builder.append(" callees, ");
            builder.append(this.callers.size());
            builder.append(" callers");
            if (this.isBridge()) {
                builder.append(", bridge");
            }
            if (this.isSelfRecursive()) {
                builder.append(", recursive");
            }
            builder.append(", invoke count ").append(this.invokeCount);
            builder.append(").\n");
            if (this.callees.size() > 0) {
                builder.append("Callees:\n");
                for (Node call : this.callees) {
                    builder.append("  ");
                    builder.append(call.method.toSourceString());
                    builder.append("\n");
                }
            }
            if (this.callers.size() > 0) {
                builder.append("Callers:\n");
                for (Node caller : this.callers) {
                    builder.append("  ");
                    builder.append(caller.method.toSourceString());
                    builder.append("\n");
                }
            }
            return builder.toString();
        }
    }
}

