/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.ByteBufferProvider;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.dex.DebugBytecodeWriter;
import com.android.tools.r8.dex.DexOutputBuffer;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.graph.ProgramClassVisitor;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.DexVersion;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LebUtils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.zip.Adler32;

public class FileWriter {
    private final ObjectToOffsetMapping mapping;
    private final DexApplication application;
    private final InternalOptions options;
    private final NamingLens namingLens;
    private final DexOutputBuffer dest;
    private final MixedSectionOffsets mixedSectionOffsets;

    public FileWriter(ByteBufferProvider provider2, ObjectToOffsetMapping mapping, DexApplication application, InternalOptions options, NamingLens namingLens) {
        this.mapping = mapping;
        this.application = application;
        this.options = options;
        this.namingLens = namingLens;
        this.dest = new DexOutputBuffer(provider2);
        this.mixedSectionOffsets = new MixedSectionOffsets(options);
    }

    public static void writeEncodedAnnotation(DexEncodedAnnotation annotation, DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
        dest.putUleb128(mapping.getOffsetFor(annotation.type));
        dest.putUleb128(annotation.elements.length);
        assert (PresortedComparable.isSorted(annotation.elements, element -> element.name));
        for (DexAnnotationElement element2 : annotation.elements) {
            dest.putUleb128(mapping.getOffsetFor(element2.name));
            element2.value.writeTo(dest, mapping);
        }
    }

    public FileWriter collect() {
        new ProgramClassDependencyCollector(this.application, this.mapping.getClasses()).run(this.mapping.getClasses());
        assert (this.mixedSectionOffsets.getClassesWithData().stream().allMatch(DexProgramClass::isSorted));
        this.mixedSectionOffsets.getClassesWithData().forEach(this::addStaticFieldValues);
        assert (this.mixedSectionOffsets.stringData.size() == 0);
        for (DexString string : this.mapping.getStrings()) {
            this.mixedSectionOffsets.add(string);
        }
        for (DexProto proto : this.mapping.getProtos()) {
            this.mixedSectionOffsets.add(proto.parameters);
        }
        DexItem.collectAll((MixedSectionCollection)this.mixedSectionOffsets, this.mapping.getCallSites());
        DexItem.collectAll((MixedSectionCollection)this.mixedSectionOffsets, (DexItem[])this.mapping.getClasses());
        return this;
    }

    public ByteBufferResult generate() {
        this.checkInterfaceMethods();
        Layout layout = Layout.from(this.mapping);
        layout.setCodesOffset(layout.dataSectionOffset);
        List<DexCode> codes = this.sortDexCodesByClassName(this.mixedSectionOffsets.getCodes(), this.application);
        this.dest.moveTo(layout.getCodesOffset() + this.sizeOfCodeItems(codes));
        this.writeItems(this.mixedSectionOffsets.getDebugInfos(), layout::setDebugInfosOffset, this::writeDebugItem);
        layout.setTypeListsOffset(this.dest.align(4));
        this.dest.moveTo(layout.getCodesOffset());
        assert (this.dest.isAligned(4));
        this.writeItems(codes, layout::alreadySetOffset, this::writeCodeItem, 4);
        assert (layout.getDebugInfosOffset() == 0 || this.dest.position() == layout.getDebugInfosOffset());
        this.dest.moveTo(layout.getTypeListsOffset());
        this.writeItems(this.mixedSectionOffsets.getTypeLists(), layout::alreadySetOffset, this::writeTypeList);
        this.writeItems(this.mixedSectionOffsets.getStringData(), layout::setStringDataOffsets, this::writeStringData);
        this.writeItems(this.mixedSectionOffsets.getAnnotations(), layout::setAnnotationsOffset, this::writeAnnotation);
        this.writeItems(this.mixedSectionOffsets.getClassesWithData(), layout::setClassDataOffset, this::writeClassData);
        this.writeItems(this.mixedSectionOffsets.getEncodedArrays(), layout::setEncodedArrarysOffset, this::writeEncodedArray);
        this.writeItems(this.mixedSectionOffsets.getAnnotationSets(), layout::setAnnotationSetsOffset, this::writeAnnotationSet, 4);
        this.writeItems(this.mixedSectionOffsets.getAnnotationSetRefLists(), layout::setAnnotationSetRefListsOffset, this::writeAnnotationSetRefList, 4);
        this.writeItems(this.mixedSectionOffsets.getAnnotationDirectories(), layout::setAnnotationDirectoriesOffset, this::writeAnnotationDirectory, 4);
        layout.setMapOffset(this.dest.align(4));
        this.writeMap(layout);
        layout.setEndOfFile(this.dest.position());
        this.dest.moveTo(112);
        this.writeFixedSectionItems(this.mapping.getStrings(), layout.stringIdsOffset, this::writeStringItem);
        this.writeFixedSectionItems(this.mapping.getTypes(), layout.typeIdsOffset, this::writeTypeItem);
        this.writeFixedSectionItems(this.mapping.getProtos(), layout.protoIdsOffset, this::writeProtoItem);
        this.writeFixedSectionItems(this.mapping.getFields(), layout.fieldIdsOffset, this::writeFieldItem);
        this.writeFixedSectionItems(this.mapping.getMethods(), layout.methodIdsOffset, this::writeMethodItem);
        this.writeFixedSectionItems(this.mapping.getClasses(), layout.classDefsOffset, this::writeClassDefItem);
        this.writeFixedSectionItems(this.mapping.getCallSites(), layout.callSiteIdsOffset, this::writeCallSite);
        this.writeFixedSectionItems(this.mapping.getMethodHandles(), layout.methodHandleIdsOffset, this::writeMethodHandle);
        this.writeHeader(layout);
        this.writeSignature(layout);
        this.writeChecksum(layout);
        return new ByteBufferResult(this.dest.stealByteBuffer(), layout.getEndOfFile());
    }

    private void checkInterfaceMethods() {
        for (DexProgramClass clazz : this.mapping.getClasses()) {
            if (!clazz.isInterface()) continue;
            for (DexEncodedMethod method : clazz.directMethods()) {
                this.checkInterfaceMethod(method);
            }
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                this.checkInterfaceMethod(method);
            }
        }
    }

    private void checkInterfaceMethod(DexEncodedMethod method) {
        if (this.application.dexItemFactory.isClassConstructor(method.method)) {
            return;
        }
        if (method.accessFlags.isStatic()) {
            if (!this.options.canUseDefaultAndStaticInterfaceMethods()) {
                throw new ApiLevelException(AndroidApiLevel.N, "Static interface methods", method.method.toSourceString());
            }
        } else {
            if (method.isInstanceInitializer()) {
                throw new CompilationError("Interface must not have constructors: " + method.method.toSourceString());
            }
            if (!(method.accessFlags.isAbstract() || method.accessFlags.isPrivate() || this.options.canUseDefaultAndStaticInterfaceMethods())) {
                throw new ApiLevelException(AndroidApiLevel.N, "Default interface methods", method.method.toSourceString());
            }
        }
        if (method.accessFlags.isPrivate()) {
            if (this.options.canUsePrivateInterfaceMethods()) {
                return;
            }
            throw new ApiLevelException(AndroidApiLevel.N, "Private interface methods", method.method.toSourceString());
        }
        if (!method.accessFlags.isPublic()) {
            throw new CompilationError("Interface methods must not be protected or package private: " + method.method.toSourceString());
        }
    }

    private List<DexCode> sortDexCodesByClassName(Collection<DexCode> codes, DexApplication application) {
        IdentityHashMap codeToSignatureMap = new IdentityHashMap();
        for (DexProgramClass clazz : this.mapping.getClasses()) {
            clazz.forEachMethod(method -> FileWriter.addSignaturesFromMethod(method, codeToSignatureMap, application.getProguardMap()));
        }
        DexCode[] codesArray = codes.toArray(new DexCode[codes.size()]);
        Arrays.sort(codesArray, Comparator.comparing(codeToSignatureMap::get));
        return Arrays.asList(codesArray);
    }

    private static void addSignaturesFromMethod(DexEncodedMethod method, Map<DexCode, String> codeToSignatureMap, ClassNameMapper proguardMap) {
        if (!method.hasCode()) {
            assert (method.shouldNotHaveCode());
        } else {
            String originalClassName;
            MemberNaming.MethodSignature signature;
            if (proguardMap != null) {
                signature = proguardMap.originalSignatureOf(method.method);
                originalClassName = proguardMap.originalNameOf(method.method.holder);
            } else {
                signature = MemberNaming.MethodSignature.fromDexMethod(method.method);
                originalClassName = method.method.holder.toSourceString();
            }
            codeToSignatureMap.put(method.getCode().asDexCode(), originalClassName + signature);
        }
    }

    private <T extends IndexedDexItem> void writeFixedSectionItems(Collection<T> items, int offset, Consumer<T> writer) {
        assert (this.dest.position() == offset);
        for (IndexedDexItem item : items) {
            writer.accept(item);
        }
    }

    private void writeFixedSectionItems(DexProgramClass[] items, int offset, Consumer<DexProgramClass> writer) {
        assert (this.dest.position() == offset);
        for (DexProgramClass item : items) {
            writer.accept(item);
        }
    }

    private <T extends DexItem> void writeItems(Collection<T> items, Consumer<Integer> offsetSetter, Consumer<T> writer) {
        this.writeItems(items, offsetSetter, writer, 1);
    }

    private <T extends DexItem> void writeItems(Collection<T> items, Consumer<Integer> offsetSetter, Consumer<T> writer, int alignment) {
        if (items.isEmpty()) {
            offsetSetter.accept(0);
        } else {
            offsetSetter.accept(this.dest.align(alignment));
            items.forEach(writer);
        }
    }

    private int sizeOfCodeItems(Iterable<DexCode> codes) {
        int size = 0;
        for (DexCode code : codes) {
            size = this.alignSize(4, size);
            size += this.sizeOfCodeItem(code);
        }
        return size;
    }

    private int sizeOfCodeItem(DexCode code) {
        int result = 16;
        int insnSize = 0;
        for (Instruction insn : code.instructions) {
            insnSize += insn.getSize();
        }
        result += insnSize * 2;
        result += code.tries.length * 8;
        if (code.handlers != null && code.handlers.length > 0) {
            result = this.alignSize(4, result);
            result += LebUtils.sizeAsUleb128(code.handlers.length);
            for (DexCode.TryHandler handler : code.handlers) {
                boolean hasCatchAll = handler.catchAllAddr != -1;
                result += LebUtils.sizeAsSleb128(hasCatchAll ? -handler.pairs.length : handler.pairs.length);
                for (DexCode.TryHandler.TypeAddrPair pair : handler.pairs) {
                    result += LebUtils.sizeAsUleb128(this.mapping.getOffsetFor(pair.type));
                    result += LebUtils.sizeAsUleb128(pair.addr);
                }
                if (!hasCatchAll) continue;
                result += LebUtils.sizeAsUleb128(handler.catchAllAddr);
            }
        }
        return result;
    }

    private void writeStringItem(DexString string) {
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(string));
    }

    private void writeTypeItem(DexType type) {
        DexString descriptor = this.namingLens.lookupDescriptor(type);
        this.dest.putInt(this.mapping.getOffsetFor(descriptor));
    }

    private void writeProtoItem(DexProto proto) {
        this.dest.putInt(this.mapping.getOffsetFor(proto.shorty));
        this.dest.putInt(this.mapping.getOffsetFor(proto.returnType));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(proto.parameters));
    }

    private void writeFieldItem(DexField field) {
        int classIdx = this.mapping.getOffsetFor(field.clazz);
        assert ((classIdx & 0xFFFF) == classIdx);
        this.dest.putShort((short)classIdx);
        int typeIdx = this.mapping.getOffsetFor(field.type);
        assert ((typeIdx & 0xFFFF) == typeIdx);
        this.dest.putShort((short)typeIdx);
        DexString name = this.namingLens.lookupName(field);
        this.dest.putInt(this.mapping.getOffsetFor(name));
    }

    private void writeMethodItem(DexMethod method) {
        int classIdx = this.mapping.getOffsetFor(method.holder);
        assert ((classIdx & 0xFFFF) == classIdx);
        this.dest.putShort((short)classIdx);
        int protoIdx = this.mapping.getOffsetFor(method.proto);
        assert ((protoIdx & 0xFFFF) == protoIdx);
        this.dest.putShort((short)protoIdx);
        DexString name = this.namingLens.lookupName(method);
        this.dest.putInt(this.mapping.getOffsetFor(name));
    }

    private void writeClassDefItem(DexProgramClass clazz) {
        this.dest.putInt(this.mapping.getOffsetFor(clazz.type));
        this.dest.putInt(clazz.accessFlags.getAsDexAccessFlags());
        this.dest.putInt(clazz.superType == null ? -1 : this.mapping.getOffsetFor(clazz.superType));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(clazz.interfaces));
        this.dest.putInt(clazz.sourceFile == null ? -1 : this.mapping.getOffsetFor(clazz.sourceFile));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetForAnnotationsDirectory(clazz));
        this.dest.putInt(clazz.hasMethodsOrFields() ? this.mixedSectionOffsets.getOffsetFor(clazz) : 0);
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(clazz.getStaticValues()));
    }

    private void writeDebugItem(DexDebugInfo debugInfo) {
        this.mixedSectionOffsets.setOffsetFor(debugInfo, this.dest.position());
        this.dest.putBytes(new DebugBytecodeWriter(debugInfo, this.mapping).generate());
    }

    private void writeCodeItem(DexCode code) {
        this.mixedSectionOffsets.setOffsetFor(code, this.dest.align(4));
        this.dest.putShort((short)code.registerSize);
        this.dest.putShort((short)code.incomingRegisterSize);
        this.dest.putShort((short)code.outgoingRegisterSize);
        this.dest.putShort((short)code.tries.length);
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(code.getDebugInfo()));
        int insnSizeOffset = this.dest.position();
        this.dest.forward(4);
        this.dest.putInstructions(code.instructions, this.mapping);
        int insnSize = this.dest.position() - insnSizeOffset - 4;
        this.dest.rewind(insnSize + 4);
        this.dest.putInt(insnSize / 2);
        this.dest.forward(insnSize);
        if (code.tries.length > 0) {
            int beginOfTriesOffset = this.dest.align(4);
            this.dest.forward(code.tries.length * 8);
            int beginOfHandlersOffset = this.dest.position();
            this.dest.putUleb128(code.handlers.length);
            short[] offsets = new short[code.handlers.length];
            int i = 0;
            for (DexCode.TryHandler handler : code.handlers) {
                offsets[i++] = (short)(this.dest.position() - beginOfHandlersOffset);
                boolean hasCatchAll = handler.catchAllAddr != -1;
                this.dest.putSleb128(hasCatchAll ? -handler.pairs.length : handler.pairs.length);
                for (DexCode.TryHandler.TypeAddrPair pair : handler.pairs) {
                    this.dest.putUleb128(this.mapping.getOffsetFor(pair.type));
                    this.dest.putUleb128(pair.addr);
                }
                if (!hasCatchAll) continue;
                this.dest.putUleb128(handler.catchAllAddr);
            }
            int endOfCodeOffset = this.dest.position();
            this.dest.moveTo(beginOfTriesOffset);
            for (DexCode.Try aTry : code.tries) {
                this.dest.putInt(aTry.startAddress);
                this.dest.putShort((short)aTry.instructionCount);
                this.dest.putShort(offsets[aTry.handlerIndex]);
            }
            this.dest.moveTo(endOfCodeOffset);
        }
    }

    private void writeTypeList(DexTypeList list) {
        assert (!list.isEmpty());
        this.mixedSectionOffsets.setOffsetFor(list, this.dest.align(4));
        DexType[] values2 = list.values;
        this.dest.putInt(values2.length);
        for (DexType type : values2) {
            this.dest.putShort((short)this.mapping.getOffsetFor(type));
        }
    }

    private void writeStringData(DexString string) {
        this.mixedSectionOffsets.setOffsetFor(string, this.dest.position());
        this.dest.putUleb128(string.size);
        this.dest.putBytes(string.content);
    }

    private void writeAnnotation(DexAnnotation annotation) {
        this.mixedSectionOffsets.setOffsetFor(annotation, this.dest.position());
        this.dest.putByte((byte)annotation.visibility);
        FileWriter.writeEncodedAnnotation(annotation.annotation, this.dest, this.mapping);
    }

    private void writeAnnotationSet(DexAnnotationSet set) {
        assert (PresortedComparable.isSorted(set.annotations, item -> item.annotation.type));
        this.mixedSectionOffsets.setOffsetFor(set, this.dest.align(4));
        this.dest.putInt(set.annotations.length);
        for (DexAnnotation annotation : set.annotations) {
            this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(annotation));
        }
    }

    private void writeAnnotationSetRefList(ParameterAnnotationsList parameterAnnotationsList) {
        assert (!parameterAnnotationsList.isEmpty());
        this.mixedSectionOffsets.setOffsetFor(parameterAnnotationsList, this.dest.align(4));
        this.dest.putInt(parameterAnnotationsList.countNonMissing());
        for (int i = 0; i < parameterAnnotationsList.size(); ++i) {
            if (parameterAnnotationsList.isMissing(i)) continue;
            this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(parameterAnnotationsList.get(i)));
        }
    }

    private <S extends Descriptor<T, S>, T extends KeyedDexItem<S>> void writeMemberAnnotations(List<T> items, ToIntFunction<T> getter) {
        for (KeyedDexItem item : items) {
            this.dest.putInt(((Descriptor)item.getKey()).getOffset(this.mapping));
            this.dest.putInt(getter.applyAsInt(item));
        }
    }

    private void writeAnnotationDirectory(DexAnnotationDirectory annotationDirectory) {
        this.mixedSectionOffsets.setOffsetForAnnotationsDirectory(annotationDirectory, this.dest.align(4));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(annotationDirectory.getClazzAnnotations()));
        List<DexEncodedMethod> methodAnnotations = annotationDirectory.getMethodAnnotations();
        List<DexEncodedMethod> parameterAnnotations = annotationDirectory.getParameterAnnotations();
        List<DexEncodedField> fieldAnnotations = annotationDirectory.getFieldAnnotations();
        this.dest.putInt(fieldAnnotations.size());
        this.dest.putInt(methodAnnotations.size());
        this.dest.putInt(parameterAnnotations.size());
        this.writeMemberAnnotations(fieldAnnotations, item -> this.mixedSectionOffsets.getOffsetFor(item.annotations));
        this.writeMemberAnnotations(methodAnnotations, item -> this.mixedSectionOffsets.getOffsetFor(item.annotations));
        this.writeMemberAnnotations(parameterAnnotations, item -> this.mixedSectionOffsets.getOffsetFor(item.parameterAnnotationsList));
    }

    private void writeEncodedFields(DexEncodedField[] fields) {
        assert (PresortedComparable.isSorted(fields));
        int currentOffset = 0;
        for (DexEncodedField field : fields) {
            int nextOffset = this.mapping.getOffsetFor(field.field);
            assert (nextOffset - currentOffset >= 0);
            this.dest.putUleb128(nextOffset - currentOffset);
            currentOffset = nextOffset;
            this.dest.putUleb128(field.accessFlags.getAsDexAccessFlags());
        }
    }

    private void writeEncodedMethods(DexEncodedMethod[] methods, boolean clearBodies) {
        assert (PresortedComparable.isSorted(methods));
        int currentOffset = 0;
        for (DexEncodedMethod method : methods) {
            int nextOffset = this.mapping.getOffsetFor(method.method);
            assert (nextOffset - currentOffset >= 0);
            this.dest.putUleb128(nextOffset - currentOffset);
            currentOffset = nextOffset;
            this.dest.putUleb128(method.accessFlags.getAsDexAccessFlags());
            if (!method.hasCode()) {
                assert (method.shouldNotHaveCode());
                this.dest.putUleb128(0);
                continue;
            }
            this.dest.putUleb128(this.mixedSectionOffsets.getOffsetFor(method.getCode().asDexCode()));
            if (!clearBodies) continue;
            method.removeCode();
        }
    }

    private void writeClassData(DexProgramClass clazz) {
        assert (clazz.hasMethodsOrFields());
        this.mixedSectionOffsets.setOffsetFor(clazz, this.dest.position());
        this.dest.putUleb128(clazz.staticFields().length);
        this.dest.putUleb128(clazz.instanceFields().length);
        this.dest.putUleb128(clazz.directMethods().length);
        this.dest.putUleb128(clazz.virtualMethods().length);
        this.writeEncodedFields(clazz.staticFields());
        this.writeEncodedFields(clazz.instanceFields());
        boolean isSharedSynthetic = clazz.getSynthesizedFrom().size() > 1;
        this.writeEncodedMethods(clazz.directMethods(), !isSharedSynthetic);
        this.writeEncodedMethods(clazz.virtualMethods(), !isSharedSynthetic);
    }

    private void addStaticFieldValues(DexProgramClass clazz) {
        clazz.computeStaticValues();
        DexEncodedArray staticValues = clazz.getStaticValues();
        if (staticValues != null) {
            this.mixedSectionOffsets.add(staticValues);
        }
    }

    private void writeMethodHandle(DexMethodHandle methodHandle) {
        int fieldOrMethodIdx;
        DexMethodHandle.MethodHandleType methodHandleDexType;
        this.checkThatInvokeCustomIsAllowed();
        switch (methodHandle.type) {
            case INVOKE_SUPER: {
                methodHandleDexType = DexMethodHandle.MethodHandleType.INVOKE_DIRECT;
                break;
            }
            default: {
                methodHandleDexType = methodHandle.type;
            }
        }
        assert (this.dest.isAligned(4));
        this.dest.putShort(methodHandleDexType.getValue());
        this.dest.putShort((short)0);
        if (methodHandle.isMethodHandle()) {
            fieldOrMethodIdx = this.mapping.getOffsetFor(methodHandle.asMethod());
        } else {
            assert (methodHandle.isFieldHandle());
            fieldOrMethodIdx = this.mapping.getOffsetFor(methodHandle.asField());
        }
        assert ((fieldOrMethodIdx & 0xFFFF) == fieldOrMethodIdx);
        this.dest.putShort((short)fieldOrMethodIdx);
        this.dest.putShort((short)0);
    }

    private void writeCallSite(DexCallSite callSite) {
        this.checkThatInvokeCustomIsAllowed();
        assert (this.dest.isAligned(4));
        this.dest.putInt(this.mixedSectionOffsets.getOffsetFor(callSite.getEncodedArray()));
    }

    private void writeEncodedArray(DexEncodedArray array) {
        this.mixedSectionOffsets.setOffsetFor(array, this.dest.position());
        this.dest.putUleb128(array.values.length);
        for (DexValue value : array.values) {
            value.writeTo(this.dest, this.mapping);
        }
    }

    private int writeMapItem(int type, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        this.dest.putShort((short)type);
        this.dest.putShort((short)0);
        this.dest.putInt(length);
        this.dest.putInt(offset);
        return 1;
    }

    private void writeMap(Layout layout) {
        int startOfMap = this.dest.align(4);
        this.dest.forward(4);
        int size = 0;
        size += this.writeMapItem(0, 0, 1);
        size += this.writeMapItem(1, layout.stringIdsOffset, this.mapping.getStrings().size());
        size += this.writeMapItem(2, layout.typeIdsOffset, this.mapping.getTypes().size());
        size += this.writeMapItem(3, layout.protoIdsOffset, this.mapping.getProtos().size());
        size += this.writeMapItem(4, layout.fieldIdsOffset, this.mapping.getFields().size());
        size += this.writeMapItem(5, layout.methodIdsOffset, this.mapping.getMethods().size());
        size += this.writeMapItem(6, layout.classDefsOffset, this.mapping.getClasses().length);
        size += this.writeMapItem(7, layout.callSiteIdsOffset, this.mapping.getCallSites().size());
        size += this.writeMapItem(8, layout.methodHandleIdsOffset, this.mapping.getMethodHandles().size());
        size += this.writeMapItem(8193, layout.getCodesOffset(), this.mixedSectionOffsets.getCodes().size());
        size += this.writeMapItem(8195, layout.getDebugInfosOffset(), this.mixedSectionOffsets.getDebugInfos().size());
        size += this.writeMapItem(4097, layout.getTypeListsOffset(), this.mixedSectionOffsets.getTypeLists().size());
        size += this.writeMapItem(8194, layout.getStringDataOffsets(), this.mixedSectionOffsets.getStringData().size());
        size += this.writeMapItem(8196, layout.getAnnotationsOffset(), this.mixedSectionOffsets.getAnnotations().size());
        size += this.writeMapItem(8192, layout.getClassDataOffset(), this.mixedSectionOffsets.getClassesWithData().size());
        size += this.writeMapItem(8197, layout.getEncodedArrarysOffset(), this.mixedSectionOffsets.getEncodedArrays().size());
        size += this.writeMapItem(4099, layout.getAnnotationSetsOffset(), this.mixedSectionOffsets.getAnnotationSets().size());
        size += this.writeMapItem(4098, layout.getAnnotationSetRefListsOffset(), this.mixedSectionOffsets.getAnnotationSetRefLists().size());
        size += this.writeMapItem(8198, layout.getAnnotationDirectoriesOffset(), this.mixedSectionOffsets.getAnnotationDirectories().size());
        this.dest.moveTo(startOfMap);
        this.dest.putInt(size += this.writeMapItem(4096, layout.getMapOffset(), 1));
        this.dest.forward(size * 12);
    }

    private void writeHeader(Layout layout) {
        this.dest.moveTo(0);
        this.dest.putBytes(Constants.DEX_FILE_MAGIC_PREFIX);
        this.dest.putBytes(DexVersion.getDexVersion(AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel)).getBytes());
        this.dest.putByte((byte)0);
        this.dest.moveTo(32);
        this.dest.putInt(layout.getEndOfFile());
        this.dest.putInt(112);
        this.dest.putInt(305419896);
        this.dest.putInt(0);
        this.dest.putInt(0);
        this.dest.putInt(layout.getMapOffset());
        int numberOfStrings = this.mapping.getStrings().size();
        this.dest.putInt(numberOfStrings);
        this.dest.putInt(numberOfStrings == 0 ? 0 : layout.stringIdsOffset);
        int numberOfTypes = this.mapping.getTypes().size();
        this.dest.putInt(numberOfTypes);
        this.dest.putInt(numberOfTypes == 0 ? 0 : layout.typeIdsOffset);
        int numberOfProtos = this.mapping.getProtos().size();
        this.dest.putInt(numberOfProtos);
        this.dest.putInt(numberOfProtos == 0 ? 0 : layout.protoIdsOffset);
        int numberOfFields = this.mapping.getFields().size();
        this.dest.putInt(numberOfFields);
        this.dest.putInt(numberOfFields == 0 ? 0 : layout.fieldIdsOffset);
        int numberOfMethods = this.mapping.getMethods().size();
        this.dest.putInt(numberOfMethods);
        this.dest.putInt(numberOfMethods == 0 ? 0 : layout.methodIdsOffset);
        int numberOfClasses = this.mapping.getClasses().length;
        this.dest.putInt(numberOfClasses);
        this.dest.putInt(numberOfClasses == 0 ? 0 : layout.classDefsOffset);
        this.dest.putInt(layout.getDataSectionSize());
        this.dest.putInt(layout.dataSectionOffset);
        assert (this.dest.position() == layout.stringIdsOffset);
    }

    private void writeSignature(Layout layout) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(this.dest.asArray(), 32, layout.getEndOfFile() - 84);
            md.digest(this.dest.asArray(), 12, 20);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeChecksum(Layout layout) {
        Adler32 adler = new Adler32();
        adler.update(this.dest.asArray(), 12, layout.getEndOfFile() - 12);
        this.dest.moveTo(8);
        this.dest.putInt((int)adler.getValue());
    }

    private int alignSize(int bytes, int value) {
        int mask = bytes - 1;
        return value + mask & ~mask;
    }

    private void checkThatInvokeCustomIsAllowed() {
        if (!this.options.canUseInvokeCustom()) {
            throw new ApiLevelException(AndroidApiLevel.O, "Invoke-customs", null);
        }
    }

    private class ProgramClassDependencyCollector
    extends ProgramClassVisitor {
        private final Set<DexClass> includedClasses;

        ProgramClassDependencyCollector(DexApplication application, DexProgramClass[] includedClasses) {
            super(application);
            this.includedClasses = Sets.newIdentityHashSet();
            Collections.addAll(this.includedClasses, includedClasses);
        }

        @Override
        public void visit(DexType type) {
        }

        @Override
        public void visit(DexClass clazz) {
            if (!this.includedClasses.contains(clazz)) {
                return;
            }
            clazz.addDependencies(FileWriter.this.mixedSectionOffsets);
        }
    }

    private static class MixedSectionOffsets
    extends MixedSectionCollection {
        private static final int NOT_SET = -1;
        private static final int NOT_KNOWN = -2;
        private final Reference2IntMap<DexCode> codes = MixedSectionOffsets.createReference2IntMap();
        private final Object2IntMap<DexDebugInfo> debugInfos = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexTypeList> typeLists = MixedSectionOffsets.createObject2IntMap();
        private final Reference2IntMap<DexString> stringData = MixedSectionOffsets.createReference2IntMap();
        private final Object2IntMap<DexAnnotation> annotations = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexAnnotationSet> annotationSets = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<ParameterAnnotationsList> annotationSetRefLists = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexAnnotationDirectory> annotationDirectories = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexProgramClass> classesWithData = MixedSectionOffsets.createObject2IntMap();
        private final Object2IntMap<DexEncodedArray> encodedArrays = MixedSectionOffsets.createObject2IntMap();
        private final Map<DexProgramClass, DexAnnotationDirectory> clazzToAnnotationDirectory = new HashMap<DexProgramClass, DexAnnotationDirectory>();
        private final int minApiLevel;

        private static <T> Object2IntMap<T> createObject2IntMap() {
            Object2IntLinkedOpenHashMap result = new Object2IntLinkedOpenHashMap();
            result.defaultReturnValue(-2);
            return result;
        }

        private static <T> Reference2IntMap<T> createReference2IntMap() {
            Reference2IntLinkedOpenHashMap result = new Reference2IntLinkedOpenHashMap();
            result.defaultReturnValue(-2);
            return result;
        }

        private MixedSectionOffsets(InternalOptions options) {
            this.minApiLevel = options.minApiLevel;
        }

        private <T> boolean add(Object2IntMap<T> map2, T item) {
            if (!map2.containsKey(item)) {
                map2.put(item, -1);
                return true;
            }
            return false;
        }

        private <T> boolean add(Reference2IntMap<T> map2, T item) {
            if (!map2.containsKey(item)) {
                map2.put(item, -1);
                return true;
            }
            return false;
        }

        @Override
        public boolean add(DexProgramClass aClassWithData) {
            return this.add(this.classesWithData, aClassWithData);
        }

        @Override
        public boolean add(DexEncodedArray encodedArray) {
            return this.add(this.encodedArrays, encodedArray);
        }

        @Override
        public boolean add(DexAnnotationSet annotationSet) {
            if (this.minApiLevel >= AndroidApiLevel.J_MR1.getLevel() && annotationSet.isEmpty()) {
                return false;
            }
            return this.add(this.annotationSets, annotationSet);
        }

        @Override
        public boolean add(DexCode code) {
            return this.add(this.codes, code);
        }

        @Override
        public boolean add(DexDebugInfo debugInfo) {
            return this.add(this.debugInfos, debugInfo);
        }

        @Override
        public boolean add(DexTypeList typeList) {
            if (typeList.isEmpty()) {
                return false;
            }
            return this.add(this.typeLists, typeList);
        }

        @Override
        public boolean add(ParameterAnnotationsList annotationSetRefList) {
            if (annotationSetRefList.isEmpty()) {
                return false;
            }
            return this.add(this.annotationSetRefLists, annotationSetRefList);
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            return this.add(this.annotations, annotation);
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            DexAnnotationDirectory previous = this.clazzToAnnotationDirectory.put(clazz, annotationDirectory);
            assert (previous == null);
            return this.add(this.annotationDirectories, annotationDirectory);
        }

        public boolean add(DexString string) {
            return this.add(this.stringData, string);
        }

        public Collection<DexCode> getCodes() {
            return this.codes.keySet();
        }

        public Collection<DexDebugInfo> getDebugInfos() {
            return this.debugInfos.keySet();
        }

        public Collection<DexTypeList> getTypeLists() {
            return this.typeLists.keySet();
        }

        public Collection<DexString> getStringData() {
            return this.stringData.keySet();
        }

        public Collection<DexAnnotation> getAnnotations() {
            return this.annotations.keySet();
        }

        public Collection<DexAnnotationSet> getAnnotationSets() {
            return this.annotationSets.keySet();
        }

        public Collection<ParameterAnnotationsList> getAnnotationSetRefLists() {
            return this.annotationSetRefLists.keySet();
        }

        public Collection<DexProgramClass> getClassesWithData() {
            return this.classesWithData.keySet();
        }

        public Collection<DexAnnotationDirectory> getAnnotationDirectories() {
            return this.annotationDirectories.keySet();
        }

        public Collection<DexEncodedArray> getEncodedArrays() {
            return this.encodedArrays.keySet();
        }

        private <T> int lookup(T item, Object2IntMap<T> table) {
            if (item == null) {
                return 0;
            }
            int offset = table.getInt(item);
            assert (offset != -1 && offset != -2);
            return offset;
        }

        private <T> int lookup(T item, Reference2IntMap<T> table) {
            if (item == null) {
                return 0;
            }
            int offset = table.getInt(item);
            assert (offset != -1 && offset != -2);
            return offset;
        }

        public int getOffsetFor(DexString item) {
            return this.lookup(item, this.stringData);
        }

        public int getOffsetFor(DexTypeList parameters) {
            if (parameters.isEmpty()) {
                return 0;
            }
            return this.lookup(parameters, this.typeLists);
        }

        public int getOffsetFor(DexProgramClass aClassWithData) {
            return this.lookup(aClassWithData, this.classesWithData);
        }

        public int getOffsetFor(DexEncodedArray encodedArray) {
            return this.lookup(encodedArray, this.encodedArrays);
        }

        public int getOffsetFor(DexDebugInfo debugInfo) {
            return this.lookup(debugInfo, this.debugInfos);
        }

        public int getOffsetForAnnotationsDirectory(DexProgramClass clazz) {
            if (!clazz.hasAnnotations()) {
                return 0;
            }
            int offset = this.annotationDirectories.getInt(this.clazzToAnnotationDirectory.get(clazz));
            assert (offset != -2);
            return offset;
        }

        public int getOffsetFor(DexAnnotation annotation) {
            return this.lookup(annotation, this.annotations);
        }

        public int getOffsetFor(DexAnnotationSet annotationSet) {
            if (this.minApiLevel >= AndroidApiLevel.J_MR1.getLevel() && annotationSet.isEmpty()) {
                return 0;
            }
            return this.lookup(annotationSet, this.annotationSets);
        }

        public int getOffsetFor(ParameterAnnotationsList annotationSetRefList) {
            if (annotationSetRefList.isEmpty()) {
                return 0;
            }
            return this.lookup(annotationSetRefList, this.annotationSetRefLists);
        }

        public int getOffsetFor(DexCode code) {
            return this.lookup(code, this.codes);
        }

        private <T> void setOffsetFor(T item, int offset, Object2IntMap<T> map2) {
            int old = map2.put(item, offset);
            assert (old <= -1);
        }

        private <T> void setOffsetFor(T item, int offset, Reference2IntMap<T> map2) {
            int old = map2.put(item, offset);
            assert (old <= -1);
        }

        void setOffsetFor(DexDebugInfo debugInfo, int offset) {
            this.setOffsetFor(debugInfo, offset, this.debugInfos);
        }

        void setOffsetFor(DexCode code, int offset) {
            this.setOffsetFor(code, offset, this.codes);
        }

        void setOffsetFor(DexTypeList typeList, int offset) {
            assert (offset != 0 && !this.typeLists.isEmpty());
            this.setOffsetFor(typeList, offset, this.typeLists);
        }

        void setOffsetFor(DexString string, int offset) {
            this.setOffsetFor(string, offset, this.stringData);
        }

        void setOffsetFor(DexAnnotation annotation, int offset) {
            this.setOffsetFor(annotation, offset, this.annotations);
        }

        void setOffsetFor(DexAnnotationSet annotationSet, int offset) {
            assert (this.minApiLevel < AndroidApiLevel.J_MR1.getLevel() || !annotationSet.isEmpty());
            this.setOffsetFor(annotationSet, offset, this.annotationSets);
        }

        void setOffsetForAnnotationsDirectory(DexAnnotationDirectory annotationDirectory, int offset) {
            this.setOffsetFor(annotationDirectory, offset, this.annotationDirectories);
        }

        void setOffsetFor(DexProgramClass aClassWithData, int offset) {
            this.setOffsetFor(aClassWithData, offset, this.classesWithData);
        }

        void setOffsetFor(DexEncodedArray encodedArray, int offset) {
            this.setOffsetFor(encodedArray, offset, this.encodedArrays);
        }

        void setOffsetFor(ParameterAnnotationsList annotationSetRefList, int offset) {
            assert (offset != 0 && !annotationSetRefList.isEmpty());
            this.setOffsetFor(annotationSetRefList, offset, this.annotationSetRefLists);
        }
    }

    private static class Layout {
        private static final int NOT_SET = -1;
        final int stringIdsOffset;
        final int typeIdsOffset;
        final int protoIdsOffset;
        final int fieldIdsOffset;
        final int methodIdsOffset;
        final int classDefsOffset;
        final int callSiteIdsOffset;
        final int methodHandleIdsOffset;
        final int dataSectionOffset;
        private int codesOffset = -1;
        private int debugInfosOffset = -1;
        private int typeListsOffset = -1;
        private int stringDataOffsets = -1;
        private int annotationsOffset = -1;
        private int annotationSetsOffset = -1;
        private int annotationSetRefListsOffset = -1;
        private int annotationDirectoriesOffset = -1;
        private int classDataOffset = -1;
        private int encodedArrarysOffset = -1;
        private int mapOffset = -1;
        private int endOfFile = -1;

        private Layout(int stringIdsOffset, int typeIdsOffset, int protoIdsOffset, int fieldIdsOffset, int methodIdsOffset, int classDefsOffset, int callSiteIdsOffset, int methodHandleIdsOffset, int dataSectionOffset) {
            this.stringIdsOffset = stringIdsOffset;
            this.typeIdsOffset = typeIdsOffset;
            this.protoIdsOffset = protoIdsOffset;
            this.fieldIdsOffset = fieldIdsOffset;
            this.methodIdsOffset = methodIdsOffset;
            this.classDefsOffset = classDefsOffset;
            this.callSiteIdsOffset = callSiteIdsOffset;
            this.methodHandleIdsOffset = methodHandleIdsOffset;
            this.dataSectionOffset = dataSectionOffset;
            assert (stringIdsOffset <= typeIdsOffset);
            assert (typeIdsOffset <= protoIdsOffset);
            assert (protoIdsOffset <= fieldIdsOffset);
            assert (fieldIdsOffset <= methodIdsOffset);
            assert (methodIdsOffset <= classDefsOffset);
            assert (classDefsOffset <= dataSectionOffset);
            assert (callSiteIdsOffset <= dataSectionOffset);
            assert (methodHandleIdsOffset <= dataSectionOffset);
        }

        static Layout from(ObjectToOffsetMapping mapping) {
            int offset = 0;
            offset = 112;
            int n = offset + mapping.getStrings().size() * 4;
            offset = n;
            int n2 = offset + mapping.getTypes().size() * 4;
            offset = n2;
            int n3 = offset + mapping.getProtos().size() * 12;
            offset = n3;
            int n4 = offset + mapping.getFields().size() * 8;
            offset = n4;
            int n5 = offset + mapping.getMethods().size() * 8;
            offset = n5;
            int n6 = offset + mapping.getClasses().length * 32;
            offset = n6;
            offset = offset + mapping.getCallSites().size() * 4;
            return new Layout(112, n, n2, n3, n4, n5, n6, offset, offset += mapping.getMethodHandles().size() * 8);
        }

        int getDataSectionSize() {
            int size = this.getEndOfFile() - this.dataSectionOffset;
            assert (size % 4 == 0);
            return size;
        }

        private boolean isValidOffset(int value, boolean isAligned) {
            return value != -1 && (!isAligned || value % 4 == 0);
        }

        public int getCodesOffset() {
            assert (this.isValidOffset(this.codesOffset, true));
            return this.codesOffset;
        }

        public void setCodesOffset(int codesOffset) {
            assert (this.codesOffset == -1);
            this.codesOffset = codesOffset;
        }

        public int getDebugInfosOffset() {
            assert (this.isValidOffset(this.debugInfosOffset, false));
            return this.debugInfosOffset;
        }

        public void setDebugInfosOffset(int debugInfosOffset) {
            assert (this.debugInfosOffset == -1);
            this.debugInfosOffset = debugInfosOffset;
        }

        public int getTypeListsOffset() {
            assert (this.isValidOffset(this.typeListsOffset, true));
            return this.typeListsOffset;
        }

        public void setTypeListsOffset(int typeListsOffset) {
            assert (this.typeListsOffset == -1);
            this.typeListsOffset = typeListsOffset;
        }

        public int getStringDataOffsets() {
            assert (this.isValidOffset(this.stringDataOffsets, false));
            return this.stringDataOffsets;
        }

        public void setStringDataOffsets(int stringDataOffsets) {
            assert (this.stringDataOffsets == -1);
            this.stringDataOffsets = stringDataOffsets;
        }

        public int getAnnotationsOffset() {
            assert (this.isValidOffset(this.annotationsOffset, false));
            return this.annotationsOffset;
        }

        public void setAnnotationsOffset(int annotationsOffset) {
            assert (this.annotationsOffset == -1);
            this.annotationsOffset = annotationsOffset;
        }

        public int getAnnotationSetsOffset() {
            assert (this.isValidOffset(this.annotationSetsOffset, true));
            return this.annotationSetsOffset;
        }

        public void alreadySetOffset(int ignored) {
        }

        public void setAnnotationSetsOffset(int annotationSetsOffset) {
            assert (this.annotationSetsOffset == -1);
            this.annotationSetsOffset = annotationSetsOffset;
        }

        public int getAnnotationSetRefListsOffset() {
            assert (this.isValidOffset(this.annotationSetRefListsOffset, true));
            return this.annotationSetRefListsOffset;
        }

        public void setAnnotationSetRefListsOffset(int annotationSetRefListsOffset) {
            assert (this.annotationSetRefListsOffset == -1);
            this.annotationSetRefListsOffset = annotationSetRefListsOffset;
        }

        public int getAnnotationDirectoriesOffset() {
            assert (this.isValidOffset(this.annotationDirectoriesOffset, true));
            return this.annotationDirectoriesOffset;
        }

        public void setAnnotationDirectoriesOffset(int annotationDirectoriesOffset) {
            assert (this.annotationDirectoriesOffset == -1);
            this.annotationDirectoriesOffset = annotationDirectoriesOffset;
        }

        public int getClassDataOffset() {
            assert (this.isValidOffset(this.classDataOffset, false));
            return this.classDataOffset;
        }

        public void setClassDataOffset(int classDataOffset) {
            assert (this.classDataOffset == -1);
            this.classDataOffset = classDataOffset;
        }

        public int getEncodedArrarysOffset() {
            assert (this.isValidOffset(this.encodedArrarysOffset, false));
            return this.encodedArrarysOffset;
        }

        public void setEncodedArrarysOffset(int encodedArrarysOffset) {
            assert (this.encodedArrarysOffset == -1);
            this.encodedArrarysOffset = encodedArrarysOffset;
        }

        public int getMapOffset() {
            return this.mapOffset;
        }

        public void setMapOffset(int mapOffset) {
            this.mapOffset = mapOffset;
        }

        public int getEndOfFile() {
            return this.endOfFile;
        }

        public void setEndOfFile(int endOfFile) {
            this.endOfFile = endOfFile;
        }
    }

    public static class ByteBufferResult {
        public final ByteBuffer buffer;
        public final int length;

        private ByteBufferResult(ByteBuffer buffer, int length) {
            this.buffer = buffer;
            this.length = length;
        }
    }
}

