/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.synthetic.TemplateMethodCode;
import com.android.tools.r8.origin.SynthesizedOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

public final class Java8MethodRewriter {
    private static final String UTILITY_CLASS_DESCRIPTOR_PREFIX = "L$r8$java8methods$utility";
    private final Set<DexType> holders = Sets.newConcurrentHashSet();
    private final IRConverter converter;
    private final DexItemFactory factory;
    private final RewritableMethods rewritableMethods;
    private Map<DexMethod, RewritableMethods.MethodGenerator> methodGenerators = new ConcurrentHashMap<DexMethod, RewritableMethods.MethodGenerator>();

    public Java8MethodRewriter(IRConverter converter) {
        this.converter = converter;
        this.factory = converter.appInfo.dexItemFactory;
        this.rewritableMethods = new RewritableMethods(this.factory);
    }

    public void desugar(IRCode code) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            InvokeStatic invoke;
            RewritableMethods.MethodGenerator generator;
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isInvokeStatic() || (generator = this.getMethodGeneratorOrNull(this.converter, (invoke = instruction.asInvokeStatic()).getInvokedMethod())) == null) continue;
            iterator2.replaceCurrentInstruction(new InvokeStatic(generator.generateMethod(this.factory), invoke.outValue(), invoke.inValues()));
            this.methodGenerators.putIfAbsent(generator.generateMethod(this.factory), generator);
            this.holders.add(code.method.method.holder);
        }
    }

    private Collection<DexProgramClass> findSynthesizedFrom(DexApplication.Builder<?> builder, DexType holder) {
        for (DexProgramClass synthesizedClass : builder.getSynthesizedClasses()) {
            if (holder != synthesizedClass.getType()) continue;
            return synthesizedClass.getSynthesizedFrom();
        }
        return null;
    }

    public static boolean hasJava8MethodRewritePrefix(DexType clazz) {
        return clazz.descriptor.toString().startsWith(UTILITY_CLASS_DESCRIPTOR_PREFIX);
    }

    public void synthesizeUtilityClass(DexApplication.Builder<?> builder, InternalOptions options) {
        if (this.holders.isEmpty()) {
            return;
        }
        Set<DexProgramClass> referencingClasses = Sets.newConcurrentHashSet();
        for (DexType holder : this.holders) {
            DexClass definitionFor = this.converter.appInfo.definitionFor(holder);
            if (definitionFor == null) {
                Collection<DexProgramClass> synthesizedFrom = this.findSynthesizedFrom(builder, holder);
                assert (synthesizedFrom != null);
                referencingClasses.addAll(synthesizedFrom);
                continue;
            }
            referencingClasses.add(definitionFor.asProgramClass());
        }
        MethodAccessFlags flags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
        ClassAccessFlags classAccessFlags = ClassAccessFlags.fromSharedAccessFlags(4097);
        for (RewritableMethods.MethodGenerator generator : this.methodGenerators.values()) {
            DexMethod method = generator.generateMethod(this.factory);
            TemplateMethodCode code = generator.generateTemplateMethod(options, method);
            DexEncodedMethod dexEncodedMethod = new DexEncodedMethod(method, flags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), code);
            DexProgramClass utilityClass = new DexProgramClass(method.holder, null, new SynthesizedOrigin("java8 methods utility class", this.getClass()), classAccessFlags, this.factory.objectType, DexTypeList.empty(), null, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, new DexEncodedMethod[]{dexEncodedMethod}, DexEncodedMethod.EMPTY_ARRAY, this.factory.getSkipNameValidationForTesting(), referencingClasses);
            code.setUpContext(utilityClass);
            boolean addToMainDexList = referencingClasses.stream().anyMatch(clazz -> this.converter.appInfo.isInMainDexList(clazz.type));
            this.converter.optimizeSynthesizedClass(utilityClass);
            builder.addSynthesizedClass(utilityClass, addToMainDexList);
        }
    }

    private RewritableMethods.MethodGenerator getMethodGeneratorOrNull(IRConverter converter, DexMethod method) {
        DexMethod original = converter.graphLense().getOriginalMethodSignature(method);
        assert (original != null);
        return this.rewritableMethods.getGenerator(original.holder.descriptor, original.name, original.proto);
    }

    public static final class RewritableMethods {
        private final Map<DexString, Map<DexString, Map<DexProto, MethodGenerator>>> rewritable = new HashMap<DexString, Map<DexString, Map<DexProto, MethodGenerator>>>();

        public RewritableMethods(DexItemFactory factory) {
            DexString clazz = factory.boxedByteDescriptor;
            DexString method = factory.createString("hashCode");
            DexProto proto = factory.createProto(factory.intType, factory.byteType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(ByteMethods::hashCodeCode, clazz, method, proto));
            clazz = factory.boxedShortDescriptor;
            method = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.shortType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(ShortMethods::hashCodeCode, clazz, method, proto));
            clazz = factory.boxedIntDescriptor;
            method = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.intType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(IntegerMethods::hashCodeCode, clazz, method, proto));
            method = factory.createString("max");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(IntegerMethods::maxCode, clazz, method, proto));
            method = factory.createString("min");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(IntegerMethods::minCode, clazz, method, proto));
            method = factory.createString("sum");
            proto = factory.createProto(factory.intType, factory.intType, factory.intType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(IntegerMethods::sumCode, clazz, method, proto));
            clazz = factory.boxedDoubleDescriptor;
            method = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.doubleType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(DoubleMethods::hashCodeCode, clazz, method, proto));
            method = factory.createString("max");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(DoubleMethods::maxCode, clazz, method, proto));
            method = factory.createString("min");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(DoubleMethods::minCode, clazz, method, proto));
            method = factory.createString("sum");
            proto = factory.createProto(factory.doubleType, factory.doubleType, factory.doubleType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(DoubleMethods::sumCode, clazz, method, proto));
            method = factory.createString("isFinite");
            proto = factory.createProto(factory.booleanType, factory.doubleType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(DoubleMethods::isFiniteCode, clazz, method, proto));
            clazz = factory.boxedFloatDescriptor;
            method = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.floatType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(FloatMethods::hashCodeCode, clazz, method, proto));
            method = factory.createString("max");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(FloatMethods::maxCode, clazz, method, proto));
            method = factory.createString("min");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(FloatMethods::minCode, clazz, method, proto));
            method = factory.createString("sum");
            proto = factory.createProto(factory.floatType, factory.floatType, factory.floatType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(FloatMethods::sumCode, clazz, method, proto));
            method = factory.createString("isFinite");
            proto = factory.createProto(factory.booleanType, factory.floatType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(FloatMethods::isFiniteCode, clazz, method, proto));
            clazz = factory.boxedBooleanDescriptor;
            method = factory.createString("hashCode");
            proto = factory.createProto(factory.intType, factory.booleanType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(BooleanMethods::hashCodeCode, clazz, method, proto));
            method = factory.createString("logicalAnd");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(BooleanMethods::logicalAndCode, clazz, method, proto));
            method = factory.createString("logicalOr");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(BooleanMethods::logicalOrCode, clazz, method, proto));
            method = factory.createString("logicalXor");
            proto = factory.createProto(factory.booleanType, factory.booleanType, factory.booleanType);
            this.addOrGetMethod(clazz, method).put(proto, new MethodGenerator(BooleanMethods::logicalXorCode, clazz, method, proto));
        }

        private Map<DexString, Map<DexProto, MethodGenerator>> addOrGetClass(DexString clazz) {
            return this.rewritable.computeIfAbsent(clazz, k -> new HashMap());
        }

        private Map<DexProto, MethodGenerator> addOrGetMethod(DexString clazz, DexString method) {
            return this.addOrGetClass(clazz).computeIfAbsent(method, k -> new HashMap());
        }

        public MethodGenerator getGenerator(DexString clazz, DexString method, DexProto proto) {
            Map<DexProto, MethodGenerator> methodMap;
            Map<DexString, Map<DexProto, MethodGenerator>> classMap = this.rewritable.get(clazz);
            if (classMap != null && (methodMap = classMap.get(method)) != null) {
                return methodMap.get(proto);
            }
            return null;
        }

        public static class MethodGenerator {
            private final BiFunction<InternalOptions, DexMethod, TemplateMethodCode> generator;
            private final DexString clazz;
            private final DexString method;
            private final DexProto proto;
            private DexMethod dexMethod;

            public MethodGenerator(BiFunction<InternalOptions, DexMethod, TemplateMethodCode> generator, DexString clazz, DexString method, DexProto proto) {
                this.generator = generator;
                this.clazz = clazz;
                this.method = method;
                this.proto = proto;
            }

            public DexMethod generateMethod(DexItemFactory factory) {
                if (this.dexMethod != null) {
                    return this.dexMethod;
                }
                String clazzDescriptor = DescriptorUtils.getSimpleClassNameFromDescriptor(this.clazz.toString());
                String postFix = "$" + clazzDescriptor + "$" + this.method + "$" + this.proto.shorty.toString();
                DexType clazz = factory.createType(Java8MethodRewriter.UTILITY_CLASS_DESCRIPTOR_PREFIX + postFix + ";");
                this.dexMethod = factory.createMethod(clazz, this.proto, this.method);
                return this.dexMethod;
            }

            public TemplateMethodCode generateTemplateMethod(InternalOptions options, DexMethod method) {
                return this.generator.apply(options, method);
            }
        }
    }

    private static final class BooleanMethods
    extends TemplateMethodCode {
        BooleanMethods(InternalOptions options, DexMethod method, String methodName) {
            super(options, method, methodName, method.proto.toDescriptorString());
        }

        public static BooleanMethods hashCodeCode(InternalOptions options, DexMethod method) {
            return new BooleanMethods(options, method, "hashCodeImpl");
        }

        public static BooleanMethods logicalAndCode(InternalOptions options, DexMethod method) {
            return new BooleanMethods(options, method, "logicalAndImpl");
        }

        public static BooleanMethods logicalOrCode(InternalOptions options, DexMethod method) {
            return new BooleanMethods(options, method, "logicalOrImpl");
        }

        public static BooleanMethods logicalXorCode(InternalOptions options, DexMethod method) {
            return new BooleanMethods(options, method, "logicalXorImpl");
        }

        public static int hashCodeImpl(boolean b) {
            return Boolean.valueOf(b).hashCode();
        }

        public static boolean logicalAndImpl(boolean a, boolean b) {
            return a && b;
        }

        public static boolean logicalOrImpl(boolean a, boolean b) {
            return a || b;
        }

        public static boolean logicalXorImpl(boolean a, boolean b) {
            return a ^ b;
        }
    }

    private static final class FloatMethods
    extends TemplateMethodCode {
        FloatMethods(InternalOptions options, DexMethod method, String methodName) {
            super(options, method, methodName, method.proto.toDescriptorString());
        }

        public static FloatMethods hashCodeCode(InternalOptions options, DexMethod method) {
            return new FloatMethods(options, method, "hashCodeImpl");
        }

        public static FloatMethods maxCode(InternalOptions options, DexMethod method) {
            return new FloatMethods(options, method, "maxImpl");
        }

        public static FloatMethods minCode(InternalOptions options, DexMethod method) {
            return new FloatMethods(options, method, "minImpl");
        }

        public static FloatMethods sumCode(InternalOptions options, DexMethod method) {
            return new FloatMethods(options, method, "sumImpl");
        }

        public static FloatMethods isFiniteCode(InternalOptions options, DexMethod method) {
            return new FloatMethods(options, method, "isFiniteImpl");
        }

        public static int hashCodeImpl(float d) {
            return Float.valueOf(d).hashCode();
        }

        public static float maxImpl(float a, float b) {
            return Math.max(a, b);
        }

        public static float minImpl(float a, float b) {
            return Math.min(a, b);
        }

        public static float sumImpl(float a, float b) {
            return a + b;
        }

        public static boolean isFiniteImpl(float d) {
            Float boxed = Float.valueOf(d);
            return !boxed.isInfinite() && !boxed.isNaN();
        }
    }

    private static final class DoubleMethods
    extends TemplateMethodCode {
        DoubleMethods(InternalOptions options, DexMethod method, String methodName) {
            super(options, method, methodName, method.proto.toDescriptorString());
        }

        public static DoubleMethods hashCodeCode(InternalOptions options, DexMethod method) {
            return new DoubleMethods(options, method, "hashCodeImpl");
        }

        public static DoubleMethods maxCode(InternalOptions options, DexMethod method) {
            return new DoubleMethods(options, method, "maxImpl");
        }

        public static DoubleMethods minCode(InternalOptions options, DexMethod method) {
            return new DoubleMethods(options, method, "minImpl");
        }

        public static DoubleMethods sumCode(InternalOptions options, DexMethod method) {
            return new DoubleMethods(options, method, "sumImpl");
        }

        public static DoubleMethods isFiniteCode(InternalOptions options, DexMethod method) {
            return new DoubleMethods(options, method, "isFiniteImpl");
        }

        public static int hashCodeImpl(double d) {
            return Double.valueOf(d).hashCode();
        }

        public static double maxImpl(double a, double b) {
            return Math.max(a, b);
        }

        public static double minImpl(double a, double b) {
            return Math.min(a, b);
        }

        public static double sumImpl(double a, double b) {
            return a + b;
        }

        public static boolean isFiniteImpl(double d) {
            Double boxed = d;
            return !boxed.isInfinite() && !boxed.isNaN();
        }
    }

    private static final class IntegerMethods
    extends TemplateMethodCode {
        IntegerMethods(InternalOptions options, DexMethod method, String methodName) {
            super(options, method, methodName, method.proto.toDescriptorString());
        }

        public static IntegerMethods hashCodeCode(InternalOptions options, DexMethod method) {
            return new IntegerMethods(options, method, "hashCodeImpl");
        }

        public static IntegerMethods maxCode(InternalOptions options, DexMethod method) {
            return new IntegerMethods(options, method, "maxImpl");
        }

        public static IntegerMethods minCode(InternalOptions options, DexMethod method) {
            return new IntegerMethods(options, method, "minImpl");
        }

        public static IntegerMethods sumCode(InternalOptions options, DexMethod method) {
            return new IntegerMethods(options, method, "sumImpl");
        }

        public static int hashCodeImpl(int i) {
            return Integer.valueOf(i).hashCode();
        }

        public static int maxImpl(int a, int b) {
            return Math.max(a, b);
        }

        public static int minImpl(int a, int b) {
            return Math.min(a, b);
        }

        public static int sumImpl(int a, int b) {
            return a + b;
        }
    }

    private static final class ShortMethods
    extends TemplateMethodCode {
        ShortMethods(InternalOptions options, DexMethod method, String methodName) {
            super(options, method, methodName, method.proto.toDescriptorString());
        }

        public static ShortMethods hashCodeCode(InternalOptions options, DexMethod method) {
            return new ShortMethods(options, method, "hashCodeImpl");
        }

        public static int hashCodeImpl(short i) {
            return Short.valueOf(i).hashCode();
        }
    }

    private static final class ByteMethods
    extends TemplateMethodCode {
        ByteMethods(InternalOptions options, DexMethod method, String methodName) {
            super(options, method, methodName, method.proto.toDescriptorString());
        }

        public static ByteMethods hashCodeCode(InternalOptions options, DexMethod method) {
            return new ByteMethods(options, method, "hashCodeImpl");
        }

        public static int hashCodeImpl(byte i) {
            return Byte.valueOf(i).hashCode();
        }
    }
}

