/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ArgumentRemovalUtils;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class UninstantiatedTypeOptimization {
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private final InternalOptions options;
    private int numberOfInstanceGetOrInstancePutWithNullReceiver = 0;
    private int numberOfInvokesWithNullArgument = 0;
    private int numberOfInvokesWithNullReceiver = 0;

    public UninstantiatedTypeOptimization(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, InternalOptions options) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.options = options;
    }

    public GraphLense run(MethodPoolCollection methodPoolCollection, ExecutorService executorService, Timing timing) {
        HashBiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
        IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod = new IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo>();
        MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        HashMap changedVirtualMethods = new HashMap();
        try {
            methodPoolCollection.buildAll(executorService, timing);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TopDownClassHierarchyTraversal.visit(this.appView, this.appView.appInfo().classes(), clazz -> {
            GraphLense.RewrittenPrototypeDescription prototypeChanges;
            DexMethod method;
            DexEncodedMethod encodedMethod;
            int i;
            Equivalence.Wrapper<DexMethod> wrapper;
            DexMethod newMethod;
            MethodPoolCollection.MethodPool methodPool = methodPoolCollection.get((DexClass)clazz);
            if (clazz.isInterface()) {
                for (DexEncodedMethod virtualMethod : clazz.virtualMethods()) {
                    DexMethod newMethod2;
                    Equivalence.Wrapper<DexMethod> wrapper2;
                    GraphLense.RewrittenPrototypeDescription prototypeChanges2 = new GraphLense.RewrittenPrototypeDescription(this.isAlwaysNull(virtualMethod.method.proto.returnType), this.getRemovedArgumentsInfo(virtualMethod, Strategy.ALLOW_ARGUMENT_REMOVAL));
                    if (prototypeChanges2.isEmpty() || methodPool.hasSeenDirectly(wrapper2 = equivalence.wrap(newMethod2 = this.getNewMethodSignature(virtualMethod, prototypeChanges2)))) continue;
                    methodPool.seen(wrapper2);
                }
                return;
            }
            IdentityHashMap<DexEncodedMethod, GraphLense.RewrittenPrototypeDescription> prototypeChangesPerMethod = new IdentityHashMap<DexEncodedMethod, GraphLense.RewrittenPrototypeDescription>();
            for (DexEncodedMethod directMethod : clazz.directMethods()) {
                GraphLense.RewrittenPrototypeDescription prototypeChanges3 = this.getPrototypeChanges(directMethod, Strategy.ALLOW_ARGUMENT_REMOVAL);
                if (prototypeChanges3.isEmpty()) continue;
                prototypeChangesPerMethod.put(directMethod, prototypeChanges3);
            }
            HashSet<Equivalence.Wrapper<DexMethod>> usedSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();
            for (DexEncodedMethod method2 : clazz.methods()) {
                if (prototypeChangesPerMethod.containsKey(method2)) continue;
                usedSignatures.add(equivalence.wrap(method2.method));
            }
            DexEncodedMethod[] directMethods = clazz.directMethods();
            for (int i2 = 0; i2 < directMethods.length; ++i2) {
                DexEncodedMethod encodedMethod2 = directMethods[i2];
                DexMethod method3 = encodedMethod2.method;
                GraphLense.RewrittenPrototypeDescription prototypeChanges4 = prototypeChangesPerMethod.getOrDefault(encodedMethod2, GraphLense.RewrittenPrototypeDescription.none());
                GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo = prototypeChanges4.getRemovedArgumentsInfo();
                newMethod = this.getNewMethodSignature(encodedMethod2, prototypeChanges4);
                if (newMethod == method3 || !usedSignatures.add(wrapper = equivalence.wrap(newMethod))) continue;
                directMethods[i2] = encodedMethod2.toTypeSubstitutedMethod(newMethod);
                methodMapping.put(method3, newMethod);
                if (!removedArgumentsInfo.hasRemovedArguments()) continue;
                removedArgumentsInfoPerMethod.put(newMethod, removedArgumentsInfo);
            }
            DexEncodedMethod[] virtualMethods = clazz.virtualMethods();
            for (i = 0; i < virtualMethods.length; ++i) {
                encodedMethod = virtualMethods[i];
                method = encodedMethod.method;
                prototypeChanges = this.getPrototypeChanges(encodedMethod, Strategy.DISALLOW_ARGUMENT_REMOVAL);
                newMethod = this.getNewMethodSignature(encodedMethod, prototypeChanges);
                if (newMethod == method) continue;
                wrapper = equivalence.wrap(newMethod);
                boolean isOverrideOfPreviouslyChangedMethodInSuperClass = ((Set)changedVirtualMethods.getOrDefault(equivalence.wrap(method), ImmutableSet.of())).stream().anyMatch(other -> clazz.type.isSubtypeOf((DexType)other, this.appView.appInfo()));
                if (!isOverrideOfPreviouslyChangedMethodInSuperClass) continue;
                assert (methodPool.hasSeen(wrapper));
                boolean signatureIsAvailable = usedSignatures.add(wrapper);
                assert (signatureIsAvailable);
                virtualMethods[i] = encodedMethod.toTypeSubstitutedMethod(newMethod);
                methodMapping.put(method, newMethod);
            }
            for (i = 0; i < virtualMethods.length; ++i) {
                encodedMethod = virtualMethods[i];
                method = encodedMethod.method;
                prototypeChanges = this.getPrototypeChanges(encodedMethod, Strategy.DISALLOW_ARGUMENT_REMOVAL);
                newMethod = this.getNewMethodSignature(encodedMethod, prototypeChanges);
                if (newMethod == method || methodPool.hasSeen(wrapper = equivalence.wrap(newMethod)) || !usedSignatures.add(wrapper)) continue;
                methodPool.seen(wrapper);
                virtualMethods[i] = encodedMethod.toTypeSubstitutedMethod(newMethod);
                methodMapping.put(method, newMethod);
                boolean added = changedVirtualMethods.computeIfAbsent(equivalence.wrap(method), key -> Sets.newIdentityHashSet()).add(clazz.type);
                assert (added);
            }
        });
        if (!methodMapping.isEmpty()) {
            return new UninstantiatedTypeOptimizationGraphLense(methodMapping, removedArgumentsInfoPerMethod, this.appView);
        }
        return this.appView.graphLense();
    }

    private GraphLense.RewrittenPrototypeDescription getPrototypeChanges(DexEncodedMethod encodedMethod, Strategy strategy) {
        if (ArgumentRemovalUtils.isPinned(encodedMethod, this.appView) || this.appView.appInfo().keepConstantArguments.contains(encodedMethod.method)) {
            return GraphLense.RewrittenPrototypeDescription.none();
        }
        return new GraphLense.RewrittenPrototypeDescription(this.isAlwaysNull(encodedMethod.method.proto.returnType), this.getRemovedArgumentsInfo(encodedMethod, strategy));
    }

    private GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo getRemovedArgumentsInfo(DexEncodedMethod encodedMethod, Strategy strategy) {
        if (strategy == Strategy.DISALLOW_ARGUMENT_REMOVAL) {
            return GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo.empty();
        }
        ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo> removedArgumentsInfo = null;
        DexProto proto = encodedMethod.method.proto;
        int offset = encodedMethod.isStatic() ? 0 : 1;
        for (int i = 0; i < proto.parameters.size(); ++i) {
            DexType type = proto.parameters.values[i];
            if (!this.isAlwaysNull(type)) continue;
            if (removedArgumentsInfo == null) {
                removedArgumentsInfo = new ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo>();
            }
            removedArgumentsInfo.add(GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo.builder().setArgumentIndex(i + offset).setIsAlwaysNull().setType(type).build());
        }
        return removedArgumentsInfo != null ? new GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo(removedArgumentsInfo) : GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo.empty();
    }

    private DexMethod getNewMethodSignature(DexEncodedMethod encodedMethod, GraphLense.RewrittenPrototypeDescription prototypeChanges) {
        DexType[] newParameters;
        DexType newReturnType;
        DexMethod method = encodedMethod.method;
        GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo = prototypeChanges.getRemovedArgumentsInfo();
        if (prototypeChanges.isEmpty()) {
            return method;
        }
        DexType dexType = newReturnType = prototypeChanges.hasBeenChangedToReturnVoid() ? this.dexItemFactory.voidType : method.proto.returnType;
        if (removedArgumentsInfo.hasRemovedArguments()) {
            assert (encodedMethod.isStatic() || !removedArgumentsInfo.isArgumentRemoved(0));
            newParameters = new DexType[method.proto.parameters.size() - removedArgumentsInfo.numberOfRemovedArguments()];
            int offset = encodedMethod.isStatic() ? 0 : 1;
            int newParametersIndex = 0;
            for (int argumentIndex = 0; argumentIndex < method.proto.parameters.size(); ++argumentIndex) {
                if (removedArgumentsInfo.isArgumentRemoved(argumentIndex + offset)) continue;
                newParameters[newParametersIndex] = method.proto.parameters.values[argumentIndex];
                ++newParametersIndex;
            }
        } else {
            newParameters = method.proto.parameters.values;
        }
        return this.dexItemFactory.createMethod(method.holder, this.dexItemFactory.createProto(newReturnType, newParameters), method.name);
    }

    public void rewrite(DexEncodedMethod method, IRCode code) {
        Set<BasicBlock> blocksToBeRemoved = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (blocksToBeRemoved.contains(block)) continue;
            InstructionListIterator instructionIterator = block.listIterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (instruction.isFieldInstruction()) {
                    if (instruction.isInstanceGet() || instruction.isInstancePut()) {
                        this.rewriteInstanceFieldInstruction(instruction.asFieldInstruction(), blockIterator, instructionIterator, code, blocksToBeRemoved);
                        continue;
                    }
                    this.rewriteStaticFieldInstruction(instruction.asFieldInstruction(), blockIterator, instructionIterator, code, blocksToBeRemoved);
                    continue;
                }
                if (!instruction.isInvokeMethod()) continue;
                this.rewriteInvoke(instruction.asInvokeMethod(), blockIterator, instructionIterator, code, blocksToBeRemoved);
            }
        }
        code.removeBlocks(blocksToBeRemoved);
        code.removeAllTrivialPhis();
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    public void logResults() {
        assert (false);
        Log.info(this.getClass(), "Number of instance-get/instance-put with null receiver: %s", this.numberOfInstanceGetOrInstancePutWithNullReceiver);
        Log.info(this.getClass(), "Number of invokes with null argument: %s", this.numberOfInvokesWithNullArgument);
        Log.info(this.getClass(), "Number of invokes with null receiver: %s", this.numberOfInvokesWithNullReceiver);
    }

    private void rewriteInstanceFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        assert (instruction.isInstanceGet() || instruction.isInstancePut());
        boolean replacedByThrowNull = false;
        Value receiver = instruction.inValues().get(0);
        if (this.isAlwaysNull(receiver) && !receiver.getTypeLattice().isDefinitelyNull()) {
            this.replaceCurrentInstructionWithThrowNull(instruction, blockIterator, instructionIterator, code, blocksToBeRemoved);
            ++this.numberOfInstanceGetOrInstancePutWithNullReceiver;
            replacedByThrowNull = true;
        }
        if (!replacedByThrowNull) {
            this.rewriteFieldInstruction(instruction, blockIterator, instructionIterator, code, blocksToBeRemoved);
        }
    }

    private void rewriteStaticFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        assert (instruction.isStaticGet() || instruction.isStaticPut());
        this.rewriteFieldInstruction(instruction, blockIterator, instructionIterator, code, blocksToBeRemoved);
    }

    private void rewriteFieldInstruction(FieldInstruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        DexType fieldType = instruction.getField().type;
        if (this.isAlwaysNull(fieldType)) {
            DexClass enclosingClass;
            DexEncodedField field = this.appView.appInfo().definitionFor(instruction.getField());
            if (field == null) {
                return;
            }
            if (field.field.clazz != code.method.method.holder && ((enclosingClass = this.appView.appInfo().definitionFor(code.method.method.holder)) == null || enclosingClass.classInitializationMayHaveSideEffects(this.appView.appInfo()))) {
                return;
            }
            BasicBlock block = instruction.getBlock();
            if (instruction.isFieldPut()) {
                Value value = instruction.isInstancePut() ? instruction.asInstancePut().value() : instruction.asStaticPut().inValue();
                TypeLatticeElement fieldLatticeType = TypeLatticeElement.fromDexType(fieldType, true, this.appView.appInfo());
                if (!value.getTypeLattice().lessThanOrEqual(fieldLatticeType, this.appView.appInfo())) {
                    assert (this.options.testing.allowTypeErrors);
                    return;
                }
                instructionIterator.removeOrReplaceByDebugLocalRead();
            } else {
                instructionIterator.replaceCurrentInstruction(code.createConstNull());
            }
            if (block.hasCatchHandlers()) {
                block.getCatchHandlers().getUniqueTargets().forEach(BasicBlock::unlinkCatchHandler);
            }
        }
    }

    private void rewriteInvoke(InvokeMethod invoke, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        Value receiver;
        if (invoke.isInvokeMethodWithReceiver() && this.isAlwaysNull(receiver = invoke.asInvokeMethodWithReceiver().getReceiver())) {
            this.replaceCurrentInstructionWithThrowNull(invoke, blockIterator, instructionIterator, code, blocksToBeRemoved);
            ++this.numberOfInvokesWithNullReceiver;
            return;
        }
        DexEncodedMethod target = invoke.lookupSingleTarget(this.appView.appInfo(), code.method.method.holder);
        if (target == null) {
            return;
        }
        BitSet facts = target.getOptimizationInfo().getNonNullParamOrThrow();
        if (facts != null) {
            for (int i = 0; i < invoke.arguments().size(); ++i) {
                Value argument = invoke.arguments().get(i);
                if (!this.isAlwaysNull(argument) || !facts.get(i)) continue;
                this.replaceCurrentInstructionWithThrowNull(invoke, blockIterator, instructionIterator, code, blocksToBeRemoved);
                ++this.numberOfInvokesWithNullArgument;
                return;
            }
        }
    }

    private void replaceCurrentInstructionWithThrowNull(Instruction instruction, ListIterator<BasicBlock> blockIterator, InstructionListIterator instructionIterator, IRCode code, Set<BasicBlock> blocksToBeRemoved) {
        BasicBlock block = instruction.getBlock();
        assert (!blocksToBeRemoved.contains(block));
        BasicBlock normalSuccessorBlock = instructionIterator.split(code, blockIterator);
        instructionIterator.previous();
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        blocksToBeRemoved.addAll(block.unlink(normalSuccessorBlock, dominatorTree));
        instructionIterator.previous();
        Value nullValue = new Value(code.valueNumberGenerator.next(), TypeLatticeElement.NULL, null);
        ConstNumber constNumberInstruction = new ConstNumber(nullValue, 0L);
        constNumberInstruction.setPosition(this.options.debug ? instruction.getPosition() : Position.none());
        instructionIterator.add(constNumberInstruction);
        instructionIterator.next();
        Throw throwInstruction = new Throw(nullValue);
        for (Value inValue : instruction.inValues()) {
            if (!inValue.hasLocalInfo()) continue;
            throwInstruction.addDebugValue(inValue);
        }
        instructionIterator.replaceCurrentInstruction(throwInstruction);
        instructionIterator.next();
        instructionIterator.remove();
        if (block.hasCatchHandlers()) {
            CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
            catchHandlers.forEach((guard, target) -> {
                if (blocksToBeRemoved.contains(target)) {
                    return;
                }
                if (!this.dexItemFactory.npeType.isSubtypeOf((DexType)guard, this.appView.appInfo())) {
                    DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
                    blocksToBeRemoved.addAll(block.unlink((BasicBlock)target, dominatorTree));
                }
            });
        }
    }

    private boolean isAlwaysNull(Value value) {
        if (value.hasLocalInfo()) {
            return false;
        }
        TypeLatticeElement typeLatticeElement = value.getTypeLattice();
        if (typeLatticeElement.isDefinitelyNull()) {
            return true;
        }
        if (typeLatticeElement.isClassType()) {
            return this.isAlwaysNull(typeLatticeElement.asClassTypeLatticeElement().getClassType());
        }
        return false;
    }

    private boolean isAlwaysNull(DexType type) {
        if (type.isClassType()) {
            DexClass clazz = this.appView.appInfo().definitionFor(type);
            return clazz != null && clazz.isProgramClass() && !this.appView.appInfo().isInstantiatedDirectlyOrIndirectly(type);
        }
        return false;
    }

    static class UninstantiatedTypeOptimizationGraphLense
    extends GraphLense.NestedGraphLense {
        private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod;

        UninstantiatedTypeOptimizationGraphLense(BiMap<DexMethod, DexMethod> methodMap, Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArgumentsInfoPerMethod, AppView<? extends AppInfo> appView) {
            super(ImmutableMap.of(), methodMap, ImmutableMap.of(), null, methodMap.inverse(), appView.graphLense(), appView.dexItemFactory());
            this.removedArgumentsInfoPerMethod = removedArgumentsInfoPerMethod;
        }

        @Override
        public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures.getOrDefault(method, method);
            GraphLense.RewrittenPrototypeDescription result = this.previousLense.lookupPrototypeChanges(originalMethod);
            if (originalMethod != method) {
                GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArgumentsInfo;
                if (method.proto.returnType.isVoidType() && !originalMethod.proto.returnType.isVoidType()) {
                    result = result.withConstantReturn();
                }
                if ((removedArgumentsInfo = this.removedArgumentsInfoPerMethod.get(method)) != null) {
                    result = result.withRemovedArguments(removedArgumentsInfo);
                }
            } else assert (!this.removedArgumentsInfoPerMethod.containsKey(method));
            return result;
        }
    }

    static enum Strategy {
        ALLOW_ARGUMENT_REMOVAL,
        DISALLOW_ARGUMENT_REMOVAL;

    }
}

