/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.FillArrayData;
import com.android.tools.r8.code.FillArrayDataPayload;
import com.android.tools.r8.code.Format35c;
import com.android.tools.r8.code.Format3rc;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.NewArray;
import com.android.tools.r8.code.Sget;
import com.android.tools.r8.code.SgetBoolean;
import com.android.tools.r8.code.SgetByte;
import com.android.tools.r8.code.SgetChar;
import com.android.tools.r8.code.SgetObject;
import com.android.tools.r8.code.SgetShort;
import com.android.tools.r8.code.SgetWide;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.ir.code.SingleConstant;
import com.android.tools.r8.ir.code.WideConstant;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;

@Deprecated
@Keep
public final class ResourceShrinker {
    public static void run(Command command, ReferenceChecker callback) throws IOException, ExecutionException {
        AndroidApp inputApp = command.getInputApp();
        Timing timing = new Timing("resource shrinker analyzer");
        DexApplication dexApplication = new ApplicationReader(inputApp, command.getInternalOptions(), timing).read();
        for (DexProgramClass programClass : dexApplication.classes()) {
            new DexClassUsageVisitor(programClass, callback).visit();
        }
    }

    private static final class DexClassUsageVisitor {
        private final DexProgramClass classDef;
        private final ReferenceChecker callback;

        DexClassUsageVisitor(DexProgramClass classDef, ReferenceChecker callback) {
            this.classDef = classDef;
            this.callback = callback;
        }

        public void visit() {
            if (!this.callback.shouldProcess(this.classDef.type.getInternalName())) {
                return;
            }
            for (DexEncodedField dexEncodedField : this.classDef.staticFields()) {
                DexValue staticValue = dexEncodedField.getStaticValue();
                if (staticValue == null) continue;
                this.processFieldValue(staticValue);
            }
            for (KeyedDexItem keyedDexItem : this.classDef.allMethodsSorted()) {
                this.processMethod((DexEncodedMethod)keyedDexItem);
            }
            if (this.classDef.hasAnnotations()) {
                this.processAnnotations(this.classDef);
            }
        }

        private void processFieldValue(DexValue value) {
            if (value instanceof DexValue.DexValueString) {
                this.callback.referencedString(((DexString)((DexValue.DexValueString)value).value).toString());
            } else if (value instanceof DexValue.DexValueInt) {
                int constantValue = ((DexValue.DexValueInt)value).getValue();
                this.callback.referencedInt(constantValue);
            } else if (value instanceof DexValue.DexValueArray) {
                DexValue.DexValueArray arrayEncodedValue = (DexValue.DexValueArray)value;
                for (DexValue encodedValue : arrayEncodedValue.getValues()) {
                    if (!(encodedValue instanceof DexValue.DexValueInt)) continue;
                    int constantValue = ((DexValue.DexValueInt)encodedValue).getValue();
                    this.callback.referencedInt(constantValue);
                }
            }
        }

        private void processMethod(DexEncodedMethod method) {
            Code implementation = method.getCode();
            if (implementation != null) {
                HashSet<Integer> methodIntArrayPayloadOffsets = Sets.newHashSet();
                ArrayList<FillArrayDataPayload> payloads = Lists.newArrayList();
                Instruction[] instructions = implementation.asDexCode().instructions;
                for (int current = 0; current < instructions.length; ++current) {
                    Instruction instruction = instructions[current];
                    if (this.isIntConstInstruction(instruction)) {
                        this.processIntConstInstruction(instruction);
                        continue;
                    }
                    if (this.isStringConstInstruction(instruction)) {
                        this.processStringConstantInstruction(instruction);
                        continue;
                    }
                    if (this.isGetStatic(instruction)) {
                        this.processGetStatic(instruction);
                        continue;
                    }
                    if (this.isInvokeInstruction(instruction)) {
                        this.processInvokeInstruction(instruction);
                        continue;
                    }
                    if (this.isInvokeRangeInstruction(instruction)) {
                        this.processInvokeRangeInstruction(instruction);
                        continue;
                    }
                    if (instruction instanceof FillArrayData) {
                        this.processFillArray(instructions, current, methodIntArrayPayloadOffsets);
                        continue;
                    }
                    if (!(instruction instanceof FillArrayDataPayload)) continue;
                    payloads.add((FillArrayDataPayload)instruction);
                }
                for (FillArrayDataPayload payload : payloads) {
                    if (!this.isIntArrayPayload(payload, methodIntArrayPayloadOffsets)) continue;
                    this.processIntArrayPayload(payload);
                }
            }
        }

        private void processAnnotations(DexProgramClass classDef) {
            Stream instanceFieldAnnotations = Arrays.stream(classDef.instanceFields()).filter(DexEncodedField::hasAnnotation).flatMap(f -> Arrays.stream(f.annotations.annotations));
            Stream staticFieldAnnotations = Arrays.stream(classDef.staticFields()).filter(DexEncodedField::hasAnnotation).flatMap(f -> Arrays.stream(f.annotations.annotations));
            Stream virtualMethodAnnotations = Arrays.stream(classDef.virtualMethods()).filter(DexEncodedMethod::hasAnnotation).flatMap(m -> Arrays.stream(m.annotations.annotations));
            Stream directMethodAnnotations = Arrays.stream(classDef.directMethods()).filter(DexEncodedMethod::hasAnnotation).flatMap(m -> Arrays.stream(m.annotations.annotations));
            Stream<DexAnnotation> classAnnotations = Arrays.stream(classDef.annotations.annotations);
            Streams.concat(instanceFieldAnnotations, staticFieldAnnotations, virtualMethodAnnotations, directMethodAnnotations, classAnnotations).forEach(annotation -> {
                for (DexAnnotationElement element : annotation.annotation.elements) {
                    DexValue value = element.value;
                    this.processAnnotationValue(value);
                }
            });
        }

        private void processIntArrayPayload(Instruction instruction) {
            FillArrayDataPayload payload = (FillArrayDataPayload)instruction;
            for (int i = 0; i < payload.data.length / 2; ++i) {
                int intValue = payload.data[2 * i + 1] << 16 | payload.data[2 * i];
                this.callback.referencedInt(intValue);
            }
        }

        private boolean isIntArrayPayload(Instruction instruction, Set<Integer> methodIntArrayPayloadOffsets) {
            if (!(instruction instanceof FillArrayDataPayload)) {
                return false;
            }
            FillArrayDataPayload payload = (FillArrayDataPayload)instruction;
            return methodIntArrayPayloadOffsets.contains(payload.getOffset());
        }

        private void processFillArray(Instruction[] instructions, int current, Set<Integer> methodIntArrayPayloadOffsets) {
            FillArrayData fillArrayData = (FillArrayData)instructions[current];
            if (current > 0 && instructions[current - 1] instanceof NewArray) {
                NewArray newArray = (NewArray)instructions[current - 1];
                if (!Objects.equals(newArray.getType().descriptor.toString(), "[I")) {
                    return;
                }
            }
            methodIntArrayPayloadOffsets.add(fillArrayData.getPayloadOffset() + fillArrayData.offset);
        }

        private void processAnnotationValue(DexValue value) {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!(value instanceof DexValue.DexValueInt)) break block2;
                            DexValue.DexValueInt dexValueInt = (DexValue.DexValueInt)value;
                            this.callback.referencedInt(dexValueInt.value);
                            break block3;
                        }
                        if (!(value instanceof DexValue.DexValueString)) break block4;
                        DexValue.DexValueString dexValueString = (DexValue.DexValueString)value;
                        this.callback.referencedString(((DexString)dexValueString.value).toString());
                        break block3;
                    }
                    if (!(value instanceof DexValue.DexValueArray)) break block5;
                    DexValue.DexValueArray dexValueArray = (DexValue.DexValueArray)value;
                    for (DexValue dexValue : dexValueArray.getValues()) {
                        this.processAnnotationValue(dexValue);
                    }
                    break block3;
                }
                if (!(value instanceof DexValue.DexValueAnnotation)) break block3;
                DexValue.DexValueAnnotation dexValueAnnotation = (DexValue.DexValueAnnotation)value;
                for (DexAnnotationElement element : dexValueAnnotation.value.elements) {
                    this.processAnnotationValue(element.value);
                }
            }
        }

        private boolean isIntConstInstruction(Instruction instruction) {
            int opcode = instruction.getOpcode();
            return opcode == 18 || opcode == 19 || opcode == 20 || opcode == 23 || opcode == 21 || opcode == 22;
        }

        private void processIntConstInstruction(Instruction instruction) {
            int constantValue;
            assert (this.isIntConstInstruction(instruction));
            if (instruction instanceof SingleConstant) {
                SingleConstant singleConstant = (SingleConstant)((Object)instruction);
                constantValue = singleConstant.decodedValue();
            } else if (instruction instanceof WideConstant) {
                WideConstant wideConstant = (WideConstant)((Object)instruction);
                if ((long)((int)wideConstant.decodedValue()) != wideConstant.decodedValue()) {
                    return;
                }
                constantValue = (int)wideConstant.decodedValue();
            } else {
                throw new AssertionError((Object)"Not an int const instruction.");
            }
            this.callback.referencedInt(constantValue);
        }

        private boolean isStringConstInstruction(Instruction instruction) {
            int opcode = instruction.getOpcode();
            return opcode == 26 || opcode == 27;
        }

        private void processStringConstantInstruction(Instruction instruction) {
            String constantValue;
            assert (this.isStringConstInstruction(instruction));
            if (instruction instanceof ConstString) {
                ConstString constString = (ConstString)instruction;
                constantValue = constString.getString().toString();
            } else if (instruction instanceof ConstStringJumbo) {
                ConstStringJumbo constStringJumbo = (ConstStringJumbo)instruction;
                constantValue = constStringJumbo.getString().toString();
            } else {
                throw new AssertionError((Object)"Not a string constant instruction.");
            }
            this.callback.referencedString(constantValue);
        }

        private boolean isGetStatic(Instruction instruction) {
            int opcode = instruction.getOpcode();
            return opcode == 96 || opcode == 99 || opcode == 100 || opcode == 101 || opcode == 98 || opcode == 102 || opcode == 97;
        }

        private void processGetStatic(Instruction instruction) {
            DexField field;
            assert (this.isGetStatic(instruction));
            if (instruction instanceof Sget) {
                Sget sget = (Sget)instruction;
                field = sget.getField();
            } else if (instruction instanceof SgetBoolean) {
                SgetBoolean sgetBoolean = (SgetBoolean)instruction;
                field = sgetBoolean.getField();
            } else if (instruction instanceof SgetByte) {
                SgetByte sgetByte = (SgetByte)instruction;
                field = sgetByte.getField();
            } else if (instruction instanceof SgetChar) {
                SgetChar sgetChar = (SgetChar)instruction;
                field = sgetChar.getField();
            } else if (instruction instanceof SgetObject) {
                SgetObject sgetObject = (SgetObject)instruction;
                field = sgetObject.getField();
            } else if (instruction instanceof SgetShort) {
                SgetShort sgetShort = (SgetShort)instruction;
                field = sgetShort.getField();
            } else if (instruction instanceof SgetWide) {
                SgetWide sgetWide = (SgetWide)instruction;
                field = sgetWide.getField();
            } else {
                throw new AssertionError((Object)"Not a get static instruction");
            }
            this.callback.referencedStaticField(field.clazz.getInternalName(), field.name.toString());
        }

        private boolean isInvokeInstruction(Instruction instruction) {
            int opcode = instruction.getOpcode();
            return opcode == 110 || opcode == 111 || opcode == 112 || opcode == 113 || opcode == 114;
        }

        private void processInvokeInstruction(Instruction instruction) {
            assert (this.isInvokeInstruction(instruction));
            Format35c ins35c = (Format35c)instruction;
            DexMethod method = (DexMethod)ins35c.BBBB;
            this.callback.referencedMethod(method.holder.getInternalName(), method.name.toString(), method.proto.toDescriptorString());
        }

        private boolean isInvokeRangeInstruction(Instruction instruction) {
            int opcode = instruction.getOpcode();
            return opcode == 116 || opcode == 117 || opcode == 118 || opcode == 119 || opcode == 120;
        }

        private void processInvokeRangeInstruction(Instruction instruction) {
            assert (this.isInvokeRangeInstruction(instruction));
            Format3rc ins3rc = (Format3rc)instruction;
            DexMethod method = (DexMethod)ins3rc.BBBB;
            this.callback.referencedMethod(method.holder.getInternalName(), method.name.toString(), method.proto.toDescriptorString());
        }
    }

    @KeepForSubclassing
    public static interface ReferenceChecker {
        public boolean shouldProcess(String var1);

        public void referencedInt(int var1);

        public void referencedString(String var1);

        public void referencedStaticField(String var1, String var2);

        public void referencedMethod(String var1, String var2, String var3);
    }

    @Keep
    public static final class Builder
    extends BaseCommand.Builder<Command, Builder> {
        @Override
        Builder self() {
            return this;
        }

        @Override
        Command makeCommand() {
            return new Command(this.getAppBuilder().build());
        }
    }

    @Keep
    public static final class Command
    extends BaseCommand {
        Command(AndroidApp app) {
            super(app);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }
    }
}

