/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.code.CfArithmeticBinop;
import com.android.tools.r8.cf.code.CfArrayLength;
import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfCmp;
import com.android.tools.r8.cf.code.CfConstClass;
import com.android.tools.r8.cf.code.CfConstMethodHandle;
import com.android.tools.r8.cf.code.CfConstMethodType;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfIfCmp;
import com.android.tools.r8.cf.code.CfIinc;
import com.android.tools.r8.cf.code.CfInstanceOf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfLogicalBinop;
import com.android.tools.r8.cf.code.CfMonitor;
import com.android.tools.r8.cf.code.CfMultiANewArray;
import com.android.tools.r8.cf.code.CfNeg;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.cf.code.CfNop;
import com.android.tools.r8.cf.code.CfNumberConversion;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.cf.code.CfSwitch;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.util.Printer;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class CfPrinter {
    private static final boolean PRINT_INSTRUCTION_INDEX = true;
    private static final boolean PRINT_INLINE_LOCALS = true;
    private final String indent;
    private final List<CfLabel> sortedLabels;
    private final Reference2IntMap<CfLabel> labelToIndex;
    private final List<List<CfCode.LocalVariableInfo>> localsAtLabel;
    private final StringBuilder builder = new StringBuilder();
    private final ClassNameMapper mapper;
    private int nextInstructionIndex = 0;
    private final int instructionIndexSpace;

    public CfPrinter() {
        this.indent = "";
        this.labelToIndex = null;
        this.mapper = null;
        this.instructionIndexSpace = 0;
        this.sortedLabels = Collections.emptyList();
        this.localsAtLabel = Collections.emptyList();
    }

    public CfPrinter(CfCode code, ClassNameMapper mapper) {
        this.mapper = mapper;
        this.indent = "  ";
        this.instructionIndexSpace = ("" + code.getInstructions().size()).length();
        this.labelToIndex = new Reference2IntOpenHashMap<CfLabel>();
        this.sortedLabels = new ArrayList<CfLabel>();
        for (CfInstruction instruction : code.getInstructions()) {
            if (!(instruction instanceof CfLabel)) continue;
            this.labelToIndex.put((CfLabel)instruction, this.sortedLabels.size());
            this.sortedLabels.add((CfLabel)instruction);
        }
        this.builder.append(".method ");
        this.appendMethod(code.getMethod());
        this.newline();
        this.builder.append(".limit stack ").append(code.getMaxStack());
        this.newline();
        this.builder.append(".limit locals ").append(code.getMaxLocals());
        List<CfCode.LocalVariableInfo> localVariables = this.getSortedLocalVariables(code);
        this.localsAtLabel = this.computeLocalsAtLabels(localVariables);
        for (CfCode.LocalVariableInfo local : localVariables) {
            DebugLocalInfo info = local.getLocal();
            this.newline();
            this.builder.append(".var ").append(local.getIndex()).append(" is ").append(info.name).append(" ").append(info.type.toDescriptorString()).append(" from ").append(this.getLabel(local.getStart())).append(" to ").append(this.getLabel(local.getEnd()));
            if (info.signature == null) continue;
            this.appendComment(info.signature.toString());
        }
        for (CfTryCatch tryCatch : code.getTryCatchRanges()) {
            for (int i = 0; i < tryCatch.guards.size(); ++i) {
                this.newline();
                DexType guard = tryCatch.guards.get(i);
                assert (guard != null);
                this.builder.append(".catch ").append(guard == DexItemFactory.catchAllType ? "all" : guard.getInternalName()).append(" from ").append(this.getLabel(tryCatch.start)).append(" to ").append(this.getLabel(tryCatch.end)).append(" using ").append(this.getLabel(tryCatch.targets.get(i)));
            }
        }
        for (CfInstruction instruction : code.getInstructions()) {
            instruction.print(this);
        }
        this.newline();
        this.builder.append(".end method");
        this.newline();
    }

    private List<List<CfCode.LocalVariableInfo>> computeLocalsAtLabels(List<CfCode.LocalVariableInfo> localVariables) {
        ArrayList<List<CfCode.LocalVariableInfo>> localsAtLabel = new ArrayList<List<CfCode.LocalVariableInfo>>(this.sortedLabels.size());
        HashSet<CfCode.LocalVariableInfo> openLocals = new HashSet<CfCode.LocalVariableInfo>();
        ListIterator<CfCode.LocalVariableInfo> nextLocalVariableEntry = localVariables.listIterator();
        for (CfLabel orderedLabel : this.sortedLabels) {
            int thisIndex = this.labelToIndex.getInt(orderedLabel);
            openLocals.removeIf(o -> this.labelToIndex.getInt(o.getEnd()) <= thisIndex);
            while (nextLocalVariableEntry.hasNext()) {
                CfCode.LocalVariableInfo next = nextLocalVariableEntry.next();
                int startIndex = this.labelToIndex.getInt(next.getStart());
                int endIndex = this.labelToIndex.getInt(next.getEnd());
                if (startIndex <= thisIndex) {
                    if (thisIndex >= endIndex) continue;
                    openLocals.add(next);
                    continue;
                }
                nextLocalVariableEntry.previous();
                break;
            }
            ArrayList locals = new ArrayList(openLocals);
            locals.sort((a, b) -> Integer.compare(a.getIndex(), b.getIndex()));
            localsAtLabel.add(locals);
        }
        return localsAtLabel;
    }

    private List<CfCode.LocalVariableInfo> getSortedLocalVariables(CfCode code) {
        ArrayList<CfCode.LocalVariableInfo> localVariables = new ArrayList<CfCode.LocalVariableInfo>(code.getLocalVariables());
        localVariables.sort((a, b) -> {
            int first = Integer.compare(this.labelToIndex.getInt(a.getStart()), this.labelToIndex.getInt(b.getStart()));
            if (first != 0) {
                return first;
            }
            int second = Integer.compare(this.labelToIndex.getInt(b.getEnd()), this.labelToIndex.getInt(a.getEnd()));
            if (second != 0) {
                return second;
            }
            return Integer.compare(a.getIndex(), b.getIndex());
        });
        return localVariables;
    }

    private void print(String name) {
        this.indent();
        this.builder.append(name);
    }

    public void print(CfNop nop) {
        this.print("nop");
    }

    public void print(CfStackInstruction instruction) {
        switch (instruction.getOpcode()) {
            case Pop: {
                this.print("pop");
                return;
            }
            case Pop2: {
                this.print("pop2");
                return;
            }
            case Dup: {
                this.print("dup");
                return;
            }
            case DupX1: {
                this.print("dup_x1");
                return;
            }
            case DupX2: {
                this.print("dup_x2");
                return;
            }
            case Dup2: {
                this.print("dup2");
                return;
            }
            case Dup2X1: {
                this.print("dup2_x1");
                return;
            }
            case Dup2X2: {
                this.print("dup2_x2");
                return;
            }
            case Swap: {
                this.print("swap");
                return;
            }
        }
        throw new Unreachable("Invalid instruction for CfStackInstruction");
    }

    public void print(CfThrow insn) {
        this.print("athrow");
    }

    public void print(CfConstNull constNull) {
        this.print("aconst_null");
    }

    public void print(CfConstNumber constNumber) {
        this.indent();
        switch (constNumber.getType()) {
            case INT: {
                this.builder.append("ldc ").append(constNumber.getIntValue());
                break;
            }
            case FLOAT: {
                this.builder.append("ldc ").append(constNumber.getFloatValue());
                break;
            }
            case LONG: {
                this.builder.append("ldc_w ").append(constNumber.getLongValue());
                break;
            }
            case DOUBLE: {
                this.builder.append("ldc_w ").append(constNumber.getDoubleValue());
                break;
            }
            default: {
                throw new Unreachable("Unexpected const-number type: " + (Object)((Object)constNumber.getType()));
            }
        }
    }

    public void print(CfConstClass constClass) {
        this.indent();
        this.builder.append("ldc ");
        this.appendClass(constClass.getType());
    }

    public void print(CfReturnVoid ret) {
        this.print("return");
    }

    public void print(CfReturn ret) {
        this.print(this.typePrefix(ret.getType()) + "return");
    }

    public void print(CfMonitor monitor) {
        this.print(monitor.getType() == Monitor.Type.ENTER ? "monitorenter" : "monitorexit");
    }

    public void print(CfArithmeticBinop arithmeticBinop) {
        this.print(this.opcodeName(arithmeticBinop.getAsmOpcode()));
    }

    public void print(CfCmp cmp) {
        this.print(this.opcodeName(cmp.getAsmOpcode()));
    }

    public void print(CfLogicalBinop logicalBinop) {
        this.print(this.opcodeName(logicalBinop.getAsmOpcode()));
    }

    public void print(CfNeg neg) {
        this.print(this.opcodeName(neg.getAsmOpcode()));
    }

    public void print(CfNumberConversion numberConversion) {
        this.print(this.opcodeName(numberConversion.getAsmOpcode()));
    }

    public void print(CfConstString constString) {
        this.indent();
        this.builder.append("ldc ").append(constString.getString());
    }

    public void print(CfDexItemBasedConstString constString) {
        this.indent();
        this.builder.append("ldc* ").append(constString.getItem().toString());
    }

    public void print(CfArrayLoad arrayLoad) {
        this.indent();
        this.builder.append(this.typePrefix(arrayLoad.getType())).append("aload");
    }

    public void print(CfArrayStore arrayStore) {
        this.indent();
        this.builder.append(this.typePrefix(arrayStore.getType())).append("astore");
    }

    public void print(CfInvoke invoke) {
        this.indent();
        this.builder.append(this.opcodeName(invoke.getOpcode())).append(' ');
        this.appendMethod(invoke.getMethod());
    }

    public void print(CfInvokeDynamic invoke) {
        this.indent();
        this.builder.append(this.opcodeName(186)).append(' ');
        this.builder.append(invoke.getCallSite().methodName);
        this.builder.append(invoke.getCallSite().methodProto.toDescriptorString());
    }

    public void print(CfFrame frame) {
        this.indent();
        this.builder.append("; frame: [");
        String separator = "";
        for (Int2ReferenceMap.Entry entry : frame.getLocals().int2ReferenceEntrySet()) {
            this.builder.append(separator).append(entry.getIntKey()).append(':');
            this.print((CfFrame.FrameType)entry.getValue());
            separator = ", ";
        }
        this.builder.append("] [");
        separator = "";
        for (CfFrame.FrameType frameType : frame.getStack()) {
            this.builder.append(separator);
            this.print(frameType);
            separator = ", ";
        }
        this.builder.append(']');
    }

    private void print(CfFrame.FrameType type) {
        if (type.isUninitializedNew()) {
            this.builder.append("uninitialized ").append(this.getLabel(type.getUninitializedLabel()));
        } else if (type.isInitialized()) {
            this.appendType(type.getInitializedType());
        } else {
            this.builder.append(type.toString());
        }
    }

    public void print(CfInstanceOf insn) {
        this.indent();
        this.builder.append("instanceof ");
        this.appendClass(insn.getType());
    }

    public void print(CfCheckCast insn) {
        this.indent();
        this.builder.append("checkcast ");
        this.appendClass(insn.getType());
    }

    public void print(CfFieldInstruction insn) {
        this.indent();
        switch (insn.getOpcode()) {
            case 180: {
                this.builder.append("getfield ");
                break;
            }
            case 181: {
                this.builder.append("putfield ");
                break;
            }
            case 178: {
                this.builder.append("getstatic ");
                break;
            }
            case 179: {
                this.builder.append("putstatic ");
                break;
            }
            default: {
                throw new Unreachable("Unexpected field-instruction opcode " + insn.getOpcode());
            }
        }
        this.appendField(insn.getField());
        this.builder.append(' ');
        this.appendDescriptor(insn.getField().type);
    }

    public void print(CfNew newInstance) {
        this.indent();
        this.builder.append("new ");
        this.appendClass(newInstance.getType());
    }

    public void print(CfNewArray newArray) {
        this.indent();
        String elementDescriptor = newArray.getType().toDescriptorString().substring(1);
        if (newArray.getType().isPrimitiveArrayType()) {
            this.builder.append("newarray ");
            this.builder.append(DescriptorUtils.descriptorToJavaType(elementDescriptor));
        } else {
            this.builder.append("anewarray ");
            if (elementDescriptor.charAt(0) == '[') {
                this.builder.append(elementDescriptor);
            } else {
                this.builder.append(Type.getType(elementDescriptor).getInternalName());
            }
        }
    }

    public void print(CfMultiANewArray multiANewArray) {
        this.indent();
        this.builder.append("multianewarray ");
        this.appendClass(multiANewArray.getType());
        this.builder.append(' ').append(multiANewArray.getDimensions());
    }

    public void print(CfArrayLength arrayLength) {
        this.print("arraylength");
    }

    public void print(CfLabel label) {
        this.newline();
        this.instructionIndex();
        this.builder.append(this.getLabel(label)).append(':');
        int labelNumber = this.labelToIndex.getInt(label);
        List<CfCode.LocalVariableInfo> locals = this.localsAtLabel.get(labelNumber);
        this.appendComment("locals: " + String.join((CharSequence)", ", locals.stream().map(CfCode.LocalVariableInfo::toString).collect(Collectors.toList())));
    }

    public void print(CfPosition instruction) {
        Position position = instruction.getPosition();
        this.indent();
        this.builder.append(".line ").append(position.line);
        if (position.file != null || position.callerPosition != null) {
            this.appendComment(position.toString());
        }
    }

    public void print(CfGoto jump) {
        this.indent();
        this.builder.append("goto ").append(this.getLabel(jump.getTarget()));
    }

    private String ifPostfix(If.Type kind) {
        return kind.toString().toLowerCase();
    }

    public void print(CfIf conditional) {
        this.indent();
        if (conditional.getType().isObject()) {
            this.builder.append("if").append(conditional.getKind() == If.Type.EQ ? "null" : "nonnull");
        } else {
            this.builder.append("if").append(this.ifPostfix(conditional.getKind()));
        }
        this.builder.append(' ').append(this.getLabel(conditional.getTarget()));
    }

    public void print(CfIfCmp conditional) {
        this.indent();
        this.builder.append(conditional.getType().isObject() ? "if_acmp" : "if_icmp").append(this.ifPostfix(conditional.getKind())).append(' ').append(this.getLabel(conditional.getTarget()));
    }

    public void print(CfSwitch cfSwitch) {
        this.indent();
        CfSwitch.Kind kind = cfSwitch.getKind();
        this.builder.append(kind == CfSwitch.Kind.LOOKUP ? "lookup" : "table").append("switch");
        IntList keys2 = cfSwitch.getKeys();
        List<CfLabel> targets = cfSwitch.getSwitchTargets();
        for (int i = 0; i < targets.size(); ++i) {
            this.indent();
            int key = kind == CfSwitch.Kind.LOOKUP ? keys2.getInt(i) : keys2.getInt(0) + i;
            this.builder.append("  ").append(key).append(": ").append(this.getLabel(targets.get(i)));
        }
        this.indent();
        this.builder.append("  default: ").append(this.getLabel(cfSwitch.getDefaultTarget()));
    }

    public void print(CfLoad load) {
        this.printPrefixed(load.getType(), "load", load.getLocalIndex());
    }

    public void print(CfStore store) {
        this.printPrefixed(store.getType(), "store", store.getLocalIndex());
    }

    public void print(CfIinc instruction) {
        this.indent();
        this.builder.append("iinc ").append(instruction.getLocalIndex()).append(' ').append(instruction.getIncrement());
    }

    private void printPrefixed(ValueType type, String instruction, int local) {
        this.indent();
        this.builder.append(this.typePrefix(type)).append(instruction).append(' ').append(local);
    }

    private char typePrefix(ValueType type) {
        switch (type) {
            case OBJECT: {
                return 'a';
            }
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected type for prefix: " + (Object)((Object)type));
    }

    public char typePrefix(MemberType type) {
        switch (type) {
            case OBJECT: {
                return 'a';
            }
            case BOOLEAN: 
            case BYTE: {
                return 'b';
            }
            case CHAR: {
                return 'c';
            }
            case SHORT: {
                return 's';
            }
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected member type for prefix: " + (Object)((Object)type));
    }

    public char typePrefix(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected numeric type for prefix: " + (Object)((Object)type));
    }

    public void print(CfConstMethodHandle handle) {
        this.indent();
        this.builder.append("ldc ");
        this.builder.append(handle.getHandle().toString());
    }

    public void print(CfConstMethodType type) {
        this.indent();
        this.builder.append("ldc ");
        this.builder.append(type.getType().toString());
    }

    private String getLabel(CfLabel label) {
        return this.labelToIndex != null ? "L" + this.labelToIndex.getInt(label) : "L?";
    }

    private void newline() {
        if (this.builder.length() > 0) {
            this.builder.append('\n');
        }
    }

    private void instructionIndex() {
        if (this.instructionIndexSpace > 0) {
            this.builder.append(String.format("%" + this.instructionIndexSpace + "d: ", this.nextInstructionIndex++));
        }
    }

    private void indent() {
        this.newline();
        this.instructionIndex();
        this.builder.append(this.indent);
    }

    private void comment(String comment) {
        this.indent();
        this.builder.append("; ").append(comment);
    }

    private void appendComment(String comment) {
        this.builder.append(" ; ").append(comment);
    }

    private void appendDescriptor(DexType type) {
        if (this.mapper != null) {
            this.builder.append(DescriptorUtils.javaTypeToDescriptor(this.mapper.originalNameOf(type)));
            return;
        }
        this.builder.append(type.toDescriptorString());
    }

    private void appendType(DexType type) {
        if (type.isArrayType() || type.isClassType()) {
            this.appendClass(type);
        } else {
            this.builder.append(type);
        }
    }

    private void appendClass(DexType type) {
        assert (type.isArrayType() || type.isClassType());
        if (this.mapper == null) {
            this.builder.append(type.getInternalName());
        } else if (type == DexItemFactory.nullValueType) {
            this.builder.append("NULL");
        } else {
            this.builder.append(DescriptorUtils.descriptorToInternalName(DescriptorUtils.javaTypeToDescriptor(this.mapper.originalNameOf(type))));
        }
    }

    private void appendField(DexField field) {
        if (this.mapper != null) {
            this.builder.append(this.mapper.originalSignatureOf(field).toString());
            return;
        }
        this.appendClass(field.getHolder());
        this.builder.append('/').append(field.name);
    }

    private void appendMethod(DexMethod method) {
        if (this.mapper != null) {
            MemberNaming.MethodSignature signature = this.mapper.originalSignatureOf(method);
            this.builder.append(this.mapper.originalNameOf(method.holder)).append('.');
            this.builder.append(signature.name).append(signature.toDescriptor());
            return;
        }
        this.builder.append(method.qualifiedName());
        this.builder.append(method.proto.toDescriptorString());
    }

    private String opcodeName(int opcode) {
        return Printer.OPCODES[opcode].toLowerCase();
    }

    public String toString() {
        return this.builder.toString();
    }
}

