/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.code.Const;
import com.android.tools.r8.code.Const16;
import com.android.tools.r8.code.Const4;
import com.android.tools.r8.code.ConstHigh16;
import com.android.tools.r8.code.ConstWide;
import com.android.tools.r8.code.ConstWide16;
import com.android.tools.r8.code.ConstWide32;
import com.android.tools.r8.code.ConstWideHigh16;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.analysis.constant.Bottom;
import com.android.tools.r8.ir.analysis.constant.ConstLatticeElement;
import com.android.tools.r8.ir.analysis.constant.LatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.utils.InternalOutputMode;
import com.android.tools.r8.utils.NumberUtils;
import java.util.function.Function;

public class ConstNumber
extends ConstInstruction {
    private final long value;

    public ConstNumber(Value dest, long value) {
        super(dest);
        assert (dest.isFixedRegisterValue() || dest.definition.isConstNumber());
        this.value = value;
    }

    public static ConstNumber copyOf(IRCode code, ConstNumber original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return ConstNumber.copyOf(newValue, original);
    }

    public static ConstNumber copyOf(Value newValue, ConstNumber original) {
        return new ConstNumber(newValue, original.getRawValue());
    }

    public Value dest() {
        return this.outValue;
    }

    public boolean getBooleanValue() {
        return !this.isZero();
    }

    public int getIntValue() {
        assert (this.outType() == ValueType.INT || this.outType() == ValueType.OBJECT);
        return (int)this.value;
    }

    public long getLongValue() {
        assert (this.outType() == ValueType.LONG);
        return this.value;
    }

    public float getFloatValue() {
        assert (this.outType() == ValueType.FLOAT);
        return Float.intBitsToFloat((int)this.value);
    }

    public double getDoubleValue() {
        assert (this.outType() == ValueType.DOUBLE);
        return Double.longBitsToDouble(this.value);
    }

    public long getRawValue() {
        return this.value;
    }

    public boolean isZero() {
        return this.value == 0L;
    }

    public boolean isIntegerZero() {
        return this.outType() == ValueType.INT && this.getIntValue() == 0;
    }

    public boolean isIntegerOne() {
        return this.outType() == ValueType.INT && this.getIntValue() == 1;
    }

    public boolean isIntegerNegativeOne(NumericType type) {
        assert (type == NumericType.INT || type == NumericType.LONG);
        if (type == NumericType.INT) {
            return this.getIntValue() == -1;
        }
        return this.getLongValue() == -1L;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        if (!this.dest().needsRegister()) {
            builder.addNothing(this);
            return;
        }
        int register = builder.allocatedRegister(this.dest(), this.getNumber());
        if (this.outType().isObject() || this.outType().isSingle()) {
            assert (NumberUtils.is32Bit(this.value));
            if ((register & 0xF) == register && NumberUtils.is4Bit(this.value)) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new Const4(register, (int)this.value));
            } else if (NumberUtils.is16Bit(this.value)) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new Const16(register, (int)this.value));
            } else if ((this.value & 0xFFFFL) == 0L) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new ConstHigh16(register, (int)this.value >>> 16));
            } else {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new Const(register, (int)this.value));
            }
        } else {
            assert (this.outType().isWide());
            if (NumberUtils.is16Bit(this.value)) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new ConstWide16(register, (int)this.value));
            } else if ((this.value & 0xFFFFFFFFFFFFL) == 0L) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new ConstWideHigh16(register, (int)(this.value >>> 48)));
            } else if (NumberUtils.is32Bit(this.value)) {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new ConstWide32(register, (int)this.value));
            } else {
                builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new ConstWide(register, this.value));
            }
        }
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        if (this.outType().isObject()) {
            builder.add(new CfConstNull());
        } else {
            builder.add(new CfConstNumber(this.value, this.outType()));
        }
    }

    public static int estimatedSize(InternalOutputMode mode, ValueType type, long value) {
        return mode.isGeneratingDex() ? ConstNumber.estimatedDexSize(type, value) : ConstNumber.estimatedCfSize(type, value);
    }

    private static int estimatedCfSize(ValueType type, long value) {
        switch (type) {
            case INT: {
                if (-1L <= value && value <= 5L) {
                    return 1;
                }
                if (-128L <= value && value <= 127L) {
                    return 2;
                }
                return 3;
            }
            case LONG: {
                if (value == 0L || value == 1L) {
                    return 1;
                }
                return 3;
            }
            case FLOAT: {
                if (value == 0L || value == 1L || value == 2L) {
                    return CfConstNumber.isNegativeZeroFloat(value) ? 2 : 1;
                }
                return 3;
            }
            case DOUBLE: {
                if (value == 0L || value == 1L) {
                    return CfConstNumber.isNegativeZeroDouble(value) ? 2 : 1;
                }
                return 3;
            }
            case OBJECT: {
                return 1;
            }
        }
        throw new UnsupportedOperationException("Not a constant number");
    }

    private static int estimatedDexSize(ValueType type, long value) {
        if (type.isSingle()) {
            assert (NumberUtils.is32Bit(value));
            if (NumberUtils.is4Bit(value)) {
                return 1;
            }
            if (NumberUtils.is16Bit(value)) {
                return 2;
            }
            if ((value & 0xFFFFL) == 0L) {
                return 2;
            }
            return 3;
        }
        assert (type.isWide());
        if (NumberUtils.is16Bit(value)) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFFFL) == 0L) {
            return 2;
        }
        if (NumberUtils.is32Bit(value)) {
            return 3;
        }
        return 5;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "Const has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.value + " (" + this.outValue().getTypeLattice() + ")";
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (other == this) {
            return true;
        }
        if (!other.isConstNumber()) {
            return false;
        }
        ConstNumber o = other.asConstNumber();
        return o.outType() == this.outType() && o.value == this.value;
    }

    public boolean is8Bit() {
        return NumberUtils.is8Bit(this.value);
    }

    public boolean negativeIs8Bit() {
        return NumberUtils.negativeIs8Bit(this.value);
    }

    public boolean is16Bit() {
        return NumberUtils.is16Bit(this.value);
    }

    public boolean negativeIs16Bit() {
        return NumberUtils.negativeIs16Bit(this.value);
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstNumber() {
        return true;
    }

    @Override
    public ConstNumber asConstNumber() {
        return this;
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        assert (this.outType().isObject());
        helper.getFactory();
        return DexItemFactory.nullValueType;
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        if (this.outValue.hasLocalInfo()) {
            return Bottom.getInstance();
        }
        return new ConstLatticeElement(this);
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return this.outValue().getTypeLattice();
    }

    @Override
    public boolean verifyTypes(AppInfo appInfo, GraphLense graphLense) {
        assert (super.verifyTypes(appInfo, graphLense));
        assert (!this.isZero() || this.outValue().getTypeLattice().isPrimitive() || this.outValue().getTypeLattice().isNullType());
        return true;
    }
}

