/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeSuper;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.origin.SynthesizedOrigin;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class InterfaceProcessor {
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final InterfaceMethodRewriter rewriter;
    final Map<DexType, DexProgramClass> syntheticClasses = new IdentityHashMap<DexType, DexProgramClass>();

    InterfaceProcessor(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, InterfaceMethodRewriter rewriter) {
        this.appView = appView;
        this.rewriter = rewriter;
    }

    void process(DexProgramClass iface, GraphLense.Builder graphLensBuilder) {
        assert (iface.isInterface());
        ArrayList<DexEncodedMethod> companionMethods = new ArrayList<DexEncodedMethod>();
        ArrayList<DexEncodedMethod> remainingMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod virtual : iface.virtualMethods()) {
            if (this.rewriter.isDefaultMethod(virtual)) {
                if (!this.canMoveToCompanionClass(virtual)) {
                    throw new CompilationError("One or more instruction is preventing default interface method from being desugared: " + virtual.method.toSourceString(), iface.origin);
                }
                DexMethod companionMethod = this.rewriter.defaultAsMethodOfCompanionClass(virtual.method);
                Code code = virtual.getCode();
                if (code == null) {
                    throw new CompilationError("Code is missing for default interface method: " + virtual.method.toSourceString(), iface.origin);
                }
                MethodAccessFlags newFlags = virtual.accessFlags.copy();
                newFlags.unsetBridge();
                newFlags.setStatic();
                DexCode dexCode = code.asDexCode();
                dexCode.setDebugInfo(dexCode.debugInfoWithAdditionalFirstParameter(this.rewriter.factory.createString("-this")));
                assert (dexCode.getDebugInfo() == null || companionMethod.getArity() == dexCode.getDebugInfo().parameters.length);
                virtual.accessFlags.setAbstract();
                virtual.removeCode();
                DexEncodedMethod implMethod = new DexEncodedMethod(companionMethod, newFlags, virtual.annotations, virtual.parameterAnnotationsList, code);
                companionMethods.add(implMethod);
                graphLensBuilder.move(virtual.method, implMethod.method);
            }
            if (!this.interfaceMethodRemovalChangesApi(virtual, iface)) continue;
            remainingMethods.add(virtual);
        }
        if (remainingMethods.size() < iface.virtualMethods().length) {
            iface.setVirtualMethods(remainingMethods.toArray(new DexEncodedMethod[remainingMethods.size()]));
        }
        remainingMethods.clear();
        for (DexEncodedMethod direct : iface.directMethods()) {
            DexMethod companionMethod;
            MethodAccessFlags originalFlags = direct.accessFlags;
            MethodAccessFlags newFlags = originalFlags.copy();
            if (originalFlags.isPrivate()) {
                newFlags.unsetPrivate();
                newFlags.setPublic();
            }
            DexMethod oldMethod = direct.method;
            if (this.isStaticMethod(direct)) {
                assert (originalFlags.isPrivate() || originalFlags.isPublic()) : "Static interface method " + direct.toSourceString() + " is expected to either be public or private in " + iface.origin;
                companionMethod = this.rewriter.staticAsMethodOfCompanionClass(oldMethod);
                companionMethods.add(new DexEncodedMethod(companionMethod, newFlags, direct.annotations, direct.parameterAnnotationsList, direct.getCode()));
                graphLensBuilder.move(oldMethod, companionMethod);
                continue;
            }
            if (originalFlags.isPrivate()) {
                assert (!this.rewriter.factory.isClassConstructor(oldMethod)) : "Unexpected private constructor " + direct.toSourceString() + " in " + iface.origin;
                newFlags.setStatic();
                companionMethod = this.rewriter.privateAsMethodOfCompanionClass(oldMethod);
                Code code = direct.getCode();
                if (code == null) {
                    throw new CompilationError("Code is missing for private instance interface method: " + oldMethod.toSourceString(), iface.origin);
                }
                DexCode dexCode = code.asDexCode();
                dexCode.setDebugInfo(dexCode.debugInfoWithAdditionalFirstParameter(null));
                assert (dexCode.getDebugInfo() == null || companionMethod.getArity() == dexCode.getDebugInfo().parameters.length);
                companionMethods.add(new DexEncodedMethod(companionMethod, newFlags, direct.annotations, direct.parameterAnnotationsList, code));
                graphLensBuilder.move(oldMethod, companionMethod);
                continue;
            }
            assert (this.rewriter.factory.isClassConstructor(oldMethod));
            remainingMethods.add(direct);
        }
        if (remainingMethods.size() < iface.directMethods().length) {
            iface.setDirectMethods(remainingMethods.toArray(new DexEncodedMethod[remainingMethods.size()]));
        }
        if (companionMethods.isEmpty()) {
            return;
        }
        ClassAccessFlags companionClassFlags = iface.accessFlags.copy();
        companionClassFlags.unsetAbstract();
        companionClassFlags.unsetInterface();
        companionClassFlags.unsetAnnotation();
        companionClassFlags.setFinal();
        companionClassFlags.setSynthetic();
        companionClassFlags.setPublic();
        DexType companionClassType = this.rewriter.getCompanionClassType(iface.type);
        DexProgramClass companionClass = new DexProgramClass(companionClassType, null, new SynthesizedOrigin("interface desugaring", this.getClass()), companionClassFlags, this.rewriter.factory.objectType, DexTypeList.empty(), iface.sourceFile, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, companionMethods.toArray(new DexEncodedMethod[companionMethods.size()]), DexEncodedMethod.EMPTY_ARRAY, this.rewriter.factory.getSkipNameValidationForTesting(), Collections.singletonList(iface));
        this.syntheticClasses.put(iface.type, companionClass);
    }

    List<DexEncodedMethod> process(DexLibraryClass iface, Set<DexProgramClass> callers) {
        assert (iface.isInterface());
        ArrayList<DexEncodedMethod> dispatchMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod direct : iface.directMethods()) {
            MethodAccessFlags originalAccessFlags = direct.accessFlags;
            if (!originalAccessFlags.isStatic() || !originalAccessFlags.isPublic()) {
                assert (!originalAccessFlags.isStatic() || originalAccessFlags.isPrivate());
                continue;
            }
            assert (!this.rewriter.factory.isClassConstructor(direct.method));
            DexMethod origMethod = direct.method;
            DexMethod newMethod = this.rewriter.staticAsMethodOfDispatchClass(origMethod);
            DexEncodedMethod newEncodedMethod = new DexEncodedMethod(newMethod, MethodAccessFlags.fromSharedAccessFlags(4105, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(callerPosition -> new ForwardMethodSourceCode(null, newMethod, newMethod, null, origMethod, Invoke.Type.STATIC, callerPosition)));
            newEncodedMethod.getMutableOptimizationInfo().markNeverInline();
            dispatchMethods.add(newEncodedMethod);
        }
        ClassAccessFlags dispatchClassFlags = ClassAccessFlags.fromSharedAccessFlags(4113);
        DexType dispatchClassType = this.rewriter.getDispatchClassType(iface.type);
        DexProgramClass dispatchClass = new DexProgramClass(dispatchClassType, null, new SynthesizedOrigin("interface dispatch", this.getClass()), dispatchClassFlags, this.rewriter.factory.objectType, DexTypeList.empty(), iface.sourceFile, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, dispatchMethods.toArray(new DexEncodedMethod[dispatchMethods.size()]), DexEncodedMethod.EMPTY_ARRAY, this.rewriter.factory.getSkipNameValidationForTesting(), callers);
        this.syntheticClasses.put(iface.type, dispatchClass);
        return dispatchMethods;
    }

    private boolean canMoveToCompanionClass(DexEncodedMethod method) {
        Code code = method.getCode();
        assert (code != null);
        if (code.isDexCode()) {
            for (Instruction insn : code.asDexCode().instructions) {
                if (!(insn instanceof InvokeSuper)) continue;
                return false;
            }
        } else {
            assert (code.isCfCode());
            for (CfInstruction insn : code.asCfCode().getInstructions()) {
                if (!(insn instanceof CfInvoke) || !((CfInvoke)insn).isInvokeSuper(method.method.holder)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean interfaceMethodRemovalChangesApi(DexEncodedMethod method, DexClass iface) {
        if (this.appView != null && this.appView.appInfo().isPinned(method.method)) {
            return true;
        }
        if (method.accessFlags.isBridge()) {
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            HashSet<DexType> seenBefore = new HashSet<DexType>();
            if (iface.superType != null) {
                worklist.add(iface.superType);
            }
            Collections.addAll(worklist, iface.interfaces.values);
            while (!worklist.isEmpty()) {
                DexClass clazz;
                DexType superType = (DexType)worklist.pop();
                if (!seenBefore.add(superType) || (clazz = this.rewriter.findDefinitionFor(superType)) == null) continue;
                if (clazz.lookupVirtualMethod(method.method) != null) {
                    return false;
                }
                if (clazz.superType != null) {
                    worklist.add(clazz.superType);
                }
                Collections.addAll(worklist, clazz.interfaces.values);
            }
        }
        return true;
    }

    private boolean isStaticMethod(DexEncodedMethod method) {
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native interface methods are not yet supported.");
        }
        return method.accessFlags.isStatic() && !this.rewriter.factory.isClassConstructor(method.method);
    }
}

