/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.ArithmeticBinop;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.ValueTypeConstraint;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.SynthesizedOrigin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class Outliner {
    private final InternalOptions options;
    private final List<List<DexEncodedMethod>> candidateMethodLists = new ArrayList<List<DexEncodedMethod>>();
    private final Set<DexEncodedMethod> methodsSelectedForOutlining = Sets.newIdentityHashSet();
    private final Map<Outline, List<DexEncodedMethod>> outlineSites = new HashMap<Outline, List<DexEncodedMethod>>();
    private final Map<Outline, DexMethod> generatedOutlines = new HashMap<Outline, DexMethod>();
    static final int MAX_IN_SIZE = 5;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final DexItemFactory dexItemFactory;
    private final IRConverter converter;
    private final InliningConstraints inliningConstraints;

    public Outliner(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options, IRConverter converter) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.converter = converter;
        this.inliningConstraints = new InliningConstraints(appInfo);
        this.options = options;
    }

    public BiConsumer<IRCode, DexEncodedMethod> identifyCandidateMethods() {
        HashMap candidateMap = new HashMap();
        assert (this.candidateMethodLists.isEmpty());
        return (code, method) -> {
            assert (!(method.getCode() instanceof OutlineCode));
            for (BasicBlock block : code.blocks) {
                new OutlineMethodIdentifier((DexEncodedMethod)method, block, candidateMap).process();
            }
        };
    }

    public void identifyOutlineSites(IRCode code, DexEncodedMethod method) {
        assert (!(method.getCode() instanceof OutlineCode));
        for (BasicBlock block : code.blocks) {
            new OutlineSiteIdentifier(method, block).process();
        }
    }

    public boolean selectMethodsForOutlining(Map<DexType, DexProgramClass> synthesizedClasses) {
        assert (this.methodsSelectedForOutlining.size() == 0);
        assert (this.outlineSites.size() == 0);
        for (List<DexEncodedMethod> outlineMethods : this.candidateMethodLists) {
            if (outlineMethods.size() < this.options.outline.threshold) continue;
            for (DexEncodedMethod outlineMethod : outlineMethods) {
                this.methodsSelectedForOutlining.add(this.converter.graphLense().mapDexEncodedMethod(outlineMethod, this.appInfo, synthesizedClasses));
            }
        }
        this.candidateMethodLists.clear();
        return this.methodsSelectedForOutlining.size() > 0;
    }

    public Set<DexEncodedMethod> getMethodsSelectedForOutlining() {
        return this.methodsSelectedForOutlining;
    }

    public DexProgramClass buildOutlinerClass(DexType type) {
        List<Outline> outlines = this.selectOutlines();
        outlines.sort(Comparator.naturalOrder());
        DexEncodedMethod[] direct = new DexEncodedMethod[outlines.size()];
        int count = 0;
        for (Outline outline : outlines) {
            MethodAccessFlags methodAccess = MethodAccessFlags.fromSharedAccessFlags(9, false);
            DexString methodName = this.dexItemFactory.createString("outline" + count);
            DexMethod method = outline.buildMethod(type, methodName);
            List<DexEncodedMethod> sites = this.outlineSites.get(outline);
            assert (!sites.isEmpty());
            direct[count] = new DexEncodedMethod(method, methodAccess, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new OutlineCode(outline));
            if (this.options.isGeneratingClassFiles()) {
                direct[count].upgradeClassFileVersion(sites.get(0).getClassFileVersion());
            }
            this.generatedOutlines.put(outline, method);
            ++count;
        }
        DexType superType = this.dexItemFactory.createType("Ljava/lang/Object;");
        DexTypeList interfaces = DexTypeList.empty();
        DexString sourceFile = this.dexItemFactory.createString("outline");
        ClassAccessFlags accessFlags = ClassAccessFlags.fromSharedAccessFlags(1);
        DexProgramClass clazz = new DexProgramClass(type, null, new SynthesizedOrigin("outlining", this.getClass()), accessFlags, superType, interfaces, sourceFile, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, direct, DexEncodedMethod.EMPTY_ARRAY, this.options.itemFactory.getSkipNameValidationForTesting());
        return clazz;
    }

    private List<Outline> selectOutlines() {
        assert (this.outlineSites.size() > 0);
        assert (this.candidateMethodLists.isEmpty());
        ArrayList<Outline> result = new ArrayList<Outline>();
        for (Map.Entry<Outline, List<DexEncodedMethod>> entry : this.outlineSites.entrySet()) {
            if (entry.getValue().size() < this.options.outline.threshold) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public void applyOutliningCandidate(IRCode code, DexEncodedMethod method) {
        assert (!(method.getCode() instanceof OutlineCode));
        ListIterator<BasicBlock> blocksIterator = code.blocks.listIterator();
        while (blocksIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blocksIterator.next();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            new OutlineRewriter(method, code, blocksIterator, block, toRemove).process();
            block.removeInstructions(toRemove);
        }
    }

    public boolean checkAllOutlineSitesFoundAgain() {
        for (Outline outline : this.generatedOutlines.keySet()) {
            assert (this.outlineSites.get(outline).isEmpty()) : this.outlineSites.get(outline);
        }
        return true;
    }

    public static void noProcessing(IRCode code, DexEncodedMethod method) {
    }

    public class OutlineCode
    extends Code {
        private final Outline outline;

        OutlineCode(Outline outline) {
            this.outline = outline;
        }

        @Override
        public boolean isOutlineCode() {
            return true;
        }

        @Override
        public int estimatedSizeForInlining() {
            return Integer.MAX_VALUE;
        }

        @Override
        public OutlineCode asOutlineCode() {
            return this;
        }

        @Override
        public boolean isEmptyVoidMethod() {
            return false;
        }

        @Override
        public IRCode buildIR(DexEncodedMethod encodedMethod, AppInfo appInfo, GraphLense graphLense, InternalOptions options, Origin origin) {
            assert (this.getOwner() == encodedMethod);
            OutlineSourceCode source = new OutlineSourceCode(this.outline, encodedMethod.method);
            return new IRBuilder(encodedMethod, appInfo, source, options, origin).build(encodedMethod);
        }

        @Override
        public String toString() {
            return this.outline.toString();
        }

        @Override
        public void registerCodeReferences(UseRegistry registry) {
            throw new Unreachable();
        }

        @Override
        protected int computeHashCode() {
            return this.outline.hashCode();
        }

        @Override
        protected boolean computeEquals(Object other) {
            return this.outline.equals(other);
        }

        @Override
        public String toString(DexEncodedMethod method, ClassNameMapper naming) {
            return null;
        }
    }

    private class OutlineSourceCode
    implements SourceCode {
        private final Outline outline;
        private final Position position;
        private int argumentMapIndex = 0;

        OutlineSourceCode(Outline outline, DexMethod method) {
            this.outline = outline;
            this.position = Position.synthetic(0, method, null);
        }

        @Override
        public int instructionCount() {
            return this.outline.templateInstructions.size() + 1;
        }

        @Override
        public int instructionIndex(int instructionOffset) {
            return instructionOffset;
        }

        @Override
        public int instructionOffset(int instructionIndex) {
            return instructionIndex;
        }

        @Override
        public DebugLocalInfo getIncomingLocalAtBlock(int register, int blockOffset) {
            return null;
        }

        @Override
        public DebugLocalInfo getIncomingLocal(int register) {
            return null;
        }

        @Override
        public DebugLocalInfo getOutgoingLocal(int register) {
            return null;
        }

        @Override
        public int traceInstruction(int instructionIndex, IRBuilder builder) {
            return instructionIndex == this.outline.templateInstructions.size() ? instructionIndex : -1;
        }

        @Override
        public void setUp() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void buildPrelude(IRBuilder builder) {
            for (int i = 0; i < this.outline.argumentTypes.size(); ++i) {
                TypeLatticeElement typeLattice = TypeLatticeElement.fromDexType(this.outline.argumentTypes.get(i), true, Outliner.this.appInfo);
                builder.addNonThisArgument(i, typeLattice);
            }
            builder.flushArgumentInstructions();
        }

        @Override
        public void buildBlockTransfer(IRBuilder builder, int predecessorOffset, int successorOffset, boolean isExceptional) {
            throw new Unreachable("Outliner does not support control flow");
        }

        @Override
        public void buildPostlude(IRBuilder builder) {
        }

        @Override
        public void buildInstruction(IRBuilder builder, int instructionIndex, boolean firstBlockInstruction) {
            if (instructionIndex == this.outline.templateInstructions.size()) {
                if (this.outline.returnType == ((Outliner)Outliner.this).dexItemFactory.voidType) {
                    builder.addReturn();
                } else {
                    builder.addReturn(this.outline.argumentCount());
                }
                return;
            }
            this.argumentMapIndex = this.outline.templateInstructions.get(instructionIndex).createInstruction(builder, this.outline, this.argumentMapIndex);
        }

        @Override
        public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
            throw new Unreachable("Unexpected call to resolveAndBuildSwitch");
        }

        @Override
        public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
            throw new Unreachable("Unexpected call to resolveAndBuildNewArrayFilledData");
        }

        @Override
        public CatchHandlers<Integer> getCurrentCatchHandlers() {
            return null;
        }

        @Override
        public int getMoveExceptionRegister(int instructionIndex) {
            throw new Unreachable();
        }

        @Override
        public Position getCanonicalDebugPositionAtOffset(int offset) {
            throw new Unreachable();
        }

        @Override
        public Position getCurrentPosition() {
            return this.position;
        }

        @Override
        public boolean verifyCurrentInstructionCanThrow() {
            return true;
        }

        @Override
        public boolean verifyLocalInScope(DebugLocalInfo local) {
            return true;
        }

        @Override
        public boolean verifyRegister(int register) {
            return true;
        }
    }

    private class OutlineRewriter
    extends OutlineSpotter {
        private final IRCode code;
        private final ListIterator<BasicBlock> blocksIterator;
        private final List<Integer> toRemove;
        int argumentsMapIndex;

        OutlineRewriter(DexEncodedMethod method, IRCode code, ListIterator<BasicBlock> blocksIterator, BasicBlock block, List<Integer> toRemove) {
            super(method, block);
            this.code = code;
            this.blocksIterator = blocksIterator;
            this.toRemove = toRemove;
        }

        @Override
        protected void handle(int start, int end, Outline outline) {
            DexMethod m = (DexMethod)Outliner.this.generatedOutlines.get(outline);
            if (m != null) {
                assert (this.removeMethodFromOutlineList(outline));
                ArrayList<Value> in = new ArrayList<Value>();
                Value returnValue = null;
                this.argumentsMapIndex = 0;
                Position position = Position.none();
                List<Instruction> instructions = this.getInstructionArray();
                for (int i = start; i < end; ++i) {
                    Instruction current = instructions.get(i);
                    if (current.isConstInstruction()) continue;
                    if (position.isNone()) {
                        position = current.getPosition();
                    }
                    List<Value> inValues = this.orderedInValues(current, returnValue);
                    for (int j = 0; j < inValues.size(); ++j) {
                        Value value = inValues.get(j);
                        value.removeUser(current);
                        int argumentIndex = outline.argumentMap.get(this.argumentsMapIndex++);
                        if (argumentIndex < in.size()) continue;
                        assert (argumentIndex == in.size());
                        in.add(value);
                    }
                    if (current.outValue() != null) {
                        returnValue = current.outValue();
                    }
                    if (i >= end - 1) continue;
                    this.toRemove.add(i);
                }
                assert (m.proto.shorty.toString().length() - 1 == in.size());
                if (returnValue != null && !returnValue.isUsed()) {
                    returnValue = null;
                }
                InvokeStatic outlineInvoke = new InvokeStatic(m, returnValue, in);
                outlineInvoke.setBlock(this.block);
                outlineInvoke.setPosition(position);
                if (position.isNone() && this.code.doAllThrowingInstructionsHavePositions()) {
                    this.code.setAllThrowingInstructionsHavePositions(false);
                }
                InstructionListIterator endIterator = this.block.listIterator(end - 1);
                Instruction instructionBeforeEnd = (Instruction)endIterator.next();
                this.invalidateInstructionArray();
                instructionBeforeEnd.clearBlock();
                endIterator.set(outlineInvoke);
                if (this.block.hasCatchHandlers()) {
                    endIterator.split(this.code, this.blocksIterator);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removeMethodFromOutlineList(Outline outline) {
            Map map2 = Outliner.this.outlineSites;
            synchronized (map2) {
                assert (((List)Outliner.this.outlineSites.get(outline)).remove(this.method));
            }
            return true;
        }
    }

    private class OutlineSiteIdentifier
    extends OutlineSpotter {
        OutlineSiteIdentifier(DexEncodedMethod method, BasicBlock block) {
            super(method, block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handle(int start, int end, Outline outline) {
            Map map2 = Outliner.this.outlineSites;
            synchronized (map2) {
                Outliner.this.outlineSites.computeIfAbsent(outline, k -> new ArrayList()).add(this.method);
            }
        }
    }

    private class OutlineMethodIdentifier
    extends OutlineSpotter {
        private final Map<Outline, List<DexEncodedMethod>> candidateMap;

        OutlineMethodIdentifier(DexEncodedMethod method, BasicBlock block, Map<Outline, List<DexEncodedMethod>> candidateMap) {
            super(method, block);
            this.candidateMap = candidateMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handle(int start, int end, Outline outline) {
            Map<Outline, List<DexEncodedMethod>> map2 = this.candidateMap;
            synchronized (map2) {
                this.candidateMap.computeIfAbsent(outline, this::addOutlineMethodList).add(this.method);
            }
        }

        private List<DexEncodedMethod> addOutlineMethodList(Outline outline) {
            ArrayList<DexEncodedMethod> result = new ArrayList<DexEncodedMethod>();
            Outliner.this.candidateMethodLists.add(result);
            return result;
        }
    }

    private abstract class OutlineSpotter {
        final DexEncodedMethod method;
        final BasicBlock block;
        private List<Instruction> instructionArrayCache = null;
        int start;
        int index;
        int actualInstructions;
        List<Value> arguments;
        List<DexType> argumentTypes;
        List<Integer> argumentsMap;
        int argumentRegisters;
        DexType returnType;
        Value returnValue;
        int returnValueUsersLeft;
        int pendingNewInstanceIndex = -1;

        OutlineSpotter(DexEncodedMethod method, BasicBlock block) {
            this.method = method;
            this.block = block;
            this.reset(0);
        }

        protected List<Instruction> getInstructionArray() {
            if (this.instructionArrayCache == null) {
                this.instructionArrayCache = new ArrayList<Instruction>(this.block.getInstructions());
            }
            return this.instructionArrayCache;
        }

        protected void invalidateInstructionArray() {
            this.instructionArrayCache = null;
        }

        protected void process() {
            List<Instruction> instructions;
            while (this.index < (instructions = this.getInstructionArray()).size()) {
                this.processInstruction(instructions.get(this.index));
            }
        }

        protected List<Value> orderedInValues(Instruction instruction, Value returnValue) {
            List<Value> inValues = instruction.inValues();
            if (instruction.isBinop() && instruction.asBinop().isCommutative() && inValues.get(1) == returnValue) {
                Value tmp = inValues.get(0);
                inValues.set(0, inValues.get(1));
                inValues.set(1, tmp);
            }
            return inValues;
        }

        private void processInstruction(Instruction instruction) {
            boolean include = false;
            int instructionIncrement = 1;
            if (instruction.isConstInstruction()) {
                if (this.index == this.start) {
                    this.reset(this.index + 1);
                    return;
                }
                include = true;
                instructionIncrement = 0;
            } else {
                include = this.canIncludeInstruction(instruction);
            }
            if (include) {
                this.actualInstructions += instructionIncrement;
                this.includeInstruction(instruction);
                if (this.actualInstructions >= ((Outliner)Outliner.this).options.outline.maxSize) {
                    this.candidate(this.start, this.index + 1);
                } else {
                    ++this.index;
                }
            } else if (this.index > this.start) {
                this.candidate(this.start, this.index);
            } else {
                this.reset(this.index + 1);
            }
        }

        private boolean canIncludeInstruction(Instruction instruction) {
            int returnValueUsersLeftIfIncluded = this.returnValueUsersLeft;
            if (this.returnValue != null) {
                for (Value value : instruction.inValues()) {
                    if (value != this.returnValue) continue;
                    --returnValueUsersLeftIfIncluded;
                }
            }
            if (instruction.outValue() != null && returnValueUsersLeftIfIncluded > 0) {
                return false;
            }
            if (instruction.isNewInstance()) {
                if (instruction.outValue().isUsed()) {
                    this.pendingNewInstanceIndex = this.index;
                }
                return true;
            }
            if (instruction.isArithmeticBinop()) {
                return true;
            }
            if (!instruction.isInvokeMethod()) {
                return false;
            }
            InvokeMethod invoke = instruction.asInvokeMethod();
            boolean constructor = Outliner.this.dexItemFactory.isConstructor(invoke.getInvokedMethod());
            Inliner.ConstraintWithTarget constraint = invoke.inliningConstraint(Outliner.this.inliningConstraints, this.method.method.holder);
            if (constraint != Inliner.ConstraintWithTarget.ALWAYS) {
                return false;
            }
            int newArgumentRegisters = this.argumentRegisters;
            if (instruction.inValues().size() > 0) {
                List<Value> inValues = this.orderedInValues(instruction, this.returnValue);
                for (int i = 0; i < inValues.size(); ++i) {
                    Value value = inValues.get(i);
                    if (value == this.returnValue) continue;
                    if (invoke.isInvokeStatic()) {
                        newArgumentRegisters += value.requiredRegisters();
                        continue;
                    }
                    if (i <= 0 && this.arguments.contains(value)) continue;
                    newArgumentRegisters += value.requiredRegisters();
                }
            }
            if (newArgumentRegisters > 5) {
                return false;
            }
            if (constructor) {
                Instruction previous;
                if (this.start == this.index) {
                    return false;
                }
                assert (this.index > 0);
                int offset = 0;
                List<Instruction> instructions = this.getInstructionArray();
                while ((previous = instructions.get(this.index - ++offset)).isConstInstruction()) {
                }
                if (!previous.isNewInstance() || previous.outValue() != this.returnValue) {
                    return false;
                }
                this.pendingNewInstanceIndex = -1;
            }
            return true;
        }

        private DexType argumentTypeFromInvoke(InvokeMethod invoke, int index) {
            assert (invoke.isInvokeMethodWithReceiver() || invoke.isInvokePolymorphic());
            if (index == 0) {
                return invoke.getInvokedMethod().getHolder();
            }
            DexProto methodProto = invoke.isInvokePolymorphic() ? invoke.asInvokePolymorphic().getProto() : invoke.getInvokedMethod().proto;
            return methodProto.parameters.values[index - 1];
        }

        private void includeInstruction(Instruction instruction) {
            List<Value> inValues = this.orderedInValues(instruction, this.returnValue);
            Value prevReturnValue = this.returnValue;
            if (this.returnValue != null) {
                for (Value value : inValues) {
                    if (value == this.returnValue) {
                        assert (this.returnValueUsersLeft > 0);
                        --this.returnValueUsersLeft;
                    }
                    if (this.returnValueUsersLeft != 0) continue;
                    this.returnValue = null;
                    this.returnType = ((Outliner)Outliner.this).dexItemFactory.voidType;
                }
            }
            if (instruction.isNewInstance()) {
                assert (this.returnValue == null);
                this.updateReturnValueState(instruction.outValue(), instruction.asNewInstance().clazz);
                return;
            }
            assert (instruction.isInvoke() || instruction.isConstInstruction() || instruction.isArithmeticBinop());
            if (inValues.size() > 0) {
                for (int i = 0; i < inValues.size(); ++i) {
                    Value value;
                    value = inValues.get(i);
                    if (value == prevReturnValue) {
                        this.argumentsMap.add(-1);
                        continue;
                    }
                    if (instruction.isInvokeMethodWithReceiver() || instruction.isInvokePolymorphic()) {
                        InvokeMethod invoke = instruction.asInvokeMethod();
                        int argumentIndex = this.arguments.indexOf(value);
                        if (i == 0 && argumentIndex != -1) {
                            DexType receiverType = this.argumentTypeFromInvoke(invoke, i);
                            if (receiverType.isClassType() && receiverType.isSubtypeOf(this.argumentTypes.get(argumentIndex), Outliner.this.appInfo)) {
                                this.argumentTypes.set(argumentIndex, receiverType);
                            }
                            this.argumentsMap.add(argumentIndex);
                            continue;
                        }
                        this.arguments.add(value);
                        this.argumentRegisters += value.requiredRegisters();
                        this.argumentTypes.add(this.argumentTypeFromInvoke(invoke, i));
                        this.argumentsMap.add(this.argumentTypes.size() - 1);
                        continue;
                    }
                    this.arguments.add(value);
                    if (instruction.isInvokeMethod()) {
                        this.argumentTypes.add(instruction.asInvokeMethod().getInvokedMethod().proto.parameters.values[i]);
                    } else {
                        this.argumentTypes.add(instruction.asBinop().getNumericType().dexTypeFor(Outliner.this.dexItemFactory));
                    }
                    this.argumentsMap.add(this.argumentTypes.size() - 1);
                }
            }
            if (!instruction.isConstInstruction() && instruction.outValue() != null) {
                assert (this.returnValue == null);
                if (instruction.isInvokeMethod()) {
                    this.updateReturnValueState(instruction.outValue(), instruction.asInvokeMethod().getInvokedMethod().proto.returnType);
                } else {
                    this.updateReturnValueState(instruction.outValue(), instruction.asBinop().getNumericType().dexTypeFor(Outliner.this.dexItemFactory));
                }
            }
        }

        private void updateReturnValueState(Value newReturnValue, DexType newReturnType) {
            this.returnValueUsersLeft = newReturnValue.numberOfAllUsers();
            if (this.returnValueUsersLeft == 0) {
                this.returnValue = null;
                this.returnType = ((Outliner)Outliner.this).dexItemFactory.voidType;
            } else {
                this.returnValue = newReturnValue;
                this.returnType = newReturnType;
            }
        }

        protected abstract void handle(int var1, int var2, Outline var3);

        private void candidate(int start, int index) {
            List<Instruction> instructions = this.getInstructionArray();
            assert (!instructions.get(start).isConstInstruction());
            if (this.pendingNewInstanceIndex != -1) {
                if (this.pendingNewInstanceIndex == start) {
                    this.reset(index);
                } else {
                    this.reset(this.pendingNewInstanceIndex);
                }
                return;
            }
            int end = index;
            while (instructions.get(end - 1).isConstInstruction()) {
                --end;
            }
            int nonConstInstructions = 0;
            for (int i = start; i < end; ++i) {
                if (instructions.get(i).isConstInstruction()) continue;
                ++nonConstInstructions;
            }
            if (nonConstInstructions < ((Outliner)Outliner.this).options.outline.minSize) {
                this.reset(start + 1);
                return;
            }
            Outline outline = new Outline(instructions, this.argumentTypes, this.argumentsMap, this.returnType, start, end);
            this.handle(start, end, outline);
            this.reset(index);
        }

        private void reset(int startIndex) {
            this.start = startIndex;
            this.index = startIndex;
            this.actualInstructions = 0;
            this.arguments = new ArrayList<Value>(5);
            this.argumentTypes = new ArrayList<DexType>(5);
            this.argumentsMap = new ArrayList<Integer>(5);
            this.argumentRegisters = 0;
            this.returnType = ((Outliner)Outliner.this).dexItemFactory.voidType;
            this.returnValue = null;
            this.returnValueUsersLeft = 0;
            this.pendingNewInstanceIndex = -1;
        }
    }

    public class Outline
    implements Comparable<Outline> {
        final List<DexType> argumentTypes;
        final List<Integer> argumentMap;
        final List<OutlineInstruction> templateInstructions = new ArrayList<OutlineInstruction>();
        public final DexType returnType;
        private DexProto proto;

        Outline(List<Instruction> instructions, List<DexType> argumentTypes, List<Integer> argumentMap, DexType returnType, int start, int end) {
            this.argumentTypes = argumentTypes;
            this.argumentMap = argumentMap;
            this.returnType = returnType;
            for (int i = start; i < end; ++i) {
                Instruction current = instructions.get(i);
                if (current.isInvoke() || current.isNewInstance() || current.isArithmeticBinop()) {
                    this.templateInstructions.add(OutlineInstruction.fromInstruction(current));
                    continue;
                }
                if (!current.isConstInstruction()) assert (false) : "Unexpected type of instruction in outlining template.";
            }
        }

        int argumentCount() {
            return this.argumentTypes.size();
        }

        DexProto buildProto() {
            if (this.proto == null) {
                DexType[] argumentTypesArray = this.argumentTypes.toArray(new DexType[this.argumentTypes.size()]);
                this.proto = Outliner.this.dexItemFactory.createProto(this.returnType, argumentTypesArray);
            }
            return this.proto;
        }

        DexMethod buildMethod(DexType clazz, DexString name) {
            return Outliner.this.dexItemFactory.createMethod(clazz, this.buildProto(), name);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Outline)) {
                return false;
            }
            List<OutlineInstruction> instructions0 = this.templateInstructions;
            List<OutlineInstruction> instructions1 = ((Outline)other).templateInstructions;
            if (instructions0.size() != instructions1.size()) {
                return false;
            }
            for (int i = 0; i < instructions0.size(); ++i) {
                OutlineInstruction i1;
                OutlineInstruction i0 = instructions0.get(i);
                if (i0.equals(i1 = instructions1.get(i))) continue;
                return false;
            }
            return this.argumentMap.equals(((Outline)other).argumentMap) && this.returnType == ((Outline)other).returnType;
        }

        public int hashCode() {
            int MAX_HASH_INSTRUCTIONS = 5;
            int hash = this.templateInstructions.size();
            int hashPart = 0;
            for (int i = 0; i < this.templateInstructions.size() && i < 5; ++i) {
                OutlineInstruction instruction = this.templateInstructions.get(i);
                hashPart <<= 4;
                hash = hash * 3 + (hashPart += instruction.hashCode());
            }
            return hash;
        }

        @Override
        public int compareTo(Outline other) {
            int i;
            if (this == other) {
                return 0;
            }
            int result = this.buildProto().slowCompareTo(other.buildProto());
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            assert (this.argumentCount() == other.argumentCount());
            List<OutlineInstruction> instructions0 = this.templateInstructions;
            List<OutlineInstruction> instructions1 = other.templateInstructions;
            result = instructions0.size() - instructions1.size();
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            for (i = 0; i < instructions0.size(); ++i) {
                OutlineInstruction i1;
                OutlineInstruction i0 = instructions0.get(i);
                result = i0.compareTo(i1 = instructions1.get(i));
                if (result == 0) continue;
                assert (!i0.equals(i1));
                return result;
            }
            result = this.argumentMap.size() - other.argumentMap.size();
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            for (i = 0; i < this.argumentMap.size(); ++i) {
                result = this.argumentMap.get(i) - other.argumentMap.get(i);
                if (result == 0) continue;
                assert (!this.equals(other));
                return result;
            }
            assert (this.equals(other));
            return 0;
        }

        public String toString() {
            int outRegisterNumber = this.argumentTypes.size();
            StringBuilder builder = new StringBuilder();
            builder.append(this.returnType);
            builder.append(" anOutline");
            StringUtils.append(builder, this.argumentTypes, ", ", StringUtils.BraceType.PARENS);
            builder.append("\n");
            int argumentMapIndex = 0;
            for (OutlineInstruction instruction : this.templateInstructions) {
                builder.append(instruction.toString());
                String name = instruction.getInstructionName();
                StringUtils.appendRightPadded(builder, name, 20);
                if (instruction.hasOutValue()) {
                    builder.append("v" + outRegisterNumber);
                    builder.append(" <- ");
                }
                for (int i = 0; i < instruction.numberOfInputs(); ++i) {
                    builder.append(i > 0 ? ", " : "");
                    builder.append("v");
                    int index = this.argumentMap.get(argumentMapIndex++);
                    if (index >= 0) {
                        builder.append(index);
                        continue;
                    }
                    builder.append(outRegisterNumber);
                }
                builder.append(instruction.getDetailsString());
                builder.append("\n");
            }
            if (this.returnType == ((Outliner)Outliner.this).dexItemFactory.voidType) {
                builder.append("Return-Void");
            } else {
                StringUtils.appendRightPadded(builder, "Return", 20);
                builder.append("v" + outRegisterNumber);
            }
            builder.append("\n");
            builder.append(this.argumentMap);
            return builder.toString();
        }
    }

    private static class InvokeOutlineInstruction
    extends OutlineInstruction {
        private final DexMethod method;
        private final Invoke.Type invokeType;
        private final boolean hasOutValue;
        private final DexProto proto;
        private final boolean hasReceiver;

        private InvokeOutlineInstruction(DexMethod method, Invoke.Type type, boolean hasOutValue, ValueType[] inputTypes, DexProto proto) {
            super(OutlineInstruction.OutlineInstructionType.INVOKE);
            boolean bl = this.hasReceiver = inputTypes.length != method.proto.parameters.values.length;
            assert (!this.hasReceiver || inputTypes[0].isObject());
            this.method = method;
            this.invokeType = type;
            this.hasOutValue = hasOutValue;
            this.proto = proto;
        }

        static InvokeOutlineInstruction fromInstruction(InvokeMethod invoke) {
            ValueType[] inputTypes = new ValueType[invoke.inValues().size()];
            int i = 0;
            for (Value value : invoke.inValues()) {
                inputTypes[i++] = value.outType();
            }
            return new InvokeOutlineInstruction(invoke.getInvokedMethod(), invoke.getType(), invoke.outValue() != null, inputTypes, invoke.isInvokePolymorphic() ? invoke.asInvokePolymorphic().getProto() : null);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 7 + this.method.hashCode() * 13 + this.invokeType.hashCode() + Boolean.hashCode(this.hasOutValue) + Objects.hashCode(this.proto);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof InvokeOutlineInstruction)) {
                return false;
            }
            InvokeOutlineInstruction o = (InvokeOutlineInstruction)other;
            return this.method == o.method && this.invokeType == o.invokeType && this.hasOutValue == o.hasOutValue && Objects.equals(this.proto, o.proto);
        }

        @Override
        public int compareTo(OutlineInstruction other) {
            if (!(other instanceof InvokeOutlineInstruction)) {
                return super.compareTo(other);
            }
            InvokeOutlineInstruction o = (InvokeOutlineInstruction)other;
            int result = this.method.slowCompareTo(o.method);
            if (result != 0) {
                return result;
            }
            result = this.invokeType.compareTo(o.invokeType);
            if (result != 0) {
                return result;
            }
            result = Boolean.compare(this.hasOutValue, o.hasOutValue);
            if (result != 0) {
                return result;
            }
            if (this.proto != null && (result = this.proto.slowCompareTo(o.proto)) != 0) {
                return result;
            }
            assert (this.equals(other));
            return 0;
        }

        @Override
        public String getDetailsString() {
            return "; method: " + this.method.toSourceString();
        }

        @Override
        public String getInstructionName() {
            return this.type.name() + "-" + this.invokeType.name();
        }

        @Override
        public boolean hasOutValue() {
            return this.hasOutValue;
        }

        @Override
        public int numberOfInputs() {
            return (this.hasReceiver ? 1 : 0) + this.method.proto.parameters.values.length;
        }

        private ValueTypeConstraint getArgumentConstraint(int index) {
            if (this.hasReceiver) {
                return index == 0 ? ValueTypeConstraint.OBJECT : ValueTypeConstraint.fromDexType(this.method.proto.parameters.values[index - 1]);
            }
            return ValueTypeConstraint.fromDexType(this.method.proto.parameters.values[index]);
        }

        @Override
        public int createInstruction(IRBuilder builder, Outline outline, int argumentMapIndex) {
            ArrayList<Value> inValues = new ArrayList<Value>(this.numberOfInputs());
            for (int i = 0; i < this.numberOfInputs(); ++i) {
                int register;
                if ((register = outline.argumentMap.get(argumentMapIndex++).intValue()) == -1) {
                    register = outline.argumentCount();
                }
                inValues.add(builder.readRegister(register, this.getArgumentConstraint(i)));
            }
            Value outValue = null;
            if (this.hasOutValue) {
                TypeLatticeElement latticeElement = TypeLatticeElement.fromDexType(this.method.proto.returnType, true, builder.getAppInfo());
                outValue = builder.writeRegister(outline.argumentCount(), latticeElement, BasicBlock.ThrowingInfo.CAN_THROW);
            }
            Invoke newInstruction = Invoke.create(this.invokeType, this.method, this.proto, outValue, inValues);
            builder.add(newInstruction);
            return argumentMapIndex;
        }
    }

    private static class NewInstanceOutlineInstruction
    extends OutlineInstruction {
        private final DexType clazz;

        NewInstanceOutlineInstruction(DexType clazz) {
            super(OutlineInstruction.OutlineInstructionType.NEW);
            this.clazz = clazz;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof NewInstanceOutlineInstruction)) {
                return false;
            }
            NewInstanceOutlineInstruction o = (NewInstanceOutlineInstruction)other;
            boolean result = this.clazz == o.clazz;
            return result;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 7 + this.clazz.hashCode();
        }

        @Override
        public int compareTo(OutlineInstruction other) {
            if (!(other instanceof NewInstanceOutlineInstruction)) {
                return super.compareTo(other);
            }
            NewInstanceOutlineInstruction o = (NewInstanceOutlineInstruction)other;
            return this.clazz.slowCompareTo(o.clazz);
        }

        @Override
        public String getDetailsString() {
            return this.clazz.toSourceString();
        }

        @Override
        public String getInstructionName() {
            return this.type.name();
        }

        @Override
        public boolean hasOutValue() {
            return true;
        }

        @Override
        public int numberOfInputs() {
            return 0;
        }

        @Override
        public int createInstruction(IRBuilder builder, Outline outline, int argumentMapIndex) {
            TypeLatticeElement latticeElement = TypeLatticeElement.fromDexType(this.clazz, false, builder.getAppInfo());
            Value outValue = builder.writeRegister(outline.argumentCount(), latticeElement, BasicBlock.ThrowingInfo.CAN_THROW);
            NewInstance newInstruction = new NewInstance(this.clazz, outValue);
            builder.add(newInstruction);
            return argumentMapIndex;
        }
    }

    private static class BinOpOutlineInstruction
    extends OutlineInstruction {
        private final NumericType numericType;

        private BinOpOutlineInstruction(OutlineInstruction.OutlineInstructionType type, NumericType numericType) {
            super(type);
            this.numericType = numericType;
        }

        static BinOpOutlineInstruction fromInstruction(Binop instruction) {
            return new BinOpOutlineInstruction(OutlineInstruction.OutlineInstructionType.fromInstruction(instruction), instruction.getNumericType());
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 7 + this.numericType.ordinal();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof BinOpOutlineInstruction)) {
                return false;
            }
            BinOpOutlineInstruction o = (BinOpOutlineInstruction)other;
            return o.type.equals((Object)this.type) && o.numericType.equals((Object)this.numericType);
        }

        @Override
        public int compareTo(OutlineInstruction other) {
            if (!(other instanceof BinOpOutlineInstruction)) {
                return super.compareTo(other);
            }
            BinOpOutlineInstruction o = (BinOpOutlineInstruction)other;
            int result = this.type.compareTo(o.type);
            if (result != 0) {
                return result;
            }
            return this.numericType.compareTo(o.numericType);
        }

        @Override
        public String getDetailsString() {
            return "";
        }

        @Override
        public String getInstructionName() {
            return this.type.name() + "-" + this.numericType.name();
        }

        @Override
        public boolean hasOutValue() {
            return true;
        }

        @Override
        public int numberOfInputs() {
            return 2;
        }

        @Override
        public int createInstruction(IRBuilder builder, Outline outline, int argumentMapIndex) {
            ArrayList<Value> inValues = new ArrayList<Value>(this.numberOfInputs());
            for (int i = 0; i < this.numberOfInputs(); ++i) {
                int register;
                if ((register = outline.argumentMap.get(argumentMapIndex++).intValue()) == -1) {
                    register = outline.argumentCount();
                }
                inValues.add(builder.readRegister(register, ValueTypeConstraint.fromNumericType(this.numericType)));
            }
            PrimitiveTypeLatticeElement latticeElement = PrimitiveTypeLatticeElement.fromNumericType(this.numericType);
            Value outValue = builder.writeRegister(outline.argumentCount(), latticeElement, BasicBlock.ThrowingInfo.CAN_THROW);
            ArithmeticBinop newInstruction = null;
            switch (this.type) {
                case ADD: {
                    newInstruction = new Add(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case MUL: {
                    newInstruction = new Mul(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case SUB: {
                    newInstruction = new Sub(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case DIV: {
                    newInstruction = new Div(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                case REM: {
                    newInstruction = new Rem(this.numericType, outValue, (Value)inValues.get(0), (Value)inValues.get(1));
                    break;
                }
                default: {
                    throw new Unreachable("Invalid binary operation type: " + (Object)((Object)this.type));
                }
            }
            builder.add(newInstruction);
            return argumentMapIndex;
        }
    }

    private static abstract class OutlineInstruction {
        private static final int OUTLINE_TEMP = -1;
        protected final OutlineInstructionType type;

        protected OutlineInstruction(OutlineInstructionType type) {
            this.type = type;
        }

        static OutlineInstruction fromInstruction(Instruction instruction) {
            if (instruction.isBinop()) {
                return BinOpOutlineInstruction.fromInstruction(instruction.asBinop());
            }
            if (instruction.isNewInstance()) {
                return new NewInstanceOutlineInstruction(instruction.asNewInstance().clazz);
            }
            assert (instruction.isInvokeMethod());
            return InvokeOutlineInstruction.fromInstruction(instruction.asInvokeMethod());
        }

        public int hashCode() {
            return this.type.ordinal();
        }

        public int compareTo(OutlineInstruction other) {
            return this.type.compareTo(other.type);
        }

        public abstract boolean equals(Object var1);

        public abstract String getDetailsString();

        public abstract String getInstructionName();

        public abstract boolean hasOutValue();

        public abstract int numberOfInputs();

        public abstract int createInstruction(IRBuilder var1, Outline var2, int var3);

        public static enum OutlineInstructionType {
            ADD,
            SUB,
            MUL,
            DIV,
            REM,
            INVOKE,
            NEW;


            static OutlineInstructionType fromInstruction(Instruction instruction) {
                if (instruction.isAdd()) {
                    return ADD;
                }
                if (instruction.isSub()) {
                    return SUB;
                }
                if (instruction.isMul()) {
                    return MUL;
                }
                if (instruction.isDiv()) {
                    return DIV;
                }
                if (instruction.isRem()) {
                    return REM;
                }
                if (instruction.isInvokeMethod()) {
                    return INVOKE;
                }
                if (instruction.isNewInstance()) {
                    return NEW;
                }
                throw new Unreachable();
            }
        }
    }
}

