/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Arrays;
import java.util.Set;

public class VisibilityBridgeRemover {
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;

    public VisibilityBridgeRemover(AppView<? extends Enqueuer.AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private void removeUnneededVisibilityBridgesFromClass(DexProgramClass clazz) {
        clazz.setDirectMethods(this.removeUnneededVisibilityBridges(clazz.directMethods()));
        clazz.setVirtualMethods(this.removeUnneededVisibilityBridges(clazz.virtualMethods()));
    }

    private DexEncodedMethod[] removeUnneededVisibilityBridges(DexEncodedMethod[] methods) {
        Set<DexEncodedMethod> methodsToBeRemoved = null;
        for (DexEncodedMethod method2 : methods) {
            if (!this.isUnneededVisibilityBridge(method2)) continue;
            if (methodsToBeRemoved == null) {
                methodsToBeRemoved = Sets.newIdentityHashSet();
            }
            methodsToBeRemoved.add(method2);
        }
        if (methodsToBeRemoved != null) {
            Set<DexEncodedMethod> finalMethodsToBeRemoved = methodsToBeRemoved;
            return (DexEncodedMethod[])Arrays.stream(methods).filter(method -> !finalMethodsToBeRemoved.contains(method)).toArray(DexEncodedMethod[]::new);
        }
        return methods;
    }

    private boolean isUnneededVisibilityBridge(DexEncodedMethod method) {
        if (this.appView.appInfo().isPinned(method.method)) {
            return false;
        }
        MethodAccessFlags accessFlags = method.accessFlags;
        if (!accessFlags.isBridge() || accessFlags.isAbstract()) {
            return false;
        }
        InvokeSingleTargetExtractor targetExtractor = new InvokeSingleTargetExtractor(this.appView.dexItemFactory());
        method.getCode().registerCodeReferences(targetExtractor);
        DexMethod target = targetExtractor.getTarget();
        InvokeSingleTargetExtractor.InvokeKind kind = targetExtractor.getKind();
        if (target != null && target.hasSameProtoAndName(method.method)) {
            DexEncodedMethod targetMethod;
            assert (!accessFlags.isPrivate() && !accessFlags.isConstructor());
            if (kind == InvokeSingleTargetExtractor.InvokeKind.SUPER && (targetMethod = this.appView.appInfo().resolveMethod(target.getHolder(), target).asSingleTarget()) != null && targetMethod.accessFlags.isPublic()) {
                return true;
            }
        }
        return false;
    }

    public void run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.removeUnneededVisibilityBridgesFromClass(clazz);
        }
    }
}

