/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "exportToCompiledJava", "", "tables", "", "Lcom/android/ide/common/symbols/SymbolTable;", "outJar", "Ljava/nio/file/Path;", "generateOuterRClass", "", "resourceTypes", "Ljava/util/EnumSet;", "Lcom/android/resources/ResourceType;", "packageR", "", "generateResourceTypeClass", "table", "resType", "internalName", "type", "builder"})
public final class BytecodeRClassWriterKt {
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on((char)',').trimResults();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportToCompiledJava(@NotNull Iterable<? extends SymbolTable> tables, @NotNull Path outJar) throws IOException {
        Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
        Intrinsics.checkParameterIsNotNull((Object)outJar, (String)"outJar");
        Closeable closeable = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(outJar, new OpenOption[0])));
        Throwable throwable = null;
        try {
            JarOutputStream jarOutputStream = (JarOutputStream)closeable;
            boolean bl = false;
            Iterable<? extends SymbolTable> $receiver$iv = tables;
            Iterator<? extends SymbolTable> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                SymbolTable element$iv;
                SymbolTable table = element$iv = iterator2.next();
                boolean bl2 = false;
                EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
                for (ResourceType resType : ResourceType.values()) {
                    byte[] bytes;
                    if (BytecodeRClassWriterKt.generateResourceTypeClass(table, resType) == null) {
                        continue;
                    }
                    resourceTypes.add(resType);
                    String innerR = BytecodeRClassWriterKt.internalName(table, resType);
                    jarOutputStream.putNextEntry(new ZipEntry(innerR + ".class"));
                    jarOutputStream.write(bytes);
                }
                String packageR = BytecodeRClassWriterKt.internalName(table, null);
                jarOutputStream.putNextEntry(new ZipEntry(packageR + ".class"));
                EnumSet<ResourceType> enumSet = resourceTypes;
                Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"resourceTypes");
                jarOutputStream.write(BytecodeRClassWriterKt.generateOuterRClass(enumSet, packageR));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final byte[] generateOuterRClass(EnumSet<ResourceType> resourceTypes, String packageR) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(52, 49, packageR, null, "java/lang/Object", null);
        for (ResourceType rt : resourceTypes) {
            cw.visitInnerClass(packageR + "$" + rt.getName(), packageR, rt.getName(), 25);
        }
        MethodVisitor mv = null;
        MethodVisitor methodVisitor = cw.visitMethod(2, "<init>", "()V", null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"cw.visitMethod(ACC_PRIVA\u2026nit>\", \"()V\", null, null)");
        mv = methodVisitor;
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] byArray = cw.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cw.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] generateResourceTypeClass(SymbolTable table, ResourceType resType) {
        List symbols = table.getSymbolByResourceType(resType);
        if (symbols.isEmpty()) {
            return null;
        }
        ClassWriter cw = new ClassWriter(1);
        String internalName = BytecodeRClassWriterKt.internalName(table, resType);
        cw.visit(52, 49, internalName, null, "java/lang/Object", null);
        cw.visitInnerClass(internalName, BytecodeRClassWriterKt.internalName(table, null), resType.getName(), 25);
        for (Symbol s : symbols) {
            cw.visitField(9, s.getCanonicalName(), s.getJavaType().getDesc(), null, s instanceof Symbol.StyleableSymbol ? null : Integer.valueOf(s.getIntValue())).visitEnd();
            if (!(s instanceof Symbol.StyleableSymbol)) continue;
            ImmutableList children = s.getChildren();
            boolean bl = false;
            for (String child : (Iterable)children) {
                void i;
                StringBuilder stringBuilder = new StringBuilder().append(s.getCanonicalName()).append('_');
                String string = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child");
                cw.visitField(9, stringBuilder.append(SymbolUtils.canonicalizeValueResourceName((String)string)).toString(), "I", null, (Object)((int)i));
                ++i;
            }
        }
        MethodVisitor init = cw.visitMethod(2, "<init>", "()V", null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        init.visitInsn(177);
        init.visitMaxs(0, 0);
        init.visitEnd();
        if (resType == ResourceType.STYLEABLE) {
            MethodVisitor clinit = cw.visitMethod(8, "<clinit>", "()V", null, null);
            clinit.visitCode();
            Iterator iterator2 = symbols.iterator();
            while (iterator2.hasNext()) {
                Symbol s;
                Symbol symbol = s = (Symbol)iterator2.next();
                if (symbol == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.StyleableSymbol");
                }
                Symbol.StyleableSymbol cfr_ignored_0 = (Symbol.StyleableSymbol)symbol;
                ImmutableList values2 = ((Symbol.StyleableSymbol)s).getValues();
                clinit.visitIntInsn(16, values2.size());
                clinit.visitIntInsn(188, 10);
                boolean bl = false;
                for (Integer value : (Iterable)values2) {
                    void i;
                    clinit.visitInsn(89);
                    clinit.visitIntInsn(16, (int)i);
                    clinit.visitLdcInsn((Object)value);
                    clinit.visitInsn(79);
                    ++i;
                }
                clinit.visitFieldInsn(179, internalName, s.getCanonicalName(), "[I");
            }
            clinit.visitInsn(177);
            clinit.visitMaxs(0, 0);
            clinit.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static final String internalName(SymbolTable table, ResourceType type) {
        String className = type == null ? "R" : "R$" + type.getName();
        CharSequence charSequence = table.getTablePackage();
        return charSequence.length() == 0 ? className : StringsKt.replace$default((String)table.getTablePackage(), (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + className;
    }
}

