/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.IdentityHashMap;
import java.util.Map;

public class LazyLoadedDexApplication
extends DexApplication {
    private final ClasspathClassCollection classpathClasses;
    private final LibraryClassCollection libraryClasses;

    private LazyLoadedDexApplication(ClassNameMapper proguardMap, ProgramClassCollection programClasses, ImmutableList<ProgramResourceProvider> programResourceProviders, ClasspathClassCollection classpathClasses, LibraryClassCollection libraryClasses, ImmutableSet<DexType> mainDexList, String deadCode, DexItemFactory dexItemFactory, DexString highestSortingString, Timing timing) {
        super(proguardMap, programClasses, programResourceProviders, mainDexList, deadCode, dexItemFactory, highestSortingString, timing);
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        Object clazz = this.programClasses.get(type);
        if (clazz == null && this.classpathClasses != null) {
            clazz = this.classpathClasses.get(type);
        }
        if (clazz == null && this.libraryClasses != null) {
            clazz = this.libraryClasses.get(type);
        }
        return clazz;
    }

    public AllClasses loadAllClasses() {
        return new AllClasses(this.libraryClasses, this.classpathClasses, this.programClasses);
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return new DirectMappedDexApplication.Builder(this).build().asDirect();
    }

    @Override
    public String toString() {
        return "Application (" + this.programClasses + "; " + this.classpathClasses + "; " + this.libraryClasses + ")";
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private ClasspathClassCollection classpathClasses;
        private LibraryClassCollection libraryClasses;
        private final ApplicationReader.ProgramClassConflictResolver resolver;

        Builder(ApplicationReader.ProgramClassConflictResolver resolver, DexItemFactory dexItemFactory, Timing timing) {
            super(dexItemFactory, timing);
            this.resolver = resolver;
            this.classpathClasses = null;
            this.libraryClasses = null;
        }

        private Builder(LazyLoadedDexApplication application) {
            super(application);
            this.resolver = ProgramClassCollection::resolveClassConflictImpl;
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setClasspathClassCollection(ClasspathClassCollection classes) {
            this.classpathClasses = classes;
            return this;
        }

        public Builder setLibraryClassCollection(LibraryClassCollection classes) {
            this.libraryClasses = classes;
            return this;
        }

        @Override
        public LazyLoadedDexApplication build() {
            return new LazyLoadedDexApplication(this.proguardMap, ProgramClassCollection.create(this.programClasses, this.resolver), ImmutableList.copyOf(this.programResourceProviders), this.classpathClasses, this.libraryClasses, ImmutableSet.copyOf(this.mainDexList), this.deadCode, this.dexItemFactory, this.highestSortingString, this.timing);
        }
    }

    static class AllClasses {
        private Map<DexType, DexClass> libraryClasses;
        private Map<DexType, DexClass> classpathClasses;
        private Map<DexType, DexClass> programClasses;
        private Map<DexType, DexClass> classes;

        AllClasses(LibraryClassCollection libraryClasses, ClasspathClassCollection classpathClasses, ProgramClassCollection programClasses) {
            this.load(libraryClasses, classpathClasses, programClasses);
            this.classes = new IdentityHashMap<DexType, DexClass>();
            this.classes.putAll(this.programClasses);
            if (classpathClasses != null) {
                classpathClasses.getAllClasses().forEach(clazz -> this.classes.putIfAbsent(clazz.type, (DexClass)clazz));
            }
            if (libraryClasses != null) {
                libraryClasses.getAllClasses().forEach(clazz -> this.classes.putIfAbsent(clazz.type, (DexClass)clazz));
            }
        }

        public Map<DexType, DexClass> getLibraryClasses() {
            return this.libraryClasses;
        }

        public Map<DexType, DexClass> getClasspathClasses() {
            return this.classpathClasses;
        }

        public Map<DexType, DexClass> getClasses() {
            return this.classes;
        }

        private void load(LibraryClassCollection libraryClasses, ClasspathClassCollection classpathClasses, ProgramClassCollection programClasses) {
            if (libraryClasses != null) {
                libraryClasses.forceLoad(type -> true);
                this.libraryClasses = libraryClasses.getAllClassesInMap();
            }
            if (classpathClasses != null) {
                classpathClasses.forceLoad(type -> true);
                this.classpathClasses = classpathClasses.getAllClassesInMap();
            }
            assert (programClasses != null);
            programClasses.forceLoad(type -> true);
            this.programClasses = programClasses.getAllClassesInMap();
        }
    }
}

