/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;

public class TopDownClassHierarchyTraversal {
    public static void visit(AppView<? extends AppInfo> appView, Iterable<DexProgramClass> classes, Consumer<DexProgramClass> visitor) {
        ArrayDeque<DexProgramClass> worklist = new ArrayDeque<DexProgramClass>();
        HashSet<DexProgramClass> visited = new HashSet<DexProgramClass>();
        Iterator<DexProgramClass> classIterator = classes.iterator();
        while (classIterator.hasNext() || !worklist.isEmpty()) {
            DexProgramClass clazz;
            if (worklist.isEmpty()) {
                TopDownClassHierarchyTraversal.addAncestorsToWorklist(classIterator.next(), worklist, visited, appView);
                if (worklist.isEmpty()) continue;
            }
            if (!visited.add(clazz = (DexProgramClass)worklist.removeFirst())) continue;
            visitor.accept(clazz);
        }
    }

    private static void addAncestorsToWorklist(DexProgramClass clazz, Deque<DexProgramClass> worklist, Set<DexProgramClass> visited, AppView<? extends AppInfo> appView) {
        DexClass definition;
        if (visited.contains(clazz)) {
            return;
        }
        worklist.addFirst(clazz);
        if (clazz.superType != null && (definition = appView.appInfo().definitionFor(clazz.superType)) != null && definition.isProgramClass()) {
            TopDownClassHierarchyTraversal.addAncestorsToWorklist(definition.asProgramClass(), worklist, visited, appView);
        }
        for (DexType interfaceType : clazz.interfaces.values) {
            DexClass definition2 = appView.appInfo().definitionFor(interfaceType);
            if (definition2 == null || !definition2.isProgramClass()) continue;
            TopDownClassHierarchyTraversal.addAncestorsToWorklist(definition2.asProgramClass(), worklist, visited, appView);
        }
    }
}

