/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BooleanTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.BottomTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ByteTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.CharTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.DoubleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.FloatTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.IntTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.LongTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ShortTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.SingleTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TopTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.WideTypeLatticeElement;

public abstract class TypeLatticeElement {
    public static final BottomTypeLatticeElement BOTTOM = BottomTypeLatticeElement.getInstance();
    public static final TopTypeLatticeElement TOP = TopTypeLatticeElement.getInstance();
    static final BooleanTypeLatticeElement BOOLEAN = BooleanTypeLatticeElement.getInstance();
    static final ByteTypeLatticeElement BYTE = ByteTypeLatticeElement.getInstance();
    static final ShortTypeLatticeElement SHORT = ShortTypeLatticeElement.getInstance();
    static final CharTypeLatticeElement CHAR = CharTypeLatticeElement.getInstance();
    public static final IntTypeLatticeElement INT = IntTypeLatticeElement.getInstance();
    public static final FloatTypeLatticeElement FLOAT = FloatTypeLatticeElement.getInstance();
    public static final SingleTypeLatticeElement SINGLE = SingleTypeLatticeElement.getInstance();
    public static final LongTypeLatticeElement LONG = LongTypeLatticeElement.getInstance();
    public static final DoubleTypeLatticeElement DOUBLE = DoubleTypeLatticeElement.getInstance();
    public static final WideTypeLatticeElement WIDE = WideTypeLatticeElement.getInstance();
    public static final ReferenceTypeLatticeElement NULL = ReferenceTypeLatticeElement.getNullTypeLatticeElement();
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public NullLatticeElement nullElement() {
        if (this.isNullType()) {
            return NullLatticeElement.definitelyNull();
        }
        if (!this.isNullable()) {
            return NullLatticeElement.definitelyNotNull();
        }
        return NullLatticeElement.maybeNull();
    }

    public abstract TypeLatticeElement asNullable();

    public TypeLatticeElement asNonNullable() {
        return BOTTOM;
    }

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    public TypeLatticeElement join(TypeLatticeElement other, AppInfo appInfo) {
        boolean isNullable;
        if (this == other) {
            return this;
        }
        if (this.isBottom()) {
            return other;
        }
        if (other.isBottom()) {
            return this;
        }
        if (this.isTop() || other.isTop()) {
            return TOP;
        }
        if (this.isNullType()) {
            return other.asNullable();
        }
        if (other.isNullType()) {
            return this.asNullable();
        }
        if (this.isPrimitive()) {
            return other.isPrimitive() ? this.asPrimitiveTypeLatticeElement().join(other.asPrimitiveTypeLatticeElement()) : TOP;
        }
        if (other.isPrimitive()) {
            return TOP;
        }
        assert (this.isReference() && other.isReference());
        assert (this.isPreciseType() && other.isPreciseType());
        boolean bl = isNullable = this.isNullable() || other.isNullable();
        if (this.getClass() != other.getClass()) {
            return TypeLatticeElement.objectClassType(appInfo, isNullable);
        }
        if (this.isArrayType()) {
            assert (other.isArrayType());
            ReferenceTypeLatticeElement join = this.asArrayTypeLatticeElement().join(other.asArrayTypeLatticeElement(), appInfo);
            return join != null ? join : (this.isNullable() ? this : other);
        }
        if (this.isClassType()) {
            assert (other.isClassType());
            return this.asClassTypeLatticeElement().join(other.asClassTypeLatticeElement(), appInfo);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    public static TypeLatticeElement join(Iterable<TypeLatticeElement> typeLattices, AppInfo appInfo) {
        TypeLatticeElement result = BOTTOM;
        for (TypeLatticeElement other : typeLattices) {
            result = result.join(other, appInfo);
        }
        return result;
    }

    public static TypeLatticeElement joinTypes(Iterable<DexType> types, boolean isNullable, AppInfo appInfo) {
        TypeLatticeElement result = BOTTOM;
        for (DexType type : types) {
            result = result.join(TypeLatticeElement.fromDexType(type, isNullable, appInfo), appInfo);
        }
        return result;
    }

    public boolean strictlyLessThan(TypeLatticeElement other, AppInfo appInfo) {
        if (this.equals(other)) {
            return false;
        }
        TypeLatticeElement lub = this.join(other, appInfo);
        return !this.equals(lub) && other.equals(lub);
    }

    public boolean lessThanOrEqual(TypeLatticeElement other, AppInfo appInfo) {
        return this.equals(other) || this.strictlyLessThan(other, appInfo);
    }

    public boolean isBasedOnMissingClass(AppInfo appInfo) {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return null;
    }

    public boolean isClassType() {
        return false;
    }

    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public PrimitiveTypeLatticeElement asPrimitiveTypeLatticeElement() {
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean isWide() {
        return false;
    }

    boolean isBoolean() {
        return false;
    }

    boolean isByte() {
        return false;
    }

    boolean isShort() {
        return false;
    }

    boolean isChar() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isPreciseType() {
        return this.isArrayType() || this.isClassType() || this.isNullType() || this.isInt() || this.isFloat() || this.isLong() || this.isDouble() || this.isBottom();
    }

    public boolean isFineGrainedType() {
        return this.isBoolean() || this.isByte() || this.isShort() || this.isChar();
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isDefinitelyNull() {
        return this.nullElement().isDefinitelyNull();
    }

    public int requiredRegisters() {
        assert (!this.isBottom() && !this.isTop());
        return this.isWide() ? 2 : 1;
    }

    static ClassTypeLatticeElement objectClassType(AppInfo appInfo, boolean isNullable) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.objectType, isNullable, appInfo).asClassTypeLatticeElement();
    }

    static ArrayTypeLatticeElement objectArrayType(AppInfo appInfo, boolean isNullable) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.createArrayType(1, appInfo.dexItemFactory.objectType), isNullable, appInfo).asArrayTypeLatticeElement();
    }

    public static TypeLatticeElement classClassType(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.classType, false, appInfo);
    }

    public static TypeLatticeElement stringClassType(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.stringType, false, appInfo);
    }

    public static TypeLatticeElement fromDexType(DexType type, boolean isNullable, AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(type, isNullable, appInfo, false);
    }

    public static TypeLatticeElement fromDexType(DexType type, boolean isNullable, AppInfo appInfo, boolean asArrayElementType) {
        if (type == DexItemFactory.nullValueType) {
            return NULL;
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.fromDexType(type, asArrayElementType);
        }
        return appInfo.dexItemFactory.createReferenceTypeLatticeElement(type, isNullable, appInfo);
    }

    public boolean isValueTypeCompatible(TypeLatticeElement other) {
        return this.isReference() && other.isReference() || this.isSingle() && other.isSingle() || this.isWide() && other.isWide();
    }

    public TypeLatticeElement checkCast(AppInfo appInfo, DexType castType) {
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, this.isNullable(), appInfo);
        if (this.lessThanOrEqual(castTypeLattice, appInfo)) {
            return this;
        }
        return castTypeLattice;
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

