/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.io.UTFDataFormatException;

public class ConstString
extends ConstInstruction {
    private final DexString value;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public ConstString(Value dest, DexString value, BasicBlock.ThrowingInfo throwingInfo) {
        super(dest);
        dest.markNeverNull();
        this.value = value;
        this.throwingInfo = throwingInfo;
    }

    public static ConstString copyOf(IRCode code, ConstString original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return ConstString.copyOf(newValue, original);
    }

    public static ConstString copyOf(Value newValue, ConstString original) {
        return new ConstString(newValue, original.getValue(), original.throwingInfo);
    }

    public Value dest() {
        return this.outValue;
    }

    public DexString getValue() {
        return this.value;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)new com.android.tools.r8.code.ConstString(dest, this.value));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstString() && other.asConstString().value == this.value;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.value + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return this.throwingInfo == BasicBlock.ThrowingInfo.CAN_THROW;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstString() {
        return true;
    }

    @Override
    public ConstString asConstString() {
        return this;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        try {
            this.value.toString();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UTFDataFormatException) {
                return true;
            }
            throw e;
        }
        return false;
    }

    @Override
    public boolean canBeDeadCode(AppInfo appInfo, IRCode code) {
        return code.options.isGeneratingClassFiles() || !this.instructionInstanceCanThrow();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstString(this.value));
    }

    @Override
    public DexType computeVerificationType(TypeVerificationHelper helper) {
        return helper.getFactory().stringType;
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo) {
        return TypeLatticeElement.fromDexType(appInfo.dexItemFactory.stringType, false, appInfo);
    }
}

