/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.signature;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.signature.GenericSignatureAction;
import com.android.tools.r8.naming.signature.GenericSignatureParser;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.lang.reflect.GenericSignatureFormatError;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GenericSignatureRewriter {
    private final AppView<Enqueuer.AppInfoWithLiveness> appView;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final Map<DexType, DexString> renaming;
    private final Reporter reporter;

    public GenericSignatureRewriter(AppView<Enqueuer.AppInfoWithLiveness> appView) {
        this(appView, Maps.newIdentityHashMap());
    }

    public GenericSignatureRewriter(AppView<Enqueuer.AppInfoWithLiveness> appView, Map<DexType, DexString> renaming) {
        this.appView = appView;
        this.appInfo = appView.appInfo();
        this.renaming = renaming;
        this.reporter = appView.options().reporter;
    }

    public void run() {
        GenericSignatureCollector genericSignatureCollector = new GenericSignatureCollector();
        GenericSignatureParser<DexType> genericSignatureParser = new GenericSignatureParser<DexType>(genericSignatureCollector);
        for (DexClass dexClass : this.appInfo.classes()) {
            dexClass.annotations = this.rewriteGenericSignatures(dexClass.annotations, genericSignatureParser::parseClassSignature, genericSignatureCollector::getRenamedSignature, (signature, e) -> this.parseError(clazz, clazz.getOrigin(), (String)signature, (GenericSignatureFormatError)e));
            dexClass.forEachField(field -> {
                field.annotations = this.rewriteGenericSignatures(field.annotations, genericSignatureParser::parseFieldSignature, genericSignatureCollector::getRenamedSignature, (signature, e) -> this.parseError((DexDefinition)field, clazz.getOrigin(), (String)signature, (GenericSignatureFormatError)e));
            });
            dexClass.forEachMethod(method -> {
                method.annotations = this.rewriteGenericSignatures(method.annotations, genericSignatureParser::parseMethodSignature, genericSignatureCollector::getRenamedSignature, (signature, e) -> this.parseError((DexDefinition)method, clazz.getOrigin(), (String)signature, (GenericSignatureFormatError)e));
            });
        }
    }

    private DexAnnotationSet rewriteGenericSignatures(DexAnnotationSet annotations, Consumer<String> parser, Supplier<String> collector, BiConsumer<String, GenericSignatureFormatError> parseError) {
        int VALID = -1;
        int invalid = -1;
        for (int i = 0; i < annotations.annotations.length && invalid == -1; ++i) {
            DexAnnotation annotation = annotations.annotations[i];
            if (!DexAnnotation.isSignatureAnnotation(annotation, this.appInfo.dexItemFactory)) continue;
            String signature = DexAnnotation.getSignature(annotation);
            try {
                parser.accept(signature);
                annotations.annotations[i] = DexAnnotation.createSignatureAnnotation(collector.get(), this.appInfo.dexItemFactory);
                continue;
            }
            catch (GenericSignatureFormatError e) {
                parseError.accept(signature, e);
                invalid = i;
            }
        }
        if (invalid == -1) {
            return annotations;
        }
        DexAnnotation[] prunedAnnotations = new DexAnnotation[annotations.annotations.length - 1];
        int dest = 0;
        for (int i = 0; i < annotations.annotations.length; ++i) {
            if (i == invalid) continue;
            prunedAnnotations[dest++] = annotations.annotations[i];
        }
        assert (dest == prunedAnnotations.length);
        return new DexAnnotationSet(prunedAnnotations);
    }

    private void parseError(DexDefinition item, Origin origin, String signature, GenericSignatureFormatError e) {
        StringBuilder message = new StringBuilder("Invalid signature '");
        message.append(signature);
        message.append("' for ");
        if (item.isDexClass()) {
            message.append("class ");
            message.append(item.asDexClass().getType().toSourceString());
        } else if (item.isDexEncodedField()) {
            message.append("field ");
            message.append(item.toSourceString());
        } else {
            assert (item.isDexEncodedMethod());
            message.append("method ");
            message.append(item.toSourceString());
        }
        message.append(".\n");
        message.append("Signature is ignored and will not be present in the output.\n");
        message.append("Parser error: ");
        message.append(e.getMessage());
        this.reporter.warning(new StringDiagnostic(message.toString(), origin));
    }

    private class GenericSignatureCollector
    implements GenericSignatureAction<DexType> {
        private StringBuilder renamedSignature;

        private GenericSignatureCollector() {
        }

        public String getRenamedSignature() {
            return this.renamedSignature.toString();
        }

        @Override
        public void parsedSymbol(char symbol) {
            this.renamedSignature.append(symbol);
        }

        @Override
        public void parsedIdentifier(String identifier) {
            this.renamedSignature.append(identifier);
        }

        @Override
        public DexType parsedTypeName(String name) {
            DexType type = ((GenericSignatureRewriter)GenericSignatureRewriter.this).appInfo.dexItemFactory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(name));
            type = GenericSignatureRewriter.this.appView.graphLense().lookupType(type);
            DexString renamedDescriptor = GenericSignatureRewriter.this.renaming.getOrDefault(type, type.descriptor);
            this.renamedSignature.append(DescriptorUtils.getClassBinaryNameFromDescriptor(renamedDescriptor.toString()));
            return type;
        }

        @Override
        public DexType parsedInnerTypeName(DexType enclosingType, String name) {
            assert (enclosingType.isClassType());
            String enclosingDescriptor = enclosingType.toDescriptorString();
            DexType type = ((GenericSignatureRewriter)GenericSignatureRewriter.this).appInfo.dexItemFactory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(enclosingDescriptor) + '$' + name));
            String enclosingRenamedBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(GenericSignatureRewriter.this.renaming.getOrDefault(enclosingType, enclosingType.descriptor).toString());
            type = GenericSignatureRewriter.this.appView.graphLense().lookupType(type);
            DexString renamedDescriptor = (DexString)GenericSignatureRewriter.this.renaming.get(type);
            if (renamedDescriptor != null) {
                String fullRenamedBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamedDescriptor.toString());
                this.renamedSignature.append(fullRenamedBinaryName.substring(enclosingRenamedBinaryName.length() + 1));
            } else {
                this.renamedSignature.append(name);
            }
            return type;
        }

        @Override
        public void start() {
            this.renamedSignature = new StringBuilder();
        }

        @Override
        public void stop() {
        }
    }
}

