/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.UsagePrinter;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class TreePruner {
    private final DexApplication application;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final InternalOptions options;
    private final UsagePrinter usagePrinter;
    private final Set<DexType> prunedTypes = Sets.newIdentityHashSet();

    public TreePruner(DexApplication application, Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this.application = application;
        this.appInfo = appInfo;
        this.options = options;
        this.usagePrinter = options.getProguardConfiguration() != null && options.getProguardConfiguration().isPrintUsage() ? new UsagePrinter() : UsagePrinter.DONT_PRINT;
    }

    public DexApplication run() {
        DexApplication result;
        this.application.timing.begin("Pruning application...");
        if (this.options.debugKeepRules && this.options.enableMinification) {
            this.options.reporter.info(new StringDiagnostic("Debugging keep rules on a minified build might yield broken builds, as minification also depends on the used keep rules. We recommend using --skip-minification."));
        }
        try {
            result = ((DexApplication.Builder)this.removeUnused(this.application).appendDeadCode(this.usagePrinter.toStringContent())).build();
        }
        finally {
            this.application.timing.end();
        }
        return result;
    }

    private DexApplication.Builder<?> removeUnused(DexApplication application) {
        return application.builder().replaceProgramClasses(this.getNewProgramClasses(application.classes()));
    }

    private List<DexProgramClass> getNewProgramClasses(List<DexProgramClass> classes) {
        ArrayList<DexProgramClass> newClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : classes) {
            DexEncodedMethod[] reachableVirtualMethods;
            if (!this.appInfo.liveTypes.contains(clazz.type)) {
                this.prunedTypes.add(clazz.type);
                this.usagePrinter.printUnusedClass(clazz);
                continue;
            }
            newClasses.add(clazz);
            if (!(this.appInfo.instantiatedTypes.contains(clazz.type) || this.options.forceProguardCompatibility || this.options.debugKeepRules && clazz.hasDefaultInitializer())) {
                if (clazz.accessFlags.isFinal()) {
                    clazz.accessFlags.unsetFinal();
                }
                clazz.accessFlags.setAbstract();
            }
            this.usagePrinter.visiting(clazz);
            DexEncodedMethod[] reachableDirectMethods = this.reachableMethods(clazz.directMethods(), clazz);
            if (reachableDirectMethods != null) {
                clazz.setDirectMethods(reachableDirectMethods);
            }
            if ((reachableVirtualMethods = this.reachableMethods(clazz.virtualMethods(), clazz)) != null) {
                clazz.setVirtualMethods(reachableVirtualMethods);
            }
            clazz.setInstanceFields(this.reachableFields(clazz.instanceFields()));
            clazz.setStaticFields(this.reachableFields(clazz.staticFields()));
            clazz.removeInnerClasses(this::isAttributeReferencingPrunedType);
            clazz.removeEnclosingMethod(this::isAttributeReferencingPrunedItem);
            this.usagePrinter.visited();
        }
        return newClasses;
    }

    private boolean isAttributeReferencingPrunedItem(EnclosingMethodAttribute attr) {
        return attr.getEnclosingClass() != null && !this.appInfo.liveTypes.contains(attr.getEnclosingClass()) || attr.getEnclosingMethod() != null && !this.appInfo.liveMethods.contains(attr.getEnclosingMethod());
    }

    private boolean isAttributeReferencingPrunedType(InnerClassAttribute attr) {
        DexClass inner;
        if (!this.appInfo.liveTypes.contains(attr.getInner())) {
            return true;
        }
        DexType context = attr.getOuter();
        if (context == null && (inner = this.appInfo.definitionFor(attr.getInner())) != null && inner.getEnclosingMethod() != null) {
            EnclosingMethodAttribute enclosingMethodAttribute = inner.getEnclosingMethod();
            if (enclosingMethodAttribute.getEnclosingClass() != null) {
                context = enclosingMethodAttribute.getEnclosingClass();
            } else {
                DexMethod enclosingMethod = enclosingMethodAttribute.getEnclosingMethod();
                if (!this.appInfo.liveMethods.contains(enclosingMethod)) {
                    return true;
                }
                context = enclosingMethod.getHolder();
            }
        }
        return context == null || !this.appInfo.liveTypes.contains(context);
    }

    private <S extends PresortedComparable<S>, T extends KeyedDexItem<S>> int firstUnreachableIndex(List<T> items, Predicate<S> live) {
        for (int i = 0; i < items.size(); ++i) {
            if (live.test(((KeyedDexItem)items.get(i)).getKey())) continue;
            return i;
        }
        return -1;
    }

    private boolean isDefaultConstructor(DexEncodedMethod method) {
        return method.isInstanceInitializer() && method.method.proto.parameters.isEmpty();
    }

    private DexEncodedMethod[] reachableMethods(List<DexEncodedMethod> methods, DexClass clazz) {
        int i;
        int firstUnreachable = this.firstUnreachableIndex(methods, this.appInfo.liveMethods::contains);
        if (firstUnreachable == -1) {
            return null;
        }
        ArrayList<DexEncodedMethod> reachableMethods = new ArrayList<DexEncodedMethod>(methods.size());
        for (i = 0; i < firstUnreachable; ++i) {
            reachableMethods.add(methods.get(i));
        }
        for (i = firstUnreachable; i < methods.size(); ++i) {
            DexEncodedMethod method = methods.get(i);
            if (this.appInfo.liveMethods.contains(method.getKey())) {
                reachableMethods.add(method);
                continue;
            }
            if (this.options.debugKeepRules && this.isDefaultConstructor(method)) {
                reachableMethods.add(method.shouldNotHaveCode() && !method.hasCode() ? method : method.toMethodThatLogsError(this.application.dexItemFactory));
                continue;
            }
            if (this.appInfo.targetedMethods.contains(method.getKey())) {
                boolean allowAbstract;
                if (method.shouldNotHaveCode() && !method.hasCode()) {
                    reachableMethods.add(method);
                    continue;
                }
                boolean bl = allowAbstract = clazz.accessFlags.isAbstract() && !method.accessFlags.isFinal() && !method.accessFlags.isNative() && !method.accessFlags.isStrict() && !method.accessFlags.isSynchronized() && !method.accessFlags.isPrivate();
                reachableMethods.add(allowAbstract ? method.toAbstractMethod() : (this.options.isGeneratingClassFiles() ? method.toEmptyThrowingMethodCf() : method.toEmptyThrowingMethodDex()));
                continue;
            }
            this.usagePrinter.printUnusedMethod(method);
        }
        return reachableMethods.toArray(new DexEncodedMethod[reachableMethods.size()]);
    }

    private DexEncodedField[] reachableFields(DexEncodedField[] fields) {
        int i;
        Predicate<DexField> isReachableOrReferencedField = field -> this.appInfo.liveFields.contains(field) || this.appInfo.isFieldRead((DexField)field) || this.appInfo.isFieldWritten((DexField)field);
        int firstUnreachable = this.firstUnreachableIndex(Arrays.asList(fields), isReachableOrReferencedField);
        if (firstUnreachable == -1) {
            return fields;
        }
        this.usagePrinter.printUnusedField(fields[firstUnreachable]);
        ArrayList<DexEncodedField> reachableOrReferencedFields = new ArrayList<DexEncodedField>(fields.length);
        for (i = 0; i < firstUnreachable; ++i) {
            reachableOrReferencedFields.add(fields[i]);
        }
        for (i = firstUnreachable + 1; i < fields.length; ++i) {
            DexEncodedField field2 = fields[i];
            if (isReachableOrReferencedField.test(field2.field)) {
                reachableOrReferencedFields.add(field2);
                continue;
            }
            this.usagePrinter.printUnusedField(field2);
        }
        return reachableOrReferencedFields.isEmpty() ? DexEncodedField.EMPTY_ARRAY : reachableOrReferencedFields.toArray(DexEncodedField.EMPTY_ARRAY);
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.prunedTypes);
    }
}

