/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.BiMapContainer;
import java.util.Map;

public class ClassRenamingMapper {
    public final ImmutableBiMap<String, String> translation;
    public final ImmutableSet<String> newClasses;
    public final ImmutableSet<String> unusedNames;

    public static ClassRenamingMapper from(ClassNameMapper originalMap, ClassNameMapper targetMap) {
        ImmutableBiMap.Builder translationBuilder = ImmutableBiMap.builder();
        ImmutableSet.Builder newClasses = ImmutableSet.builder();
        Map sourceOriginalToObfuscated = originalMap.getObfuscatedToOriginalMapping().inverse;
        BiMapContainer<String, String> targetMapping = targetMap.getObfuscatedToOriginalMapping();
        Map targetOriginalToObfuscated = targetMapping.inverse;
        for (String originalName : sourceOriginalToObfuscated.keySet()) {
            String sourceObfuscatedName = (String)sourceOriginalToObfuscated.get(originalName);
            String targetObfuscatedName = (String)targetOriginalToObfuscated.get(originalName);
            if (targetObfuscatedName == null) {
                newClasses.add(originalName);
                continue;
            }
            translationBuilder.put(sourceObfuscatedName, targetObfuscatedName);
        }
        ImmutableMap translation = translationBuilder.build();
        ImmutableSet<String> unusedNames = ImmutableSet.copyOf(Sets.difference(targetMapping.original.keySet(), ((ImmutableBiMap)translation).values()));
        return new ClassRenamingMapper((ImmutableBiMap<String, String>)translation, (ImmutableSet<String>)newClasses.build(), unusedNames);
    }

    private ClassRenamingMapper(ImmutableBiMap<String, String> translation, ImmutableSet<String> newClasses, ImmutableSet<String> unusedNames) {
        this.translation = translation;
        this.newClasses = newClasses;
        this.unusedNames = unusedNames;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Translation:\n\n");
        for (String name : this.translation.keySet()) {
            String newName;
            builder.append(name.equals(newName = (String)this.translation.get(name)) ? "    " : " --- ").append(name).append(" -> ").append(newName).append('\n');
        }
        builder.append("\nNew classes:\n\n");
        for (String name : this.newClasses) {
            builder.append("    ").append(name).append('\n');
        }
        builder.append("\nUnused names:\n\n");
        for (String unused : this.unusedNames) {
            builder.append("    ").append(unused).append('\n');
        }
        return builder.toString();
    }
}

