/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AppServices {
    public static final String SERVICE_DIRECTORY_NAME = "META-INF/services/";
    private final AppView<? extends AppInfo> appView;
    private final Map<DexType, Set<DexType>> services;

    private AppServices(AppView<? extends AppInfo> appView, Map<DexType, Set<DexType>> services) {
        this.appView = appView;
        this.services = services;
    }

    public Set<DexType> allServiceTypes() {
        assert (this.verifyRewrittenWithLens());
        return this.services.keySet();
    }

    public Set<DexType> serviceImplementationsFor(DexType serviceType) {
        assert (this.verifyRewrittenWithLens());
        assert (this.services.containsKey(serviceType));
        Set<DexType> serviceImplementationTypes = this.services.get(serviceType);
        if (serviceImplementationTypes == null) {
            assert (false) : "Unexpected attempt to get service implementations for non-service type `" + serviceType.toSourceString() + "`";
            return ImmutableSet.of();
        }
        return serviceImplementationTypes;
    }

    public AppServices rewrittenWithLens(GraphLense graphLens) {
        ImmutableMap.Builder<DexType, ImmutableCollection> rewrittenServices = ImmutableMap.builder();
        for (Map.Entry<DexType, Set<DexType>> entry : this.services.entrySet()) {
            DexType rewrittenServiceType = graphLens.lookupType(entry.getKey());
            ImmutableSet.Builder rewrittenServiceImplementationTypes = ImmutableSet.builder();
            for (DexType serviceImplementationType : entry.getValue()) {
                rewrittenServiceImplementationTypes.add(graphLens.lookupType(serviceImplementationType));
            }
            rewrittenServices.put(rewrittenServiceType, rewrittenServiceImplementationTypes.build());
        }
        return new AppServices(this.appView, rewrittenServices.build());
    }

    private boolean verifyRewrittenWithLens() {
        for (Map.Entry<DexType, Set<DexType>> entry : this.services.entrySet()) {
            assert (entry.getKey() == this.appView.graphLense().lookupType(entry.getKey()));
            for (DexType type : entry.getValue()) {
                assert (type == this.appView.graphLense().lookupType(type));
            }
        }
        return true;
    }

    public static Builder builder(AppView<? extends AppInfo> appView) {
        return new Builder(appView);
    }

    public static class Builder {
        private final AppView<? extends AppInfo> appView;
        private final Map<DexType, Set<DexType>> services = new IdentityHashMap<DexType, Set<DexType>>();

        private Builder(AppView<? extends AppInfo> appView) {
            this.appView = appView;
        }

        public AppServices build() {
            ImmutableList<ProgramResourceProvider> programResourceProviders = this.appView.appInfo().app.programResourceProviders;
            for (ProgramResourceProvider programResourceProvider : programResourceProviders) {
                DataResourceProvider dataResourceProvider = programResourceProvider.getDataResourceProvider();
                if (dataResourceProvider == null) continue;
                this.readServices(dataResourceProvider);
            }
            return new AppServices(this.appView, this.services);
        }

        private void readServices(DataResourceProvider dataResourceProvider) {
            try {
                dataResourceProvider.accept(new DataResourceProviderVisitor());
            }
            catch (ResourceException e) {
                throw new CompilationError(e.getMessage(), e);
            }
        }

        private class DataResourceProviderVisitor
        implements DataResourceProvider.Visitor {
            private DataResourceProviderVisitor() {
            }

            @Override
            public void visit(DataDirectoryResource directory) {
            }

            @Override
            public void visit(DataEntryResource file) {
                try {
                    String serviceName;
                    String name = file.getName();
                    if (name.startsWith(AppServices.SERVICE_DIRECTORY_NAME) && DescriptorUtils.isValidJavaType(serviceName = name.substring(AppServices.SERVICE_DIRECTORY_NAME.length()))) {
                        String serviceDescriptor = DescriptorUtils.javaTypeToDescriptor(serviceName);
                        DexType serviceType = Builder.this.appView.dexItemFactory().createType(serviceDescriptor);
                        byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                        String contents = new String(bytes, Charset.defaultCharset());
                        Builder.this.services.put(serviceType, this.readServiceImplementationsForService(contents, file.getOrigin()));
                    }
                }
                catch (ResourceException | IOException e) {
                    throw new CompilationError(e.getMessage(), e);
                }
            }

            private Set<DexType> readServiceImplementationsForService(String contents, Origin origin) {
                if (contents != null) {
                    return Arrays.stream(contents.split(System.lineSeparator())).map(String::trim).filter(line -> !line.isEmpty()).filter(DescriptorUtils::isValidJavaType).map(DescriptorUtils::javaTypeToDescriptor).map(Builder.this.appView.dexItemFactory()::createType).filter(serviceImplementationType -> {
                        if (!serviceImplementationType.isClassType()) {
                            ((Builder)Builder.this).appView.options().reporter.warning(new StringDiagnostic("Unexpected service implementation found in META-INF/services/: `" + serviceImplementationType.toSourceString() + "`.", origin));
                            return false;
                        }
                        return true;
                    }).collect(Collectors.toSet());
                }
                return ImmutableSet.of();
            }
        }
    }
}

