/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.Version;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MinifiedNameMapPrinter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.VersionProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class ProguardMapSupplier {
    public static final String MARKER_KEY_COMPILER = "compiler";
    public static final String MARKER_VALUE_COMPILER = "R8";
    public static final String MARKER_KEY_COMPILER_VERSION = "compiler_version";
    public static final String MARKER_KEY_COMPILER_HASH = "compiler_hash";
    public static final String MARKER_KEY_MIN_API = "min_api";
    private final boolean useClassNameMapper;
    private final ClassNameMapper classNameMapper;
    private final NamingLens namingLens;
    private final DexApplication application;
    private final int minApiLevel;

    public static ProguardMapSupplier fromClassNameMapper(ClassNameMapper classNameMapper, int minApiLevel) {
        return new ProguardMapSupplier(classNameMapper, minApiLevel);
    }

    public static ProguardMapSupplier fromNamingLens(NamingLens namingLens, DexApplication dexApplication, int minApiLevel) {
        return new ProguardMapSupplier(namingLens, dexApplication, minApiLevel);
    }

    private ProguardMapSupplier(ClassNameMapper classNameMapper, int minApiLevel) {
        this.useClassNameMapper = true;
        this.classNameMapper = classNameMapper;
        this.namingLens = null;
        this.application = null;
        this.minApiLevel = minApiLevel;
    }

    private ProguardMapSupplier(NamingLens namingLens, DexApplication dexApplication, int minApiLevel) {
        this.useClassNameMapper = false;
        this.classNameMapper = null;
        this.namingLens = namingLens;
        this.application = dexApplication;
        this.minApiLevel = minApiLevel;
    }

    public String get() {
        String body = this.getBody();
        if (body == null || body.trim().length() == 0) {
            return null;
        }
        String shaLine = "";
        if (Version.isDev()) {
            shaLine = "# compiler_hash: " + VersionProperties.INSTANCE.getSha() + "\n";
        }
        return "# compiler: R8\n# compiler_version: 1.4.77\n# min_api: " + this.minApiLevel + "\n" + shaLine + body;
    }

    private String getBody() {
        if (this.useClassNameMapper) {
            assert (this.classNameMapper != null);
            return this.classNameMapper.toString();
        }
        assert (this.namingLens != null && this.application != null);
        if (!this.namingLens.isIdentityLens()) {
            StringBuilder map2 = new StringBuilder();
            new MinifiedNameMapPrinter(this.application, this.namingLens).write(map2);
            return map2.toString();
        }
        if (this.application.getProguardMap() != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes);
            try {
                this.application.getProguardMap().write(writer);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while creating Proguard-map output: " + e);
            }
            return bytes.toString();
        }
        return null;
    }
}

