/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.experimental.graphinfo;

public class GraphEdgeInfo {
    private static GraphEdgeInfo UNKNOWN = new GraphEdgeInfo(EdgeKind.Unknown);
    private final EdgeKind kind;

    public static GraphEdgeInfo unknown() {
        return UNKNOWN;
    }

    public GraphEdgeInfo(EdgeKind kind) {
        this.kind = kind;
    }

    public EdgeKind edgeKind() {
        return this.kind;
    }

    public String getInfoPrefix() {
        switch (this.edgeKind()) {
            case KeepRule: 
            case CompatibilityRule: {
                return "referenced in keep rule";
            }
            case InstantiatedIn: {
                return "instantiated in";
            }
            case InvokedViaSuper: {
                return "invoked via super from";
            }
            case TargetedBySuper: {
                return "targeted by super from";
            }
            case InvokedFrom: {
                return "invoked from";
            }
            case InvokedFromLambdaCreatedIn: {
                return "invoked from lambda created in";
            }
            case AnnotatedOn: {
                return "annotated on";
            }
            case ReferencedFrom: {
                return "referenced from";
            }
            case ReflectiveUseFrom: {
                return "reflected from";
            }
            case ReachableFromLiveType: {
                return "reachable from";
            }
            case ReferencedInAnnotation: {
                return "referenced in annotation";
            }
            case IsLibraryMethod: {
                return "defined in library";
            }
            case MethodHandleUseFrom: {
                return "referenced by method handle";
            }
            default: {
                assert (false) : "Unknown edge kind: " + (Object)((Object)this.edgeKind());
                break;
            }
            case Unknown: 
        }
        return "kept for unknown reasons";
    }

    public String toString() {
        return "{edge-type:" + this.kind.toString() + "}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof GraphEdgeInfo && ((GraphEdgeInfo)o).kind == this.kind;
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public static enum EdgeKind {
        KeepRule,
        CompatibilityRule,
        InstantiatedIn,
        InvokedViaSuper,
        TargetedBySuper,
        InvokedFrom,
        InvokedFromLambdaCreatedIn,
        AnnotatedOn,
        ReferencedFrom,
        ReflectiveUseFrom,
        ReachableFromLiveType,
        ReferencedInAnnotation,
        IsLibraryMethod,
        MethodHandleUseFrom,
        Unknown;

    }
}

