/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MemberNameMinifier;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.Timing;
import java.util.Map;
import java.util.function.Function;

class FieldNameMinifier
extends MemberNameMinifier<DexField, DexType> {
    FieldNameMinifier(AppView<Enqueuer.AppInfoWithLiveness> appView, RootSetBuilder.RootSet rootSet) {
        super(appView, rootSet);
    }

    @Override
    Function<DexType, ?> getKeyTransform() {
        if (this.overloadAggressively) {
            return Function.identity();
        }
        return a -> Void.class;
    }

    FieldRenaming computeRenaming(Timing timing) {
        timing.begin("reserve-classes");
        this.reserveNamesInSubtypes(this.appInfo.dexItemFactory.objectType, this.globalState);
        timing.end();
        timing.begin("reserve-interfaces");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInSubtypes((DexType)iface, this.globalState));
        timing.end();
        timing.begin("rename-definitions");
        this.renameFieldsInSubtypes(this.appInfo.dexItemFactory.objectType);
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, this::renameFieldsInSubtypes);
        timing.end();
        timing.begin("rename-references");
        this.renameNonReboundReferences();
        timing.end();
        return new FieldRenaming(this.renaming);
    }

    private void reserveNamesInSubtypes(DexType type, NamingState<DexType, ?> state) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder == null) {
            return;
        }
        NamingState newState = this.computeStateIfAbsent(type, t -> state.createChild());
        holder.forEachField(field -> this.reserveFieldName((DexEncodedField)field, newState, holder.isLibraryClass()));
        type.forAllExtendsSubtypes(subtype -> this.reserveNamesInSubtypes((DexType)subtype, newState));
    }

    private void reserveFieldName(DexEncodedField encodedField, NamingState<DexType, ?> state, boolean isLibrary) {
        DexField field = encodedField.field;
        if (isLibrary || this.rootSet.noObfuscation.contains(field)) {
            state.reserveName(field.name, field.type);
        }
    }

    private void renameFieldsInSubtypes(DexType type) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return;
        }
        NamingState state = this.minifierState.getState(clazz.type);
        assert (state != null);
        clazz.forEachField(field -> this.renameField((DexEncodedField)field, state));
        type.forAllExtendsSubtypes(this::renameFieldsInSubtypes);
    }

    private void renameField(DexEncodedField encodedField, NamingState<DexType, ?> state) {
        DexField field = encodedField.field;
        if (!state.isReserved(field.name, field.type)) {
            this.renaming.put(field, state.assignNewNameFor(field.name, field.type, this.useUniqueMemberNames));
        }
    }

    private void renameNonReboundReferences() {
        Sets.union(Sets.union(this.appInfo.staticFieldReads.keySet(), this.appInfo.staticFieldWrites.keySet()), Sets.union(this.appInfo.instanceFieldReads.keySet(), this.appInfo.instanceFieldWrites.keySet())).forEach(this::renameNonReboundReference);
    }

    private void renameNonReboundReference(DexField field) {
        if (this.renaming.containsKey(field)) {
            return;
        }
        DexEncodedField definition = this.appInfo.definitionFor(field);
        if (definition != null) {
            assert (definition.field == field);
            return;
        }
        DexType holderType = field.getHolder();
        DexClass holder = this.appInfo.definitionFor(holderType);
        if (holder == null || holder.isLibraryClass()) {
            return;
        }
        definition = this.appInfo.resolveFieldOn(holderType, field);
        if (definition == null) {
            return;
        }
        assert (definition.field != field);
        assert (definition.field.getHolder() != holderType);
        if (this.renaming.containsKey(definition.field)) {
            this.renaming.put(field, (DexString)this.renaming.get(definition.field));
        }
    }

    static class FieldRenaming {
        final Map<DexField, DexString> renaming;

        private FieldRenaming(Map<DexField, DexString> renaming) {
            this.renaming = renaming;
        }

        public static FieldRenaming empty() {
            return new FieldRenaming(ImmutableMap.of());
        }
    }
}

