/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

abstract class MemberNameMinifier<MemberType, StateType extends CachedHashValueDexItem> {
    protected final AppView<Enqueuer.AppInfoWithLiveness> appView;
    protected final Enqueuer.AppInfoWithLiveness appInfo;
    protected final RootSetBuilder.RootSet rootSet;
    protected final InternalOptions options;
    protected final List<String> dictionary;
    protected final Map<MemberType, DexString> renaming = new IdentityHashMap<MemberType, DexString>();
    protected final NamingState<StateType, ?> globalState;
    protected final boolean useUniqueMemberNames;
    protected final boolean overloadAggressively;
    protected final State minifierState = new State();
    private final BiMap<DexType, NamingState<StateType, ?>> states = HashBiMap.create();

    MemberNameMinifier(AppView<Enqueuer.AppInfoWithLiveness> appView, RootSetBuilder.RootSet rootSet) {
        this.appView = appView;
        this.appInfo = appView.appInfo();
        this.rootSet = rootSet;
        this.options = appView.options();
        this.dictionary = this.options.getProguardConfiguration().getObfuscationDictionary();
        this.useUniqueMemberNames = this.options.getProguardConfiguration().isUseUniqueClassMemberNames();
        this.overloadAggressively = this.options.getProguardConfiguration().isOverloadAggressivelyWithoutUseUniqueClassMemberNames();
        this.globalState = NamingState.createRoot(this.appInfo.dexItemFactory, this.dictionary, this.getKeyTransform(), this.useUniqueMemberNames);
    }

    abstract Function<StateType, ?> getKeyTransform();

    protected NamingState<StateType, ?> computeStateIfAbsent(DexType type, Function<DexType, NamingState<StateType, ?>> f) {
        return this.useUniqueMemberNames ? this.globalState : this.states.computeIfAbsent(type, f);
    }

    class State {
        State() {
        }

        DexString getRenaming(MemberType key) {
            return MemberNameMinifier.this.renaming.get(key);
        }

        void putRenaming(MemberType key, DexString value) {
            MemberNameMinifier.this.renaming.put(key, value);
        }

        NamingState<StateType, ?> getState(DexType type) {
            return MemberNameMinifier.this.useUniqueMemberNames ? MemberNameMinifier.this.globalState : (NamingState)MemberNameMinifier.this.states.get(type);
        }

        DexType getStateKey(NamingState<StateType, ?> state) {
            return (DexType)MemberNameMinifier.this.states.inverse().get(state);
        }

        NamingState<StateType, ?> globalState() {
            return MemberNameMinifier.this.globalState;
        }

        boolean isReservedInGlobalState(DexString name, StateType state) {
            return MemberNameMinifier.this.globalState.isReserved(name, state);
        }

        boolean useUniqueMemberNames() {
            return MemberNameMinifier.this.useUniqueMemberNames;
        }
    }
}

