/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.Keep;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.AppliedGraphLens;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.EnumOrdinalMapCollector;
import com.android.tools.r8.ir.optimize.MethodPoolCollection;
import com.android.tools.r8.ir.optimize.SwitchMapCollector;
import com.android.tools.r8.ir.optimize.UninstantiatedTypeOptimization;
import com.android.tools.r8.ir.optimize.UnusedArgumentsCollector;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapApplier;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.naming.SourceFileRewriter;
import com.android.tools.r8.naming.signature.GenericSignatureRewriter;
import com.android.tools.r8.optimize.ClassAndMemberPublicizer;
import com.android.tools.r8.optimize.MemberRebindingAnalysis;
import com.android.tools.r8.optimize.VisibilityBridgeRemover;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.shaking.AbstractMethodRemover;
import com.android.tools.r8.shaking.AnnotationRemover;
import com.android.tools.r8.shaking.DiscardedChecker;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.MainDexClasses;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.StaticClassMerger;
import com.android.tools.r8.shaking.TreePruner;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.CollectionUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LineNumberOptimizer;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SelfRetraceTest;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.VersionProperties;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public class R8 {
    private final Timing timing = new Timing("R8");
    private final InternalOptions options;

    private R8(InternalOptions options) {
        this.options = options;
        options.itemFactory.resetSortedIndices();
    }

    public static void run(R8Command command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        R8.runForTesting(app, options);
    }

    public static void run(R8Command command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ExceptionUtils.withR8CompilationHandler(command.getReporter(), () -> R8.run(app, options, executor));
    }

    private static Marker getMarker(InternalOptions options) {
        if (options.hasMarker()) {
            return options.getMarker();
        }
        Marker marker = new Marker(Marker.Tool.R8).setVersion("1.4.94").setCompilationMode(options.debug ? CompilationMode.DEBUG : CompilationMode.RELEASE).setMinApi(options.minApiLevel);
        if (Version.isDev()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        return marker;
    }

    static void writeApplication(ExecutorService executorService, DexApplication application, AppView<? extends AppInfo> appView, String deadCode, GraphLense graphLense, NamingLens namingLens, String proguardSeedsData, InternalOptions options, ProguardMapSupplier proguardMapSupplier) throws ExecutionException {
        try {
            Marker marker = R8.getMarker(options);
            if (options.isGeneratingClassFiles()) {
                new CfApplicationWriter(application, appView, options, deadCode, graphLense, namingLens, proguardSeedsData, proguardMapSupplier).write(options.getClassFileConsumer(), executorService);
            } else {
                new ApplicationWriter(application, appView, options, marker == null ? null : Collections.singletonList(marker), deadCode, graphLense, namingLens, proguardSeedsData, proguardMapSupplier).write(executorService);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write application", e);
        }
    }

    private Set<DexType> filterMissingClasses(Set<DexType> missingClasses, ProguardClassFilter dontWarnPatterns) {
        HashSet<DexType> result = new HashSet<DexType>(missingClasses);
        dontWarnPatterns.filterOutMatches(result);
        return result;
    }

    static void runForTesting(AndroidApp app, InternalOptions options) throws CompilationFailedException {
        ExecutorService executor = ThreadUtils.getExecutorService(options);
        ExceptionUtils.withR8CompilationHandler(options.reporter, () -> {
            try {
                R8.run(app, options, executor);
            }
            finally {
                executor.shutdown();
            }
        });
    }

    private static void run(AndroidApp app, InternalOptions options, ExecutorService executor) throws IOException {
        new R8(options).run(app, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(AndroidApp inputApp, ExecutorService executorService) throws IOException {
        assert (this.options.programConsumer != null);
        if (this.options.quiet) {
            System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
        }
        try {
            NamingLens namingLens;
            Enqueuer enqueuer;
            WhyAreYouKeepingConsumer whyAreYouKeepingConsumer;
            Set<DexCallSite> desugaredCallSites;
            GraphLense publicizedLense;
            Object outputStream2;
            Enqueuer enqueuer2;
            RootSetBuilder.RootSet rootSet;
            Set<DexType> classesToRetainInnerClassAttributeFor;
            String proguardSeedsData;
            ArrayList<ProguardAssumeValuesRule> synthesizedProguardRules;
            AppView<AppInfoWithSubtyping> appView;
            DexApplication application;
            block75: {
                application = new ApplicationReader(inputApp, this.options, this.timing).read(executorService).toDirect();
                inputApp.closeInternalArchiveProviders();
                appView = new AppView<AppInfoWithSubtyping>(new AppInfoWithSubtyping(application), GraphLense.getIdentityLense(), this.options);
                appView.setAppServices(AppServices.builder(appView).build());
                synthesizedProguardRules = new ArrayList<ProguardAssumeValuesRule>();
                proguardSeedsData = null;
                this.timing.begin("Strip unused code");
                classesToRetainInnerClassAttributeFor = null;
                try {
                    Object out;
                    Set<DexType> missingClasses = appView.appInfo().getMissingClasses();
                    missingClasses = this.filterMissingClasses(missingClasses, this.options.getProguardConfiguration().getDontWarnPatterns());
                    if (!missingClasses.isEmpty()) {
                        missingClasses.forEach(clazz -> this.options.reporter.warning(new StringDiagnostic("Missing class: " + clazz.toSourceString())));
                        if (!this.options.ignoreMissingClasses) {
                            throw new CompilationError("Compilation can't be completed because some library classes are missing.");
                        }
                    }
                    this.computeKotlinInfoForProgramClasses(application, appView.appInfo());
                    ProguardConfiguration.Builder compatibility = ProguardConfiguration.builder(application.dexItemFactory, this.options.reporter);
                    if (this.options.isGeneratingDex() && !ProguardConfigurationUtils.hasExplicitAssumeValuesRuleForMinSdk(this.options.itemFactory, this.options.getProguardConfiguration().getRules())) {
                        synthesizedProguardRules.add(ProguardConfigurationUtils.buildAssumeValuesForApiLevel(this.options.itemFactory, AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel)));
                    }
                    rootSet = new RootSetBuilder(appView, application, Iterables.concat(this.options.getProguardConfiguration().getRules(), synthesizedProguardRules), this.options).run(executorService);
                    enqueuer2 = new Enqueuer(appView, this.options, null, compatibility);
                    appView.setAppInfo(enqueuer2.traceApplication(rootSet, this.options.getProguardConfiguration().getDontWarnPatterns(), executorService, this.timing));
                    assert (rootSet.verifyKeptFieldsAreAccessedAndLive(appView.appInfo().withLiveness()));
                    assert (rootSet.verifyKeptMethodsAreTargetedAndLive(appView.appInfo().withLiveness()));
                    assert (rootSet.verifyKeptTypesAreLive(appView.appInfo().withLiveness()));
                    if (this.options.getProguardConfiguration().isPrintSeeds()) {
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        out = new PrintStream(bytes);
                        RootSetBuilder.writeSeeds(appView.appInfo().withLiveness(), (PrintStream)out, type -> true);
                        ((PrintStream)out).flush();
                        proguardSeedsData = bytes.toString();
                    }
                    if (this.options.enableTreeShaking) {
                        TreePruner pruner = new TreePruner(application, appView.appInfo().withLiveness(), this.options);
                        application = pruner.run();
                        appView.setAppInfo(appView.appInfo().withLiveness().prunedCopyFrom(application, pruner.getRemovedClasses()));
                        new AbstractMethodRemover(appView.appInfo().withLiveness()).run();
                    }
                    classesToRetainInnerClassAttributeFor = AnnotationRemover.computeClassesToRetainInnerClassAttributeFor(appView.appInfo().withLiveness(), this.options);
                    new AnnotationRemover(appView.appInfo().withLiveness(), appView.graphLense(), this.options, classesToRetainInnerClassAttributeFor).ensureValid(compatibility).run();
                    if (!this.options.forceProguardCompatibility || this.options.proguardCompatibilityRulesOutput == null) break block75;
                    Closer closer = Closer.create();
                    out = null;
                    try {
                        outputStream2 = FileUtils.openPath(closer, this.options.proguardCompatibilityRulesOutput, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                        PrintStream ps = new PrintStream((OutputStream)outputStream2);
                        ps.println(compatibility.buildRaw().toString());
                    }
                    catch (Throwable outputStream2) {
                        out = outputStream2;
                        throw outputStream2;
                    }
                    finally {
                        if (closer != null) {
                            R8.$closeResource((Throwable)out, closer);
                        }
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            assert (appView.appInfo().hasLiveness());
            if (this.options.getProguardConfiguration().isAccessModificationAllowed() && (publicizedLense = ClassAndMemberPublicizer.run(executorService, this.timing, application, appView.withLiveness(), rootSet)) != appView.graphLense()) {
                appView.setGraphLense(publicizedLense);
                new VisibilityBridgeRemover(appView.withLiveness()).run();
            }
            RootSetBuilder.RootSet mainDexRootSet = null;
            MainDexClasses mainDexClasses = MainDexClasses.NONE;
            if (!this.options.mainDexKeepRules.isEmpty()) {
                mainDexRootSet = new RootSetBuilder(appView, application, this.options.mainDexKeepRules, this.options).run(executorService);
                enqueuer2 = new Enqueuer(appView, this.options, null, true);
                Enqueuer.AppInfoWithLiveness mainDexAppInfo = enqueuer2.traceMainDex(mainDexRootSet, executorService, this.timing);
                HashSet<DexType> mainDexBaseClasses = new HashSet<DexType>(mainDexAppInfo.liveTypes);
                mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
            }
            appView.dexItemFactory().clearReferenceTypeLatticeElementsCache();
            if (appView.appInfo().hasLiveness()) {
                AppView<Enqueuer.AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
                if (this.options.getProguardConfiguration().hasApplyMappingFile()) {
                    SeedMapper seedMapper = SeedMapper.seedMapperFromFile(this.options.getProguardConfiguration().getApplyMappingFile());
                    this.timing.begin("apply-mapping");
                    GraphLense applyMappingLense = new ProguardMapApplier(appView.withLiveness(), seedMapper).run(this.timing);
                    rootSet = rootSet.rewrittenWithLense(applyMappingLense);
                    appView.setGraphLense(applyMappingLense);
                    application = application.asDirect().rewrittenWithLense(appView.graphLense());
                    appView.setAppInfo(appView.appInfo().withLiveness().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                    this.timing.end();
                }
                appView.setGraphLense(new MemberRebindingAnalysis(appViewWithLiveness, this.options).run());
                if (this.options.enableHorizontalClassMerging) {
                    StaticClassMerger staticClassMerger = new StaticClassMerger(appViewWithLiveness, this.options, mainDexClasses);
                    appView.setGraphLense(staticClassMerger.run());
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                if (this.options.enableVerticalClassMerging) {
                    this.timing.begin("ClassMerger");
                    VerticalClassMerger verticalClassMerger = new VerticalClassMerger(application, appViewWithLiveness, executorService, this.options, this.timing, mainDexClasses);
                    appView.setGraphLense(verticalClassMerger.run());
                    appView.setVerticallyMergedClasses(verticalClassMerger.getMergedClasses());
                    this.timing.end();
                    application = application.asDirect().rewrittenWithLense(appView.graphLense());
                    appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().prunedCopyFrom(application, verticalClassMerger.getRemovedClasses()).rewrittenWithLense(application.asDirect(), appView.graphLense()));
                }
                if (this.options.enableArgumentRemoval) {
                    if (this.options.enableUnusedArgumentRemoval) {
                        this.timing.begin("UnusedArgumentRemoval");
                        appView.setGraphLense(new UnusedArgumentsCollector(appViewWithLiveness).run(executorService));
                        application = application.asDirect().rewrittenWithLense(appView.graphLense());
                        this.timing.end();
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                    }
                    if (this.options.enableUninstantiatedTypeOptimization) {
                        this.timing.begin("UninstantiatedTypeOptimization");
                        appView.setGraphLense(new UninstantiatedTypeOptimization(appViewWithLiveness).run(new MethodPoolCollection(appView), executorService, this.timing));
                        application = application.asDirect().rewrittenWithLense(appView.graphLense());
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().rewrittenWithLense(application.asDirect(), appView.graphLense()));
                        this.timing.end();
                    }
                }
                assert (appView.dexItemFactory().verifyNoCachedReferenceTypeLatticeElements());
                appViewWithLiveness.setAppInfo(new SwitchMapCollector(appViewWithLiveness, this.options).run());
                appViewWithLiveness.setAppInfo(new EnumOrdinalMapCollector(appViewWithLiveness, this.options).run());
            }
            appView.setAppServices(appView.appServices().rewrittenWithLens(appView.graphLense()));
            this.timing.begin("Create IR");
            CfgPrinter printer = this.options.printCfg ? new CfgPrinter() : null;
            try {
                IRConverter converter = new IRConverter(appView.withLiveness(), this.options, this.timing, printer, mainDexClasses, rootSet);
                application = converter.optimize(application, executorService);
                desugaredCallSites = converter.getDesugaredCallSites();
            }
            finally {
                this.timing.end();
            }
            appView.dexItemFactory().clearReferenceTypeLatticeElementsCache();
            this.timing.begin("AppliedGraphLens construction");
            appView.setGraphLense(new AppliedGraphLens(appView, application.classes()));
            this.timing.end();
            if (this.options.printCfg) {
                if (this.options.printCfgFile == null || this.options.printCfgFile.isEmpty()) {
                    System.out.print(printer.toString());
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.options.printCfgFile), StandardCharsets.UTF_8);
                    outputStream2 = null;
                    try {
                        writer.write(printer.toString());
                    }
                    catch (Throwable ps) {
                        outputStream2 = ps;
                        throw ps;
                    }
                    finally {
                        R8.$closeResource((Throwable)outputStream2, writer);
                    }
                }
            }
            this.timing.begin("Rename SourceFile");
            new SourceFileRewriter(appView.appInfo(), this.options).run();
            this.timing.end();
            Set<DexType> prunedTypes = appView.withLiveness().appInfo().getPrunedTypes();
            if (!this.options.mainDexKeepRules.isEmpty()) {
                appView.setAppInfo(new AppInfoWithSubtyping(application));
                assert (mainDexRootSet != null);
                GraphConsumer mainDexKeptGraphConsumer = this.options.mainDexKeptGraphConsumer;
                whyAreYouKeepingConsumer = null;
                if (!mainDexRootSet.reasonAsked.isEmpty()) {
                    whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(mainDexKeptGraphConsumer);
                    mainDexKeptGraphConsumer = whyAreYouKeepingConsumer;
                }
                enqueuer = new Enqueuer(appView, this.options, mainDexKeptGraphConsumer, true);
                Enqueuer.AppInfoWithLiveness mainDexAppInfo = enqueuer.traceMainDex(mainDexRootSet, executorService, this.timing);
                HashSet<DexType> mainDexBaseClasses = new HashSet<DexType>(mainDexAppInfo.liveTypes);
                mainDexClasses = new MainDexListBuilder(mainDexBaseClasses, application).run();
                if (!mainDexRootSet.checkDiscarded.isEmpty()) {
                    new DiscardedChecker(mainDexRootSet, mainDexClasses.getClasses(), appView.appInfo(), this.options).run();
                }
                if (whyAreYouKeepingConsumer != null) {
                    for (DexReference reference : mainDexRootSet.reasonAsked) {
                        whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphNode(reference), System.out);
                    }
                }
            }
            appView.setAppInfo(new AppInfoWithSubtyping(application));
            if (this.options.enableTreeShaking || this.options.enableMinification) {
                this.timing.begin("Post optimization code stripping");
                try {
                    GraphConsumer keptGraphConsumer = null;
                    whyAreYouKeepingConsumer = null;
                    if (this.options.enableTreeShaking) {
                        keptGraphConsumer = this.options.keptGraphConsumer;
                        if (!rootSet.reasonAsked.isEmpty()) {
                            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(keptGraphConsumer);
                            keptGraphConsumer = whyAreYouKeepingConsumer;
                        }
                    }
                    enqueuer = new Enqueuer(appView, this.options, keptGraphConsumer);
                    appView.setAppInfo(enqueuer.traceApplication(rootSet, this.options.getProguardConfiguration().getDontWarnPatterns(), executorService, this.timing));
                    AppView<Enqueuer.AppInfoWithLiveness> appViewWithLiveness = appView.withLiveness();
                    if (this.options.enableTreeShaking) {
                        TreePruner pruner = new TreePruner(application, appViewWithLiveness.appInfo(), this.options);
                        application = pruner.run();
                        appViewWithLiveness.setAppInfo(appViewWithLiveness.appInfo().prunedCopyFrom(application, CollectionUtils.mergeSets(prunedTypes, pruner.getRemovedClasses())));
                        if (whyAreYouKeepingConsumer != null) {
                            for (DexReference reference : rootSet.reasonAsked) {
                                whyAreYouKeepingConsumer.printWhyAreYouKeeping(enqueuer.getGraphNode(reference), System.out);
                            }
                        }
                        assert (classesToRetainInnerClassAttributeFor != null);
                        new AnnotationRemover(appView.appInfo().withLiveness(), appView.graphLense(), this.options, classesToRetainInnerClassAttributeFor).run();
                        if (!mainDexClasses.isEmpty()) {
                            mainDexClasses = mainDexClasses.prunedCopy(appView.appInfo().withLiveness());
                        }
                    }
                }
                finally {
                    this.timing.end();
                }
            }
            if (!this.options.mainDexKeepRules.isEmpty()) {
                application = application.builder().addToMainDexList(mainDexClasses.getClasses()).build();
            }
            if (this.options.enableTreeShaking && !rootSet.checkDiscarded.isEmpty()) {
                new DiscardedChecker(rootSet, application, this.options).run();
            }
            if (this.options.enableMinification) {
                this.timing.begin("Minification");
                namingLens = new Minifier(appView.withLiveness(), rootSet, desugaredCallSites).run(this.timing);
                this.timing.end();
            } else {
                if (appView.appInfo().hasLiveness()) {
                    new GenericSignatureRewriter(appView.withLiveness()).run();
                }
                namingLens = NamingLens.getIdentityLens();
            }
            this.timing.begin("Line number remapping");
            ClassNameMapper classNameMapper = LineNumberOptimizer.run(application, appView.graphLense(), namingLens, this.options.lineNumberOptimization == InternalOptions.LineNumberOptimization.OFF);
            this.timing.end();
            ProguardMapSupplier proguardMapSupplier = ProguardMapSupplier.fromClassNameMapper(classNameMapper, this.options.minApiLevel);
            if (this.options.hasMethodsFilter()) {
                System.out.println("Finished compilation with method filter: ");
                this.options.methodsFilter.forEach(m -> System.out.println("  - " + m));
                return;
            }
            assert (application.classes().stream().allMatch(DexClass::isValid));
            assert (rootSet.verifyKeptItemsAreKept(application, appView.appInfo()));
            assert (appView.graphLense().verifyMappingToOriginalProgram(application.classesWithDeterministicOrder(), new ApplicationReader(inputApp.withoutMainDexList(), this.options, this.timing).read(executorService), appView.dexItemFactory()));
            if (this.options.syntheticProguardRulesConsumer != null) {
                this.options.syntheticProguardRulesConsumer.accept(synthesizedProguardRules);
            }
            R8.writeApplication(executorService, application, appView, application.deadCode, appView.graphLense(), namingLens, proguardSeedsData, this.options, proguardMapSupplier);
            this.options.printWarnings();
        }
        catch (ExecutionException e) {
            throw R8.unwrapExecutionException(e);
        }
        finally {
            this.options.signalFinishedToConsumers();
            if (this.options.printTimes) {
                this.timing.report();
            }
        }
    }

    private void computeKotlinInfoForProgramClasses(DexApplication application, AppInfoWithSubtyping appInfo) {
        Kotlin kotlin = appInfo.dexItemFactory.kotlin;
        Reporter reporter = this.options.reporter;
        for (DexProgramClass programClass : application.classes()) {
            programClass.setKotlinInfo(kotlin.getKotlinInfo(programClass, reporter));
        }
    }

    static RuntimeException unwrapExecutionException(ExecutionException executionException) {
        Throwable cause = executionException.getCause();
        if (cause instanceof Error) {
            cause.addSuppressed(executionException);
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            cause.addSuppressed(executionException);
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(executionException.getMessage(), cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws CompilationFailedException {
        R8Command command = (R8Command)R8Command.parse(args, CommandLineOrigin.INSTANCE).build();
        if (command.isPrintHelp()) {
            SelfRetraceTest.test();
            System.out.println(R8Command.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            Version.printToolVersion("R8");
            return;
        }
        InternalOptions options = command.getInternalOptions();
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        try {
            ExceptionUtils.withR8CompilationHandler(options.reporter, () -> R8.run(command.getInputApp(), options, executorService));
        }
        finally {
            executorService.shutdown();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println(R8Command.USAGE_MESSAGE);
            System.exit(1);
        }
        ExceptionUtils.withMainProgramHandler(() -> R8.run(args));
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

