/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EscapeAnalysis {
    public static Set<Instruction> escape(IRCode code, Value valueOfInterest) {
        BasicBlock block;
        BasicBlock basicBlock = block = valueOfInterest.isPhi() ? valueOfInterest.asPhi().getBlock() : valueOfInterest.definition.getBlock();
        assert (code.blocks.contains(block));
        List<Value> arguments = code.collectArguments();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set<Value> trackedValues = Sets.newIdentityHashSet();
        ArrayDeque<Value> valuesToTrack = new ArrayDeque<Value>();
        valuesToTrack.push(valueOfInterest);
        while (!valuesToTrack.isEmpty()) {
            Value v = (Value)valuesToTrack.poll();
            if (!trackedValues.add(v)) continue;
            v.uniquePhiUsers().forEach(valuesToTrack::push);
            for (Instruction user : v.uniqueUsers()) {
                Value propagatedValue;
                LinkedList<Instruction> instructions;
                if (user.getBlock() == block && !valueOfInterest.isPhi() && (instructions = block.getInstructions()).indexOf(user) < instructions.indexOf(valueOfInterest.definition)) continue;
                if (EscapeAnalysis.isDirectlyEscaping(user, code.method, arguments)) {
                    builder.add(user);
                    continue;
                }
                if (user.couldIntroduceAnAlias()) {
                    Value outValue = user.outValue();
                    assert (outValue != null);
                    valuesToTrack.push(outValue);
                }
                if ((propagatedValue = EscapeAnalysis.getPropagatedSubject(v, user)) == null || propagatedValue == v) continue;
                valuesToTrack.push(propagatedValue);
            }
        }
        return builder.build();
    }

    private static boolean isDirectlyEscaping(Instruction instr, DexEncodedMethod invocationContext, List<Value> arguments) {
        if (instr.isReturn()) {
            return true;
        }
        if (instr.isThrow()) {
            return true;
        }
        if (instr.isStaticPut()) {
            return true;
        }
        if (instr.isInvokeMethod()) {
            DexMethod invokedMethod = instr.asInvokeMethod().getInvokedMethod();
            if (invokedMethod == invocationContext.method) {
                return !instr.inValues().equals(arguments);
            }
            return true;
        }
        if (instr.isArrayPut()) {
            return instr.asArrayPut().array().isArgument();
        }
        return false;
    }

    private static Value getPropagatedSubject(Value src, Instruction instr) {
        if (instr.isArrayGet()) {
            return instr.asArrayGet().dest();
        }
        if (instr.isArrayPut()) {
            return instr.asArrayPut().array();
        }
        if (instr.isInstancePut()) {
            return instr.asInstancePut().object();
        }
        return null;
    }
}

