/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ParameterUsagesInfo {
    private ImmutableList<ParameterUsage> parametersUsages;

    public ParameterUsagesInfo(List<ParameterUsage> usages) {
        assert (!usages.isEmpty());
        this.parametersUsages = ImmutableList.copyOf(usages);
        assert (this.parametersUsages.size() == this.parametersUsages.stream().map(usage -> usage.index).collect(Collectors.toSet()).size());
    }

    ParameterUsage getParameterUsage(int parameter) {
        for (ParameterUsage usage : this.parametersUsages) {
            if (usage.index != parameter) continue;
            return usage;
        }
        return null;
    }

    public static class ParameterUsageBuilder {
        private final int index;
        private final Value arg;
        private final Set<If.Type> ifZeroTestTypes = new HashSet<If.Type>();
        private final List<Pair<Invoke.Type, DexMethod>> callsOnReceiver = new ArrayList<Pair<Invoke.Type, DexMethod>>();
        private boolean hasFieldAssignment = false;
        private boolean hasFieldRead = false;
        private boolean isAssignedToField = false;
        private boolean isReturned = false;

        public ParameterUsageBuilder(Value arg, int index) {
            this.arg = arg;
            this.index = index;
        }

        public boolean note(Instruction instruction) {
            if (instruction.isIf()) {
                return this.note(instruction.asIf());
            }
            if (instruction.isInstanceGet()) {
                return this.note(instruction.asInstanceGet());
            }
            if (instruction.isInstancePut()) {
                return this.note(instruction.asInstancePut());
            }
            if (instruction.isInvokeMethodWithReceiver()) {
                return this.note(instruction.asInvokeMethodWithReceiver());
            }
            if (instruction.isReturn()) {
                return this.note(instruction.asReturn());
            }
            return false;
        }

        public ParameterUsage build() {
            return new ParameterUsage(this.index, this.ifZeroTestTypes, this.callsOnReceiver, this.hasFieldAssignment, this.hasFieldRead, this.isAssignedToField, this.isReturned);
        }

        private boolean note(If ifInstruction) {
            if (ifInstruction.asIf().isZeroTest()) {
                assert (ifInstruction.inValues().size() == 1 && ifInstruction.inValues().get(0) == this.arg);
                this.ifZeroTestTypes.add(ifInstruction.asIf().getType());
                return true;
            }
            return false;
        }

        private boolean note(InstanceGet instanceGetInstruction) {
            assert (this.arg != instanceGetInstruction.outValue());
            if (instanceGetInstruction.object() == this.arg) {
                this.hasFieldRead = true;
                return true;
            }
            return false;
        }

        private boolean note(InstancePut instancePutInstruction) {
            assert (this.arg != instancePutInstruction.outValue());
            if (instancePutInstruction.object() == this.arg) {
                this.hasFieldAssignment = true;
                this.isAssignedToField |= instancePutInstruction.value() == this.arg;
                return true;
            }
            if (instancePutInstruction.value() == this.arg) {
                this.isAssignedToField = true;
                return true;
            }
            return false;
        }

        private boolean note(InvokeMethodWithReceiver invokeInstruction) {
            if (invokeInstruction.inValues().lastIndexOf(this.arg) == 0) {
                this.callsOnReceiver.add(new Pair<Invoke.Type, DexMethod>(invokeInstruction.asInvokeMethodWithReceiver().getType(), invokeInstruction.asInvokeMethodWithReceiver().getInvokedMethod()));
                return true;
            }
            return false;
        }

        private boolean note(Return returnInstruction) {
            assert (returnInstruction.inValues().size() == 1 && returnInstruction.inValues().get(0) == this.arg);
            this.isReturned = true;
            return true;
        }
    }

    public static final class ParameterUsage {
        public final int index;
        public final Set<If.Type> ifZeroTest;
        public final List<Pair<Invoke.Type, DexMethod>> callsReceiver;
        public final boolean hasFieldAssignment;
        public final boolean hasFieldRead;
        public final boolean isAssignedToField;
        public final boolean isReturned;

        ParameterUsage(int index, Set<If.Type> ifZeroTest, List<Pair<Invoke.Type, DexMethod>> callsReceiver, boolean hasFieldAssignment, boolean hasFieldRead, boolean isAssignedToField, boolean isReturned) {
            this.index = index;
            this.ifZeroTest = ifZeroTest.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(ifZeroTest);
            this.callsReceiver = callsReceiver.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(callsReceiver);
            this.hasFieldAssignment = hasFieldAssignment;
            this.hasFieldRead = hasFieldRead;
            this.isAssignedToField = isAssignedToField;
            this.isReturned = isReturned;
        }

        public boolean notUsed() {
            return this.ifZeroTest == null && this.callsReceiver == null && !this.hasFieldAssignment && !this.hasFieldRead && !this.isAssignedToField && !this.isReturned;
        }
    }
}

