/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ArrayTypeLatticeElement
extends ReferenceTypeLatticeElement {
    private final TypeLatticeElement memberTypeLattice;

    public ArrayTypeLatticeElement(TypeLatticeElement memberTypeLattice, boolean isNullable) {
        super(isNullable, null);
        this.memberTypeLattice = memberTypeLattice;
    }

    public DexType getArrayType(DexItemFactory factory) {
        DexType baseType;
        TypeLatticeElement baseTypeLattice = this.getArrayBaseTypeLattice();
        if (baseTypeLattice.isPrimitive()) {
            baseType = baseTypeLattice.asPrimitiveTypeLatticeElement().toDexType(factory);
        } else {
            assert (baseTypeLattice.isClassType());
            baseType = baseTypeLattice.asClassTypeLatticeElement().getClassType();
        }
        return factory.createArrayType(this.getNesting(), baseType);
    }

    int getNesting() {
        int nesting = 1;
        TypeLatticeElement member = this.getArrayMemberTypeAsMemberType();
        while (member.isArrayType()) {
            ++nesting;
            member = member.asArrayTypeLatticeElement().getArrayMemberTypeAsMemberType();
        }
        return nesting;
    }

    TypeLatticeElement getArrayMemberTypeAsMemberType() {
        return this.memberTypeLattice;
    }

    public TypeLatticeElement getArrayMemberTypeAsValueType() {
        return this.memberTypeLattice.isFineGrainedType() ? INT : this.memberTypeLattice;
    }

    private TypeLatticeElement getArrayBaseTypeLattice() {
        TypeLatticeElement base = this.getArrayMemberTypeAsMemberType();
        while (base.isArrayType()) {
            base = base.asArrayTypeLatticeElement().getArrayMemberTypeAsMemberType();
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceTypeLatticeElement getOrCreateDualLattice() {
        if (this.dual != null) {
            return this.dual;
        }
        ArrayTypeLatticeElement arrayTypeLatticeElement = this;
        synchronized (arrayTypeLatticeElement) {
            if (this.dual == null) {
                ArrayTypeLatticeElement dual = new ArrayTypeLatticeElement(this.memberTypeLattice, !this.isNullable());
                ArrayTypeLatticeElement.linkDualLattice(this, dual);
            }
        }
        return this.dual;
    }

    @Override
    public TypeLatticeElement asNullable() {
        return this.isNullable() ? this : this.getOrCreateDualLattice();
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return !this.isNullable() ? this : this.getOrCreateDualLattice();
    }

    @Override
    public boolean isBasedOnMissingClass(AppInfo appInfo) {
        return this.memberTypeLattice.isBasedOnMissingClass(appInfo);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ArrayTypeLatticeElement asArrayTypeLatticeElement() {
        return this;
    }

    @Override
    public String toString() {
        return this.memberTypeLattice.toString() + "[]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayTypeLatticeElement)) {
            return false;
        }
        ArrayTypeLatticeElement other = (ArrayTypeLatticeElement)o;
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        if (this.type != null && other.type != null && !this.type.equals(other.type)) {
            return false;
        }
        return this.memberTypeLattice.equals(other.memberTypeLattice);
    }

    @Override
    public int hashCode() {
        return (this.isNullable() ? 1 : -1) * this.memberTypeLattice.hashCode();
    }

    ReferenceTypeLatticeElement join(ArrayTypeLatticeElement other, AppInfo appInfo) {
        boolean isNullable;
        TypeLatticeElement bMember;
        TypeLatticeElement aMember = this.getArrayMemberTypeAsMemberType();
        if (aMember.equals(bMember = other.getArrayMemberTypeAsMemberType())) {
            return null;
        }
        boolean bl = isNullable = this.isNullable() || other.isNullable();
        if (aMember.isArrayType() && bMember.isArrayType()) {
            ReferenceTypeLatticeElement join = aMember.asArrayTypeLatticeElement().join(bMember.asArrayTypeLatticeElement(), appInfo);
            return join == null ? null : new ArrayTypeLatticeElement(join, isNullable);
        }
        if (aMember.isClassType() && bMember.isClassType()) {
            ClassTypeLatticeElement join = aMember.asClassTypeLatticeElement().join(bMember.asClassTypeLatticeElement(), appInfo);
            return join == null ? null : new ArrayTypeLatticeElement(join, isNullable);
        }
        if (aMember.isPrimitive() || bMember.isPrimitive()) {
            return ArrayTypeLatticeElement.objectClassType(appInfo, isNullable);
        }
        return ArrayTypeLatticeElement.objectArrayType(appInfo, isNullable);
    }
}

