/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import java.util.List;
import java.util.ListIterator;

public class LinearFlowInstructionIterator
implements InstructionIterator,
InstructionListIterator {
    private BasicBlock currentBlock;
    private InstructionListIterator currentBlockIterator;

    public LinearFlowInstructionIterator(BasicBlock block) {
        this(block, 0);
    }

    public LinearFlowInstructionIterator(BasicBlock block, int index) {
        this.currentBlock = block;
        this.currentBlockIterator = block.listIterator(index);
        if (index > 0) {
            this.previous();
            this.next();
        }
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction) {
        this.currentBlockIterator.replaceCurrentInstruction(newInstruction);
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blockIterator) {
        return this.currentBlockIterator.split(code, blockIterator);
    }

    @Override
    public BasicBlock split(IRCode code, int instructions, ListIterator<BasicBlock> blockIterator) {
        return this.currentBlockIterator.split(code, instructions, blockIterator);
    }

    @Override
    public BasicBlock inlineInvoke(AppInfo appInfo, IRCode code, IRCode inlinee, ListIterator<BasicBlock> blockIterator, List<BasicBlock> blocksToRemove, DexType downcast) {
        return this.currentBlockIterator.inlineInvoke(appInfo, code, inlinee, blockIterator, blocksToRemove, downcast);
    }

    @Override
    public void add(Instruction instruction) {
        this.currentBlockIterator.add(instruction);
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        this.currentBlockIterator.removeOrReplaceByDebugLocalRead();
    }

    private boolean isLinearEdge(BasicBlock pred, BasicBlock succ) {
        assert (pred.getSuccessors().contains(succ));
        assert (succ.getPredecessors().contains(pred));
        Goto exit = pred.exit().asGoto();
        return exit != null && exit.getTarget() == succ && succ.getPredecessors().size() == 1;
    }

    @Override
    public boolean hasNext() {
        return this.currentBlockIterator.hasNext();
    }

    @Override
    public Instruction next() {
        BasicBlock candidate;
        Instruction current = (Instruction)this.currentBlockIterator.next();
        if (!current.isGoto()) {
            return current;
        }
        BasicBlock target = current.asGoto().getTarget();
        if (!this.isLinearEdge(this.currentBlock, target)) {
            return current;
        }
        while (target.isTrivialGoto() && this.isLinearEdge(target, candidate = target.exit().asGoto().getTarget())) {
            target = candidate;
        }
        this.currentBlock = target;
        this.currentBlockIterator = this.currentBlock.listIterator();
        return (Instruction)this.currentBlockIterator.next();
    }

    private BasicBlock getBeginningOfTrivialLinearGotoChain(BasicBlock block) {
        if (block.getPredecessors().size() != 1 || !this.isLinearEdge(block.getPredecessors().get(0), block)) {
            return null;
        }
        BasicBlock target = block.getPredecessors().get(0);
        while (target.getPredecessors().size() == 1 && this.isLinearEdge(target.getPredecessors().get(0), target) && target.isTrivialGoto()) {
            target = target.getPredecessors().get(0);
        }
        return target.isTrivialGoto() ? null : target;
    }

    @Override
    public boolean hasPrevious() {
        if (this.currentBlockIterator.hasPrevious()) {
            return true;
        }
        return this.getBeginningOfTrivialLinearGotoChain(this.currentBlock) != null;
    }

    @Override
    public Instruction previous() {
        if (this.currentBlockIterator.hasPrevious()) {
            return (Instruction)this.currentBlockIterator.previous();
        }
        BasicBlock target = this.getBeginningOfTrivialLinearGotoChain(this.currentBlock);
        if (target == null) {
            return (Instruction)this.currentBlockIterator.previous();
        }
        this.currentBlock = target;
        this.currentBlockIterator = this.currentBlock.listIterator(this.currentBlock.getInstructions().size());
        this.currentBlockIterator.previous();
        return (Instruction)this.currentBlockIterator.previous();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this.currentBlockIterator.remove();
    }

    @Override
    public void set(Instruction instruction) {
        this.currentBlockIterator.set(instruction);
    }
}

