/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.staticizer;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.ir.optimize.staticizer.ClassStaticizer;
import com.android.tools.r8.ir.optimize.staticizer.ClassStaticizerGraphLense;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class StaticizingProcessor {
    private final ClassStaticizer classStaticizer;
    private final ExecutorService executorService;
    private final Set<DexEncodedMethod> referencingExtraMethods = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, ClassStaticizer.CandidateInfo> hostClassInits = new IdentityHashMap<DexEncodedMethod, ClassStaticizer.CandidateInfo>();
    private final Set<DexEncodedMethod> methodsToBeStaticized = Sets.newIdentityHashSet();
    private final Map<DexField, ClassStaticizer.CandidateInfo> singletonFields = new IdentityHashMap<DexField, ClassStaticizer.CandidateInfo>();
    private final Map<DexType, DexType> candidateToHostMapping = new IdentityHashMap<DexType, DexType>();

    StaticizingProcessor(ClassStaticizer classStaticizer, ExecutorService executorService) {
        this.classStaticizer = classStaticizer;
        this.executorService = executorService;
    }

    final Set<DexEncodedMethod> run(OptimizationFeedback feedback) throws ExecutionException {
        this.finalEligibilityCheck();
        this.prepareCandidates();
        this.processMethodsConcurrently(this.hostClassInits.keySet(), this::removeCandidateInstantiation, feedback);
        this.processMethodsConcurrently(this.methodsToBeStaticized, this::removeReferencesToThis, feedback);
        Set<DexEncodedMethod> methods = this.staticizeMethodSymbols();
        methods.addAll(this.referencingExtraMethods);
        methods.addAll(this.hostClassInits.keySet());
        this.processMethodsConcurrently(methods, this::rewriteReferences, feedback);
        return methods;
    }

    private void finalEligibilityCheck() {
        Iterator<Map.Entry<DexType, ClassStaticizer.CandidateInfo>> it = this.classStaticizer.candidates.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DexType, ClassStaticizer.CandidateInfo> entry = it.next();
            DexType candidateType = entry.getKey();
            ClassStaticizer.CandidateInfo info = entry.getValue();
            DexProgramClass candidateClass = info.candidate;
            DexType candidateHostType = info.hostType();
            DexEncodedMethod constructorUsed = info.constructor.get();
            int instancesCreated = info.instancesCreated.get();
            assert (instancesCreated == info.fieldWrites.get());
            assert (instancesCreated <= 1);
            assert (instancesCreated == 0 == (constructorUsed == null));
            if (instancesCreated == 0) {
                it.remove();
                continue;
            }
            assert (candidateClass.instanceFields().length == 0);
            assert (constructorUsed.isProcessed());
            DexEncodedMethod.TrivialInitializer trivialInitializer = constructorUsed.getOptimizationInfo().getTrivialInitializerInfo();
            if (trivialInitializer == null) {
                it.remove();
                continue;
            }
            DexEncodedMethod classInitializer = candidateClass.getClassInitializer();
            assert (classInitializer != null || candidateType != candidateHostType);
            if (classInitializer != null && candidateType != candidateHostType) {
                it.remove();
                continue;
            }
            if (!Streams.stream(candidateClass.methods()).anyMatch(method -> !method.isStatic() && method.shouldNotHaveCode())) continue;
            it.remove();
        }
    }

    private void prepareCandidates() {
        Set<DexEncodedMethod> removedInstanceMethods = Sets.newIdentityHashSet();
        for (ClassStaticizer.CandidateInfo candidate : this.classStaticizer.candidates.values()) {
            DexProgramClass candidateClass = candidate.candidate;
            DexClass hostClass = candidate.hostClass();
            DexEncodedMethod hostClassInitializer = hostClass.getClassInitializer();
            assert (hostClassInitializer != null);
            ClassStaticizer.CandidateInfo previous = this.hostClassInits.put(hostClassInitializer, candidate);
            assert (previous == null);
            for (DexEncodedMethod method : candidateClass.methods()) {
                if (method.isStatic()) continue;
                removedInstanceMethods.add(method);
                if (this.factory().isConstructor(method.method)) continue;
                this.methodsToBeStaticized.add(method);
            }
            this.singletonFields.put(candidate.singletonField.field, candidate);
            this.referencingExtraMethods.addAll(candidate.referencedFrom);
        }
        this.referencingExtraMethods.removeAll(removedInstanceMethods);
    }

    private void processMethodsConcurrently(Set<DexEncodedMethod> methods, BiConsumer<DexEncodedMethod, IRCode> strategy, OptimizationFeedback feedback) throws ExecutionException {
        this.classStaticizer.setFixupStrategy(strategy);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexEncodedMethod method : methods) {
            futures.add(this.executorService.submit(() -> {
                this.classStaticizer.converter.processMethod(method, feedback, methods::contains, CallSiteInformation.empty(), Outliner::noProcessing);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
        this.classStaticizer.cleanFixupStrategy();
    }

    private void removeCandidateInstantiation(DexEncodedMethod method, IRCode code) {
        ClassStaticizer.CandidateInfo candidateInfo = this.hostClassInits.get(method);
        assert (candidateInfo != null);
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            if (!instruction.isNewInstance() || instruction.asNewInstance().clazz != candidateInfo.candidate.type) continue;
            assert (candidateInfo.candidate.superType == this.factory().objectType);
            assert (candidateInfo.candidate.instanceFields().length == 0);
            Value singletonValue = instruction.outValue();
            assert (singletonValue != null);
            singletonValue.uniqueUsers().forEach(Instruction::removeOrReplaceByDebugLocalRead);
            instruction.removeOrReplaceByDebugLocalRead();
            return;
        }
        assert (false) : "Must always be able to find and remove the instantiation";
    }

    private void removeReferencesToThis(DexEncodedMethod method, IRCode code) {
        this.fixupStaticizedThisUsers(code, code.getThis());
    }

    private void rewriteReferences(DexEncodedMethod method, IRCode code) {
        List<StaticGet> singletonFieldReads = Streams.stream(code.instructionIterator()).filter(Instruction::isStaticGet).map(Instruction::asStaticGet).filter(get2 -> this.singletonFields.containsKey(get2.getField())).collect(Collectors.toList());
        singletonFieldReads.forEach(read -> {
            DexField field = read.getField();
            ClassStaticizer.CandidateInfo candidateInfo = this.singletonFields.get(field);
            assert (candidateInfo != null);
            Value value = read.dest();
            if (value != null) {
                this.fixupStaticizedFieldReadUsers(code, value, field);
            }
            if (!candidateInfo.preserveRead.get()) {
                read.removeOrReplaceByDebugLocalRead();
            }
        });
        if (!this.candidateToHostMapping.isEmpty()) {
            this.remapMovedCandidates(code);
        }
    }

    private void fixupStaticizedThisUsers(IRCode code, Value thisValue) {
        assert (thisValue != null);
        assert (thisValue.numberOfPhiUsers() == 0);
        this.fixupStaticizedValueUsers(code, thisValue.uniqueUsers());
        assert (thisValue.numberOfUsers() == 0);
    }

    private boolean testAndcollectPhisComposedOfSameFieldRead(Set<Phi> phisToCheck, DexField field, Set<Phi> trivialPhis) {
        for (Phi phi : phisToCheck) {
            Set<Phi> chainedPhis = Sets.newIdentityHashSet();
            for (Value operand : phi.getOperands()) {
                if (operand.isPhi()) {
                    chainedPhis.add(operand.asPhi());
                    continue;
                }
                if (!operand.definition.isStaticGet()) {
                    return false;
                }
                if (operand.definition.asStaticGet().getField() == field) continue;
                return false;
            }
            if (!chainedPhis.isEmpty() && !this.testAndcollectPhisComposedOfSameFieldRead(chainedPhis, field, trivialPhis)) {
                return false;
            }
            trivialPhis.add(phi);
        }
        return true;
    }

    private void fixupStaticizedFieldReadUsers(IRCode code, Value dest, DexField field) {
        assert (dest != null);
        Set<Phi> trivialPhis = Sets.newIdentityHashSet();
        boolean hasTrivialPhis = this.testAndcollectPhisComposedOfSameFieldRead(dest.uniquePhiUsers(), field, trivialPhis);
        assert (dest.numberOfPhiUsers() == 0 || hasTrivialPhis);
        HashSet<Instruction> users = new HashSet<Instruction>(dest.uniqueUsers());
        if (hasTrivialPhis) {
            for (Phi phi : trivialPhis) {
                users.addAll(phi.uniqueUsers());
            }
        }
        this.fixupStaticizedValueUsers(code, users);
        if (hasTrivialPhis) {
            for (Phi phi : trivialPhis) {
                assert (phi.numberOfUsers() == 0);
                for (Value operand : phi.getOperands()) {
                    operand.removePhiUser(phi);
                }
                phi.getBlock().removePhi(phi);
            }
        }
        assert (dest.numberOfUsers() == 0 && dest.numberOfPhiUsers() == 0);
    }

    private void fixupStaticizedValueUsers(IRCode code, Set<Instruction> users) {
        for (Instruction user : users) {
            assert (user.isInvokeVirtual() || user.isInvokeDirect());
            InvokeMethodWithReceiver invoke = user.asInvokeMethodWithReceiver();
            Value newValue = null;
            Value outValue = invoke.outValue();
            if (outValue != null) {
                newValue = code.createValue(outValue.getTypeLattice());
                DebugLocalInfo localInfo = outValue.getLocalInfo();
                if (localInfo != null) {
                    newValue.setLocalInfo(localInfo);
                }
            }
            List<Value> args = invoke.inValues();
            invoke.replace(new InvokeStatic(invoke.getInvokedMethod(), newValue, args.subList(1, args.size())));
        }
    }

    private void remapMovedCandidates(IRCode code) {
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            DexField field;
            Instruction instruction = (Instruction)it.next();
            if (instruction.isStaticGet()) {
                StaticGet staticGet = instruction.asStaticGet();
                field = this.mapFieldIfMoved(staticGet.getField());
                if (field == staticGet.getField()) continue;
                Value outValue = staticGet.dest();
                assert (outValue != null);
                it.replaceCurrentInstruction(new StaticGet(code.createValue(TypeLatticeElement.fromDexType(field.type, true, this.classStaticizer.appInfo), outValue.getLocalInfo()), field));
                continue;
            }
            if (instruction.isStaticPut()) {
                StaticPut staticPut = instruction.asStaticPut();
                field = this.mapFieldIfMoved(staticPut.getField());
                if (field == staticPut.getField()) continue;
                it.replaceCurrentInstruction(new StaticPut(staticPut.inValue(), field));
                continue;
            }
            if (!instruction.isInvokeStatic()) continue;
            InvokeStatic invoke = instruction.asInvokeStatic();
            DexMethod method = invoke.getInvokedMethod();
            DexType hostType = this.candidateToHostMapping.get(method.holder);
            if (hostType == null) continue;
            DexMethod newMethod = this.factory().createMethod(hostType, method.proto, method.name);
            Value outValue = invoke.outValue();
            Value newOutValue = method.proto.returnType.isVoidType() ? null : code.createValue(TypeLatticeElement.fromDexType(method.proto.returnType, true, this.classStaticizer.appInfo), outValue == null ? null : outValue.getLocalInfo());
            it.replaceCurrentInstruction(new InvokeStatic(newMethod, newOutValue, invoke.inValues()));
        }
    }

    private DexField mapFieldIfMoved(DexField field) {
        DexType hostType = this.candidateToHostMapping.get(field.clazz);
        if (hostType != null) {
            field = this.factory().createField(hostType, field.type, field.name);
        }
        if ((hostType = this.candidateToHostMapping.get(field.type)) != null) {
            field = this.factory().createField(field.clazz, hostType, field.name);
        }
        return field;
    }

    private Set<DexEncodedMethod> staticizeMethodSymbols() {
        HashBiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
        HashMap<DexEncodedMethod, DexEncodedMethod> encodedMethodMapping = new HashMap<DexEncodedMethod, DexEncodedMethod>();
        HashBiMap<DexField, DexField> fieldMapping = HashBiMap.create();
        Set<DexEncodedMethod> staticizedMethods = Sets.newIdentityHashSet();
        for (ClassStaticizer.CandidateInfo candidate : this.classStaticizer.candidates.values()) {
            DexProgramClass candidateClass = candidate.candidate;
            ArrayList<DexEncodedMethod> newDirectMethods = new ArrayList<DexEncodedMethod>();
            for (DexEncodedMethod method : candidateClass.methods()) {
                if (method.isStatic()) {
                    newDirectMethods.add(method);
                    continue;
                }
                if (this.factory().isConstructor(method.method)) continue;
                DexEncodedMethod staticizedMethod = method.toStaticMethodWithoutThis();
                newDirectMethods.add(staticizedMethod);
                staticizedMethods.add(staticizedMethod);
                methodMapping.put(method.method, staticizedMethod.method);
                encodedMethodMapping.put(method, staticizedMethod);
            }
            candidateClass.setVirtualMethods(DexEncodedMethod.EMPTY_ARRAY);
            candidateClass.setDirectMethods(newDirectMethods.toArray(new DexEncodedMethod[newDirectMethods.size()]));
            DexType hostType = candidate.hostType();
            if (candidateClass.type == hostType) continue;
            DexClass hostClass = this.classStaticizer.appInfo.definitionFor(hostType);
            assert (hostClass != null);
            if (this.classMembersConflict(candidateClass, hostClass)) continue;
            this.moveMembersIntoHost(staticizedMethods, candidateClass, hostType, hostClass, methodMapping, fieldMapping);
        }
        if (!methodMapping.isEmpty() || fieldMapping.isEmpty()) {
            this.classStaticizer.converter.appView.setGraphLense(new ClassStaticizerGraphLense(this.classStaticizer.converter.graphLense(), this.classStaticizer.factory, fieldMapping, methodMapping, encodedMethodMapping));
        }
        return staticizedMethods;
    }

    private boolean classMembersConflict(DexClass a, DexClass b) {
        assert (Streams.stream(a.methods()).allMatch(DexEncodedMethod::isStatic));
        assert (a.instanceFields().length == 0);
        return Stream.of(a.staticFields()).anyMatch(fld -> b.lookupField(fld.field) != null) || Streams.stream(a.methods()).anyMatch(method -> b.lookupMethod(method.method) != null);
    }

    private void moveMembersIntoHost(Set<DexEncodedMethod> staticizedMethods, DexProgramClass candidateClass, DexType hostType, DexClass hostClass, BiMap<DexMethod, DexMethod> methodMapping, BiMap<DexField, DexField> fieldMapping) {
        this.candidateToHostMapping.put(candidateClass.type, hostType);
        if (candidateClass.staticFields().length > 0) {
            DexEncodedField[] oldFields = hostClass.staticFields();
            DexEncodedField[] extraFields = candidateClass.staticFields();
            DexEncodedField[] newFields = new DexEncodedField[oldFields.length + extraFields.length];
            System.arraycopy(oldFields, 0, newFields, 0, oldFields.length);
            System.arraycopy(extraFields, 0, newFields, oldFields.length, extraFields.length);
            hostClass.setStaticFields(newFields);
        }
        DexEncodedField[] staticFields = hostClass.staticFields();
        for (int i = 0; i < staticFields.length; ++i) {
            DexEncodedField field = staticFields[i];
            DexField newField = this.mapCandidateField(field.field, candidateClass.type, hostType);
            if (newField == field.field) continue;
            staticFields[i] = field.toTypeSubstitutedField(newField);
            fieldMapping.put(field.field, newField);
        }
        if (candidateClass.directMethods().length > 0) {
            DexEncodedMethod[] oldMethods = hostClass.directMethods();
            DexEncodedMethod[] extraMethods = candidateClass.directMethods();
            DexEncodedMethod[] newMethods = new DexEncodedMethod[oldMethods.length + extraMethods.length];
            System.arraycopy(oldMethods, 0, newMethods, 0, oldMethods.length);
            for (int i = 0; i < extraMethods.length; ++i) {
                DexEncodedMethod newMethod;
                DexEncodedMethod method = extraMethods[i];
                newMethods[oldMethods.length + i] = newMethod = method.toTypeSubstitutedMethod(this.factory().createMethod(hostType, method.method.proto, method.method.name));
                staticizedMethods.add(newMethod);
                staticizedMethods.remove(method);
                DexMethod originalMethod = (DexMethod)methodMapping.inverse().get(method.method);
                if (originalMethod == null) {
                    methodMapping.put(method.method, newMethod.method);
                    continue;
                }
                methodMapping.put(originalMethod, newMethod.method);
            }
            hostClass.setDirectMethods(newMethods);
        }
    }

    private DexField mapCandidateField(DexField field, DexType candidateType, DexType hostType) {
        return field.clazz != candidateType && field.type != candidateType ? field : this.factory().createField(field.clazz == candidateType ? hostType : field.clazz, field.type == candidateType ? hostType : field.type, field.name);
    }

    private DexItemFactory factory() {
        return this.classStaticizer.factory;
    }
}

