/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.string;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StringOptimizer {
    private final BasicBlock.ThrowingInfo throwingInfo;

    public StringOptimizer(InternalOptions options) {
        this.throwingInfo = options.isGeneratingClassFiles() ? BasicBlock.ThrowingInfo.NO_THROW : BasicBlock.ThrowingInfo.CAN_THROW;
    }

    public void computeTrivialOperationsOnConstString(IRCode code, DexItemFactory factory) {
        if (!code.hasConstString) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual()) continue;
            InvokeVirtual invoke = instr.asInvokeVirtual();
            DexMethod invokedMethod = invoke.getInvokedMethod();
            Function<String, Integer> operatorWithNoArg = null;
            BiFunction<String, String, Integer> operatorWithString = null;
            if (invokedMethod == factory.stringMethods.length) {
                operatorWithNoArg = String::length;
            } else if (invokedMethod == factory.stringMethods.isEmpty) {
                operatorWithNoArg = rcv -> rcv.isEmpty() ? 1 : 0;
            } else if (invokedMethod == factory.stringMethods.contains) {
                operatorWithString = (rcv, arg) -> rcv.contains((CharSequence)arg) ? 1 : 0;
            } else if (invokedMethod == factory.stringMethods.startsWith) {
                operatorWithString = (rcv, arg) -> rcv.startsWith((String)arg) ? 1 : 0;
            } else if (invokedMethod == factory.stringMethods.endsWith) {
                operatorWithString = (rcv, arg) -> rcv.endsWith((String)arg) ? 1 : 0;
            } else if (invokedMethod == factory.stringMethods.equals) {
                operatorWithString = (rcv, arg) -> rcv.equals(arg) ? 1 : 0;
            } else if (invokedMethod == factory.stringMethods.equalsIgnoreCase) {
                operatorWithString = (rcv, arg) -> rcv.equalsIgnoreCase((String)arg) ? 1 : 0;
            } else if (invokedMethod == factory.stringMethods.contentEqualsCharSequence) {
                operatorWithString = (rcv, arg) -> rcv.contentEquals((CharSequence)arg) ? 1 : 0;
            }
            if (operatorWithNoArg == null && operatorWithString == null) continue;
            Value rcv2 = invoke.getReceiver().getAliasedValue();
            if (rcv2.definition == null || !rcv2.definition.isConstString() || !rcv2.isConstant()) continue;
            if (operatorWithNoArg != null) {
                assert (invoke.inValues().size() == 1);
                ConstString rcvString = rcv2.definition.asConstString();
                int v = operatorWithNoArg.apply(rcvString.getValue().toString());
                ConstNumber constNumber = code.createIntConstant(v);
                it.replaceCurrentInstruction(constNumber);
                continue;
            }
            assert (operatorWithString != null);
            assert (invoke.inValues().size() == 2);
            Value arg2 = invoke.inValues().get(1).getAliasedValue();
            if (arg2.definition == null || !arg2.definition.isConstString() || !arg2.isConstant()) continue;
            ConstString rcvString = rcv2.definition.asConstString();
            ConstString argString = arg2.definition.asConstString();
            int v = operatorWithString.apply(rcvString.getValue().toString(), argString.getValue().toString());
            ConstNumber constNumber = code.createIntConstant(v);
            it.replaceCurrentInstruction(constNumber);
        }
    }

    public void rewriteClassGetName(IRCode code, AppInfo appInfo, RootSetBuilder.RootSet rootSet) {
        if (code.method.isClassInitializer()) {
            return;
        }
        boolean markUseIdentifierNameString = false;
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            DexClass holder;
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !appInfo.dexItemFactory.classMethods.isReflectiveNameLookup(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod())) continue;
            assert (invoke.inValues().size() == 1);
            Value in = invoke.getReceiver().getAliasedValue();
            if (in.definition == null || !in.definition.isConstClass() || !in.isConstant()) continue;
            ConstClass constClass = in.definition.asConstClass();
            DexType type = constClass.getValue();
            int arrayDepth = type.getNumberOfLeadingSquareBrackets();
            DexType baseType = type.toBaseType(appInfo.dexItemFactory);
            if (!baseType.isClassType() || (holder = appInfo.definitionFor(baseType)) == null) continue;
            String descriptor = baseType.toDescriptorString();
            boolean assumeTopLevel = descriptor.indexOf(36) < 0;
            DexItemBasedConstString deferred = null;
            String name = null;
            if (invokedMethod == appInfo.dexItemFactory.classMethods.getName) {
                if (code.options.enableMinification && !rootSet.noObfuscation.contains(holder)) {
                    deferred = new DexItemBasedConstString(invoke.outValue(), baseType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, arrayDepth));
                } else {
                    name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, arrayDepth);
                }
            } else {
                if (invokedMethod == appInfo.dexItemFactory.classMethods.getTypeName) continue;
                if (invokedMethod == appInfo.dexItemFactory.classMethods.getCanonicalName) {
                    if (holder.isLocalClass() || holder.isAnonymousClass()) {
                        ConstNumber constNull = code.createConstNull();
                        it.replaceCurrentInstruction(constNull);
                    } else {
                        if (!assumeTopLevel) continue;
                        if (code.options.enableMinification && !rootSet.noObfuscation.contains(holder)) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, arrayDepth));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, arrayDepth);
                        }
                    }
                } else if (invokedMethod == appInfo.dexItemFactory.classMethods.getSimpleName) {
                    if (holder.isAnonymousClass()) {
                        name = "";
                    } else {
                        if (!assumeTopLevel) continue;
                        if (code.options.enableMinification && !rootSet.noObfuscation.contains(holder)) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, arrayDepth));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, arrayDepth);
                        }
                    }
                }
            }
            if (name != null) {
                Value stringValue = code.createValue(TypeLatticeElement.stringClassType(appInfo), invoke.getLocalInfo());
                ConstString constString = new ConstString(stringValue, appInfo.dexItemFactory.createString(name), this.throwingInfo);
                it.replaceCurrentInstruction(constString);
                continue;
            }
            if (deferred == null) continue;
            it.replaceCurrentInstruction(deferred);
            markUseIdentifierNameString = true;
        }
        if (markUseIdentifierNameString) {
            code.method.getMutableOptimizationInfo().markUseIdentifierNameString();
        }
    }

    public void removeTrivialConversions(IRCode code, AppInfo appInfo) {
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Value out;
            TypeLatticeElement inType;
            Value in;
            DexMethod invokedMethod;
            InvokeMethod invoke;
            Instruction instr = (Instruction)it.next();
            if (instr.isInvokeStatic()) {
                invoke = instr.asInvokeStatic();
                invokedMethod = invoke.getInvokedMethod();
                if (invokedMethod != appInfo.dexItemFactory.stringMethods.valueOf) continue;
                assert (invoke.inValues().size() == 1);
                in = invoke.inValues().get(0);
                if (in.hasLocalInfo()) continue;
                inType = in.getTypeLattice();
                if (inType.isConstantNull()) {
                    Value nullStringValue = code.createValue(TypeLatticeElement.stringClassType(appInfo), invoke.getLocalInfo());
                    ConstString nullString = new ConstString(nullStringValue, appInfo.dexItemFactory.createString("null"), this.throwingInfo);
                    it.replaceCurrentInstruction(nullString);
                    continue;
                }
                if (!inType.nullElement().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(appInfo.dexItemFactory.stringType)) continue;
                out = invoke.outValue();
                if (out != null) {
                    CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                    continue;
                }
                it.removeOrReplaceByDebugLocalRead();
                continue;
            }
            if (!instr.isInvokeVirtual() || (invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) != appInfo.dexItemFactory.stringMethods.toString) continue;
            assert (invoke.inValues().size() == 1);
            in = ((InvokeMethodWithReceiver)invoke).getReceiver();
            inType = in.getTypeLattice();
            if (!inType.nullElement().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(appInfo.dexItemFactory.stringType)) continue;
            out = invoke.outValue();
            if (out != null) {
                CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                continue;
            }
            it.removeOrReplaceByDebugLocalRead();
        }
    }
}

