/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import java.util.Set;

public class ProguardClassFilter {
    private static ProguardClassFilter EMPTY = new ProguardClassFilter(ImmutableList.of());
    private final ImmutableList<ProguardClassNameList> patterns;

    public static Builder builder() {
        return new Builder();
    }

    private ProguardClassFilter(ImmutableList<ProguardClassNameList> patterns) {
        this.patterns = patterns;
    }

    public static ProguardClassFilter empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.patterns.size() == 0;
    }

    public boolean matches(DexType type) {
        for (ProguardClassNameList pattern : this.patterns) {
            if (!pattern.matches(type)) continue;
            return true;
        }
        return false;
    }

    public void filterOutMatches(Set<DexType> types) {
        for (ProguardClassNameList pattern : this.patterns) {
            pattern.forEachTypeMatcher(matcher -> {
                if (matcher instanceof ProguardTypeMatcher.MatchSpecificType) {
                    assert (matcher.getSpecificType() != null);
                    types.remove(matcher.getSpecificType());
                } else {
                    types.removeIf(matcher::matches);
                }
            });
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<ProguardClassNameList> patterns = ImmutableList.builder();

        private Builder() {
        }

        public Builder addPattern(ProguardClassNameList pattern) {
            this.patterns.add((Object)pattern);
            return this;
        }

        ProguardClassFilter build() {
            return new ProguardClassFilter((ImmutableList)this.patterns.build());
        }
    }
}

