/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.FieldSignatureEquivalence;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.SingletonEquivalence;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StaticClassMerger {
    private static final String GLOBAL = "<global>";
    private static final int HEURISTIC_FOR_CAPACITY_OF_REPRESENTATIVES = 30;
    private final AppView<? extends Enqueuer.AppInfoWithLiveness> appView;
    private final Equivalence<DexField> fieldEquivalence;
    private final Equivalence<DexMethod> methodEquivalence;
    private final Map<String, Representative> representatives = new HashMap<String, Representative>();
    private final BiMap<DexField, DexField> fieldMapping = HashBiMap.create();
    private final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private int numberOfMergedClasses = 0;

    public StaticClassMerger(AppView<? extends Enqueuer.AppInfoWithLiveness> appView, InternalOptions options) {
        this.appView = appView;
        if (options.proguardConfiguration.isOverloadAggressivelyWithoutUseUniqueClassMemberNames()) {
            this.fieldEquivalence = FieldSignatureEquivalence.getEquivalenceIgnoreName();
            this.methodEquivalence = MethodSignatureEquivalence.getEquivalenceIgnoreName();
        } else {
            this.fieldEquivalence = new SingletonEquivalence<DexField>();
            this.methodEquivalence = MethodJavaSignatureEquivalence.getEquivalenceIgnoreName();
        }
    }

    public GraphLense run() {
        for (DexProgramClass clazz : this.appView.appInfo().app.classesWithDeterministicOrder()) {
            if (!this.satisfiesMergeCriteria(clazz)) continue;
            this.merge(clazz);
        }
        return this.buildGraphLense();
    }

    private GraphLense buildGraphLense() {
        if (!this.fieldMapping.isEmpty() || !this.methodMapping.isEmpty()) {
            BiMap<DexField, DexField> originalFieldSignatures = this.fieldMapping.inverse();
            BiMap<DexMethod, DexMethod> originalMethodSignatures = this.methodMapping.inverse();
            return new GraphLense.NestedGraphLense(ImmutableMap.of(), this.methodMapping, this.fieldMapping, originalFieldSignatures, originalMethodSignatures, this.appView.graphLense(), this.appView.dexItemFactory());
        }
        return this.appView.graphLense();
    }

    private boolean satisfiesMergeCriteria(DexProgramClass clazz) {
        if (this.appView.appInfo().neverMerge.contains(clazz.type)) {
            return false;
        }
        if (clazz.staticFields().length + clazz.directMethods().length + clazz.virtualMethods().length == 0) {
            return false;
        }
        if (clazz.instanceFields().length > 0) {
            return false;
        }
        if (Arrays.stream(clazz.staticFields()).anyMatch(field -> this.appView.appInfo().isPinned(field.field))) {
            return false;
        }
        if (Arrays.stream(clazz.directMethods()).anyMatch(DexEncodedMethod::isInitializer)) {
            return false;
        }
        if (!Arrays.stream(clazz.virtualMethods()).allMatch(DexEncodedMethod::isPrivateMethod)) {
            return false;
        }
        if (Streams.stream(clazz.methods()).anyMatch(method -> method.accessFlags.isNative() || this.appView.appInfo().isPinned(method.method) || this.appView.appInfo().alwaysInline.contains(method.method) || this.appView.appInfo().noSideEffects.keySet().contains(method))) {
            return false;
        }
        return !clazz.classInitializationMayHaveSideEffects(this.appView.appInfo());
    }

    private boolean isValidRepresentative(DexProgramClass clazz) {
        return !clazz.isInterface();
    }

    private boolean merge(DexProgramClass clazz) {
        assert (this.satisfiesMergeCriteria(clazz));
        String pkg = clazz.type.getPackageDescriptor();
        return this.mayMergeAcrossPackageBoundaries(clazz) ? this.mergeGlobally(clazz, pkg) : this.mergeInsidePackage(clazz, pkg);
    }

    private boolean mergeGlobally(DexProgramClass clazz, String pkg) {
        Representative globalRepresentative = this.representatives.get(GLOBAL);
        if (globalRepresentative == null) {
            if (this.isValidRepresentative(clazz)) {
                this.setRepresentative(GLOBAL, this.getOrCreateRepresentative(clazz, pkg));
            } else {
                this.clearRepresentative(GLOBAL);
            }
            return false;
        }
        globalRepresentative.include(clazz);
        if (globalRepresentative.isFull()) {
            if (this.isValidRepresentative(clazz)) {
                this.setRepresentative(GLOBAL, this.getOrCreateRepresentative(clazz, pkg));
            } else {
                this.clearRepresentative(GLOBAL);
            }
            return false;
        }
        this.moveMembersFromSourceToTarget(clazz, globalRepresentative.clazz);
        return true;
    }

    private boolean mergeInsidePackage(DexProgramClass clazz, String pkg) {
        Representative packageRepresentative = this.representatives.get(pkg);
        if (packageRepresentative != null) {
            if (this.isValidRepresentative(clazz) && clazz.accessFlags.isMoreVisibleThan(((Representative)packageRepresentative).clazz.accessFlags)) {
                Representative newRepresentative = this.getOrCreateRepresentative(clazz, pkg);
                newRepresentative.include(packageRepresentative.clazz);
                if (!newRepresentative.isFull()) {
                    this.setRepresentative(pkg, newRepresentative);
                    this.moveMembersFromSourceToTarget(packageRepresentative.clazz, clazz);
                    return true;
                }
                return false;
            }
            packageRepresentative.include(clazz);
            if (!packageRepresentative.isFull()) {
                this.moveMembersFromSourceToTarget(clazz, packageRepresentative.clazz);
                return true;
            }
        }
        if (this.isValidRepresentative(clazz)) {
            this.setRepresentative(pkg, this.getOrCreateRepresentative(clazz, pkg));
        }
        return false;
    }

    private Representative getOrCreateRepresentative(DexProgramClass clazz, String pkg) {
        Representative globalRepresentative = this.representatives.get(GLOBAL);
        if (globalRepresentative != null && globalRepresentative.clazz == clazz) {
            return globalRepresentative;
        }
        Representative packageRepresentative = this.representatives.get(pkg);
        if (packageRepresentative != null && packageRepresentative.clazz == clazz) {
            return packageRepresentative;
        }
        return new Representative(clazz);
    }

    private void setRepresentative(String pkg, Representative representative) {
        assert (this.isValidRepresentative(representative.clazz));
        this.representatives.put(pkg, representative);
    }

    private void clearRepresentative(String pkg) {
        this.representatives.remove(pkg);
    }

    private boolean mayMergeAcrossPackageBoundaries(DexProgramClass clazz) {
        if (!clazz.accessFlags.isPublic()) {
            return false;
        }
        if (!Arrays.stream(clazz.directMethods()).allMatch(method -> method.accessFlags.isPrivate() || method.accessFlags.isPublic())) {
            return false;
        }
        if (!Arrays.stream(clazz.staticFields()).allMatch(method -> method.accessFlags.isPrivate() || method.accessFlags.isPublic())) {
            return false;
        }
        assert (Arrays.stream(clazz.instanceFields()).count() == 0L);
        assert (Arrays.stream(clazz.virtualMethods()).allMatch(method -> method.accessFlags.isPrivate()));
        VerticalClassMerger.IllegalAccessDetector registry = new VerticalClassMerger.IllegalAccessDetector(this.appView, clazz);
        for (DexEncodedMethod method2 : clazz.methods()) {
            registry.setContext(method2);
            method2.registerCodeReferences(registry);
            if (!registry.foundIllegalAccess()) continue;
            return false;
        }
        return true;
    }

    private void moveMembersFromSourceToTarget(DexProgramClass sourceClass, DexProgramClass targetClass) {
        assert (targetClass.accessFlags.isAtLeastAsVisibleAs(sourceClass.accessFlags));
        assert (sourceClass.instanceFields().length == 0);
        assert (targetClass.instanceFields().length == 0);
        ++this.numberOfMergedClasses;
        targetClass.setDirectMethods(this.mergeMethods(sourceClass.directMethods(), targetClass.directMethods(), targetClass));
        targetClass.setVirtualMethods(this.mergeMethods(sourceClass.virtualMethods(), targetClass.virtualMethods(), targetClass));
        targetClass.setStaticFields(this.mergeFields(sourceClass.staticFields(), targetClass.staticFields(), targetClass));
        sourceClass.setDirectMethods(DexEncodedMethod.EMPTY_ARRAY);
        sourceClass.setVirtualMethods(DexEncodedMethod.EMPTY_ARRAY);
        sourceClass.setStaticFields(DexEncodedField.EMPTY_ARRAY);
    }

    private DexEncodedMethod[] mergeMethods(DexEncodedMethod[] sourceMethods, DexEncodedMethod[] targetMethods, DexProgramClass targetClass) {
        DexEncodedMethod[] result = new DexEncodedMethod[sourceMethods.length + targetMethods.length];
        System.arraycopy(targetMethods, 0, result, 0, targetMethods.length);
        MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        Set existingMethods = Arrays.stream(targetMethods).map(targetMethod -> equivalence.wrap(targetMethod.method)).collect(Collectors.toSet());
        Predicate<DexMethod> availableMethodSignatures = method -> !existingMethods.contains(equivalence.wrap(method));
        int i = targetMethods.length;
        for (DexEncodedMethod sourceMethod : sourceMethods) {
            DexEncodedMethod sourceMethodAfterMove = this.renameMethodIfNeeded(sourceMethod, targetClass, availableMethodSignatures);
            result[i++] = sourceMethodAfterMove;
            DexMethod originalMethod = this.methodMapping.inverse().getOrDefault(sourceMethod.method, sourceMethod.method);
            this.methodMapping.forcePut(originalMethod, sourceMethodAfterMove.method);
            existingMethods.add(equivalence.wrap(sourceMethodAfterMove.method));
        }
        return result;
    }

    private DexEncodedField[] mergeFields(DexEncodedField[] sourceFields, DexEncodedField[] targetFields, DexProgramClass targetClass) {
        DexEncodedField[] result = new DexEncodedField[sourceFields.length + targetFields.length];
        System.arraycopy(targetFields, 0, result, 0, targetFields.length);
        FieldSignatureEquivalence equivalence = FieldSignatureEquivalence.get();
        Set existingFields = Arrays.stream(targetFields).map(targetField -> equivalence.wrap(targetField.field)).collect(Collectors.toSet());
        Predicate<DexField> availableFieldSignatures = field -> !existingFields.contains(equivalence.wrap(field));
        int i = targetFields.length;
        for (DexEncodedField sourceField : sourceFields) {
            DexEncodedField sourceFieldAfterMove = this.renameFieldIfNeeded(sourceField, targetClass, availableFieldSignatures);
            result[i++] = sourceFieldAfterMove;
            DexField originalField = this.fieldMapping.inverse().getOrDefault(sourceField.field, sourceField.field);
            this.fieldMapping.forcePut(originalField, sourceFieldAfterMove.field);
            existingFields.add(equivalence.wrap(sourceFieldAfterMove.field));
        }
        return result;
    }

    private DexEncodedMethod renameMethodIfNeeded(DexEncodedMethod method, DexProgramClass targetClass, Predicate<DexMethod> availableMethodSignatures) {
        assert (!method.accessFlags.isConstructor());
        DexString oldName = method.method.name;
        DexMethod newSignature = this.appView.dexItemFactory().createMethod(targetClass.type, method.method.proto, oldName);
        if (!availableMethodSignatures.test(newSignature)) {
            int count = 1;
            do {
                DexString newName = this.appView.dexItemFactory().createString(oldName.toSourceString() + count);
                newSignature = this.appView.dexItemFactory().createMethod(targetClass.type, method.method.proto, newName);
                ++count;
            } while (!availableMethodSignatures.test(newSignature));
        }
        return method.toTypeSubstitutedMethod(newSignature);
    }

    private DexEncodedField renameFieldIfNeeded(DexEncodedField field, DexProgramClass targetClass, Predicate<DexField> availableFieldSignatures) {
        DexString oldName = field.field.name;
        DexField newSignature = this.appView.dexItemFactory().createField(targetClass.type, field.field.type, oldName);
        if (!availableFieldSignatures.test(newSignature)) {
            int count = 1;
            do {
                DexString newName = this.appView.dexItemFactory().createString(oldName.toSourceString() + count);
                newSignature = this.appView.dexItemFactory().createField(targetClass.type, field.field.type, newName);
                ++count;
            } while (!availableFieldSignatures.test(newSignature));
        }
        return field.toTypeSubstitutedField(newSignature);
    }

    private class Representative {
        private final DexProgramClass clazz;
        private final HashMultiset<Equivalence.Wrapper<DexField>> fieldBuckets = HashMultiset.create();
        private final HashMultiset<Equivalence.Wrapper<DexMethod>> methodBuckets = HashMultiset.create();

        public Representative(DexProgramClass clazz) {
            this.clazz = clazz;
            this.include(clazz);
        }

        public void include(DexProgramClass clazz) {
            Equivalence.Wrapper<Descriptor> wrapper;
            for (DexEncodedField field : clazz.fields()) {
                wrapper = StaticClassMerger.this.fieldEquivalence.wrap(field.field);
                this.fieldBuckets.add(wrapper);
            }
            for (DexEncodedMethod method : clazz.methods()) {
                wrapper = StaticClassMerger.this.methodEquivalence.wrap(method.method);
                this.methodBuckets.add(wrapper);
            }
        }

        public boolean isFull() {
            int numberOfNamesNeeded = 1;
            for (Multiset.Entry entry : this.fieldBuckets.entrySet()) {
                numberOfNamesNeeded = Math.max(entry.getCount(), numberOfNamesNeeded);
            }
            for (Multiset.Entry entry : this.methodBuckets.entrySet()) {
                numberOfNamesNeeded = Math.max(entry.getCount(), numberOfNamesNeeded);
            }
            return numberOfNamesNeeded > 30;
        }
    }
}

