/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;

public enum ValueTypeConstraint {
    OBJECT,
    INT,
    FLOAT,
    INT_OR_FLOAT,
    INT_OR_FLOAT_OR_OBJECT,
    LONG,
    DOUBLE,
    LONG_OR_DOUBLE;


    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isSingle() {
        return this == INT || this == FLOAT || this == INT_OR_FLOAT;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE || this == LONG_OR_DOUBLE;
    }

    public boolean isPrecise() {
        return this != INT_OR_FLOAT && this != LONG_OR_DOUBLE && this != INT_OR_FLOAT_OR_OBJECT;
    }

    public int requiredRegisters() {
        return this.isWide() ? 2 : 1;
    }

    public static ValueTypeConstraint fromValueType(ValueType type) {
        switch (type) {
            case OBJECT: {
                return OBJECT;
            }
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Unexpected value type: " + (Object)((Object)type));
    }

    public static ValueTypeConstraint fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT_OR_FLOAT: {
                return INT_OR_FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                return LONG_OR_DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static ValueTypeConstraint fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static ValueTypeConstraint fromDexType(DexType type) {
        return ValueTypeConstraint.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static ValueTypeConstraint fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }

    public static ValueTypeConstraint fromTypeLattice(TypeLatticeElement typeLatticeElement) {
        if (typeLatticeElement.isReference()) {
            return OBJECT;
        }
        if (typeLatticeElement.isFineGrainedType() || typeLatticeElement.isInt()) {
            return INT;
        }
        if (typeLatticeElement.isFloat()) {
            return FLOAT;
        }
        if (typeLatticeElement.isLong()) {
            return LONG;
        }
        if (typeLatticeElement.isDouble()) {
            return DOUBLE;
        }
        if (typeLatticeElement.isSingle()) {
            return INT_OR_FLOAT;
        }
        if (typeLatticeElement.isWide()) {
            return LONG_OR_DOUBLE;
        }
        if (typeLatticeElement.isTop()) {
            return INT_OR_FLOAT_OR_OBJECT;
        }
        throw new Unreachable("Unexpected conversion of type: " + typeLatticeElement);
    }

    public PrimitiveTypeLatticeElement toPrimitiveTypeLattice() {
        switch (this) {
            case INT: {
                return TypeLatticeElement.INT;
            }
            case FLOAT: {
                return TypeLatticeElement.FLOAT;
            }
            case LONG: {
                return TypeLatticeElement.LONG;
            }
            case DOUBLE: {
                return TypeLatticeElement.DOUBLE;
            }
        }
        throw new Unreachable("Unexpected type in conversion to primitive: " + (Object)((Object)this));
    }
}

