/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.LineCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApkInfoParser {
    private static final Pattern PATTERN = Pattern.compile("^package: name='([^']+)' versionCode='([0-9]*)' versionName='([^']*)'.*$");
    private final File mAaptFile;
    private final ProcessExecutor mProcessExecutor;

    public ApkInfoParser(File aaptFile, ProcessExecutor processExecutor) {
        this.mAaptFile = aaptFile;
        this.mProcessExecutor = processExecutor;
    }

    public ApkInfo parseApk(File apkFile) throws ProcessException {
        if (!this.mAaptFile.isFile()) {
            throw new IllegalStateException("aapt is missing from location: " + this.mAaptFile.getAbsolutePath());
        }
        return ApkInfoParser.getApkInfo(this.getAaptOutput(apkFile));
    }

    @VisibleForTesting
    static ApkInfo getApkInfo(List<String> aaptOutput) {
        String pkgName = null;
        String versionCode = null;
        String versionName = null;
        for (String line : aaptOutput) {
            Matcher m2 = PATTERN.matcher(line);
            if (!m2.matches()) continue;
            pkgName = m2.group(1);
            versionCode = m2.group(2);
            versionName = m2.group(3);
            break;
        }
        if (pkgName == null) {
            throw new RuntimeException("Failed to find apk information with aapt");
        }
        Integer intVersionCode = null;
        try {
            intVersionCode = Integer.parseInt(versionCode);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ApkInfo(pkgName, intVersionCode, versionName);
    }

    private List<String> getAaptOutput(File apkFile) throws ProcessException {
        return this.invokeAaptWithParameters(apkFile, "dump", "badging");
    }

    public List<String> getFullAaptOutput(File apkFile) throws ProcessException {
        return this.invokeAaptWithParameters(apkFile, "l", "-a");
    }

    private List<String> invokeAaptWithParameters(File apkFile, String ... parameters) throws ProcessException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mAaptFile);
        builder.addArgs(parameters);
        builder.addArgs(apkFile.getPath());
        CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
        this.mProcessExecutor.execute(builder.createProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure().assertNormalExitValue();
        BaseProcessOutputHandler.BaseProcessOutput output = processOutputHandler.getProcessOutput();
        LineCollector lineCollector = new LineCollector();
        output.processStandardOutputLines((LineProcessor)lineCollector);
        return lineCollector.getResult();
    }

    public static final class ApkInfo {
        private final String mPackageName;
        private final Integer mVersionCode;
        private final String mVersionName;

        private ApkInfo(String packageName, Integer versionCode, String versionName) {
            this.mPackageName = packageName;
            this.mVersionCode = versionCode;
            this.mVersionName = versionName;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public Integer getVersionCode() {
            return this.mVersionCode;
        }

        public String getVersionName() {
            return this.mVersionName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("packageName", (Object)this.mPackageName).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).toString();
        }
    }
}

